/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.hraux.DegreeCollection;
import com.kingdee.eas.basedata.hraux.DegreeFactory;
import com.kingdee.eas.basedata.hraux.DegreeInfo;
import com.kingdee.eas.basedata.hraux.DiplomaCollection;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.SpecialtyTypeCollection;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.SpecialtyTypeInfo;
import com.kingdee.eas.hr.rec.EducationExpFactory;
import com.kingdee.eas.hr.rec.EducationExpInfo;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.app.ExcelField;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class EducationExpDataTransmission
extends AbstractDataTransmission {
    private boolean isFirstSubmit = true;
    private Set resumeBaseIds = new HashSet();
    private String resumeBaseID = null;
    private static final String solution = "com.kingdee.eas.hr.rec.app.ExportEducationExpQuery";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.EducationExpDataTransmission");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EducationExpFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public boolean isEnqualsNow(Context ctx, String date) {
        return date.equals(ExcelField.getToNow(ctx.getLocale())) || date.equals(ExcelField.getNow(ctx.getLocale()));
    }

    private DiplomaInfo getDiplomaInfo(Context ctx, String diplomaName) throws BOSException {
        DiplomaInfo info = null;
        EntityViewInfo diplomaEntityViewInfo = new EntityViewInfo();
        FilterInfo diplomaFilter = new FilterInfo();
        diplomaFilter.getFilterItems().add(new FilterItemInfo("name", (Object)diplomaName));
        diplomaEntityViewInfo.setFilter(diplomaFilter);
        diplomaEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        DiplomaCollection dCol = DiplomaFactory.getLocalInstance((Context)ctx).getDiplomaCollection(diplomaEntityViewInfo);
        if (dCol.size() > 0) {
            info = dCol.get(0);
        }
        return info;
    }

    private DegreeInfo getDegreeInfo(Context ctx, String degreeName) throws BOSException {
        EntityViewInfo degreeEntityViewInfo = new EntityViewInfo();
        FilterInfo degreeFilter = new FilterInfo();
        degreeFilter.getFilterItems().add(new FilterItemInfo("name", (Object)degreeName));
        degreeEntityViewInfo.setFilter(degreeFilter);
        degreeEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        DegreeCollection dCol = DegreeFactory.getLocalInstance((Context)ctx).getDegreeCollection(degreeEntityViewInfo);
        if (dCol.size() > 0) {
            return dCol.get(0);
        }
        return null;
    }

    public ResumeBaseCollection getResumeBaseInfoBySign(Context ctx, String sign) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)sign));
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        if (fi != null) {
            filter.mergeFilter(fi, "and");
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        SorterItemInfo sInfo = new SorterItemInfo("createTime");
        sInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sInfo);
        ResumeBaseCollection col = ResumeBaseFactory.getLocalInstance(ctx).getResumeBaseCollection(viewInfo);
        return col;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            DiplomaInfo dInfo;
            if (RecServerUtils.objectIsNull(hsData.get("resumeBaseID"))) {
                throw new ImportDataException(ImportDataException.ACCESSID_NOT_NULL);
            }
            this.resumeBaseID = hsData.get("resumeBaseID").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)this.resumeBaseID));
            FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
            if (fi != null) {
                filter.mergeFilter(fi, "and");
            }
            if (!ResumeBaseFactory.getLocalInstance(ctx).exists(filter)) {
                new ImportDataException(ImportDataException.NEEDRESUMEBASE);
            }
            EducationExpInfo info = new EducationExpInfo();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (hsData.get("dateStart") != null && !StringUtils.isEmpty((String)hsData.get("dateStart").toString())) {
                try {
                    info.setStartDate(format.parse(hsData.get("dateStart").toString()));
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"1_EducationExpDataTransmission", (Locale)ctx.getLocale()));
                }
            }
            if (hsData.get("dateEnd") != null && !StringUtils.isEmpty((String)hsData.get("dateEnd").toString())) {
                if (this.isEnqualsNow(ctx, hsData.get("dateEnd").toString())) {
                    info.setEndDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
                } else {
                    try {
                        info.setEndDate(format.parse(hsData.get("dateEnd").toString()));
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"2_EducationExpDataTransmission", (Locale)ctx.getLocale()));
                    }
                }
            }
            if (RecServerUtils.objectIsNull(hsData.get("school"))) {
                throw new ImportDataException(ImportDataException.EDUEXP_SCHOOL_NULL);
            }
            info.setSchool(hsData.get("school").toString());
            String str = hsData.get("isStudent").toString();
            if (str != null && str.length() > 0) {
                if ("1".equals(str)) {
                    info.setIsStudent(true);
                } else if ("0".equals(str)) {
                    info.setIsStudent(false);
                } else {
                    throw new ImportDataException(ImportDataException.EDUCATION_ISSTUDENT_ERROR);
                }
            }
            if (hsData.get("schoolAddress") != null) {
                info.setSchoolAddress(hsData.get("schoolAddress").toString());
            }
            if (hsData.get("grade") != null) {
                info.setGrade(hsData.get("grade").toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("specialty"))) {
                info.setSpecialty(hsData.get("specialty").toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("diploma"))) {
                dInfo = this.getDiplomaInfo(ctx, hsData.get("diploma").toString());
                if (dInfo == null) {
                    throw new ImportDataException(ImportDataException.EDUCATIONEXP_DIPLOMA_VALID);
                }
                info.setDiploma(dInfo);
            }
            if (!RecServerUtils.objectIsNull(hsData.get("degree"))) {
                dInfo = this.getDegreeInfo(ctx, hsData.get("degree").toString());
                if (RecServerUtils.objectIsNull(dInfo)) {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_DEGREE_ERROR);
                }
                info.setDegree((DegreeInfo)dInfo);
            }
            SpecialtyTypeCollection stCol = SpecialtyTypeFactory.getLocalInstance((Context)ctx).getSpecialtyTypeCollection();
            SpecialtyTypeInfo stInfo = null;
            int size = stCol.size();
            for (int i = 0; i < size; ++i) {
                if (!stCol.get(i).getName().equals(ExcelField.getUnknown(ctx.getLocale()))) continue;
                stInfo = stCol.get(i);
                break;
            }
            info.setSpecialtyType(stInfo);
            return info;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Object tmp = null;
        try {
            if (!StringUtils.isEmpty((String)rs.getString("idCardNO"))) {
                result.put("resumeBaseID", rs.getString("idCardNO"));
            }
            if (!RecServerUtils.objectIsNull(rs.getDate("educationExp.startDate"))) {
                result.put("dateStart", rs.getDate("educationExp.startDate").toString());
            }
            if (!RecServerUtils.objectIsNull(rs.getDate("educationExp.endDate"))) {
                result.put("dateEnd", rs.getDate("educationExp.endDate").toString());
            }
            if (!StringUtils.isEmpty((String)rs.getString("educationExp.school"))) {
                result.put("school", rs.getString("educationExp.school"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("educationExp.specialty"))) {
                result.put("specialty", rs.getString("educationExp.specialty"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("diploma.name"))) {
                result.put("diploma", rs.getString("diploma.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("educationExp.schoolAddress"))) {
                result.put("schoolAddress", rs.getString("educationExp.schoolAddress"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("educationExp.grade"))) {
                result.put("grade", rs.getString("educationExp.grade"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("educationExp.isStudent"))) {
                result.put("isStudent", rs.getString("educationExp.isStudent"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        try {
            return RecServerUtils.getHRFilterByParam(ctx, "REC002");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return solution;
    }

    private FilterInfo makeIDFilterByResumeBaseID(Context ctx, String table, String resumeBaseID) {
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer("SELECT FID FROM ");
        sql.append(table);
        sql.append(" WHERE FresumeBaseID = ");
        sql.append("'");
        sql.append(resumeBaseID);
        sql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ResumeBaseCollection col = this.getResumeBaseInfoBySign(ctx, this.resumeBaseID);
            if (col != null && col.size() > 0) {
                EducationExpInfo info = (EducationExpInfo)coreBaseInfo;
                if (this.isSltImportUpdate()) {
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        ResumeBaseInfo resumeBaseInfo = col.get(i);
                        String resumeBaseId = resumeBaseInfo.getId().toString();
                        info.setResumeBase(resumeBaseInfo);
                        this.isFirstSubmit = !this.resumeBaseIds.contains(resumeBaseId);
                        if (RecServerUtils.isNotExists(ctx, this.getSQL2(resumeBaseId, String.valueOf(1), "FHighDegree"))) {
                            info.setHighDegree(true);
                        } else {
                            info.setHighDegree(false);
                        }
                        if (this.isFirstSubmit) {
                            FilterInfo filter = this.makeIDFilterByResumeBaseID(ctx, "T_HR_EducationExp", resumeBaseId);
                            EducationExpFactory.getLocalInstance(ctx).delete(filter);
                            this.resumeBaseIds.add(resumeBaseId);
                        }
                        if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                            this.getController(ctx).addnew(coreBaseInfo);
                        } else {
                            this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                        }
                        coreBaseInfo.setId(null);
                    }
                } else {
                    ResumeBaseInfo currResumeBaseInfo = col.get(0);
                    info.setResumeBase(currResumeBaseInfo);
                    if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                        if (RecServerUtils.isNotExists(ctx, this.getSQL(currResumeBaseInfo.getId().toString(), String.valueOf(1), "FHighDegree"))) {
                            info.setHighDegree(true);
                        } else {
                            info.setHighDegree(false);
                        }
                        if (RecServerUtils.isNotExists(ctx, this.getSQL(currResumeBaseInfo.getId().toString(), info.getSchool(), "Fschool"))) {
                            this.getController(ctx).addnew(coreBaseInfo);
                        }
                    } else {
                        this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public String getSQL(String resumeBaseID, String name, String columeName) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ");
        strBuffer.append(columeName);
        strBuffer.append(",FResumeBaseID FROM T_HR_EducationExp where ");
        strBuffer.append(columeName);
        strBuffer.append(" = '");
        strBuffer.append(name);
        strBuffer.append("'");
        strBuffer.append(" and FResumeBaseID = '");
        strBuffer.append(resumeBaseID);
        strBuffer.append("'");
        return strBuffer.toString();
    }

    public String getSQL2(String resumeBaseID, String name, String columeName) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ");
        strBuffer.append(columeName);
        strBuffer.append(",FResumeBaseID FROM T_HR_EducationExp where ");
        strBuffer.append(columeName);
        strBuffer.append(" = ");
        strBuffer.append(name);
        strBuffer.append("");
        strBuffer.append(" and FResumeBaseID = '");
        strBuffer.append(resumeBaseID);
        strBuffer.append("'");
        return strBuffer.toString();
    }
}

