/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.rec.HRRecException;
import com.kingdee.eas.hr.rec.HireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.HireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.HireApplyBillEntryInfo;
import com.kingdee.eas.hr.rec.HireApplyBillInfo;
import com.kingdee.eas.hr.rec.HireApplyException;
import com.kingdee.eas.hr.rec.IHireApplyBillEntry;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.app.AbstractHireApplyBillControllerBean;
import java.util.Date;
import org.apache.log4j.Logger;

public class HireApplyBillControllerBean
extends AbstractHireApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.HireApplyBillControllerBean");

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        this.setResumeState(ctx, billID, ResumeStateEnum.pass);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITEND);
        this.setResumeState(ctx, billID, ResumeStateEnum.pass_in_hireApp);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITING);
        this.setResumeState(ctx, billID, ResumeStateEnum.hireApp_aduit);
    }

    protected void updateBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        if (billID == null || state == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("approvalDate"));
        HireApplyBillInfo model = this.getHireApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), selector);
        if (model != null) {
            model.setBillState(state);
            if (state.equals((Object)HRBillStateEnum.SAVED)) {
                model.setBizDate(null);
                model.setApprovalDate(null);
            } else {
                model.setBizDate(new Date());
                model.setApprovalDate(model.getBizDate());
            }
            this.updatePartial(ctx, (CoreBaseInfo)model, selector);
        }
    }

    private void setResumeState(Context ctx, BOSUuid hireApplyBillId, ResumeStateEnum resumeState) throws BOSException, EASBizException {
        SelectorItemCollection resumeSic = new SelectorItemCollection();
        resumeSic.add(new SelectorItemInfo("resumeState"));
        SelectorItemCollection hireApplySic = new SelectorItemCollection();
        hireApplySic.add(new SelectorItemInfo("id"));
        hireApplySic.add(new SelectorItemInfo("entrys.id"));
        hireApplySic.add(new SelectorItemInfo("entrys.resumeBase.id"));
        hireApplySic.add(new SelectorItemInfo("entrys.resumeBase.resumeState"));
        HireApplyBillInfo habInfo = super.getHireApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(hireApplyBillId), hireApplySic);
        HireApplyBillEntryCollection habeColl = habInfo.getEntrys();
        if (habeColl.isEmpty()) {
            return;
        }
        IResumeBase rb = ResumeBaseFactory.getLocalInstance(ctx);
        for (int i = 0; i < habeColl.size(); ++i) {
            ResumeBaseInfo resumeBaseInfo = habeColl.get(i).getResumeBase();
            resumeBaseInfo.setResumeState(resumeState);
            rb.updatePartial((CoreBaseInfo)resumeBaseInfo, resumeSic);
        }
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._beforeSave(ctx, model);
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._beforeSave(ctx, model);
        return super._save(ctx, model);
    }

    protected void _beforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _beforeDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRBillBaseInfo info = (HRBillBaseInfo)this._getValue(ctx, pk);
        if (info.getBillState().getValue() != 0) {
            throw new HRRecException(HRRecException.HRBILL_CAN_NOT_DELETE);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._beforeDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmit(ctx, model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    private void beforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void checkExistsResume(Context ctx, HireApplyBillInfo model) throws BOSException, EASBizException {
        HireApplyBillEntryCollection habeColl = model.getEntrys();
        if (habeColl.isEmpty()) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        IHireApplyBillEntry hbe = HireApplyBillEntryFactory.getLocalInstance(ctx);
        for (int i = 0; i < habeColl.size(); ++i) {
            HireApplyBillEntryInfo entryInfo = habeColl.get(i);
            Object appBillCol = null;
            if (entryInfo.getResumeBase().getId() == null) continue;
            oql.delete(0, oql.length());
            oql.append(" where resumeBase.id='").append(entryInfo.getResumeBase().getId()).append("' ");
            if (entryInfo.getId() != null) {
                oql.append(" and id<>'").append(entryInfo.getId()).append("' ");
                oql.append(" and parent.billState<>").append(4);
            }
            if (!hbe.exists(oql.toString())) continue;
            throw new HireApplyException(HireApplyException.CHECK_RESUMEBASE_DUP, new Object[]{entryInfo.getResumeBase().getName()});
        }
    }
}

