/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.rec.CertificateFactory;
import com.kingdee.eas.hr.rec.CertificateInfo;
import com.kingdee.eas.hr.rec.EducationExpFactory;
import com.kingdee.eas.hr.rec.EducationExpInfo;
import com.kingdee.eas.hr.rec.ICertificate;
import com.kingdee.eas.hr.rec.IEducationExp;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumeCategory;
import com.kingdee.eas.hr.rec.IResumeExtend;
import com.kingdee.eas.hr.rec.ISkill;
import com.kingdee.eas.hr.rec.ITrainExp;
import com.kingdee.eas.hr.rec.IWorkExp;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryFactory;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.ResumeExtendFactory;
import com.kingdee.eas.hr.rec.ResumeExtendInfo;
import com.kingdee.eas.hr.rec.SkillFactory;
import com.kingdee.eas.hr.rec.SkillInfo;
import com.kingdee.eas.hr.rec.TrainExpFactory;
import com.kingdee.eas.hr.rec.TrainExpInfo;
import com.kingdee.eas.hr.rec.WorkExpFactory;
import com.kingdee.eas.hr.rec.WorkExpInfo;
import com.kingdee.eas.hr.rec.app.AbstractImportByAccessFacadeControllerBean;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ImportByAccessFacadeControllerBean
extends AbstractImportByAccessFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.ImportByAccessFacadeControllerBean");

    protected IObjectPK _certificateImport(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (info != null && info instanceof CertificateInfo) {
            CertificateInfo certificateInfo = (CertificateInfo)info;
            if (certificateInfo.getId() != null) {
                certificateInfo.setId(null);
            }
            pk = CertificateFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)certificateInfo);
            return pk;
        }
        throw new ImportDataException(ImportDataException.CERTIFICATE_ADD_ERROR);
    }

    protected IObjectPK _educationExpImport(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (info != null && info instanceof EducationExpInfo) {
            EducationExpInfo educationExpInfo = (EducationExpInfo)info;
            if (educationExpInfo.getId() != null) {
                educationExpInfo.setId(null);
            }
            pk = EducationExpFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)educationExpInfo);
            return pk;
        }
        throw new ImportDataException(ImportDataException.EDUEXP_ADD_ERROR);
    }

    protected IObjectPK _skillImport(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (info != null && info instanceof SkillInfo) {
            SkillInfo skillInfo = (SkillInfo)info;
            if (skillInfo.getId() != null) {
                skillInfo.setId(null);
            }
            pk = SkillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)skillInfo);
            return pk;
        }
        throw new ImportDataException(ImportDataException.SKILL_ADD_ERROR);
    }

    protected IObjectPK _trainExpImport(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (info != null && info instanceof TrainExpInfo) {
            TrainExpInfo trainExpInfo = (TrainExpInfo)info;
            if (trainExpInfo.getId() != null) {
                trainExpInfo.setId(null);
            }
            pk = TrainExpFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)trainExpInfo);
            return pk;
        }
        throw new ImportDataException(ImportDataException.TRAINEXP_ADD_ERROR);
    }

    protected IObjectPK _workExpImport(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (info != null && info instanceof WorkExpInfo) {
            WorkExpInfo workExpInfo = (WorkExpInfo)info;
            if (workExpInfo.getId() != null) {
                workExpInfo.setId(null);
            }
            pk = WorkExpFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)workExpInfo);
            return pk;
        }
        throw new ImportDataException(ImportDataException.WORKEXP_ADD_ERROR);
    }

    protected IObjectPK _resumeBaseImport(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        BOSUuid id = null;
        if (info != null && info instanceof ResumeBaseInfo) {
            ResumeBaseInfo resumeBaseInfo = (ResumeBaseInfo)info;
            id = resumeBaseInfo.getId();
            resumeBaseInfo.setNumber(RecServerUtils.getNumberSilent(ctx, (CoreBaseInfo)resumeBaseInfo, RecServerUtils.getCurrentHROrgUnit(ctx).getId().toString()));
            if (id != null) {
                pk = new ObjectUuidPK(id);
                ResumeBaseFactory.getLocalInstance(ctx).addnew((IObjectPK)pk, (CoreBaseInfo)resumeBaseInfo);
                return pk;
            }
            throw new ImportDataException(ImportDataException.RESUMEBASE_ID_NULL);
        }
        throw new ImportDataException(ImportDataException.RESUMEBASE_ADD_ERROR);
    }

    protected IObjectPK _resumeExtendImport(Context ctx, IObjectValue resumeBaseInfo, IObjectValue resumeCategoryInfo) throws BOSException, EASBizException {
        ResumeExtendInfo resumeExtendInfo = null;
        IResumeBase resumeBase = null;
        IResumeCategory resumeCategory = null;
        IObjectPK pk = null;
        if (resumeBaseInfo != null && resumeBaseInfo instanceof ResumeBaseInfo && resumeCategoryInfo != null && resumeCategoryInfo instanceof ResumeCategoryInfo) {
            resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            resumeCategory = ResumeCategoryFactory.getLocalInstance(ctx);
            if (resumeBase.exists(this.makeIDFilterInfo(ctx, ((ResumeBaseInfo)resumeBaseInfo).getId().toString(), "hrOrgUnit.id")) && resumeCategory.exists(this.makeIDFilterInfo(((ResumeCategoryInfo)resumeCategoryInfo).getId().toString()))) {
                resumeExtendInfo = new ResumeExtendInfo();
                resumeExtendInfo.setResumeBase((ResumeBaseInfo)resumeBaseInfo);
                resumeExtendInfo.setCategory((ResumeCategoryInfo)resumeCategoryInfo);
                resumeExtendInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                pk = ResumeExtendFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)resumeExtendInfo);
                return pk;
            }
            throw new ImportDataException(ImportDataException.BASECATEGORY_NOT_EXIST);
        }
        throw new ImportDataException(ImportDataException.RESUMEEXTEND_ADD_ERROR);
    }

    protected void _deleteCertificate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            ICertificate certificate = CertificateFactory.getLocalInstance(ctx);
            certificate.delete(pk);
        }
    }

    protected void _deleteEducationExp(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            IEducationExp educationExp = EducationExpFactory.getLocalInstance(ctx);
            educationExp.delete(pk);
        }
    }

    protected void _deleteResumeBase(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            resumeBase.delete(pk);
        }
    }

    protected void _deleteResumeExtend(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            IResumeExtend resumeExtend = ResumeExtendFactory.getLocalInstance(ctx);
            resumeExtend.delete(pk);
        }
    }

    protected void _deleteSkill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            ISkill skill = SkillFactory.getLocalInstance(ctx);
            skill.delete(pk);
        }
    }

    protected void _deleteTrainExp(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            ITrainExp trainExp = TrainExpFactory.getLocalInstance(ctx);
            trainExp.delete(pk);
        }
    }

    protected void _deleteWorkExp(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            IWorkExp workExp = WorkExpFactory.getLocalInstance(ctx);
            workExp.delete(pk);
        }
    }

    protected List _overcastExtendSameData(Context ctx, IObjectValue resumeBaseInfo) throws BOSException, EASBizException {
        ArrayList<ResumeBaseInfo> baseInfos = new ArrayList<ResumeBaseInfo>();
        IResumeBase resumeBase = null;
        ResumeBaseCollection col = null;
        IObjectPK pk = null;
        BOSUuid id = null;
        String name = null;
        FilterInfo filterInfo = null;
        ResumeBaseInfo baseInfo = null;
        if (resumeBaseInfo != null && resumeBaseInfo instanceof ResumeBaseInfo) {
            resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            name = ((ResumeBaseInfo)resumeBaseInfo).getName();
            filterInfo = this.makeNameFilterInfo(ctx, name, "hrOrgUnit.id");
            baseInfo = (ResumeBaseInfo)resumeBaseInfo;
            if (resumeBase.exists(filterInfo)) {
                EntityViewInfo entityInfo = new EntityViewInfo();
                entityInfo.setFilter(filterInfo);
                SelectorItemCollection sc = entityInfo.getSelector();
                sc.add(new SelectorItemInfo("id"));
                sc.add(new SelectorItemInfo("number"));
                col = resumeBase.getResumeBaseCollection(entityInfo);
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    id = col.get(i).getId();
                    pk = new ObjectUuidPK(id);
                    baseInfo.setId(id);
                    baseInfo.setNumber(col.get(i).getNumber());
                    resumeBase.update(pk, (CoreBaseInfo)baseInfo);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    ResumeBaseInfo info = resumeBase.getResumeBaseInfo(pk, selector);
                    baseInfos.add(info);
                }
                FilterInfo cerFilter = this.makeIDFilterByResumeBaseName(ctx, "T_HR_Certificate", resumeBaseInfo);
                CertificateFactory.getLocalInstance(ctx).delete(cerFilter);
                FilterInfo eduFilter = this.makeIDFilterByResumeBaseName(ctx, "T_HR_EducationExp", resumeBaseInfo);
                EducationExpFactory.getLocalInstance(ctx).delete(eduFilter);
                FilterInfo trainFilter = this.makeIDFilterByResumeBaseName(ctx, "T_HR_TrainExp", resumeBaseInfo);
                TrainExpFactory.getLocalInstance(ctx).delete(trainFilter);
                FilterInfo skillFilter = this.makeIDFilterByResumeBaseName(ctx, "T_HR_Skill", resumeBaseInfo);
                SkillFactory.getLocalInstance(ctx).delete(skillFilter);
                FilterInfo workFilter = this.makeIDFilterByResumeBaseName(ctx, "T_HR_WorkExp", resumeBaseInfo);
                WorkExpFactory.getLocalInstance(ctx).delete(workFilter);
                FilterInfo extendFilter = this.makeIDFilterByResumeBaseName(ctx, "T_HR_ResumeExtend", resumeBaseInfo);
                ResumeExtendFactory.getLocalInstance(ctx).delete(extendFilter);
            } else {
                baseInfo.setNumber(RecServerUtils.getNumberSilent(ctx, (CoreBaseInfo)baseInfo, RecServerUtils.getCurrentHROrgUnit(ctx).getId().toString()));
                pk = resumeBase.addnew((CoreBaseInfo)baseInfo);
                baseInfo = resumeBase.getResumeBaseInfo(pk);
                baseInfos.add(baseInfo);
            }
        } else {
            throw new ImportDataException(ImportDataException.RESUMEBASE_ADD_ERROR);
        }
        return baseInfos;
    }

    private FilterInfo makeIDFilterByResumeBaseName(Context ctx, String table, IObjectValue resumeBaseInfo) {
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer("SELECT FID FROM ");
        sql.append(table);
        sql.append(" WHERE FresumeBaseID IN (SELECT FID FROM T_HR_ResumeBase WHERE FName_");
        sql.append(ctx.getLocale().toString());
        sql.append("=");
        sql.append("'");
        sql.append(((ResumeBaseInfo)resumeBaseInfo).getName(ctx.getLocale()));
        sql.append("'");
        sql.append(")");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    private FilterInfo makeIDFilterInfo(String id) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)id, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        return filter;
    }

    private FilterInfo makeNameFilterInfo(Context ctx, String name, String hrOrgUnitId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)name, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        if (fi != null) {
            filter.mergeFilter(fi, "and");
        }
        return filter;
    }

    private FilterInfo makeIDFilterInfo(Context ctx, String id, String hrOrgUnitId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)id, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        if (fi != null) {
            filter.mergeFilter(fi, "and");
        }
        return filter;
    }
}

