/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.rec.IInterview;
import com.kingdee.eas.hr.rec.IInterviewEntry;
import com.kingdee.eas.hr.rec.IInterviewRecord;
import com.kingdee.eas.hr.rec.InterviewCollection;
import com.kingdee.eas.hr.rec.InterviewEntryCollection;
import com.kingdee.eas.hr.rec.InterviewEntryFactory;
import com.kingdee.eas.hr.rec.InterviewEntryInfo;
import com.kingdee.eas.hr.rec.InterviewException;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewRecordCollection;
import com.kingdee.eas.hr.rec.InterviewRecordFactory;
import com.kingdee.eas.hr.rec.InterviewRecordInfo;
import com.kingdee.eas.hr.rec.InterviewStepMagageFacadeFactory;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.app.AbstractInterviewFacadeControllerBean;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InterviewFacadeControllerBean
extends AbstractInterviewFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.InterviewFacadeControllerBean");

    protected IRowSet _getHistoryInterview(Context ctx, String resumeBaseId) throws BOSException, InterviewException, EASBizException {
        DynamicRowSet rowSet = null;
        if (resumeBaseId != null) {
            IRowSet distinctDateRowSet = this.getDistinctDate(ctx, resumeBaseId);
            try {
                rowSet = new DynamicRowSet(1);
                rowSet.setColInfo(1, new ColInfo("id", "id", 12, null));
                IInterview interview = InterviewFactory.getLocalInstance(ctx);
                for (int i = 0; i < distinctDateRowSet.size(); ++i) {
                    distinctDateRowSet.next();
                    Time time = (Time)distinctDateRowSet.getObject("interviewTime");
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("interviewTime", (Object)time));
                    filterInfo.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseId));
                    ev.setFilter(filterInfo);
                    SorterItemInfo sorterInfo = new SorterItemInfo("stepDate");
                    sorterInfo.setSortType(SortType.ASCEND);
                    ev.getSorter().add(sorterInfo);
                    InterviewCollection ic = interview.getInterviewCollection(ev);
                    if (ic == null || ic.size() <= 0) continue;
                    rowSet.moveToInsertRow();
                    rowSet.updateString("id", ic.get(ic.size() - 1).getId().toString());
                    rowSet.insertRow();
                }
                rowSet.beforeFirst();
            }
            catch (Exception ex) {
                throw new InterviewException(InterviewException.GET_HISTORYINTERVIEW_ERROR);
            }
        }
        return rowSet;
    }

    protected IObjectCollection _getHistoryStep(Context ctx, String resumeBaseId, String positionId, Time interviewTime, boolean isHistoryData) throws BOSException, InterviewException, EASBizException {
        IInterview interview = InterviewFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("interviewLevel.name"));
        sic.add(new SelectorItemInfo("interviewRecord.*"));
        sic.add(new SelectorItemInfo("interviewRecord.person.id"));
        sic.add(new SelectorItemInfo("interviewRecord.person.name"));
        int index = -1;
        if (resumeBaseId != null) {
            if (isHistoryData) {
                fic.add(new FilterItemInfo("resumeHistory.id", (Object)resumeBaseId));
            } else {
                fic.add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseId));
            }
            ++index;
        }
        if (positionId != null) {
            fic.add(new FilterItemInfo("position.id", (Object)positionId));
            ++index;
        }
        if (interviewTime != null) {
            fic.add(new FilterItemInfo("interviewTime", (Object)interviewTime));
            ++index;
        }
        StringBuffer maskString = new StringBuffer();
        if (index > 0) {
            for (int i = 0; i < index; ++i) {
                maskString.append("#" + i + " and ");
            }
            maskString.append("#" + index);
        }
        filterInfo.setMaskString(maskString.toString());
        evi.setFilter(filterInfo);
        return interview.getInterviewCollection(evi);
    }

    protected void _updateInterviewAndRecord(Context ctx, List interviewList, List recordList) throws BOSException, EASBizException {
        if (recordList != null && interviewList != null) {
            IInterviewRecord interviewRecord = InterviewRecordFactory.getLocalInstance(ctx);
            for (int i = 0; i < recordList.size(); ++i) {
                InterviewRecordInfo temp = (InterviewRecordInfo)recordList.get(i);
                InterviewRecordInfo realRecordInfo = interviewRecord.getInterviewRecordInfo((IObjectPK)new ObjectUuidPK(temp.getId().toString()));
                realRecordInfo.setInterviewComent(temp.getInterviewComent());
                realRecordInfo.setScore(temp.getScore());
                realRecordInfo.setDescription(temp.getDescription());
                if (temp.getInterviewResult() != null) {
                    realRecordInfo.setInterviewResult(temp.getInterviewResult());
                }
                if (temp.getCommentDate() != null) {
                    realRecordInfo.setCommentDate(temp.getCommentDate());
                }
                interviewRecord.update((IObjectPK)new ObjectUuidPK(realRecordInfo.getId().toString()), (CoreBaseInfo)realRecordInfo);
            }
        }
    }

    protected void _updateInterviewEntry(Context ctx, IObjectValue interviewEntryInfo) throws BOSException, EASBizException {
        InterviewEntryInfo temp;
        if (interviewEntryInfo != null && interviewEntryInfo instanceof InterviewEntryInfo && (temp = (InterviewEntryInfo)interviewEntryInfo).getId() != null) {
            IInterviewEntry interviewEntry = InterviewEntryFactory.getLocalInstance(ctx);
            InterviewEntryInfo info = interviewEntry.getInterviewEntryInfo((IObjectPK)new ObjectUuidPK(temp.getId().toString()));
            info.setInterviewComent(temp.getInterviewComent());
            info.setScore(temp.getScore());
            info.setDescription(temp.getDescription());
            if (temp.getInterviewResult() != null) {
                info.setInterviewResult(temp.getInterviewResult());
            }
            info.setIsRecorded(temp.isIsRecorded());
            interviewEntry.update((IObjectPK)new ObjectUuidPK(temp.getId().toString()), (CoreBaseInfo)info);
        }
    }

    private IRowSet getDistinctDate(Context ctx, String resumeBaseId) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryInterviewDistinctDateQuery");
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseId));
        SorterItemInfo sorterInfo = new SorterItemInfo("interviewTime");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        ev.setFilter(filterInfo);
        query.setObjectView(ev);
        return query.executeQuery();
    }

    protected Map _getInterviewPerson(Context ctx, List interviewIds) throws BOSException, EASBizException {
        LinkedHashMap map = new LinkedHashMap();
        if (interviewIds != null && interviewIds.size() > 0) {
            int j = interviewIds.size();
            for (int i = 0; i < j; ++i) {
                String str = this._getInterviewPersonAndPosition(ctx, interviewIds.get(i).toString());
                map.put(interviewIds.get(i), str);
            }
        }
        return map;
    }

    protected String _getInterviewPersonAndPosition(Context ctx, String interviewId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        IInterviewRecord interviewRecord = InterviewRecordFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("person.id"));
        fic.add(new FilterItemInfo("interview.id", (Object)interviewId));
        evi.setFilter(filterInfo);
        InterviewRecordCollection irc = interviewRecord.getInterviewRecordCollection(evi);
        if (irc != null && irc.size() > 0) {
            try {
                int j = irc.size();
                for (int i = 0; i < j; ++i) {
                    InterviewRecordInfo info = irc.get(i);
                    if (info.getPerson() == null) continue;
                    MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.PersonofPositionQuery");
                    IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo fInfo = new FilterInfo();
                    fInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId()));
                    viewInfo.setFilter(fInfo);
                    query.setObjectView(viewInfo);
                    IRowSet rowSet = query.executeQuery();
                    if (rowSet == null || rowSet.size() <= 0) continue;
                    rowSet.next();
                    String position = rowSet.getObject("position.name").toString();
                    String person = rowSet.getObject("person.name").toString();
                    sb.append(person).append("(").append(position).append(")").append(";");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
        return sb.toString();
    }

    protected IObjectValue _getPersonInterviewRecord(Context ctx, String interviewId) throws BOSException, EASBizException {
        IInterviewRecord interviewRecord = InterviewRecordFactory.getLocalInstance(ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo != null) {
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("interview.id", (Object)interviewId));
            fInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString()));
            evInfo.setFilter(fInfo);
            InterviewRecordCollection irc = interviewRecord.getInterviewRecordCollection(evInfo);
            if (irc != null && irc.size() > 0) {
                return irc.get(0);
            }
        }
        return null;
    }

    protected IObjectValue _getPersonInterviewEntry(Context ctx, String interviewId) throws BOSException, EASBizException {
        IInterviewEntry interviewEntry = InterviewEntryFactory.getLocalInstance(ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo != null) {
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("interview.id", (Object)interviewId));
            fInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString()));
            evInfo.setFilter(fInfo);
            InterviewEntryCollection iec = interviewEntry.getInterviewEntryCollection(evInfo);
            if (iec != null && iec.size() > 0) {
                return iec.get(0);
            }
        }
        return null;
    }

    protected Date _getInterviewTime(Context ctx, BOSUuid interviewId, BOSUuid personId) throws BOSException, EASBizException {
        Date date = null;
        if (interviewId != null && personId != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("interview.id", (Object)interviewId.toString()));
            fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)interviewId.toString()));
            evi.setFilter(fi);
            IInterviewEntry interviewEntry = InterviewEntryFactory.getLocalInstance(ctx);
            InterviewEntryCollection iec = interviewEntry.getInterviewEntryCollection(evi);
            if (iec != null && iec.size() > 0) {
                InterviewEntryInfo iei = iec.get(0);
                date = iei.getInterviewTime();
            }
        }
        return date;
    }

    protected void _setSalaryAndPosition(Context ctx, Map resumeMap, BOSUuid activityId) throws BOSException, EASBizException {
        if (resumeMap == null || resumeMap.size() == 0 || activityId == null) {
            return;
        }
        Set idSet = resumeMap.keySet();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.setSelector(RecServerUtils.getSic(new String[]{"id", "position.id"}));
        ResumeBaseCollection coll = ResumeBaseFactory.getLocalInstance(ctx).getResumeBaseCollection(evi);
        SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"workDate", "workAspect", "remark", "position", "outPosition", "xinDian", "adminOrgUnit"});
        HashMap<String, String> m = new HashMap<String, String>();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            ResumeBaseInfo oldInfo = coll.get(i);
            ResumeBaseInfo newInfo = (ResumeBaseInfo)resumeMap.get(oldInfo.getId().toString());
            if (oldInfo.getPosition() == null && newInfo.getPosition() != null || newInfo.getPosition() == null || oldInfo.getPosition() != null && newInfo.getPosition() != null && !newInfo.getPosition().getId().equals((Object)oldInfo.getPosition().getId())) {
                if (newInfo.getPosition() == null) {
                    m.put(newInfo.getId().toString(), null);
                } else {
                    m.put(newInfo.getId().toString(), newInfo.getPosition().getId().toString());
                }
            }
            this.batchUpdateHistory(ctx, activityId.toString(), m);
            ResumeBaseFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)newInfo, sic);
        }
    }

    private void batchUpdateHistory(Context ctx, String activityId, Map arrPosMap) throws BOSException, EASBizException {
        if (arrPosMap == null || arrPosMap.size() == 0) {
            return;
        }
        Set set = arrPosMap.entrySet();
        Connection conn = null;
        Statement ps = null;
        String sql = "update T_HR_ActivityRelationResume set FPositionID = ? where FResumeBaseID = ? and FInterviewActivityID= ?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (Map.Entry entry : set) {
                String id = entry.getKey().toString();
                String positionId = entry.getValue() == null ? null : entry.getValue().toString();
                ps = conn.prepareStatement(sql);
                ps.setString(1, positionId);
                ps.setString(2, id);
                ps.setString(3, activityId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
    }

    protected void _sendMessageAndEmail(Context ctx, String interviewId) throws BOSException, EASBizException {
        String personEmail = null;
        StringBuffer content = null;
        String RESOURCE = "com.kingdee.eas.hr.rec.HRRecResource";
        if (interviewId == null) {
            return;
        }
        String inteActiviname = null;
        String inteLevelname = null;
        HashSet<String> personId = new HashSet<String>();
        IRowSet rowSet = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fliter = new FilterInfo();
        fliter.getFilterItems().add(new FilterItemInfo("id", (Object)interviewId));
        viewInfo.setFilter(fliter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.rec.app", "InterviewforSendQuery"));
        iqec.setObjectView(viewInfo);
        rowSet = iqec.executeQuery();
        try {
            if (rowSet.next()) {
                personId.add(rowSet.getString("person.id"));
                personEmail = rowSet.getString("person.email");
                inteActiviname = rowSet.getString("interviewActivity.name");
                inteLevelname = rowSet.getString("interviewLevel.name");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (inteActiviname != null && inteLevelname != null) {
            content = new StringBuffer();
            String template = ResourceBase.getString((String)RESOURCE, (String)"sendMesAndEmail", (Locale)ctx.getLocale());
            content.append(MessageFormat.format(template, inteActiviname, inteLevelname));
        }
        if (personEmail != null) {
            MailUtil mailUtil = MailUtil.getInstance((Context)ctx);
            try {
                mailUtil.sendHtmlMail("", personEmail, ResourceBase.getString((String)RESOURCE, (String)"interviewLevelStep", (Locale)ctx.getLocale()), content.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (personId != null && inteActiviname != null && inteLevelname != null) {
            HashMap<String, String> msgMap = new HashMap<String, String>();
            msgMap.put("sender", ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"17_InterviewRecordUI", (Locale)ctx.getLocale()));
            msgMap.put("title", ResourceBase.getString((String)RESOURCE, (String)"interviewLevelStep", (Locale)ctx.getLocale()));
            msgMap.put("body", content.toString());
            InterviewStepMagageFacadeFactory.getLocalInstance(ctx).sendMsg(personId, msgMap);
        }
    }

    protected void _updateInterviewer(Context ctx, String oldvalue, String newValue, String interviewID) throws BOSException, EASBizException {
        StringBuffer updateEntry = new StringBuffer("update T_HR_InterviewEntry set FPersonID='");
        updateEntry.append(newValue).append("' where FPersonID='").append(oldvalue).append("' and FInterviewID='").append(interviewID).append("'");
        StringBuffer updateRecord = new StringBuffer("update T_HR_InterviewRecord set FPersonID='");
        updateRecord.append(newValue).append("' where FPersonID='").append(oldvalue).append("' and FInterviewID='").append(interviewID).append("'");
        DbUtil.execute((Context)ctx, (String)updateEntry.toString());
        DbUtil.execute((Context)ctx, (String)updateRecord.toString());
    }
}

