/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.app.PersonCountFacade;
import com.kingdee.eas.hr.rec.PositionVacancyInfo;
import com.kingdee.eas.hr.rec.app.AbstractPositionVacancyFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PositionVacancyFacadeControllerBean
extends AbstractPositionVacancyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.PositionVacancyFacadeControllerBean");
    private static String SEPARATOR_IDS = "@79931a4a-aa3a-4271-fe04-0a8c01c3d56a1234@";

    protected List _getPositionVacancyData(Context ctx, HashMap map, FilterInfo empTypeFilter) throws BOSException, EASBizException {
        Set idsSet;
        ArrayList<PositionVacancyInfo> list = new ArrayList<PositionVacancyInfo>();
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String hrOrgUnitID = "nodata";
        if (hrInfo != null) {
            hrOrgUnitID = hrInfo.getId().toString();
        }
        AdminOrgUnitInfo adminInfo = null;
        PositionInfo posiInfo = null;
        boolean paramPartimeOrg = false;
        paramPartimeOrg = hrInfo != null ? HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_SUM_ADMIN", (String)hrInfo.getId().toString()) : HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_SUM_ADMIN", null);
        String whereStr = HRUtil.getWhereStr((Context)ctx, (String)"T_ORG_Admin.FID");
        FilterInfo adminFilterInfo = null;
        FilterInfo posiFilterInfo = null;
        if (map.get("Admin_Item") != null) {
            String orgIds = (String)map.get("Admin_Item");
            idsSet = this.getIdSet(orgIds);
            adminFilterInfo = new FilterInfo();
            adminFilterInfo.getFilterItems().add(new FilterItemInfo("T_ORG_Admin.FID", (Object)idsSet, CompareType.INCLUDE));
        }
        if (map.get("Position_Item") != null) {
            String posiIds = (String)map.get("Position_Item");
            idsSet = this.getIdSet(posiIds);
            posiFilterInfo = new FilterInfo();
            posiFilterInfo.getFilterItems().add(new FilterItemInfo("T_ORG_Position.FID", (Object)idsSet, CompareType.INCLUDE));
        }
        IRowSet planRows = this.getPosiPlanCount(ctx, whereStr);
        IRowSet actualRows = PersonCountFacade.getInstance().getPosiActualCount(ctx, paramPartimeOrg, hrOrgUnitID, true);
        HashMap numByEmployeeTypeMas = null;
        if (empTypeFilter != null && empTypeFilter.getFilterItems().size() > 0) {
            IRowSet numByEmployeeTypeRows = this.getNumByEmployeeType(ctx, hrOrgUnitID, empTypeFilter, paramPartimeOrg, true);
            numByEmployeeTypeMas = this.getPosiDataByRowSet(ctx, numByEmployeeTypeRows, false);
        }
        HashMap posiPlanMaps = this.getPosiDataByRowSet(ctx, planRows, true, true);
        HashMap posiActualMaps = this.getPosiDataByRowSet(ctx, actualRows, false);
        IRowSet posiRows = this.getPositionRows(ctx, hrOrgUnitID, adminFilterInfo, posiFilterInfo);
        try {
            posiRows.beforeFirst();
            while (posiRows.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)posiRows.getString("FAdminOrgUnitID")));
                adminInfo.setName(posiRows.getString("adminName"));
                posiInfo = new PositionInfo();
                posiInfo.setId(BOSUuid.read((String)posiRows.getString("FID")));
                posiInfo.setName(posiRows.getString("Name"));
                if (empTypeFilter != null && empTypeFilter.getFilterItems().size() > 0) {
                    list.add(this.getRowInfo(ctx, adminInfo, posiPlanMaps, posiActualMaps, numByEmployeeTypeMas, posiInfo));
                    continue;
                }
                list.add(this.getRowInfo(ctx, adminInfo, posiPlanMaps, posiActualMaps, posiInfo));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private Set getIdSet(String idStrs) {
        HashSet<String> idSet = new HashSet<String>();
        String[] ids = idStrs.split(SEPARATOR_IDS);
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(ids[i]);
        }
        return idSet;
    }

    private IRowSet getPosiPlanCount(Context ctx, String whereStr) throws BOSException, EASBizException {
        IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getLocalInstance((Context)ctx);
        PersonPlanSchemeInfo schemeInfo = iPPScheme.getDefaultScheme();
        if (schemeInfo == null || schemeInfo.getStatus() != SchemeStatus.EXECUTE || schemeInfo.getPlanType() != PersonPlanType.POSITION) {
            return null;
        }
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPositionID FItem, FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,");
        sql.append("FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12 ");
        sql.append(" FROM T_HR_PersonPlan ");
        sql.append(whereStr.replaceAll("T_ORG_Admin.FID", "FAdminOrgID"));
        sql.append(" AND FSchemeID='");
        sql.append(schemeInfo.getId());
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getNumByEmployeeType(Context ctx, String hrOrgUnitID, FilterInfo empTypeFilter, boolean paramPartimeOrg, boolean showVirtualOrg) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (paramPartimeOrg) {
            sql.append("SELECT T_ORG_Position.FID FItem ,T_ORG_Admin.FID, COUNT(T_BD_Person.FID) numCount ");
        } else {
            sql.append("SELECT T_ORG_Position.FID FItem ,T_ORG_Admin.FID, COUNT(DISTINCT T_BD_Person.FID) numCount ");
        }
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_BD_Person INNER JOIN T_ORG_PositionMember ON ");
        sql.append("T_BD_Person.FID = T_ORG_PositionMember.FPersonID ON ");
        sql.append("T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ON ");
        sql.append("T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("INNER JOIN T_HR_BDEmployeeType on T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append(" inner join T_ORG_UnitRelation on T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID  ");
            sql.append(" and T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        }
        sql.append(" WHERE ");
        sql.append(" T_ORG_Admin.FIsSealUp = 0 ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append(" AND (");
            sql.append("T_ORG_Admin.FID = '");
            sql.append(hrOrgUnitID);
            sql.append("' or (T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgUnitID);
            sql.append("' )");
            sql.append(")");
        }
        if (empTypeFilter != null) {
            sql.append(" AND " + empTypeFilter.toSql());
        }
        if (!paramPartimeOrg) {
            sql.append(" AND T_ORG_PositionMember.FisPrimary = 1 ");
        }
        if (!showVirtualOrg) {
            sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
        }
        sql.append(" GROUP BY T_ORG_Position.FID,T_ORG_Admin.FID");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private HashMap getPosiDataByRowSet(Context ctx, IRowSet rows, boolean isPlan) throws BOSException, EASBizException {
        return this.getPosiDataByRowSet(ctx, rows, isPlan, true);
    }

    private HashMap getPosiDataByRowSet(Context ctx, IRowSet rows, boolean isPlan, boolean isShowInvalidPosition) throws BOSException, EASBizException {
        if (rows == null) {
            return new HashMap();
        }
        int size = rows.size();
        HashMap<String, String> maps = null;
        maps = size > 0 ? new HashMap(size) : new HashMap<String, String>();
        Calendar now = Calendar.getInstance(ctx.getLocale());
        try {
            HashSet<String> deletedPositionSet = new HashSet<String>();
            if (isPlan && !isShowInvalidPosition) {
                IPosition iposi = PositionFactory.getLocalInstance((Context)ctx);
                PositionCollection posCol = iposi.getPositionCollection("select id where deletedStatus=2");
                for (int i = 0; i < posCol.size(); ++i) {
                    deletedPositionSet.add(posCol.get(i).getId().toString());
                }
            }
            while (rows.next()) {
                if (isPlan) {
                    if (deletedPositionSet.contains(rows.getString("FItem")) && !isShowInvalidPosition) continue;
                    maps.put(rows.getString("FItem"), rows.getString(now.get(2) + 2));
                    continue;
                }
                maps.put(rows.getString("FItem"), rows.getString("numCount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return maps;
    }

    private IRowSet getPositionRows(Context ctx, String hrOrgUnitID, FilterInfo adminFilterInfo, FilterInfo posiFilterInfo) throws EASBizException, BOSException {
        PersonPlanSchemeInfo schemeInfo;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_ORG_Position.FID,T_ORG_Position.FName_");
        sql.append(ctx.getLocale().toString());
        sql.append(" Name, T_ORG_Position.FAdminOrgUnitID, T_ORG_Admin.FDisplayName_");
        sql.append(ctx.getLocale().toString());
        sql.append(" adminName FROM T_ORG_Position ");
        sql.append(" inner join T_ORG_Admin on T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append(" inner join T_ORG_UnitRelation on T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
            sql.append("AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        }
        sql.append(" WHERE ");
        sql.append(" T_ORG_Admin.FIsSealUp = 0 ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            sql.append(" AND (");
            sql.append(" T_ORG_Admin.FID in ( ");
            sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation  where FToUnitID =");
            sql.append("'");
            sql.append(hrOrgUnitID);
            sql.append("' AND FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sql.append(" AND FFromUnitID in (");
            sql.append(" SElECT FOrgID FROM T_PM_OrgRange where FUserID=");
            sql.append("'");
            sql.append(userId);
            sql.append("'");
            sql.append(" AND FType=");
            sql.append(20);
            sql.append("))");
            sql.append(")");
        }
        if ((schemeInfo = PersonPlanSchemeFactory.getLocalInstance((Context)ctx).getDefaultScheme()) != null && schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append(" AND ((T_ORG_Position.FID IN (SELECT FPositionID FROM T_HR_PersonPlan WHERE FSchemeID = '");
            sql.append(schemeInfo.getId().toString());
            sql.append("')) OR (T_ORG_Position.FDeletedStatus = 1))");
        }
        if (adminFilterInfo != null) {
            sql.append(" AND " + adminFilterInfo.toSql());
        }
        if (posiFilterInfo != null) {
            sql.append(" AND " + posiFilterInfo.toSql());
        }
        sql.append(" ORDER BY T_ORG_Position.FAdminOrgUnitID,T_ORG_Position.FIndex ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private PositionVacancyInfo getRowInfo(Context ctx, AdminOrgUnitInfo info, HashMap posiPlanMaps, HashMap posiActualMaps, PositionInfo pInfo) {
        return this.getRowInfo(ctx, info, posiPlanMaps, posiActualMaps, null, pInfo);
    }

    private PositionVacancyInfo getRowInfo(Context ctx, AdminOrgUnitInfo info, HashMap posiPlanMaps, HashMap posiActualMaps, HashMap numByEmployeeTypeMas, PositionInfo pInfo) {
        PositionVacancyInfo rowInfo = new PositionVacancyInfo();
        rowInfo.adminInfo = info;
        rowInfo.positionInfo = pInfo;
        if (posiPlanMaps.get(pInfo.getId().toString()) != null) {
            rowInfo.plan = Integer.parseInt(posiPlanMaps.get(pInfo.getId().toString()).toString());
        }
        if (posiActualMaps.get(pInfo.getId().toString()) != null) {
            rowInfo.actual = Integer.parseInt(posiActualMaps.get(pInfo.getId().toString()).toString());
        }
        rowInfo.vacancy = rowInfo.plan - rowInfo.actual;
        if (numByEmployeeTypeMas != null && numByEmployeeTypeMas.get(pInfo.getId().toString()) != null) {
            rowInfo.isSetEmployeeType = true;
            rowInfo.numByEmployeeType = Integer.parseInt(numByEmployeeTypeMas.get(pInfo.getId().toString()).toString());
        }
        return rowInfo;
    }
}

