/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.rec.app.AbstractRecChanneFacadeControllerBean;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class RecChanneFacadeControllerBean
extends AbstractRecChanneFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.RecChanneFacadeControllerBean");

    private StringBuffer getAloneStringSQL(Context ctx, String strType, List arrayCustomAge) throws BOSException {
        StringBuffer strBuffer = new StringBuffer();
        if (strType.equals("chkAge")) {
            int iMin = this._getMinAgeSegment(ctx, arrayCustomAge);
            int iMax = this._getMaxAgeSegment(ctx, arrayCustomAge);
            strBuffer.append(" GROUP BY ");
            strBuffer.append(" recChanne.FID, ResumeCategory.FID");
            strBuffer.append(", resumeBase.FBirthday ");
        } else if (strType.equals("chkDiploma")) {
            strBuffer.append(" Left JOIN T_BD_HRDiploma AS DIPLOMA ");
            strBuffer.append(" ON resumeBase.FHighestDiplomaID = DIPLOMA.FID");
            strBuffer.append(" GROUP BY ");
            strBuffer.append(" recChanne.FID, ResumeCategory.FID");
            strBuffer.append(" , resumeBase.FHighestDiplomaID");
        } else if (strType.equals("chkSex")) {
            strBuffer.append(" GROUP BY ");
            strBuffer.append(" recChanne.FID, ResumeCategory.FID");
            strBuffer.append(" ,resumeBase.FGender");
        }
        return strBuffer;
    }

    private int _getMinAgeSegment(Context ctx, List arrayCustomAge) throws BOSException {
        if (arrayCustomAge != null && arrayCustomAge.size() != 0) {
            return this.getMinFromList(arrayCustomAge);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select isnull(min(FStartAge),0) as minAge from t_hr_bdagesegment");
        if (rowSet.size() > 0) {
            try {
                rowSet.next();
                return rowSet.getInt("minAge");
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }

    private int _getMaxAgeSegment(Context ctx, List arrayCustomAge) throws BOSException {
        if (arrayCustomAge != null && arrayCustomAge.size() != 0) {
            return this.getMaxFromList(arrayCustomAge);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select isnull(max(FEndAge),0) as maxAge from t_hr_bdagesegment");
        if (rowSet.size() > 0) {
            try {
                rowSet.next();
                return rowSet.getInt("maxAge");
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }

    private int getMinFromList(List arr) {
        int min = 0;
        for (int i = 0; i < arr.size(); ++i) {
            String str = (String)arr.get(i);
            String[] strList = str.split("--");
            String strMin = strList[0];
            if (i == 0) {
                min = Integer.parseInt(strMin);
            }
            if (Integer.parseInt(strMin) >= min) continue;
            min = Integer.parseInt(strMin);
        }
        return min;
    }

    private int getMaxFromList(List arr) {
        int max = 0;
        for (int i = 0; i < arr.size(); ++i) {
            String str = (String)arr.get(i);
            String[] strList = str.split("--");
            String strMax = strList[1];
            if (i == 0) {
                max = Integer.parseInt(strMax);
            }
            if (Integer.parseInt(strMax) <= max) continue;
            max = Integer.parseInt(strMax);
        }
        return max;
    }

    private StringBuffer getCommonSQL(Context ctx, String recChanneID, String interviewActivityID, String curResumeTypeId) throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" FROM  T_HR_ResumeExtend as resumeExtend");
        strBuffer.append(" LEFT OUTER JOIN  T_HR_ResumeCategory as ResumeCategory on  ResumeCategory.FID=resumeExtend.fcategoryID ");
        strBuffer.append(" inner JOIN  T_HR_ResumeBase as resumeBase on resumeBase.FID=resumeExtend.fResumeBaseID ");
        strBuffer.append(" LEFT OUTER JOIN  T_ORG_HRO AS HRORGUNIT  ON resumeExtend.FHrOrgUnitID = HRORGUNIT.FID ");
        strBuffer.append(" Inner JOIN  T_HR_RecChanne as recChanne on recChanne.FID= resumeBase.frecChanneID ");
        strBuffer.append(" inner join T_HR_InterviewActivity as InterviewActivity ");
        strBuffer.append(" on InterviewActivity.FID=resumeBase.FInterviewActivityID ");
        strBuffer.append(this.getConditionSQL(recChanneID, interviewActivityID, curResumeTypeId));
        return strBuffer;
    }

    private StringBuffer getConditionSQL(String recChanneID, String interviewActivityID) {
        String[] strs;
        StringBuffer strBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)recChanneID)) {
            strBuffer.append(" And recChanne.FID in ");
            strs = recChanneID.split(",");
            strBuffer.append(" (");
            strBuffer.append(this.getStringByArray(strs));
            strBuffer.append(" )");
        }
        if (StringUtils.isEmpty((String)interviewActivityID)) {
            strBuffer.append(" And InterviewActivity.FID in ('')");
        } else {
            strBuffer.append(" And InterviewActivity.FID in ");
            strs = interviewActivityID.split(",");
            strBuffer.append(" (");
            strBuffer.append(this.getStringByArray(strs));
            strBuffer.append(" )");
        }
        return strBuffer;
    }

    private StringBuffer getConditionSQL(String recChanneID, String interviewActivityID, String curResumeTypeId) {
        StringBuffer strBuffer = this.getConditionSQL(recChanneID, interviewActivityID);
        if (!StringUtils.isEmpty((String)curResumeTypeId)) {
            strBuffer.append(" AND ResumeCategory.FID in ");
            String[] strs = curResumeTypeId.split(",");
            strBuffer.append(" (");
            strBuffer.append(this.getStringByArray(strs));
            strBuffer.append(" ) OR ResumeCategory.FID IS NULL AND resumeBase.FIsInter = 1 ");
        } else {
            strBuffer.append(" OR ResumeCategory.FID IS NULL AND resumeBase.FIsInter = 1 ");
        }
        return strBuffer;
    }

    private StringBuffer getStringByArray(String[] strs) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            strBuffer.append("'");
            strBuffer.append(strs[i]);
            strBuffer.append("'");
            if (i == strs.length - 1) continue;
            strBuffer.append(",");
        }
        return strBuffer;
    }

    public String getHRFilterSQL(Context ctx) throws EASBizException, BOSException {
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        String sql = "";
        if (fi != null) {
            sql = " and HRORGUNIT.FID='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString() + "'";
        }
        return sql;
    }

    private String getSelectString(String strName) {
        String strSelect = "";
        if (strName.equals("chkAge")) {
            strSelect = " ,(YEAR(GetDate())-YEAR(resumeBase.FBirthday)) AS SNUMBER";
        } else if (strName.equals("chkDiploma")) {
            strSelect = " ,resumeBase.FHighestDiplomaID AS SNUMBER ";
        } else if (strName.equals("chkSex")) {
            strSelect = " ,resumeBase.FGender AS SNUMBER ";
        }
        return strSelect;
    }

    public StringBuffer getQuerySQL(Context ctx, String strType, String recChanneID, String interviewActivityID, String curResumeTypeId, List arrayCustomAge) throws EASBizException, BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  COUNT(distinct resumeExtend.FID) as resumeExtendCount,recChanne.FID as recChanneID,ResumeCategory.FID as resumeCategoryID");
        strBuffer.append(this.getSelectString(strType));
        strBuffer.append(this.getCommonSQL(ctx, recChanneID, interviewActivityID, curResumeTypeId));
        strBuffer.append(this.getHRFilterSQL(ctx));
        strBuffer.append(this.getAloneStringSQL(ctx, strType, arrayCustomAge));
        return strBuffer;
    }

    protected IRowSet _getRowsByCondtion(Context ctx, String condition, String interviewActivityID, String recChanneID, String curResumeTypeId, List arrayCustomAge) throws BOSException, EASBizException {
        StringBuffer strBuffer = this.getQuerySQL(ctx, condition, recChanneID, interviewActivityID, curResumeTypeId, arrayCustomAge);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        return rowSet;
    }

    protected IRowSet _getEmployRowSetByCondition(Context ctx, String interviewActivityID, String recChanneID, String curResumeTypeId) throws BOSException, EASBizException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  COUNT(distinct resumeExtend.FID) as resumeExtendCount,recChanne.FID as recChanneID,ResumeCategory.FID as resumeCategoryID ");
        strBuffer.append(this.getCommonSQL(ctx, recChanneID, interviewActivityID, curResumeTypeId));
        strBuffer.append(" where  (resumeBase.FresumeState=3 or resumeBase.FresumeState=6 or resumeBase.FresumeState=7 or resumeBase.FresumeState=8)");
        strBuffer.append(this.getHRFilterSQL(ctx));
        strBuffer.append(" Group by recChanne.FID ,ResumeCategory.FID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        return rowSet;
    }

    protected IRowSet _getInterviewRowSetByCondition(Context ctx, String interviewActivityID, String recChanneID, String curResumeTypeId) throws BOSException, EASBizException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  COUNT(distinct resumeExtend.FID) as resumeExtendCount,recChanne.FID as recChanneID,ResumeCategory.FID as resumeCategoryID ");
        strBuffer.append(this.getCommonSQL(ctx, recChanneID, interviewActivityID, curResumeTypeId));
        strBuffer.append(this.getHRFilterSQL(ctx));
        strBuffer.append(" Group by recChanne.FID ,ResumeCategory.FID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        return rowSet;
    }
}

