/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.app.AbstractRecCommonUtilFacadeControllerBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecCommonUtilFacadeControllerBean
extends AbstractRecCommonUtilFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.RecCommonUtilFacadeControllerBean");

    public Map _getPersonPosition(Context ctx, Set personIds) throws BOSException, EASBizException {
        if (personIds == null || personIds.size() <= 0) {
            return null;
        }
        HashMap<String, PositionMemberInfo> map = new HashMap<String, PositionMemberInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIds, CompareType.INCLUDE));
        evi.setFilter(fi);
        IPositionMember dao = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = dao.getPositionMemberCollection(evi);
        if (coll != null && coll.size() > 0) {
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                PositionMemberInfo info = coll.get(i);
                info = dao.getPositionMemberInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
                map.put(info.getPerson().getId().toString(), info);
            }
        }
        return map;
    }

    protected List _getDataBaseInfos(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        ArrayList<DataBaseInfo> list = new ArrayList<DataBaseInfo>();
        IResumeBase dao = ResumeBaseFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        int j = ids.size();
        for (int i = 0; i < j; ++i) {
            String id = ids.get(i).toString();
            DataBaseInfo info = dao.getDataBaseInfo((IObjectPK)new ObjectUuidPK(id), sic);
            list.add(info);
        }
        return list;
    }

    protected List _getPositionByNumber(Context ctx, List numberList) throws BOSException, EASBizException {
        ArrayList<PositionInfo> list = new ArrayList<PositionInfo>();
        if (numberList == null || numberList.size() <= 0) {
            return list;
        }
        IPosition biz = PositionFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        fi.getFilterItems().add(new FilterItemInfo("number", new HashSet(numberList), CompareType.INCLUDE));
        evi.setFilter(fi);
        PositionCollection pc = biz.getPositionCollection(evi);
        int j = pc.size();
        for (int i = 0; i < j; ++i) {
            list.add(pc.get(i));
        }
        return list;
    }

    protected Date _getServerDate(Context ctx) throws BOSException, EASBizException {
        return new Date(System.currentTimeMillis());
    }

    protected List _getBatchPersonByIds(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        int j = ids.size();
        for (int i = 0; i < j; ++i) {
            if (ids.get(i) == null || ids.get(i).toString().trim().length() == 0) continue;
            PersonInfo info = person.getPersonInfo((IObjectPK)new ObjectUuidPK(ids.get(i).toString()), sic);
            list.add(info);
        }
        return list;
    }

    protected List _getBatchPositionByIds(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        ArrayList<PositionInfo> list = new ArrayList<PositionInfo>();
        IPosition position = PositionFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        int j = ids.size();
        for (int i = 0; i < j; ++i) {
            if (ids.get(i) == null || ids.get(i).toString().trim().length() == 0) continue;
            PositionInfo info = position.getPositionInfo((IObjectPK)new ObjectUuidPK(ids.get(i).toString()), sic);
            list.add(info);
        }
        return list;
    }

    protected List _getBatchAdminOrgUnitByIds(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        ArrayList<AdminOrgUnitInfo> list = new ArrayList<AdminOrgUnitInfo>();
        IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        int j = ids.size();
        for (int i = 0; i < j; ++i) {
            if (ids.get(i) == null || ids.get(i).toString().trim().length() == 0) continue;
            AdminOrgUnitInfo info = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(ids.get(i).toString()), sic);
            list.add(info);
        }
        return list;
    }

    protected void _sendMessage(Context ctx, Set personIdSet, Map msgMap) throws BOSException, EASBizException {
        LanguageCollection langs;
        if (personIdSet == null || personIdSet.size() <= 0) {
            return;
        }
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        if (locales == null || locales.length <= 0) {
            return;
        }
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale locale2 = null;
        String personId2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        for (Locale locale2 : locales) {
            message.setLocaleStringHeader("title", (String)msgMap.get("title"), locale2);
            message.setLocaleStringHeader("sender", (String)msgMap.get("sender"), locale2);
            message.setLocaleStringHeader("body", (String)msgMap.get("body"), locale2);
        }
        BOSUuid[] userIds = null;
        for (String personId2 : personIdSet) {
            userIds = this.getUsersByPerson(ctx, personId2);
            if (userIds == null || userIds.length == 0) continue;
            int length = userIds.length;
            for (int j = 0; j < length; ++j) {
                if (userIds[j] == null) continue;
                message.setStringHeader("receiver", userIds[j].toString());
                senderAgent.sendMessage(message);
            }
        }
    }

    private BOSUuid[] getUsersByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        BOSUuid[] userIDs = null;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection users = iUser.getCollection("where person='" + personId + "'");
        if (users.size() > 0) {
            userIDs = new BOSUuid[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                userIDs[i] = users.get(i).getId();
            }
        }
        return userIDs;
    }

    protected Map _getCodeRuleProperties(Context ctx, IObjectValue info, String hrOrgUnitId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (info == null || hrOrgUnitId == null) {
            return map;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isExist = codingRuleManager.isExist(info, hrOrgUnitId);
        map.put("isExist", isExist);
        if (isExist) {
            boolean isAddView = codingRuleManager.isAddView(info, hrOrgUnitId);
            map.put("isAddView", isAddView);
            boolean isModifiable = codingRuleManager.isModifiable(info, hrOrgUnitId);
            map.put("isModifiable", isModifiable);
            String[] prop = codingRuleManager.getProperties(info, hrOrgUnitId);
            map.put("prop", prop);
            if (isAddView) {
                String number = codingRuleManager.getNumber(info, hrOrgUnitId);
                map.put("number", number);
            }
        }
        return map;
    }
}

