/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.rec.RecAuditStatesEnum;
import com.kingdee.eas.hr.rec.RecCommonException;
import com.kingdee.eas.hr.rec.RecruitSummaryFactory;
import com.kingdee.eas.hr.rec.RecruitSummaryInfo;
import com.kingdee.eas.hr.rec.app.AbstractRecruitSummaryControllerBean;
import org.apache.log4j.Logger;

public class RecruitSummaryControllerBean
extends AbstractRecruitSummaryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.RecruitSummaryControllerBean");

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("interviewActivity.number"));
        sic.add(new SelectorItemInfo("interviewActivity.name"));
        RecruitSummaryInfo summaryInfo = (RecruitSummaryInfo)this._getValue(ctx, pk, sic);
        return summaryInfo.getLogInfo();
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        RecruitSummaryInfo summaryInfo = (RecruitSummaryInfo)model;
        if (summaryInfo.getId() != null && RecAuditStatesEnum.AUDITED.equals((Object)this.getRecruitSummaryState(ctx, (IObjectPK)new ObjectUuidPK(summaryInfo.getId().toString())))) {
            throw new RecCommonException(RecCommonException.MODIFY_OR_DELETE_FAIL);
        }
        return super.submit(ctx, model);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (RecAuditStatesEnum.AUDITED.equals((Object)this.getRecruitSummaryState(ctx, pk))) {
            throw new RecCommonException(RecCommonException.MODIFY_OR_DELETE_FAIL);
        }
        super.delete(ctx, pk);
    }

    private RecAuditStatesEnum getRecruitSummaryState(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditState"));
        RecruitSummaryInfo info = RecruitSummaryFactory.getLocalInstance(ctx).getRecruitSummaryInfo(pk, sic);
        return info.getAuditState();
    }
}

