/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.hraux.DiplomaCollection;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ILangGrade;
import com.kingdee.eas.hr.base.LangGradeCollection;
import com.kingdee.eas.hr.base.LangGradeFactory;
import com.kingdee.eas.hr.base.LangGradeInfo;
import com.kingdee.eas.hr.base.SpecialtyTypeCollection;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.SpecialtyTypeInfo;
import com.kingdee.eas.hr.rec.AccessImportTaskFacadeFactory;
import com.kingdee.eas.hr.rec.AccessImportTaskStateEnum;
import com.kingdee.eas.hr.rec.CertificateInfo;
import com.kingdee.eas.hr.rec.EducationExpInfo;
import com.kingdee.eas.hr.rec.IAccessImportTaskFacade;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.SkillInfo;
import com.kingdee.eas.hr.rec.TrainExpInfo;
import com.kingdee.eas.hr.rec.WorkExpInfo;
import com.kingdee.eas.hr.rec.util.AccessField;
import com.kingdee.eas.hr.rec.util.AccessImportTaskLog;
import com.kingdee.eas.hr.rec.util.RecUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AccessFieldUtils {
    private static int diplomaMin = 2;
    private static int diplomaMax = 0;
    private static int gradeMin = 2;
    private static int gradeMax = 0;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.util.AccessFieldUtils");

    public static List splitEduExp(String eduExp) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        if (eduExp == null || eduExp.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)eduExp, (String)"********************");
        AccessFieldUtils.setDiplomaLength();
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList<String> info = new ArrayList<String>();
            String[] splits = StringUtils.split((String)infos[i], (String)"\r\n");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        if (j == 0) {
                            String[] date = StringUtils.split((String)temp[j], (String)AccessField.getTo());
                            for (int m = 0; m < date.length; ++m) {
                                info.add(date[m]);
                            }
                            continue;
                        }
                        info.add(temp[j]);
                    }
                    continue;
                }
                if (k == 1) {
                    AccessFieldUtils.checkDiplomaExist(splits[k], info);
                    continue;
                }
                info.add(splits[k]);
            }
            result.add(info);
        }
        return result;
    }

    private static void setDiplomaLength() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        DiplomaCollection diplomaColl = DiplomaFactory.getRemoteInstance().getDiplomaCollection(viewInfo);
        int size = diplomaColl.size();
        for (int i = 0; i < size; ++i) {
            int length = diplomaColl.get(i).getName().trim().length();
            if (diplomaMin > length) {
                diplomaMin = length;
            }
            if (diplomaMax >= length) continue;
            diplomaMax = length;
        }
        if (diplomaMin < 2) {
            diplomaMin = 2;
        }
    }

    private static void setGradeLength() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        LangGradeCollection gradeColl = LangGradeFactory.getRemoteInstance().getLangGradeCollection(viewInfo);
        int size = gradeColl.size();
        for (int i = 0; i < size; ++i) {
            int length = gradeColl.get(i).getName().trim().length();
            if (gradeMin > length) {
                gradeMin = length;
            }
            if (gradeMax >= length) continue;
            gradeMax = length;
        }
        if (gradeMin < 2) {
            gradeMin = 2;
        }
    }

    private static boolean isSimilar(String toSplit, String haved) {
        if (StringUtils.isEmpty((String)toSplit) || StringUtils.isEmpty((String)haved)) {
            return true;
        }
        int index = haved.indexOf(toSplit.substring(0, 1));
        if (index < 0) {
            return false;
        }
        return AccessFieldUtils.isSimilar(toSplit.substring(1), haved.substring(index));
    }

    private static void checkDiplomaExist(String sp, List info) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        DiplomaCollection diplomaColl = DiplomaFactory.getRemoteInstance().getDiplomaCollection(viewInfo);
        DiplomaInfo diplomaInfo = null;
        if (sp.length() <= diplomaMin) {
            throw new ImportDataException(ImportDataException.SPECIALTY_DIPLOMA_ERROR);
        }
        int len = sp.length();
        boolean isHave = false;
        String temp = null;
        String diplomaName = null;
        int count = diplomaMax < len ? diplomaMax : len;
        for (int i = diplomaMin; i <= count; ++i) {
            int size = diplomaColl.size();
            for (int j = 0; j < size; ++j) {
                diplomaInfo = diplomaColl.get(j);
                temp = sp.substring(len - i);
                diplomaName = diplomaInfo.getName();
                if (diplomaName.indexOf(temp) >= 0) {
                    info.add(sp.substring(0, len - i));
                    info.add(diplomaInfo);
                    isHave = true;
                    break;
                }
                if (!AccessFieldUtils.isSimilar(temp, diplomaName)) continue;
                info.add(sp.substring(0, len - i));
                info.add(diplomaInfo);
                isHave = true;
                break;
            }
            if (isHave) break;
        }
        if (!isHave) {
            info.add(sp);
        }
    }

    private static void checkGradeExist(String sp, List info) throws EASBizException, BOSException {
        ILangGrade grade = LangGradeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        LangGradeCollection gradeColl = grade.getLangGradeCollection(viewInfo);
        LangGradeInfo gradeInfo = null;
        if (sp.length() <= gradeMin) {
            throw new ImportDataException(ImportDataException.SKILL_GRADE_ERROR);
        }
        int len = sp.length();
        boolean isHave = false;
        String temp = null;
        String gradeName = null;
        int count = gradeMax < len ? gradeMax : len;
        for (int i = gradeMin; i <= count; ++i) {
            int size = gradeColl.size();
            for (int j = 0; j < size; ++j) {
                gradeInfo = gradeColl.get(j);
                temp = sp.substring(len - i);
                gradeName = gradeInfo.getName();
                if (gradeName.indexOf(temp) >= 0) {
                    info.add(sp.substring(0, len - i));
                    info.add(gradeInfo);
                    isHave = true;
                    break;
                }
                if (!AccessFieldUtils.isSimilar(temp, gradeName)) continue;
                info.add(sp.substring(0, len - i));
                info.add(gradeInfo);
                isHave = true;
                break;
            }
            if (isHave) break;
        }
        if (!isHave) {
            info.add(sp);
        }
    }

    public static List splitWorkExp(String workExp) {
        String REPORTOBJECT = AccessField.getReportObjet();
        String PERSONLEADED = AccessField.getPersonLeaded();
        String REASONTOLEAVE = AccessField.getReasonToLeave();
        String ATTESTOR = AccessField.getAttestor();
        String OUTSTANDINGACHIEVEMENT = AccessField.getOutstandingArchievement();
        ArrayList result = new ArrayList();
        if (workExp == null || workExp.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)workExp, (String)"********************");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            HashMap<String, String> info = new HashMap<String, String>();
            String[] splits = StringUtils.split((String)infos[i], (String)"\r\n");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        if (j == 0) {
                            String[] date = StringUtils.split((String)temp[j], (String)AccessField.getTo());
                            for (int m = 0; m < date.length; ++m) {
                                if (m == 0) {
                                    info.put("DateStart", date[m]);
                                    continue;
                                }
                                info.put("DateEnd", date[m]);
                            }
                            continue;
                        }
                        info.put("Company", temp[j]);
                    }
                    continue;
                }
                if (k == 1) {
                    info.put("PositionName", splits[k]);
                    continue;
                }
                if (k == 2) {
                    info.put("PositionDiscription", splits[k]);
                    continue;
                }
                if (k <= 2) continue;
                if (splits[k].lastIndexOf(REPORTOBJECT) >= 0) {
                    info.put("ReportObject", splits[k].substring(splits[k].lastIndexOf(REPORTOBJECT) + REPORTOBJECT.length()));
                }
                if (splits[k].lastIndexOf(PERSONLEADED) >= 0) {
                    info.put("PersonLeaded", splits[k].substring(splits[k].lastIndexOf(PERSONLEADED) + PERSONLEADED.length()));
                }
                if (splits[k].lastIndexOf(REASONTOLEAVE) >= 0) {
                    info.put("ReasonToLeave", splits[k].substring(splits[k].lastIndexOf(REASONTOLEAVE) + REASONTOLEAVE.length()));
                }
                if (splits[k].lastIndexOf(ATTESTOR) >= 0) {
                    info.put("Attestor", splits[k].substring(splits[k].lastIndexOf(ATTESTOR) + ATTESTOR.length()));
                }
                if (splits[k].lastIndexOf(OUTSTANDINGACHIEVEMENT) < 0) continue;
                info.put("OutstandingAchievement", splits[k].substring(splits[k].lastIndexOf(OUTSTANDINGACHIEVEMENT) + OUTSTANDINGACHIEVEMENT.length()));
            }
            result.add(info);
        }
        return result;
    }

    public static List splitTrainExp(String trainExp) {
        ArrayList result = new ArrayList();
        if (trainExp == null || trainExp.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)trainExp, (String)"********************");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList<String> info = new ArrayList<String>();
            String[] splits = StringUtils.split((String)infos[i], (String)"\r\n");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        if (j == 0) {
                            String[] date = StringUtils.split((String)temp[j], (String)AccessField.getTo());
                            for (int m = 0; m < date.length; ++m) {
                                info.add(date[m]);
                            }
                            continue;
                        }
                        info.add(temp[j]);
                    }
                    continue;
                }
                info.add(splits[k]);
            }
            result.add(info);
        }
        return result;
    }

    public static List splitCertificate(String certificate) {
        ArrayList result = new ArrayList();
        if (certificate == null || certificate.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)certificate, (String)"\r\n");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList<String> info = new ArrayList<String>();
            String[] splits = StringUtils.split((String)infos[i], (String)":");
            for (int k = 0; k < splits.length; ++k) {
                if (k == 0) {
                    String[] temp = StringUtils.split((String)splits[k], (String)AccessField.getDash());
                    for (int j = 0; j < temp.length; ++j) {
                        info.add(temp[j]);
                    }
                    continue;
                }
                info.add(splits[k]);
            }
            result.add(info);
        }
        return result;
    }

    public static List splitLanguage(String language) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        if (language == null || language.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)language, (String)"/");
        AccessFieldUtils.setGradeLength();
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            ArrayList info = new ArrayList();
            AccessFieldUtils.checkGradeExist(infos[i], info);
            result.add(info);
        }
        return result;
    }

    public static List splitSkill(String skill) throws BOSException {
        ArrayList result = new ArrayList();
        if (skill == null || skill.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)skill, (String)"\n\r");
        String separate = "-";
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            int split = infos[i].lastIndexOf(separate);
            if (split < 0) continue;
            ArrayList<String> info = new ArrayList<String>();
            info.add(infos[i].substring(0, split));
            info.add((String)AccessFieldUtils.getLGInfo(infos[i].substring(split += separate.length())));
            result.add(info);
        }
        return result;
    }

    public static List splitJobs(String jobs) {
        ArrayList<String> result = new ArrayList<String>();
        if (jobs == null || jobs.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)jobs, (String)",");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            result.add(infos[i]);
        }
        return result;
    }

    public static ResumeBaseInfo formResumeBaseInfo(Map resumeBaseMap, boolean isOvercast) throws Exception {
        ResumeBaseInfo info = new ResumeBaseInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (resumeBaseMap == null || !(resumeBaseMap instanceof HashMap)) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_MAP_NULL);
        }
        if (RecUtils.objectIsNull(resumeBaseMap.get("Name"))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_NAME_NULL);
        }
        info.setName((String)resumeBaseMap.get("Name"));
        if (RecUtils.objectIsNull(resumeBaseMap.get("Sex"))) {
            throw new ImportDataException(ImportDataException.RESUMEBASE_SEX_NULL);
        }
        if (((String)resumeBaseMap.get("Sex")).replace('\n', ' ').trim().equals(Genders.getEnum((String)"Male").toString())) {
            info.setGender(Genders.getEnum((String)"Male"));
        } else if (((String)resumeBaseMap.get("Sex")).replace('\n', ' ').trim().equals(Genders.getEnum((String)"Female").toString())) {
            info.setGender(Genders.getEnum((String)"Female"));
        } else {
            throw new ImportDataException(ImportDataException.RESUMEBASE_SEX_INVALID);
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Birthday"))) {
            String brith = resumeBaseMap.get("Birthday").toString();
            if (brith.length() == 7) {
                format.applyPattern("yyyy-MM");
            }
            try {
                Date birth = format.parse(brith);
                info.setBirthday(birth);
                info.setAge(AccessFieldUtils.getAgeByDate(birth));
            }
            catch (Exception imEx) {
                logger.debug((Object)"Access Import Error", (Throwable)imEx);
            }
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("NestedPlace"))) {
            Object[] obj = AccessFieldUtils.getProvinceCity((String)resumeBaseMap.get("NestedPlace"));
            info.setCity((CityInfo)obj[1]);
            info.setProvince((ProvinceInfo)obj[0]);
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("WorkYears"))) {
            info.setWorkYears(Integer.valueOf((String)resumeBaseMap.get("WorkYears")));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Hukou"))) {
            info.setNativePlace((String)resumeBaseMap.get("Hukou"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Address"))) {
            info.setAddressTX((String)resumeBaseMap.get("Address"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Email"))) {
            info.setEmail((String)resumeBaseMap.get("Email"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Tel_home"))) {
            info.setHomePhone((String)resumeBaseMap.get("Tel_home"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Tel_company"))) {
            info.setOfficePhone((String)resumeBaseMap.get("Tel_company"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Tel_mobile"))) {
            info.setCell((String)resumeBaseMap.get("Tel_mobile"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("WorkExpected"))) {
            info.setWorkAspect((String)resumeBaseMap.get("WorkExpected"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Job1"))) {
            info.setJob_1((String)resumeBaseMap.get("Job1"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Job2"))) {
            info.setJob_2((String)resumeBaseMap.get("Job2"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("Job3"))) {
            info.setJob_3((String)resumeBaseMap.get("Job3"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("SalaryExpected"))) {
            info.setSalaryReq((String)resumeBaseMap.get("SalaryExpected"));
        }
        if (!RecUtils.objectIsNull(resumeBaseMap.get("EVALUATE"))) {
            info.setEvaluate((String)resumeBaseMap.get("EVALUATE"));
        }
        if (!isOvercast) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        info.setYingPDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
        info.setHrOrgUnit(RecUtils.getCurrentHROrgUnit());
        return info;
    }

    private static int getAgeByDate(Date birth) {
        int age = 0;
        int birthYear = 0;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(birth);
        birthYear = calendar.get(1);
        Date now = new Date();
        calendar.setTime(now);
        age = calendar.get(1) - birthYear;
        return age;
    }

    private static Object[] getProvinceCity(String place) throws BOSException {
        int i;
        int size;
        String provinceKey = AccessField.getProvince();
        String cityKey = AccessField.getCity();
        String provinceName = null;
        String cityName = null;
        CityInfo cityInfo = null;
        ProvinceInfo provinceInfo = null;
        int provinceIndex = 0;
        int cityIndex = 0;
        Object[] obj = new Object[2];
        provinceIndex = place.indexOf(provinceKey);
        cityIndex = place.indexOf(cityKey);
        if (provinceIndex >= 0 && cityIndex == -1) {
            provinceName = place.substring(0, provinceIndex);
        } else if (provinceIndex >= 0 && cityIndex >= 0) {
            int cityLength = cityIndex + cityKey.length();
            int provinceLen = provinceIndex + provinceKey.length();
            if (provinceIndex > cityIndex) {
                provinceName = place.substring(cityLength, provinceIndex);
                cityName = place.substring(0, cityIndex);
            } else {
                cityName = place.substring(provinceLen, cityIndex);
                provinceName = place.substring(0, provinceIndex);
            }
        } else if (provinceIndex == -1 && cityIndex >= 0) {
            cityName = place.substring(0, cityIndex);
        }
        if (provinceName != null) {
            EntityViewInfo provineEntityViewInfo = new EntityViewInfo();
            FilterInfo provinceFilter = new FilterInfo();
            provinceFilter.getFilterItems().add(new FilterItemInfo("name", (Object)provinceName));
            provineEntityViewInfo.setFilter(provinceFilter);
            provineEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
            ProvinceCollection pcol = ProvinceFactory.getRemoteInstance().getProvinceCollection(provineEntityViewInfo);
            size = pcol.size();
            for (i = 0; i < size; ++i) {
                if (!pcol.get(i).getName().equals(provinceName)) continue;
                provinceInfo = pcol.get(i);
                break;
            }
        }
        if (cityName != null) {
            EntityViewInfo cityEntityViewInfo = new EntityViewInfo();
            FilterInfo cityFilter = new FilterInfo();
            cityFilter.getFilterItems().add(new FilterItemInfo("name", (Object)cityName));
            cityEntityViewInfo.setFilter(cityFilter);
            cityEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
            CityCollection ccol = CityFactory.getRemoteInstance().getCityCollection(cityEntityViewInfo);
            size = ccol.size();
            for (i = 0; i < size; ++i) {
                if (!ccol.get(i).getName().equals(cityName)) continue;
                cityInfo = ccol.get(i);
                provinceInfo = cityInfo.getProvince();
                break;
            }
        }
        obj[0] = provinceInfo;
        obj[1] = cityInfo;
        return obj;
    }

    public static boolean isEnqualsNow(String date) {
        return date.equals(AccessField.getToNow()) || date.equals(AccessField.getNow()) || date.equals(AccessField.getOnnow());
    }

    public static WorkExpInfo formWorkExp(Map workExp, ResumeBaseInfo resumeBase) throws Exception {
        WorkExpInfo info = new WorkExpInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (workExp == null || !(workExp instanceof HashMap)) {
            throw new ImportDataException(ImportDataException.WORKEXP_MAP_NULL);
        }
        if (!RecUtils.objectIsNull(workExp.get("DateStart"))) {
            String dateStart = workExp.get("DateStart").toString();
            if (dateStart.length() == 7) {
                format.applyPattern("yyyy-MM");
            }
            try {
                info.setStartDate(format.parse(dateStart));
            }
            catch (Exception imEx) {
                logger.debug((Object)"Access Import Error", (Throwable)imEx);
            }
        }
        if (!RecUtils.objectIsNull(workExp.get("DateEnd"))) {
            if (AccessFieldUtils.isEnqualsNow((String)workExp.get("DateEnd"))) {
                info.setEndDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
            } else {
                String dateEnd = workExp.get("DateEnd").toString();
                if (dateEnd.length() == 7) {
                    format.applyPattern("yyyy-MM");
                } else {
                    format.applyPattern("yyyy-MM-dd");
                }
                try {
                    info.setEndDate(format.parse(dateEnd));
                }
                catch (Exception imEx) {
                    logger.debug((Object)"Access Import Error", (Throwable)imEx);
                }
            }
        }
        if (RecUtils.objectIsNull(workExp.get("Company"))) {
            throw new ImportDataException(ImportDataException.WORKEXP_COMPANY_NULL);
        }
        info.setOrgan((String)workExp.get("Company"));
        if (!RecUtils.objectIsNull(workExp.get("PositionName"))) {
            info.setPosition((String)workExp.get("PositionName"));
        }
        if (!RecUtils.objectIsNull(workExp.get("PositionDiscription"))) {
            info.setDuty((String)workExp.get("PositionDiscription"));
        }
        if (!RecUtils.objectIsNull(workExp.get("PersonLeaded"))) {
            info.setUnderNum(new Integer((String)workExp.get("PersonLeaded")));
        }
        if (!RecUtils.objectIsNull(workExp.get("Attestor"))) {
            info.setLinkman((String)workExp.get("Attestor"));
        }
        if (!RecUtils.objectIsNull(workExp.get("ReasonToLeave"))) {
            info.setDimissionReson((String)workExp.get("ReasonToLeave"));
        }
        if (!RecUtils.objectIsNull(workExp.get("OutstandingAchievement"))) {
            info.setRemark((String)workExp.get("OutstandingAchievement"));
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    public static EducationExpInfo formEducationExp(List eduExp, ResumeBaseInfo resumeBase) throws Exception {
        EducationExpInfo info = new EducationExpInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (eduExp == null || !(eduExp instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.EDUEXP_LIST_NULL);
        }
        int size = eduExp.size();
        block11: for (int i = 0; i < size; ++i) {
            if (eduExp.get(i).toString().length() == 7) {
                format.applyPattern("yyyy-MM");
            } else {
                format.applyPattern("yyyy-MM-dd");
            }
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) continue block11;
                    try {
                        info.setStartDate(format.parse((String)eduExp.get(i)));
                    }
                    catch (Exception imEx) {
                        logger.debug((Object)"Access Import Error", (Throwable)imEx);
                    }
                    continue block11;
                }
                case 1: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) continue block11;
                    if (AccessFieldUtils.isEnqualsNow((String)eduExp.get(i))) {
                        info.setEndDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
                        continue block11;
                    }
                    try {
                        info.setEndDate(format.parse((String)eduExp.get(i)));
                    }
                    catch (Exception imEx) {
                        logger.debug((Object)"Access Import Error", (Throwable)imEx);
                    }
                    continue block11;
                }
                case 2: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) {
                        throw new ImportDataException(ImportDataException.EDUEXP_SCHOOL_NULL);
                    }
                    info.setSchool((String)eduExp.get(i));
                    continue block11;
                }
                case 3: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) continue block11;
                    info.setSpecialty((String)eduExp.get(i));
                    continue block11;
                }
                case 4: {
                    if (RecUtils.objectIsNull(eduExp.get(i))) continue block11;
                    if (eduExp.get(i) == null || !(eduExp.get(i) instanceof DiplomaInfo)) {
                        info.setDiploma(null);
                        continue block11;
                    }
                    info.setDiploma((DiplomaInfo)eduExp.get(i));
                    continue block11;
                }
            }
        }
        EntityViewInfo specialtyEntityViewInfo = new EntityViewInfo();
        FilterInfo speciaFilter = new FilterInfo();
        speciaFilter.getFilterItems().add(new FilterItemInfo("name", (Object)AccessField.getUnknown()));
        specialtyEntityViewInfo.setFilter(speciaFilter);
        specialtyEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        SpecialtyTypeCollection stCol = SpecialtyTypeFactory.getRemoteInstance().getSpecialtyTypeCollection(specialtyEntityViewInfo);
        SpecialtyTypeInfo stInfo = null;
        int size2 = stCol.size();
        for (int i = 0; i < size2; ++i) {
            if (!stCol.get(i).getName().equals(AccessField.getUnknown())) continue;
            stInfo = stCol.get(i);
            break;
        }
        info.setSpecialtyType(stInfo);
        info.setResumeBase(resumeBase);
        return info;
    }

    public static TrainExpInfo formTrainExp(List trainExp, ResumeBaseInfo resumeBase) throws Exception {
        TrainExpInfo info = new TrainExpInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (trainExp == null || !(trainExp instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.TRAINEXP_LIST_NULL);
        }
        int size = trainExp.size();
        block11: for (int i = 0; i < size; ++i) {
            if (trainExp.get(i).toString().length() == 7) {
                format.applyPattern("yyyy-MM");
            } else {
                format.applyPattern("yyyy-MM-dd");
            }
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) continue block11;
                    try {
                        info.setStartDate(format.parse((String)trainExp.get(i)));
                    }
                    catch (Exception imEx) {
                        logger.debug((Object)"Access Import Error", (Throwable)imEx);
                    }
                    continue block11;
                }
                case 1: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) continue block11;
                    if (AccessFieldUtils.isEnqualsNow((String)trainExp.get(i))) {
                        info.setEndDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
                        continue block11;
                    }
                    try {
                        info.setEndDate(format.parse((String)trainExp.get(i)));
                    }
                    catch (Exception imEx) {
                        logger.debug((Object)"Access Import Error", (Throwable)imEx);
                    }
                    continue block11;
                }
                case 2: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) continue block11;
                    info.setTrainOrg((String)trainExp.get(i));
                    continue block11;
                }
                case 3: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) {
                        throw new ImportDataException(ImportDataException.TRAINEXP_COURCE_NULL);
                    }
                    info.setTrainItem((String)trainExp.get(i));
                    continue block11;
                }
                case 4: {
                    if (RecUtils.objectIsNull(trainExp.get(i))) continue block11;
                    info.setTrainContent((String)trainExp.get(i));
                }
            }
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    public static SkillInfo formSkillInfo(List skill, ResumeBaseInfo resumeBase) throws Exception {
        SkillInfo info = new SkillInfo();
        if (skill == null || !(skill instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.SKILL_LIST_NULL);
        }
        int size = skill.size();
        block4: for (int i = 0; i < size; ++i) {
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(skill.get(i))) {
                        throw new ImportDataException(ImportDataException.SKILL_NAME_NULL);
                    }
                    info.setName((String)skill.get(i));
                    continue block4;
                }
                case 1: {
                    if (RecUtils.objectIsNull(skill.get(i))) continue block4;
                    info.setLangGrade((LangGradeInfo)skill.get(i));
                }
            }
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    private static LangGradeInfo getLGInfo(String name) throws BOSException {
        LangGradeInfo info = null;
        EntityViewInfo lgEntityViewInfo = new EntityViewInfo();
        FilterInfo lgFilter = new FilterInfo();
        lgFilter.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        lgEntityViewInfo.setFilter(lgFilter);
        lgEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        LangGradeCollection lgCol = LangGradeFactory.getRemoteInstance().getLangGradeCollection(lgEntityViewInfo);
        int size = lgCol.size();
        for (int i = 0; i < size && !(info = lgCol.get(i)).getName().equals(name); ++i) {
        }
        return info;
    }

    public static CertificateInfo formCertificateInfo(List cer, ResumeBaseInfo resumeBase) throws Exception {
        CertificateInfo info = new CertificateInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (cer == null || !(cer instanceof ArrayList)) {
            throw new ImportDataException(ImportDataException.CERTIFICATE_LIST_NULL);
        }
        block6: for (int i = 0; i < cer.size(); ++i) {
            if (cer.get(i).toString().length() == 7) {
                format.applyPattern("yyyy-MM");
            } else {
                format.applyPattern("yyyy-MM-dd");
            }
            switch (i) {
                case 0: {
                    if (RecUtils.objectIsNull(cer.get(i))) continue block6;
                    try {
                        info.setCertifyDate(format.parse((String)cer.get(i)));
                    }
                    catch (Exception imEx) {
                        logger.debug((Object)"Access Import Error", (Throwable)imEx);
                    }
                    continue block6;
                }
                case 1: {
                    if (RecUtils.objectIsNull(cer.get(i))) {
                        throw new ImportDataException(ImportDataException.CERTIFICATE_NAME_NULL);
                    }
                    info.setName((String)cer.get(i));
                    continue block6;
                }
            }
        }
        info.setResumeBase(resumeBase);
        return info;
    }

    public static String workYearsTrans(String workyears) {
        String result = null;
        if (!StringUtils.isEmpty((String)workyears)) {
            int yearsIndex = workyears.indexOf(AccessField.getYear());
            result = yearsIndex == -1 ? Integer.valueOf(0).toString() : AccessFieldUtils.numberTrans(workyears.substring(0, yearsIndex));
        }
        return result;
    }

    public static String numberTrans(String number) {
        String result = null;
        int tenIndex = number.indexOf(AccessField.getTen());
        result = tenIndex == -1 ? Integer.valueOf(AccessFieldUtils.singleNumberTrans(number)).toString() : Integer.valueOf(AccessFieldUtils.singleNumberTrans(number.substring(0, tenIndex))).toString() + Integer.valueOf(AccessFieldUtils.singleNumberTrans(number.substring(tenIndex + AccessField.getTen().length()))).toString();
        return result;
    }

    public static int singleNumberTrans(String number) {
        if (number.equals(AccessField.getZero())) {
            return 0;
        }
        if (number.equals(AccessField.getOne())) {
            return 1;
        }
        if (number.equals(AccessField.getTwo())) {
            return 2;
        }
        if (number.equals(AccessField.getThree())) {
            return 3;
        }
        if (number.equals(AccessField.getFour())) {
            return 4;
        }
        if (number.equals(AccessField.getFive())) {
            return 5;
        }
        if (number.equals(AccessField.getSix())) {
            return 6;
        }
        if (number.equals(AccessField.getSeven())) {
            return 7;
        }
        if (number.equals(AccessField.getEight())) {
            return 8;
        }
        if (number.equals(AccessField.getNine())) {
            return 9;
        }
        return 0;
    }

    public static List excuteImport(RowSet rs, ResumeCategoryInfo rcInfo, boolean isOvercast) throws Exception {
        HashMap<String, String> resumeBaseMap = new HashMap<String, String>();
        IAccessImportTaskFacade iAccessImportTaskFacade = AccessImportTaskFacadeFactory.getRemoteInstance();
        List list = null;
        String accessID = null;
        String accessName = null;
        ArrayList<String> importInfo = new ArrayList<String>();
        StringBuffer exInfo = null;
        int totalRecord = 0;
        int successRecord = 0;
        ResumeBaseInfo resumeBaseInfo = null;
        ArrayList<WorkExpInfo> workExpInfos = null;
        ArrayList<EducationExpInfo> educationExpInfos = null;
        ArrayList<TrainExpInfo> trainExpInfos = null;
        ArrayList<SkillInfo> skillInfos = null;
        ArrayList<CertificateInfo> certificateInfos = null;
        while (rs.next()) {
            ++totalRecord;
            accessID = rs.getString(AccessField.getID());
            accessName = rs.getString(AccessField.getName());
            resumeBaseMap.put("Name", rs.getString(AccessField.getName()));
            resumeBaseMap.put("Sex", rs.getString(AccessField.getGender()));
            resumeBaseMap.put("Birthday", rs.getString(AccessField.getBirthday()));
            resumeBaseMap.put("NestedPlace", rs.getString(AccessField.getCurrentResidency()));
            resumeBaseMap.put("WorkYears", AccessFieldUtils.workYearsTrans(rs.getString(AccessField.getYearsofWorking())));
            resumeBaseMap.put("Hukou", rs.getString(AccessField.getHuKou()));
            resumeBaseMap.put("Address", rs.getString(AccessField.getAddress()));
            resumeBaseMap.put("Email", rs.getString(AccessField.getEMail()));
            resumeBaseMap.put("Tel_home", rs.getString(AccessField.getHomeTelephone()));
            resumeBaseMap.put("Tel_company", rs.getString(AccessField.getWorkPhone()));
            resumeBaseMap.put("Tel_mobile", rs.getString(AccessField.getMobilePhone()));
            resumeBaseMap.put("EVALUATE", rs.getString(AccessField.getSelfAssessment()));
            resumeBaseMap.put("SalaryExpected", rs.getString(AccessField.getSalaryExpected()));
            StringBuffer workExpected = new StringBuffer();
            workExpected.append(AccessField.getTypeofEmployment());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getTypeofEmployment()));
            workExpected.append("\n");
            workExpected.append(AccessField.getTypeofCompany());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getTypeofCompany()));
            workExpected.append("\n");
            workExpected.append(AccessField.getIndustryExpected());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getIndustryExpected()));
            workExpected.append("\n");
            workExpected.append(AccessField.getWorkingPlaceExpected());
            workExpected.append(":");
            workExpected.append(rs.getString(AccessField.getWorkingPlaceExpected()));
            workExpected.append("\n");
            resumeBaseMap.put("WorkExpected", workExpected.toString());
            List jobs = AccessFieldUtils.splitJobs(rs.getString(AccessField.getJobFunctionExpected()));
            int max = jobs.size() > 3 ? 3 : jobs.size();
            for (int i = 0; i < max; ++i) {
                if (i == 0) {
                    resumeBaseMap.put("Job1", (String)jobs.get(i));
                }
                if (i == 1) {
                    resumeBaseMap.put("Job2", (String)jobs.get(i));
                }
                if (i != 2) continue;
                resumeBaseMap.put("Job3", (String)jobs.get(i));
            }
            try {
                int i;
                int i2;
                resumeBaseInfo = AccessFieldUtils.formResumeBaseInfo(resumeBaseMap, isOvercast);
                resumeBaseInfo.setResumeState(ResumeStateEnum.no_dispose);
                resumeBaseInfo.setPersonState(PersonStateEnum.noEntry);
                resumeBaseInfo.setIsInter(false);
                ResumeBaseInfo baseinfo = null;
                if (!isOvercast) {
                    baseinfo = resumeBaseInfo;
                }
                list = AccessFieldUtils.splitWorkExp(rs.getString(AccessField.getWorkingExperience()));
                workExpInfos = new ArrayList<WorkExpInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    workExpInfos.add(AccessFieldUtils.formWorkExp((Map)list.get(i2), baseinfo));
                }
                list = AccessFieldUtils.splitEduExp(rs.getString(AccessField.getEducation()));
                educationExpInfos = new ArrayList<EducationExpInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    EducationExpInfo info = AccessFieldUtils.formEducationExp((List)list.get(i2), baseinfo);
                    if (i2 == 0) {
                        info.setHighDegree(true);
                    } else {
                        info.setHighDegree(false);
                    }
                    educationExpInfos.add(info);
                }
                list = AccessFieldUtils.splitTrainExp(rs.getString(AccessField.getTraining()));
                trainExpInfos = new ArrayList<TrainExpInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    trainExpInfos.add(AccessFieldUtils.formTrainExp((List)list.get(i2), baseinfo));
                }
                list = AccessFieldUtils.splitSkill(rs.getString(AccessField.getITSkill()));
                skillInfos = new ArrayList<SkillInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    skillInfos.add(AccessFieldUtils.formSkillInfo((List)list.get(i2), baseinfo));
                }
                List listLan = AccessFieldUtils.splitLanguage(rs.getString(AccessField.getLanguage()));
                for (i = 0; i < listLan.size(); ++i) {
                    skillInfos.add(AccessFieldUtils.formSkillInfo((List)listLan.get(i), baseinfo));
                }
                list = AccessFieldUtils.splitCertificate(rs.getString(AccessField.getCertifications()));
                certificateInfos = new ArrayList<CertificateInfo>();
                for (i = 0; i < list.size(); ++i) {
                    CertificateInfo certificateInfo = AccessFieldUtils.formCertificateInfo((List)list.get(i), baseinfo);
                    if (certificateInfo == null) continue;
                    certificateInfos.add(certificateInfo);
                }
                iAccessImportTaskFacade.excuteImport(isOvercast, resumeBaseInfo, workExpInfos, educationExpInfos, trainExpInfos, skillInfos, certificateInfos, rcInfo);
                ++successRecord;
            }
            catch (Exception imEx) {
                exInfo = new StringBuffer();
                exInfo.append(AccessField.getID());
                exInfo.append(accessID);
                exInfo.append(" ");
                exInfo.append(accessName);
                exInfo.append(" :");
                exInfo.append(imEx.getMessage());
                importInfo.add(exInfo.toString());
                logger.debug((Object)"Access Import Error", (Throwable)imEx);
            }
        }
        if (exInfo != null) {
            exInfo = new StringBuffer();
            exInfo.append("\n" + AccessField.getError() + ":");
            importInfo.add(exInfo.toString());
        }
        exInfo = new StringBuffer();
        exInfo.append(AccessField.getTotal());
        exInfo.append(totalRecord);
        exInfo.append(AccessField.getPiece() + AccessField.getRecord() + ",");
        exInfo.append(AccessField.getSuccessToImport());
        exInfo.append(successRecord);
        exInfo.append(AccessField.getPiece() + AccessField.getRecord());
        importInfo.add(exInfo.toString());
        return importInfo;
    }

    public static AccessImportTaskLog excuteImport(RowSet rs, ResumeCategoryInfo rcInfo, boolean isOvercast, boolean isLog) throws Exception {
        HashMap<String, String> resumeBaseMap = new HashMap<String, String>();
        IAccessImportTaskFacade iAccessImportTaskFacade = AccessImportTaskFacadeFactory.getRemoteInstance();
        List list = null;
        String accessID = null;
        String accessName = null;
        AccessImportTaskLog log = new AccessImportTaskLog();
        StringBuffer exInfo = null;
        int totalRecord = 0;
        int successRecord = 0;
        ResumeBaseInfo resumeBaseInfo = null;
        ArrayList<WorkExpInfo> workExpInfos = null;
        ArrayList<EducationExpInfo> educationExpInfos = null;
        ArrayList<TrainExpInfo> trainExpInfos = null;
        ArrayList<SkillInfo> skillInfos = null;
        ArrayList<CertificateInfo> certificateInfos = null;
        while (rs.next()) {
            ++totalRecord;
            accessID = rs.getString(AccessField.getID());
            accessName = rs.getString(AccessField.getName());
            resumeBaseMap.put("Name", rs.getString(AccessField.getName()));
            resumeBaseMap.put("Sex", rs.getString(AccessField.getGender()));
            resumeBaseMap.put("Birthday", rs.getString(AccessField.getBirthday()));
            resumeBaseMap.put("NestedPlace", rs.getString(AccessField.getCurrentResidency()));
            resumeBaseMap.put("WorkYears", AccessFieldUtils.workYearsTrans(rs.getString(AccessField.getYearsofWorking())));
            resumeBaseMap.put("Hukou", rs.getString(AccessField.getHuKou()));
            resumeBaseMap.put("Address", rs.getString(AccessField.getAddress()));
            resumeBaseMap.put("Email", rs.getString(AccessField.getEMail()));
            resumeBaseMap.put("Tel_home", rs.getString(AccessField.getHomeTelephone()));
            resumeBaseMap.put("Tel_company", rs.getString(AccessField.getWorkPhone()));
            resumeBaseMap.put("Tel_mobile", rs.getString(AccessField.getMobilePhone()));
            resumeBaseMap.put("EVALUATE", rs.getString(AccessField.getSelfAssessment()));
            resumeBaseMap.put("SalaryExpected", rs.getString(AccessField.getSalaryExpected()));
            StringBuffer workExpected = new StringBuffer();
            workExpected.append(AccessField.getTypeofEmployment());
            workExpected.append(":");
            String typeOfEmployment = rs.getString(AccessField.getTypeofEmployment());
            if (typeOfEmployment != null) {
                workExpected.append(typeOfEmployment);
            }
            workExpected.append("\n");
            workExpected.append(AccessField.getTypeofCompany());
            workExpected.append(":");
            String typeOfCompany = rs.getString(AccessField.getTypeofCompany());
            if (typeOfCompany != null) {
                workExpected.append(typeOfCompany);
            }
            workExpected.append("\n");
            workExpected.append(AccessField.getIndustryExpected());
            workExpected.append(":");
            String industryExpected = rs.getString(AccessField.getIndustryExpected());
            if (industryExpected != null) {
                workExpected.append(industryExpected);
            }
            workExpected.append("\n");
            workExpected.append(AccessField.getWorkingPlaceExpected());
            workExpected.append(":");
            String workingPlaceExpected = rs.getString(AccessField.getWorkingPlaceExpected());
            if (workingPlaceExpected != null) {
                workExpected.append(workingPlaceExpected);
            }
            workExpected.append("\n");
            resumeBaseMap.put("WorkExpected", workExpected.toString());
            List jobs = AccessFieldUtils.splitJobs(rs.getString(AccessField.getJobFunctionExpected()));
            int max = jobs.size() > 3 ? 3 : jobs.size();
            for (int i = 0; i < max; ++i) {
                if (i == 0) {
                    resumeBaseMap.put("Job1", (String)jobs.get(i));
                }
                if (i == 1) {
                    resumeBaseMap.put("Job2", (String)jobs.get(i));
                }
                if (i != 2) continue;
                resumeBaseMap.put("Job3", (String)jobs.get(i));
            }
            try {
                int i;
                int i2;
                resumeBaseInfo = AccessFieldUtils.formResumeBaseInfo(resumeBaseMap, isOvercast);
                resumeBaseInfo.setResumeState(ResumeStateEnum.no_dispose);
                resumeBaseInfo.setPersonState(PersonStateEnum.noEntry);
                resumeBaseInfo.setIsInter(false);
                ResumeBaseInfo baseinfo = null;
                if (!isOvercast) {
                    baseinfo = resumeBaseInfo;
                }
                list = AccessFieldUtils.splitWorkExp(rs.getString(AccessField.getWorkingExperience()));
                workExpInfos = new ArrayList<WorkExpInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    workExpInfos.add(AccessFieldUtils.formWorkExp((Map)list.get(i2), baseinfo));
                }
                list = AccessFieldUtils.splitEduExp(rs.getString(AccessField.getEducation()));
                educationExpInfos = new ArrayList<EducationExpInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    EducationExpInfo info = AccessFieldUtils.formEducationExp((List)list.get(i2), baseinfo);
                    if (i2 == 0) {
                        info.setHighDegree(true);
                    } else {
                        info.setHighDegree(false);
                    }
                    educationExpInfos.add(info);
                }
                list = AccessFieldUtils.splitTrainExp(rs.getString(AccessField.getTraining()));
                trainExpInfos = new ArrayList<TrainExpInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    trainExpInfos.add(AccessFieldUtils.formTrainExp((List)list.get(i2), baseinfo));
                }
                list = AccessFieldUtils.splitSkill(rs.getString(AccessField.getITSkill()));
                skillInfos = new ArrayList<SkillInfo>();
                for (i2 = 0; i2 < list.size(); ++i2) {
                    skillInfos.add(AccessFieldUtils.formSkillInfo((List)list.get(i2), baseinfo));
                }
                List listLan = AccessFieldUtils.splitLanguage(rs.getString(AccessField.getLanguage()));
                for (i = 0; i < listLan.size(); ++i) {
                    skillInfos.add(AccessFieldUtils.formSkillInfo((List)listLan.get(i), baseinfo));
                }
                list = AccessFieldUtils.splitCertificate(rs.getString(AccessField.getCertifications()));
                certificateInfos = new ArrayList<CertificateInfo>();
                for (i = 0; i < list.size(); ++i) {
                    certificateInfos.add(AccessFieldUtils.formCertificateInfo((List)list.get(i), baseinfo));
                }
                iAccessImportTaskFacade.excuteImport(isOvercast, resumeBaseInfo, workExpInfos, educationExpInfos, trainExpInfos, skillInfos, certificateInfos, rcInfo);
                ++successRecord;
            }
            catch (Exception imEx) {
                exInfo = new StringBuffer();
                exInfo.append(AccessField.getID());
                exInfo.append(accessID);
                exInfo.append(" ");
                exInfo.append(accessName);
                exInfo.append(" :");
                exInfo.append(imEx.getMessage());
                log.addException(exInfo.toString(), imEx);
                logger.debug((Object)"Access Import Error", (Throwable)imEx);
            }
        }
        if (exInfo != null) {
            log.setTaskState(AccessImportTaskStateEnum.FAILEND);
        } else {
            log.setTaskState(AccessImportTaskStateEnum.SUCCESSEND);
        }
        log.setSuccessRecordCount(successRecord);
        log.setRecordCount(totalRecord);
        log.setFailRecordCount(totalRecord - successRecord);
        return log;
    }
}

