/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtil {
    public static Date getDateFirstTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtil.getDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static Date getDateEndTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = DateUtil.getDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        calendar.setTime(date);
        calendar.add(5, 1);
        long time = calendar.getTimeInMillis() - 1L;
        return new Date(time);
    }

    public static Date getCurrentDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return DateUtil.truncate(cal.getTime());
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        return DateUtil.truncate(cal.getTime());
    }

    public static Date addDay(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date truncate(Date date) {
        date = new Date(date.getTime() / 1000L * 1000L);
        return date;
    }

    public static Date parse(String source, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = df.parse(source);
        }
        catch (Exception e) {
            date = new Date();
        }
        return date;
    }

    public static Date parse(String source, String pattern, Date defaultDate) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = df.parse(source);
        }
        catch (Exception e) {
            date = defaultDate;
        }
        return date;
    }

    public static String format(Date date, String pattern) {
        return DateUtil.format(date, pattern, Locale.getDefault());
    }

    public static String formatNull(Date date, String pattern) {
        return DateUtil.formatNull(date, pattern, Locale.getDefault());
    }

    public static String format(Date date, String pattern, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
        String d = null;
        try {
            d = df.format(date);
        }
        catch (Exception e) {
            d = DateUtil.format(new Date(), pattern);
        }
        return d;
    }

    public static String formatNull(Date date, String pattern, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
        if (date == null) {
            return "";
        }
        String d = df.format(date);
        return d;
    }

    public static int getYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    public static int getDay(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static long getLongTime(int days) {
        return (long)days * 24L * 3600L * 1000L;
    }

    public static int getWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int subTwoDate(Date edate, Date sdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long slong = cal.getTimeInMillis();
        cal.setTime(edate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long elong = cal.getTimeInMillis();
        return (int)((elong - slong) / 86400000L);
    }

    public static int compareTWODate(Date date1, Date date2) {
        return DateUtil.getDateFirstTimeStamp(date1).compareTo(DateUtil.getDateFirstTimeStamp(date2));
    }

    public static List getMonthDates(int year, int month) {
        ArrayList<Date> monthDates = new ArrayList<Date>();
        for (int i = 1; i <= DateUtil.getMonthDays(year, month); ++i) {
            Date date = DateUtil.getDate(year, month, i);
            monthDates.add(date);
        }
        return monthDates;
    }

    public static int getMonthDays(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static int compareToNowByDate(Date date) throws ParseException {
        return DateUtil.compareByDate(null, date);
    }

    public static int compareByDate(Date dateLeft, Date dateRight) throws ParseException {
        Date ld = DateUtil.simpleDate(dateLeft);
        Date sd = DateUtil.simpleDate(dateRight);
        return ld.compareTo(sd);
    }

    public static Date simpleDate(Date date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date d = date != null ? date : new Date();
        return format.parse(format.format(d));
    }
}

