/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.rec.ActivityRelationLevelCollection;
import com.kingdee.eas.hr.rec.ActivityRelationLevelFactory;
import com.kingdee.eas.hr.rec.ActivityRelationLevelInfo;
import com.kingdee.eas.hr.rec.GenyRecFacadeFactory;
import com.kingdee.eas.hr.rec.InterviewActivityCollection;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewLevelCollection;
import com.kingdee.eas.hr.rec.InterviewLevelFactory;
import com.kingdee.eas.hr.rec.RecCommonUtilFacadeFactory;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RecUtils {
    private static Logger logger = Logger.getLogger(RecUtils.class);

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof DataToken) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static FilterInfo getCUFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    public static HROrgUnitInfo getCurrentHROrgUnit(Context ctx) {
        HROrgUnitInfo info = ContextUtil.getCurrentHRUnit((Context)ctx);
        return info;
    }

    public static FilterInfo getHRFilterInfo(Context ctx, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitId, (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        }
        return filter;
    }

    public static FilterInfo getHROrgUnitFilter(String columnName) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)RecUtils.getCurrentHROrgUnit().getId().toString()));
        return filterInfo;
    }

    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException, EASBizException {
        if (info == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException, EASBizException {
        if (info == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, orgUnitId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId)) {
            codingRuleManager.recycleNumber((IObjectValue)info, orgUnitId, info.getString("number"));
        }
    }

    public static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static String getWholeNameByAdminOrgUnitId(String id) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.name"));
        selector.add(new SelectorItemInfo("parent.number"));
        AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), selector);
        if (adminOrgUnitInfo == null) {
            return null;
        }
        if (adminOrgUnitInfo.getParent() == null) {
            return adminOrgUnitInfo.getName();
        }
        return RecUtils.getWholeNameByAdminOrgUnitId(adminOrgUnitInfo.getParent().getId().toString()) + "-" + adminOrgUnitInfo.getName();
    }

    public static boolean isNumber(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static byte[] convertFileToBytes(File file) {
        byte[] bts = null;
        if (file != null) {
            try {
                int size = (int)file.length();
                FileInputStream fin = new FileInputStream(file);
                if (size > 0) {
                    bts = new byte[size];
                    fin.read(bts);
                }
                fin.close();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return bts;
    }

    public static Date dateAdd(Date inputDate, int next) {
        Calendar c = Calendar.getInstance();
        c.setTime(inputDate);
        c.add(5, next);
        return c.getTime();
    }

    public static void setAdminOrgUnitF7(JPanel ui, KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, String displayFormat) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (isMultiSelect) {
            boolean isSingleSelect = false;
            hashMap.put("IS_SINGLE_SELECT", isSingleSelect);
        }
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)ui, hashMap);
        HashSet<String> set = new HashSet<String>();
        if (RecUtils.getParamtForHRO()) {
            try {
                set = new HashSet(GenyRecFacadeFactory.getRemoteInstance().getHROrgUnitIDSet());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            set.add(RecUtils.getCurrentHROrgUnit().getId().toString());
        }
        f7.setHROFilter(set);
        prmpt.setSelector((KDPromptSelector)f7);
        prmpt.setEnabledMultiSelection(isMultiSelect);
        prmpt.setDisplayFormat(displayFormat);
        prmpt.setEditable(editable);
    }

    public static void setAdminOrgF7(JPanel ui, KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, String displayFormat) {
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)ui);
        HashSet<String> set = new HashSet<String>();
        set.add(RecUtils.getCurrentHROrgUnit().getId().toString());
        f7.setHROFilter(set);
        prmpt.setSelector((KDPromptSelector)f7);
        prmpt.setEnabledMultiSelection(isMultiSelect);
        prmpt.setDisplayFormat(displayFormat);
        prmpt.setEditable(editable);
    }

    public static void setAdminOrgF7(JPanel ui, KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, String displayFormat, boolean includeSealUp) {
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)ui);
        HashSet<String> set = new HashSet<String>();
        set.add(RecUtils.getCurrentHROrgUnit().getId().toString());
        f7.setHROFilter(set);
        if (!includeSealUp) {
            f7.setIncludeSealUp("false");
        }
        prmpt.setSelector((KDPromptSelector)f7);
        prmpt.setEnabledMultiSelection(isMultiSelect);
        prmpt.setDisplayFormat(displayFormat);
        prmpt.setEditable(editable);
    }

    public static void setPositionF7(CoreUIObject ui, KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, String displayFormat, boolean includeSealUp) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (isMultiSelect) {
            hashMap.put("MULTI_SELECT", new Boolean(isMultiSelect));
        }
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)ui, hashMap);
        HashSet<String> set = new HashSet<String>();
        if (RecUtils.getParamtForHRO()) {
            try {
                set = new HashSet(GenyRecFacadeFactory.getRemoteInstance().getHROrgUnitIDSet());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            set.add(RecUtils.getCurrentHROrgUnit().getId().toString());
        }
        if (!includeSealUp) {
            pmtNew.setSealUp("false");
        }
        pmtNew.setHROFilter(set);
        prmpt.setSelector((KDPromptSelector)pmtNew);
        prmpt.setEnabledMultiSelection(isMultiSelect);
        prmpt.setDisplayFormat(displayFormat);
        prmpt.setEditable(editable);
    }

    public static void setPositionF7(CoreUIObject ui, KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, String displayFormat) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (isMultiSelect) {
            hashMap.put("MULTI_SELECT", isMultiSelect);
        }
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)ui, hashMap);
        HashSet<String> set = new HashSet<String>();
        if (RecUtils.getParamtForHRO()) {
            try {
                set = new HashSet(GenyRecFacadeFactory.getRemoteInstance().getHROrgUnitIDSet());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            set.add(RecUtils.getCurrentHROrgUnit().getId().toString());
        }
        pmtNew.setHROFilter(set);
        prmpt.setSelector((KDPromptSelector)pmtNew);
        prmpt.setEnabledMultiSelection(isMultiSelect);
        prmpt.setDisplayFormat(displayFormat);
        prmpt.setEditable(editable);
    }

    public static void setPositionF7(CoreUIObject ui, KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, boolean isHROFilter, String displayFormat) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (isMultiSelect) {
            hashMap.put("MULTI_SELECT", isMultiSelect);
        }
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)ui, hashMap);
        HashSet<String> set = new HashSet<String>();
        if (RecUtils.getParamtForHRO()) {
            try {
                set = new HashSet(GenyRecFacadeFactory.getRemoteInstance().getHROrgUnitIDSet());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            set.add(RecUtils.getCurrentHROrgUnit().getId().toString());
        }
        pmtNew.setHROFilter(set);
        prmpt.setSelector((KDPromptSelector)pmtNew);
        prmpt.setEnabledMultiSelection(isMultiSelect);
        prmpt.setDisplayFormat(displayFormat);
        prmpt.setEditable(editable);
    }

    public static void setPersonF7(KDBizPromptBox prmpt, boolean isMultiSelect, boolean editable, String displayFormat) {
        EmployeeMultiF7PromptBox personF7 = new EmployeeMultiF7PromptBox();
        try {
            RecUtils.setF7Filter(personF7);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        personF7.setModal(true);
        personF7.setIsSingleSelect(!isMultiSelect);
        personF7.showNoPositionPerson(true);
        personF7.setUserOrgRangeFilter(true);
        personF7.setReturnPositionAndUnit(false);
        prmpt.setSelector((KDPromptSelector)personF7);
        prmpt.setDisplayFormat(displayFormat);
    }

    public static void setKDTColumnTextField(IColumn column, int maxLength, int minLength) {
        KDTextField textFiled = new KDTextField();
        textFiled.setMaxLength(maxLength);
        if (minLength > 0) {
            textFiled.setMinLength(minLength);
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textFiled);
        column.setEditor((ICellEditor)cellEditor);
    }

    public static DataBaseInfo getDataBaseInfo(IDataBase dataBase, String pk) throws Exception {
        DataBaseInfo info = null;
        if (dataBase != null && !StringUtils.isEmpty((String)pk)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            info = dataBase.getDataBaseInfo((IObjectPK)new ObjectUuidPK(pk));
        }
        return info;
    }

    public static SelectorItemCollection getSic(String[] columns) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < columns.length; ++i) {
            sic.add(new SelectorItemInfo(columns[i]));
        }
        return sic;
    }

    public static FilterItemCollection buildFilterItemInfo(FilterItemCollection fic, String field, Object obj, CompareType compareType) {
        if (fic == null) {
            return null;
        }
        if (obj instanceof Object[]) {
            Object[] array;
            if (obj != null && (array = (Object[])obj).length > 0) {
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == null) continue;
                    CoreBaseInfo info = (CoreBaseInfo)array[i];
                    set.add(info.getId().toString());
                }
                if (set.size() > 0) {
                    fic.add(new FilterItemInfo(field, set, compareType));
                }
            }
        } else if (obj != null) {
            if (obj instanceof CoreBaseInfo) {
                CoreBaseInfo info = (CoreBaseInfo)obj;
                fic.add(new FilterItemInfo(field, (Object)info.getId().toString(), compareType));
            } else if (obj instanceof String) {
                String str = obj.toString().trim();
                if (str.length() > 0) {
                    fic.add(new FilterItemInfo(field, (Object)str, compareType));
                }
            } else if (obj instanceof Date) {
                fic.add(new FilterItemInfo(field, obj, compareType));
            }
        }
        return fic;
    }

    public static CustomerParams buildCustomerParams(CustomerParams cp, String key, Object value) {
        String str;
        if (cp == null || value == null) {
            return cp;
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array.length > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < array.length; ++i) {
                    CoreBaseInfo info = (CoreBaseInfo)array[i];
                    if (info == null || info.getId() == null) continue;
                    sb.append(info.getId().toString()).append("#--#");
                }
                cp.addCustomerParam(key, sb.toString());
            }
        } else if (value instanceof CoreBaseInfo) {
            CoreBaseInfo info = (CoreBaseInfo)value;
            cp.addCustomerParam(key, info.getId().toString());
        } else if (value instanceof Date) {
            Date date = (Date)value;
            cp.putDate(key, date);
        } else if (value instanceof String && (str = value.toString().trim()).length() > 0) {
            cp.addCustomerParam(key, str);
        }
        return cp;
    }

    public static Object[] getInterviewActivitysByIDs(String[] ids) {
        HashSet<String> set = new HashSet<String>();
        if (ids == null || ids.length == 0) {
            return null;
        }
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        try {
            if (ids != null && ids.length > 0) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                ev.setFilter(filter);
                InterviewActivityCollection coll = InterviewActivityFactory.getRemoteInstance().getInterviewActivityCollection(ev);
                if (coll != null) {
                    return coll.toArray();
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static void initInterviewLevelCombo(KDComboBox combo, String activityId) throws Exception {
        Object[] comboxInfos = null;
        if (activityId == null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SorterItemCollection sorter = entityViewInfo.getSorter();
            SorterItemInfo sorterItem = new SorterItemInfo("number");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem);
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            entityViewInfo.setFilter(filterInfo);
            InterviewLevelCollection collection = InterviewLevelFactory.getRemoteInstance().getInterviewLevelCollection(entityViewInfo);
            if (collection != null) {
                comboxInfos = new Object[collection.size()];
                int length = collection.size();
                for (int i = 0; i < length; ++i) {
                    comboxInfos[i] = collection.get(i);
                }
            }
        } else {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SorterItemCollection sorter = entityViewInfo.getSorter();
            SorterItemInfo sorterItem = new SorterItemInfo("interviewLevel.number");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem);
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("interviewLevel.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)activityId));
            entityViewInfo.setFilter(filterInfo);
            ActivityRelationLevelCollection coll = ActivityRelationLevelFactory.getRemoteInstance().getActivityRelationLevelCollection(entityViewInfo);
            if (coll != null) {
                comboxInfos = new Object[coll.size()];
                int length = coll.size();
                for (int i = 0; i < length; ++i) {
                    ActivityRelationLevelInfo info = coll.get(i);
                    comboxInfos[i] = info.getInterviewLevel();
                }
            }
        }
        if (comboxInfos != null) {
            combo.removeAllItems();
            combo.addItem((Object)"");
            combo.addItems(comboxInfos);
        }
    }

    public static void setCellPrmtEditor(KDTable table, String column, KDBizPromptBox prmt) {
        KDTDefaultCellEditor name_cellEditor = new KDTDefaultCellEditor((IKDEditor)prmt);
        table.getColumn(column).setEditor((ICellEditor)name_cellEditor);
    }

    public static void setCellTextEditor(KDTable table, String column, int minLength, int maxLength) {
        KDTextField textField = new KDTextField();
        textField.setMinLength(minLength);
        textField.setMaxLength(maxLength);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellNumberEditor(KDTable table, String column, int dataType, int precision, int min, int max) {
        KDFormattedTextField field = new KDFormattedTextField();
        field.setDataType(dataType);
        field.setPrecision(precision);
        field.setMinimumValue((Comparable)new BigDecimal(min));
        field.setMaximumValue((Comparable)new BigDecimal(max));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)field);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellComboBoxEditor(KDTable table, String column, Object[] items) {
        KDComboBox box = new KDComboBox();
        box.addItems(items);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)box);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellDateEditor(KDTable table, String column, boolean editabl) {
        if (table == null || column == null) {
            return;
        }
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setEditable(true);
        datePicker.setVisible(true);
        datePicker.setDatePattern("yyyy-MM-dd");
        KDTDefaultCellEditor datePicker_CellEditor = new KDTDefaultCellEditor(datePicker);
        table.getColumn(column).setEditor((ICellEditor)datePicker_CellEditor);
    }

    public static void setCellQueryInfo(KDTable table, String column, String query) {
        KDBizPromptBox prmtPoliticalFace = new KDBizPromptBox();
        prmtPoliticalFace.setDisplayFormat("$name$");
        prmtPoliticalFace.setQueryInfo(query);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPoliticalFace);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellQueryInfo2(KDTable table, String column, String query, boolean editable) {
        KDBizPromptBox prmtPoliticalFace = new KDBizPromptBox();
        prmtPoliticalFace.setDisplayFormat("$name$");
        prmtPoliticalFace.setQueryInfo(query);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPoliticalFace);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
        prmtPoliticalFace.setEditable(editable);
    }

    public static void setCellCheckBoxEditor(KDTable table, String column, boolean defaultSelected) {
        KDCheckBox checkBox = new KDCheckBox();
        checkBox.setSelected(defaultSelected);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setKDTableUISort(KDTable table) {
        if (table == null) {
            return;
        }
        KDTSortManager sm = new KDTSortManager(table);
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    public static String getCNNumber(int i) {
        if (i < 1) {
            return "";
        }
        String str = String.valueOf(i);
        StringBuffer sb = new StringBuffer();
        char[] c = str.toCharArray();
        int n = c.length;
        block11: for (int m = 0; m < n; ++m) {
            switch (c[m]) {
                case '1': {
                    if (c.length == 1) {
                        sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"39_RecUtils"));
                        continue block11;
                    }
                    if (c.length == 2 && m == 0) {
                        sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                        continue block11;
                    }
                    if (c.length != 2 || m != 1) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"39_RecUtils"));
                    continue block11;
                }
                case '2': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"41_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '3': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"42_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '4': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"43_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '5': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"44_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '6': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"45_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '7': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"46_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '8': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"47_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
                case '9': {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"48_RecUtils"));
                    if (c.length != 2 || m != 0) continue block11;
                    sb.append(EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"40_RecUtils"));
                    continue block11;
                }
            }
        }
        return sb.toString();
    }

    public static int subTwoDate(Date edate, Date sdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long slong = cal.getTimeInMillis();
        cal.setTime(edate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long elong = cal.getTimeInMillis();
        int days = (int)((elong - slong) / 86400000L);
        return days / 365;
    }

    public static boolean compareObject(CoreBaseInfo o1, CoreBaseInfo o2, String[] properties) {
        Class<?> c2;
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        if (!c1.equals(c2 = o2.getClass())) {
            return false;
        }
        if (properties != null && properties.length > 0) {
            for (int i = 0; i < properties.length; ++i) {
                Object value1 = o1.get(properties[i]);
                Object value2 = o2.get(properties[i]);
                if (value1 == null) {
                    if (value2 == null) continue;
                    return false;
                }
                if (value2 == null) {
                    return false;
                }
                if (value1.equals(value2)) continue;
                return false;
            }
        }
        return true;
    }

    public static void setAutoNumber(EditUI editUI, CoreBaseInfo info, KDTextField txtNumber, String state, String orgUnitId) throws Exception {
        if (OprtState.ADDNEW.equals(state)) {
            if (info == null || orgUnitId == null || editUI == null || txtNumber == null) {
                return;
            }
            Map map = RecCommonUtilFacadeFactory.getRemoteInstance().getCodeRuleProperties((IObjectValue)info, orgUnitId);
            boolean isExist = (Boolean)map.get("isExist");
            if (isExist) {
                boolean isAddView = (Boolean)map.get("isAddView");
                boolean isModifiable = (Boolean)map.get("isModifiable");
                String[] prop = (String[])map.get("prop");
                if (isAddView) {
                    if (prop != null && prop.length > 0) {
                        throw new Exception("code_error");
                    }
                    String number = map.get("number").toString();
                    info.setString("number", number);
                }
                txtNumber.setEnabled(isModifiable);
                txtNumber.setEditable(isModifiable);
            }
        } else {
            txtNumber.setEnabled(false);
        }
    }

    public static List getTableSelectValue(KDTable table, String col) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (table == null || col == null || table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return ids;
        }
        KDTSelectBlock sb = null;
        int size = table.getSelectManager().size();
        int num = 0;
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            sb = table.getSelectManager().get(i);
            num = sb.getBottom();
            for (int j = sb.getTop(); j <= num; ++j) {
                row = table.getRow(j);
                ids.add(row.getCell(col).getValue());
            }
        }
        return ids;
    }

    public static List getTableSelectedValue(KDTable table, String col) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (table == null || col == null || table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return ids;
        }
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                ids.add(table.getRow(j).getCell(col).getValue());
            }
        }
        return ids;
    }

    public static void checkValidHRO() {
        HROrgUnitInfo hrInfo = SysContext.getSysContext().getCurrentHRUnit();
        if (hrInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"49_RecUtils"));
            SysUtil.abort();
        }
    }

    public static void checkValidPerson(CoreUI uiObject) {
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() == null) {
            MsgBox.showInfo((Component)uiObject, (String)EASResource.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"50_RecUtils"));
            SysUtil.abort();
        }
    }

    public static FilterInfo getDefaultFilterInfo(String className, String queryName, String filterUIName) throws Exception {
        QuerySolutionInfo solution;
        QueryPanelCollection queryPanelCollection;
        if (className == null || queryName == null || filterUIName == null) {
            return null;
        }
        FilterInfo defFilter = null;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        boolean hasDefQuery = iQuery.hasDefaultSolution(className, queryName);
        if (hasDefQuery && (queryPanelCollection = (solution = iQuery.getDefaultSolution(className, queryName)).getQueryPanelInfo()) != null && queryPanelCollection.size() > 0) {
            int n = queryPanelCollection.size();
            for (int i = 0; i < n; ++i) {
                if (!filterUIName.equalsIgnoreCase(queryPanelCollection.get(i).getPanelClassName())) continue;
                defFilter = new FilterInfo(solution.getQueryPanelInfo().get(i).getFilterInfo());
                break;
            }
        }
        return defFilter;
    }

    public static boolean isNotEq(Object o1, Object o2) {
        if (o1 != null && o2 != null && !o1.equals(o2)) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return true;
        }
        return o2 == null && o1 != null;
    }

    public static boolean isEq(CoreBaseInfo c1, CoreBaseInfo c2) {
        if (c1 != null && c1.getId() == null) {
            c1 = null;
        }
        if (c2 != null && c2.getId() == null) {
            c2 = null;
        }
        if (c1 != null && c2 != null && !c1.getId().toString().equals(c2.getId().toString())) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        return c2 != null || c1 == null;
    }

    public static int getFileSize(File file) throws Exception {
        if (file == null) {
            return 0;
        }
        FileInputStream fi = new FileInputStream(file);
        int available = fi.available();
        fi.close();
        return available;
    }

    public static boolean getParamValue(String number) throws Exception {
        String HRO_ID;
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), number);
        return "true".equals(val);
    }

    public static int getSelectedRow(KDTable table) {
        IBlock selectBlock = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get());
        return selectBlock.getTop();
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String orgUnitColumnName) {
        String hrOrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return RecUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitId);
    }

    public static FilterInfo getAdminRangeFilterInfo(String orgUnitColumnName, String hrOrgUnitId) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getHRFilterByParam(String paramNumber) {
        String val = "";
        try {
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            val = iParam.getParamValue(null, paramNumber);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if ("true".equals(val)) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)RecUtils.getCurrentHROrgUnit().getId().toString()));
        return filterInfo;
    }

    public static FilterInfo getHRFilterByParam(String paramNumber, String hrOrgUnitId) {
        String val = "";
        try {
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            val = iParam.getParamValue(null, paramNumber);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if ("true".equals(val)) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(hrOrgUnitId, (Object)RecUtils.getCurrentHROrgUnit().getId().toString()));
        return filterInfo;
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        return table.addRow();
    }

    public static IRow insertLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = RecUtils.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        return row;
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || RecUtils.isTableColumnSelected(table)) {
            return;
        }
        int[] selectRowsIndex = RecUtils.getSelectedRows(table);
        if (selectRowsIndex.length > 0) {
            int[] selectedColumnIndexs = RecUtils.getSelectedColumns(table);
            Arrays.sort(selectRowsIndex);
            for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
                RecUtils.removeRow(table, selectRowsIndex[i]);
            }
            if (table.getRowCount() > 0) {
                Arrays.sort(selectedColumnIndexs);
                int columnIndex = 0;
                if (selectedColumnIndexs.length > 0) {
                    columnIndex = selectedColumnIndexs[0];
                }
                table.getSelectManager().select(selectRowsIndex[0], columnIndex);
            }
        }
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = RecUtils.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    public static void removeRows(KDTable table) {
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            RecUtils.removeRow(table, i);
        }
    }

    private static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static int[] getSelectedColumns(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                set.add(j);
            }
        }
        int[] columns = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            columns[k++] = (Integer)iter.next();
        }
        return columns;
    }

    public static int getSelectedRowCount(KDTable table) {
        int[] rows = RecUtils.getSelectedRows(table);
        return rows.length;
    }

    public static boolean getParamtForHRO() {
        boolean result = false;
        try {
            result = HRParamUtil.getParamOfHR(null, (String)"REC003", (String)SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    public static String getResource(String RES, String message, Object[] params) {
        String str = RecUtils.getResource(RES, message);
        return MessageFormat.format(str, params);
    }

    public static void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)RecUtils.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void showErrorMessage(String resource, String message, Object[] arguments, CoreUI ui) {
        String str = EASResource.getString((String)resource, (String)message);
        MessageFormat format = new MessageFormat(str);
        MsgBox.showError((Component)ui, (String)format.format(arguments));
        ui.setCursorOfDefault();
        SysUtil.abort();
    }

    private static String getCurrentUserId(Context ctx) {
        String userID = null;
        userID = ctx != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return userID;
    }

    public static String getHRRangeByUserId(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRange.forgId as forgId from T_PM_OrgRange orgRange inner join ");
        sql.append("T_ORG_HRO hro on orgRange.forgId = hro.fid ");
        sql.append("where orgRange.ftype = ");
        sql.append(10);
        sql.append(" and fuserid = '");
        sql.append(userID);
        sql.append("' ");
        return sql.toString();
    }

    public static String getAdminRangeSql(Context ctx) {
        String userID = RecUtils.getCurrentUserId(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID in (");
        sql.append(RecUtils.getHRRangeByUserId(userID));
        sql.append(") AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static FilterItemInfo getAdminRangeFilterItemInfo(Context ctx, String orgUnitColumnName) {
        String sql = RecUtils.getAdminRangeSql(ctx);
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        return item;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static HashSet getObjectArrayIds(Object obj) {
        HashSet<String> set = new HashSet<String>();
        if (!RecUtils.objectIsNull(obj)) {
            Object[] objs = (Object[])obj;
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                set.add(((CoreBaseInfo)objs[i]).getId().toString());
            }
        }
        return set;
    }

    public static CustomerParams getFilterUIParams(String queryName, KDPanel userPanel, String className, boolean isFirstDefultQuery) throws BOSException, EASBizException {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        CustomerParams customerParams = null;
        if (isFirstDefultQuery && iQuery.hasDefaultSolution(className, queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(className, queryName);
            String cutomerParams = null;
            if (solution.getQueryPanelInfo().size() > 0) {
                for (int i = 0; i < solution.getQueryPanelInfo().size(); ++i) {
                    if (solution.getQueryPanelInfo().get(i).getCustomerParams() == null) continue;
                    cutomerParams = solution.getQueryPanelInfo().get(i).getCustomerParams();
                    break;
                }
                if (cutomerParams != null) {
                    customerParams = CustomerParams.getCustomerParams2(cutomerParams);
                }
            }
        } else if (userPanel != null) {
            customerParams = ((CustomerQueryPanel)userPanel).getCustomerParams();
        }
        return customerParams;
    }

    public static void setDipslayAdminOrgUnit(KDTable tblMain, CustomerParams customerParams) throws BOSException, EASBizException {
        boolean displayNameIsHide = tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().isHided();
        boolean nameIsHide = tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().isHided();
        if (customerParams != null) {
            boolean isDisplayName = customerParams.getBoolean("isDisplayName");
            if (isDisplayName) {
                if (!displayNameIsHide) {
                    tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(false);
                    tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
                } else {
                    tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
                    tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
                }
            } else if (!nameIsHide) {
                tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
                tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(false);
            } else {
                tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
                tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
            }
        } else if (!displayNameIsHide) {
            tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(false);
            tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
        } else {
            tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
            tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
        }
    }

    public static IRowSet getRowSet(String queryName, EntityViewInfo viewInfo) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    public static void setColHidden(KDTable tblMain, KDPanel userPanel, String queryName, String fullName, boolean isFirstDefaultQuery) {
        CustomerParams customerParams = null;
        try {
            customerParams = RecUtils.getFilterUIParams(queryName, userPanel, fullName, isFirstDefaultQuery);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (customerParams != null) {
            boolean isDisplayName = customerParams.getBoolean("isDisplayName");
            if (isDisplayName) {
                if (tblMain.getColumn("adminOrgUnit.displayName") != null) {
                    tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(false);
                }
                if (tblMain.getColumn("adminOrgUnit.name") != null) {
                    tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
                }
                tblMain.repaint();
            } else {
                if (tblMain.getColumn("adminOrgUnit.name") != null) {
                    tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(false);
                }
                if (tblMain.getColumn("adminOrgUnit.displayName") != null) {
                    tblMain.getColumn("adminOrgUnit.displayName").getStyleAttributes().setHided(true);
                }
                tblMain.repaint();
            }
        }
    }

    public static SalariatSchemeInfo getCurrentHRSalSchm() throws BOSException, EASBizException {
        SalariatSchemeInfo salariatSchemeInfo = null;
        try {
            salariatSchemeInfo = HRSchemeUtils.getCurrentHRSalSchm(null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return salariatSchemeInfo;
    }
}

