/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.ModifyLogInfo;
import com.kingdee.eas.hr.service.SolidFildConfigCollection;
import com.kingdee.eas.hr.service.SolidFildConfigFactory;
import com.kingdee.eas.hr.service.SolidFildConfigInfo;
import com.kingdee.eas.hr.service.app.listener.DigestThread;
import com.kingdee.eas.hr.service.app.listener.DigestThreadUtil;
import com.kingdee.eas.hr.service.app.listener.ProcessUpdateLog;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ModifyStateManager {
    private static ModifyStateManager instance = null;
    private static final Logger logger = Logger.getLogger(ModifyStateManager.class);
    private Map<String, String> operatePKMap = new HashMap<String, String>();
    private Set<String> person = new HashSet<String>();
    private Set<String> position = new HashSet<String>();
    private Set<String> admin = new HashSet<String>();
    private Set<String> mainBosType = new HashSet<String>();
    private static final Set<String> METHODS = new HashSet<String>();
    private String state = "ready";
    private Map<String, ConcurrentHashMap<String, ModifyLogInfo>> updateQueue = new HashMap<String, ConcurrentHashMap<String, ModifyLogInfo>>();

    private ModifyStateManager() {
    }

    private SolidFildConfigCollection getSolidFildColl(Context ctx) throws BOSException {
        return SolidFildConfigFactory.getLocalInstance(ctx).getSolidFildConfigCollection();
    }

    private void init(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        try {
            SolidFildConfigCollection collection = this.getSolidFildColl(ctx);
            for (int i = 0; i < collection.size(); ++i) {
                EntityObjectInfo eoi;
                SolidFildConfigInfo info = collection.get(i);
                if (!FactTypeEnum.PERSON.equals((Object)info.getType()) || StringUtils.isEmpty((String)info.getSourceEntity()) || (eoi = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)info.getSourceEntity()))).getType() == null) continue;
                this.person.add(eoi.getType().toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        PersonInfo personInfo = new PersonInfo();
        PositionInfo positionInfo = new PositionInfo();
        this.person.add(personInfo.getBOSType().toString());
        this.position.add(positionInfo.getBOSType().toString());
        this.admin.add(adminInfo.getBOSType().toString());
        this.mainBosType.add(personInfo.getBOSType().toString());
        this.mainBosType.add(positionInfo.getBOSType().toString());
        this.mainBosType.add(adminInfo.getBOSType().toString());
        this.initMethod((BusinessObjectInfo)loader.getEntity(personInfo.getBOSType()));
        this.initMethod((BusinessObjectInfo)loader.getEntity(positionInfo.getBOSType()));
        this.initMethod((BusinessObjectInfo)loader.getEntity(adminInfo.getBOSType()));
        for (String each : this.person) {
            if (StringUtils.isEmpty((String)each)) continue;
            this.initMethod((BusinessObjectInfo)loader.getEntity(BOSObjectType.create((String)each)));
        }
        int Interval = this.getScanInterval(ctx);
        DigestThreadUtil.setIsSyncPause(ctx, false);
        DigestThread dog = new DigestThread(this, Interval);
        dog.start();
    }

    private int getScanInterval(Context ctx) {
        int interval = 15000;
        try {
            String sql = "select FVALUE from t_hr_hrinit where FKEY = 'ModifyStateManager_Scan_Interval'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            String value = null;
            while (rowSet.next()) {
                value = rowSet.getString("FVALUE");
                interval = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return interval;
    }

    public boolean needUpdate(String type, String operatePK) {
        boolean result = false;
        String operateName = this.operatePKMap.get(ModifyStateManager.getKey(type, operatePK));
        if (!StringUtils.isEmpty((String)operateName)) {
            result = true;
        }
        return result;
    }

    public static String getKey(String type, String operatePK) {
        return MessageFormat.format("{0}_{1}", type, operatePK);
    }

    private void initMethod(BusinessObjectInfo bo) {
        if (bo == null) {
            return;
        }
        MethodCollection methods = bo.getAllMethodsRuntime();
        if (null == methods || methods.isEmpty()) {
            return;
        }
        for (int i = 0; i < methods.size(); ++i) {
            if (!METHODS.contains(methods.get(i).getName())) continue;
            this.operatePKMap.put(ModifyStateManager.getKey(bo.getType().toString(), methods.get(i).getInnerID()), methods.get(i).getName());
        }
    }

    public static ModifyStateManager getInstance(Context ctx) throws BOSException {
        if (instance != null) {
            return instance;
        }
        instance = new ModifyStateManager();
        instance.init(ctx);
        return instance;
    }

    public void processUpdate(Context ctx, String bosType, String operatePK, Object[] inputArgu, Object returnValue) {
        ProcessUpdateLog updateLog = new ProcessUpdateLog(ctx, this.operatePKMap, this.person, this.position, this.admin);
        ModifyLogInfo logInfo = updateLog.processUpdateLog(ctx, bosType, operatePK, inputArgu, returnValue);
        if (logInfo == null || StringUtil.isEmpty((String)logInfo.getObjectID())) {
            return;
        }
        this.addQueue(ctx, logInfo);
        this.udpateStateNeedUpdate();
    }

    public void processBeforeExecute(Context ctx, String bosType, String operatePK, Object[] inputArgu, Object returnValue) {
        String method = this.operatePKMap.get(ModifyStateManager.getKey(bosType, operatePK));
        if ("delete".equals(method) && !this.mainBosType.contains(bosType)) {
            ProcessUpdateLog updateLog = new ProcessUpdateLog(ctx, this.operatePKMap, this.person, this.position, this.admin);
            ModifyLogInfo logInfo = updateLog.processUpdateLog(ctx, bosType, operatePK, inputArgu, returnValue);
            logInfo.setMethod("update");
            if (StringUtil.isEmpty((String)logInfo.getObjectID())) {
                return;
            }
            this.addQueue(ctx, logInfo);
            this.udpateStateNeedUpdate();
        }
    }

    private void udpateStateNeedUpdate() {
        this.state = "update";
    }

    public Map<String, ConcurrentHashMap<String, ModifyLogInfo>> getUpdateQueue() {
        return this.updateQueue;
    }

    public void initUpdateQueue() {
        this.updateQueue = new HashMap<String, ConcurrentHashMap<String, ModifyLogInfo>>();
        this.state = "ready";
    }

    private void addQueue(Context ctx, ModifyLogInfo logInfo) {
        String logKey;
        try {
            String objectId = logInfo.getObjectID();
            String pattern = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"IntegratedPattern", null, (boolean)true);
            if ("1".equals(pattern)) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FobjectidId from T_HR_ModifyDataEASRec where FobjectidId='").append(objectId).append("' and fSynEasState=0");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rs.next()) {
                    GregorianCalendar cal = new GregorianCalendar();
                    SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String modifyDate = "{ts'" + sFormat.format(cal.getTime()) + "'}";
                    sql = new StringBuffer();
                    String id = BOSUuid.create((String)"1BFECF12").toString();
                    sql.append("insert into T_HR_ModifyDataEASRec(fid,FobjectidId,FType,FMethod,FOptTime,fSynEasState)").append(" values( '").append(id).append("','").append(objectId).append("',");
                    int type = logInfo.getType().getValue();
                    if (type == 10) {
                        sql.append("'orgUnit'");
                    } else if (type == 20) {
                        sql.append("'position'");
                    } else {
                        sql.append("'person'");
                    }
                    sql.append(",'").append(logInfo.getMethod()).append("',").append(modifyDate).append(",").append(logInfo.getState()).append(")");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ConcurrentHashMap<String, ModifyLogInfo> logMap = this.updateQueue.get(ctx.getAIS());
        if (logMap == null) {
            logMap = new ConcurrentHashMap();
            this.updateQueue.put(ctx.getAIS(), logMap);
        }
        if (!logMap.containsKey(logKey = logInfo.getObjectID() + logInfo.getMethod())) {
            logMap.put(logKey, logInfo);
        }
    }

    static {
        METHODS.add("addnew");
        METHODS.add("update");
        METHODS.add("delete");
        METHODS.add("updatePartial");
        METHODS.add("addNewHistoryOnly");
        METHODS.add("updateHistoryOnly");
        METHODS.add("reviseHistoryOnly");
        METHODS.add("revise");
    }
}

