/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.listener;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.hr.service.app.ModifyStateManager;
import com.kingdee.util.LowTimer;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import org.apache.log4j.Logger;

public class HRRecordModifyEventListener
extends AbstractServiceAdapter {
    private static final String recordModify = "HRSYNMODIFY_EVENT";
    private static final int WORKFLOW_PRIORITY = 1;
    private static final Logger logger = Logger.getLogger(HRRecordModifyEventListener.class);

    public int getPriority() {
        return 1;
    }

    public String getName() {
        return recordModify;
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        LowTimer timer = new LowTimer();
        try {
            if (1 == serviceContext.getExecutionMode()) {
                if (this.isEntityOrFacadeInvoke(serviceContext)) {
                    this.executeAfter(serviceContext);
                }
            } else if (0 == serviceContext.getExecutionMode() && this.isEntityOrFacadeInvoke(serviceContext)) {
                this.executeBefore(serviceContext);
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void executeBefore(IServiceContext serviceContext) throws BOSException {
        this.doExecute(serviceContext, true);
    }

    private void executeAfter(IServiceContext serviceContext) throws BOSException {
        this.doExecute(serviceContext, false);
    }

    private void doExecute(IServiceContext serviceContext, boolean isBefore) throws BOSException {
        Context ctx = serviceContext.getContext();
        BOSObjectType boType = serviceContext.getBoType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        if (null != operationPK && null != boType && ModifyStateManager.getInstance(ctx).needUpdate(boType.toString(), operationPK.toString())) {
            Object[] args = serviceContext.getOperationParameters();
            Object returnValue = serviceContext.getMethodReturnValue();
            if (isBefore) {
                ModifyStateManager.getInstance(ctx).processBeforeExecute(ctx, boType.toString(), operationPK.toString(), args, returnValue);
            } else {
                ModifyStateManager.getInstance(ctx).processUpdate(ctx, boType.toString(), operationPK.toString(), args, returnValue);
            }
        }
    }

    private boolean isEntityOrFacadeInvoke(IServiceContext serviceContext) {
        return MetaDataTypeList.ENTITY.equals((Object)serviceContext.getMetaType());
    }
}

