/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.listener;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.ModifyLogInfo;
import com.kingdee.eas.hr.service.app.ModifyStateManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProcessUpdateLog {
    private static final Logger logger = Logger.getLogger(ProcessUpdateLog.class);
    private Map<String, String> operatePKMap = null;
    private Set<String> person = null;
    private Set<String> position = null;
    private Set<String> admin = null;
    Context ctx = null;

    public ProcessUpdateLog(Context ctx, Map<String, String> operatePKMap, Set<String> person, Set<String> position, Set<String> admin) {
        this.ctx = ctx;
        this.operatePKMap = operatePKMap;
        this.person = person;
        this.position = position;
        this.admin = admin;
    }

    public ModifyLogInfo processUpdateLog(Context ctx, String bosType, String operatePK, Object[] inputArgu, Object returnValue) {
        ModifyLogInfo logInfo = new ModifyLogInfo();
        try {
            logInfo.setType(this.getFactType(bosType));
            String method = this.operatePKMap.get(ModifyStateManager.getKey(bosType, operatePK));
            String id = this.getPKs(ctx, bosType, logInfo.getType(), method, inputArgu, returnValue);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("ProcessUpdateLog.processUpdateLog info={0}_{1}_{2},id={3}", bosType, operatePK, method, id));
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            logInfo.setMethod(method);
            logInfo.setObjectID(id);
            logInfo.setUserID(userId);
            if (StringUtils.isEmpty((String)id)) {
                return logInfo;
            }
            logInfo.setModifyDate(new Date());
            logInfo.setState(0);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return logInfo;
    }

    private String getPKs(Context ctx2, String bosType, FactTypeEnum type, String methodName, Object[] inputArgu, Object returnValue) throws BOSException {
        String id = null;
        if ("addnew".equals(methodName)) {
            id = this.getAddNewValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("update".equals(methodName)) {
            id = this.getUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("updatePartial".equals(methodName)) {
            id = this.getPartialUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("addNewHistoryOnly".equals(methodName)) {
            id = this.getUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("updateHistoryOnly".equals(methodName)) {
            id = this.getUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("reviseHistoryOnly".equals(methodName)) {
            id = this.getUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("revise".equals(methodName)) {
            id = this.getUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        } else if ("delete".equals(methodName)) {
            id = this.getUpdateValue(this.ctx, bosType, type, inputArgu, returnValue);
        }
        return id;
    }

    private String getUpdateValue(Context ctx2, String bosType, FactTypeEnum type, Object[] inputArgu, Object returnValue) throws BOSException {
        if (inputArgu.length < 2) {
            return null;
        }
        if (!(inputArgu[1] instanceof IObjectPK)) {
            return null;
        }
        IObjectPK pk = (IObjectPK)inputArgu[1];
        IObjectValue value = null;
        if (inputArgu.length > 2 && inputArgu[2] instanceof IObjectValue) {
            value = (IObjectValue)inputArgu[2];
        } else if (inputArgu.length > 3 && inputArgu[3] instanceof IObjectValue) {
            value = (IObjectValue)inputArgu[3];
        }
        return this.getPK(ctx2, bosType, type, pk, value);
    }

    private String getPartialUpdateValue(Context ctx2, String bosType, FactTypeEnum type, Object[] inputArgu, Object returnValue) throws BOSException {
        if (inputArgu.length < 2) {
            return null;
        }
        if (!(inputArgu[1] instanceof IObjectValue)) {
            return null;
        }
        IObjectValue value = (IObjectValue)inputArgu[1];
        ObjectUuidPK pk = null;
        if (value.get("id") != null) {
            pk = new ObjectUuidPK(value.get("id").toString());
        }
        return this.getPK(ctx2, bosType, type, (IObjectPK)pk, value);
    }

    private String getAddNewValue(Context ctx2, String bosType, FactTypeEnum type, Object[] inputArgu, Object returnValue) throws BOSException {
        IObjectPK pk = (IObjectPK)returnValue;
        IObjectValue value = null;
        if (inputArgu.length > 1 && inputArgu[1] instanceof IObjectValue) {
            value = (IObjectValue)inputArgu[1];
        } else if (inputArgu.length > 2 && inputArgu[2] instanceof IObjectValue) {
            value = (IObjectValue)inputArgu[2];
        }
        return this.getPK(ctx2, bosType, type, pk, value);
    }

    private String getPK(Context ctx2, String bosType, FactTypeEnum type, IObjectPK pk, IObjectValue value) throws BOSException {
        if (FactTypeEnum.PERSON.equals((Object)type)) {
            if (bosType.equals(new PersonInfo().getBOSType().toString())) {
                return pk.toString();
            }
            String id = this.getPersonPK(value);
            if (StringUtils.isEmpty((String)id)) {
                id = this.getPersonPK(this.getInfo(ctx2, bosType, pk));
            }
            return id;
        }
        if (pk == null && value.get("id") != null) {
            return value.get("id").toString();
        }
        return pk.toString();
    }

    private String getPersonPK(IObjectValue value) {
        if (value != null && value.get("person") != null) {
            if (((IObjectValue)value.get("person")).get("id") != null) {
                return ((IObjectValue)value.get("person")).get("id").toString();
            }
        } else if (value != null && value.get("employee") != null && ((IObjectValue)value.get("employee")).get("id") != null) {
            return ((IObjectValue)value.get("employee")).get("id").toString();
        }
        return null;
    }

    private IObjectValue getInfo(Context ctx2, String bosType, IObjectPK pk) throws BOSException {
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.getLocalBOSObjectFactory((Context)ctx2).createBOSObject(BOSObjectType.create((String)bosType));
        CoreBaseCollection creBaseCollection = iCoreBase.getCollection("where id = '" + pk.toString() + "'");
        if (creBaseCollection != null && creBaseCollection.size() > 0) {
            CoreBaseInfo info = creBaseCollection.get(0);
            return info;
        }
        return null;
    }

    private FactTypeEnum getFactType(String bosType) {
        if (this.person.contains(bosType)) {
            return FactTypeEnum.PERSON;
        }
        if (this.position.contains(bosType)) {
            return FactTypeEnum.POSITION;
        }
        if (this.admin.contains(bosType)) {
            return FactTypeEnum.ADMIN;
        }
        return null;
    }
}

