/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.output;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.app.output.SelectParseParam;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.util.StringUtils;
import java.util.Set;

public class WhereGeneratorHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringBuffer getWhereClause(Context ctx, SelectParseParam param, FilterInfo filterInfo) throws EASBizException, BOSException {
        int i;
        StringBuffer whereSql = new StringBuffer("");
        int filtersCount = filterInfo.getFilterItems().size();
        if (filtersCount <= 0) return whereSql;
        String format = filterInfo.getMaskString();
        if (!StringUtils.isEmpty((String)format)) {
            format = "(" + format + ")";
            for (i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (i = 0; i < filtersCount; ++i) {
            StringBuffer filter = new StringBuffer("");
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            Object value = filterItemInfo.getCompareValue();
            CompareType type = filterItemInfo.getCompareType();
            if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                filter.append(param.getFileMappings().get(filterItemInfo.getPropertyName().trim().toLowerCase()));
            }
            if (filterItemInfo.isCompareValueIsProperty()) {
                filter.append(filterItemInfo.getCompareExpression());
                filter.append(param.getFileMappings().get(filterItemInfo.getPropertyName().trim().toLowerCase()));
            } else {
                String tmp;
                if (value != null && value instanceof String && (tmp = (String)value).startsWith("~9^Nz")) {
                    value = tmp.substring(tmp.lastIndexOf("~9^Nz") + 5);
                }
                if (value == null) {
                    if (CompareType.EQUALS.equals((Object)type)) {
                        filter.append(" is null");
                    } else {
                        if (!CompareType.NOTEQUALS.equals((Object)type)) throw new IllegalArgumentException("can't compare with null,   comparetype = " + type);
                        filter.append(" is not null");
                    }
                } else if (CompareType.LIKE.equals((Object)type)) {
                    filter.append(" like ").append(SolidUtil.getValueString(value));
                    filter.deleteCharAt(filter.length() - 1);
                } else if (CompareType.INCLUDE.equals((Object)type) || CompareType.NOTINCLUDE.equals((Object)type)) {
                    if (value != null && value instanceof Set && ((Set)value).size() == 0) {
                        ((Set)value).add("");
                    }
                    filter.append(SolidUtil.appendIn(filterItemInfo, param.getFilePropertyMappings().get(filterItemInfo.getPropertyName().trim().toLowerCase()), CompareType.INCLUDE.equals((Object)type)));
                } else if (CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type)) {
                    if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'inner' or 'notinner' as compare type, the compare value must be string");
                    filter.append(type == CompareType.INNER ? " in " : " not in ");
                    filter.append("(");
                    filter.append(value.toString());
                    filter.append(")");
                } else if (CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type)) {
                    if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'exists' or 'notexists' as compare type, the compare value must be string");
                    filter.append(type == CompareType.EXISTS ? " exists " : " not exists ");
                    filter.append("(");
                    filter.append(value.toString());
                    filter.append(")");
                } else if (CompareType.IS.equals((Object)type) || CompareType.ISNOT.equals((Object)type)) {
                    filter.append(" ").append(filterItemInfo.getCompareExpression());
                    filter.append(" ").append("null");
                } else {
                    filter.append(filterItemInfo.getCompareExpression());
                    filter.append(" ").append(SolidUtil.getValueString(value));
                    filter.deleteCharAt(filter.length() - 1);
                }
            }
            if (StringUtils.isEmpty((String)format)) {
                whereSql.append(filter);
                if (i >= filtersCount - 1) continue;
                whereSql.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
        }
        if (format == null) return whereSql;
        whereSql.append(format);
        return whereSql;
    }
}

