/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AdminRangeCountService
implements IHRMsfService {
    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String adminOrgID = (String)param.get("adminOrgID");
        Date beginDate = null;
        Date endDate = null;
        try {
            beginDate = DateTimeUtils.parseDate((String)((String)param.get("beginDate")), (String)"yyyy-MM-dd");
            endDate = DateTimeUtils.parseDate((String)((String)param.get("endDate")), (String)"yyyy-MM-dd");
        }
        catch (ParseException e1) {
            throw new BOSException((Throwable)e1);
        }
        String adminTempTable = null;
        ArrayList result = new ArrayList();
        try {
            adminTempTable = this.createAdminTempTable(ctx, adminOrgID, beginDate, endDate);
            List<Map<String, Object>> positionResult = this.getPositionValues(ctx, adminTempTable);
            int initPersonCount = this.getInitPersonCount(ctx, adminOrgID, beginDate);
            HashMap<String, Integer> flowInt = this.getFlowInRecord(ctx, adminTempTable);
            HashMap<String, Integer> flowOut = this.getFlowOutRecord(ctx, adminTempTable);
            HashMap<String, Integer> leave = this.getLeaveRecord(ctx, adminTempTable);
            HashMap<String, Integer> enter = this.getEnterRecord(ctx, adminTempTable);
            int actualPerson = initPersonCount;
            while (beginDate.before(endDate)) {
                Integer out;
                Integer flowout;
                HashMap<String, Object> each = new HashMap<String, Object>();
                String formatDate = DateTimeUtils.format((Date)beginDate, (String)"yyyy-MM-dd");
                each.put("day", formatDate);
                int positionCount = this.getPositionPlanCount(positionResult, beginDate);
                each.put("planCount", new Integer(positionCount));
                Integer flowin = flowInt.get(formatDate);
                if (flowin == null) {
                    flowin = new Integer("0");
                }
                if ((flowout = flowOut.get(formatDate)) == null) {
                    flowout = new Integer("0");
                }
                each.put("flowin", flowin);
                each.put("flowout", flowout);
                initPersonCount = initPersonCount + flowin - flowout;
                Integer in = enter.get(formatDate);
                if (in == null) {
                    in = new Integer("0");
                }
                if ((out = leave.get(formatDate)) == null) {
                    out = new Integer("0");
                }
                each.put("in", in);
                each.put("out", out);
                each.put("actual", new Integer(initPersonCount));
                result.add(each);
                beginDate = HistoryUtil.getAfterDay((Date)beginDate);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(adminTempTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(adminTempTable);
        return result;
    }

    private HashMap<String, Integer> getFlowOutRecord(Context ctx, String adminTempTable) throws BOSException {
        HashMap<String, Integer> flowMap = new HashMap<String, Integer>();
        StringBuffer sql = this.getFlowInOutSql(adminTempTable);
        sql.append(" and affairtype.flongnumber like '02!%'");
        sql.append(" group by to_char(flowinout.feffdt,'yyyy-MM-dd') ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                flowMap.put(rowSet.getString("feffdt"), new Integer(rowSet.getInt("pcount")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flowMap;
    }

    private HashMap<String, Integer> getLeaveRecord(Context ctx, String adminTempTable) throws BOSException {
        HashMap<String, Integer> flowMap = new HashMap<String, Integer>();
        StringBuffer sql = this.getFlowInOutSql(adminTempTable);
        sql.append(" and affairtype.flongnumber like '02!0201%'");
        sql.append(" group by to_char(flowinout.feffdt,'yyyy-MM-dd') ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                flowMap.put(rowSet.getString("feffdt"), new Integer(rowSet.getInt("pcount")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flowMap;
    }

    private HashMap<String, Integer> getEnterRecord(Context ctx, String adminTempTable) throws BOSException {
        HashMap<String, Integer> flowMap = new HashMap<String, Integer>();
        StringBuffer sql = this.getFlowInOutSql(adminTempTable);
        sql.append(" and affairtype.flongnumber like '01!0101%'");
        sql.append(" group by to_char(flowinout.feffdt,'yyyy-MM-dd') ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                flowMap.put(rowSet.getString("feffdt"), new Integer(rowSet.getInt("pcount")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flowMap;
    }

    private HashMap<String, Integer> getFlowInRecord(Context ctx, String adminTempTable) throws BOSException {
        HashMap<String, Integer> flowMap = new HashMap<String, Integer>();
        StringBuffer sql = this.getFlowInOutSql(adminTempTable);
        sql.append(" and  affairtype.flongnumber like '01!%'");
        sql.append(" group by to_char(flowinout.feffdt,'yyyy-MM-dd') ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                flowMap.put(rowSet.getString("feffdt"), new Integer(rowSet.getInt("pcount")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return flowMap;
    }

    private StringBuffer getFlowInOutSql(String adminTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(*) pcount,to_char(flowinout.feffdt,'yyyy-MM-dd') feffdt from T_HR_EmpFlowInOut flowinout ");
        sql.append(" inner join T_HR_EmpLaborRelationHis emplabor ");
        sql.append(" on emplabor.fhistoryrelateid = flowinout.FlaborRelationID ").append(" and flowinout.FBizDate >= emplabor.feffdt and flowinout.fbizdate < emplabor.fleffdt ").append(" inner join t_hr_bdemployeetype emptype on emplabor.FLaborRelationStateID = emptype.fid ").append(" inner join T_HR_AffairActionReason affairtype on affairtype.fid = flowinout.FActionTypeID ").append(" where ").append("flowinout").append(".").append("FAssignType =1 ");
        sql.append(" and emptype").append(".").append("FIsInCount =1  ");
        sql.append(" and  flowinout.fadminorgid in (").append(" select admin.fhistoryrelateid from  ").append(adminTempTable).append(" admin  ").append(" where flowinout.feffdt >= admin.feffdt and flowinout.feffdt <= admin.fleffdt  ").append(" ) ");
        return sql;
    }

    private int getInitPersonCount(Context ctx, String adminOrgID, Date beginDate) throws EASBizException, BOSException {
        Date effdtDate = HistoryUtil.getBeforeDay((Date)beginDate);
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getHisValueByCurrentIDAndDate((IObjectPK)new ObjectUuidPK(adminOrgID), effdtDate);
        if (adminInfo == null) {
            return 0;
        }
        String dateFilter = SolidUtil.getValueStringOnly(new Timestamp(effdtDate.getTime()));
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(*) pcount from t_hr_emporgrelation relation ").append(" inner join t_org_adminhis admin on admin.fhistoryrelateid = relation.fadminorgid ");
        sql.append(" inner join T_HR_EmpLaborRelationHis emplabor ");
        sql.append(" on emplabor.fhistoryrelateid = relation.FlaborRelationID ").append(" and relation.Feffdt >= emplabor.feffdt and relation.feffdt < emplabor.fleffdt ").append(" inner join t_hr_bdemployeetype emptype on emplabor.FLaborRelationStateID = emptype.fid ").append(" where ").append("relation").append(".").append("FAssignType =1 ");
        sql.append(" and ").append("relation").append(".").append("FEFFDT  <= ").append(dateFilter);
        sql.append(" and ").append("relation").append(".").append("FLEFFDT  > ").append(dateFilter);
        sql.append(" and ").append("admin").append(".").append("FEFFDT  <= ").append(dateFilter);
        sql.append(" and ").append("admin").append(".").append("FLEFFDT  > ").append(dateFilter);
        sql.append(" and emptype").append(".").append("FIsInCount =1  ");
        sql.append(" and ").append("(admin").append(".").append("flongnumber like ").append("'").append(adminInfo.getLongNumber()).append("!%'").append(" or ").append("admin.fhistoryrelateid = '").append(adminOrgID).append("')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                count = rowSet.getInt("pcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return count;
    }

    private int getPositionPlanCount(List<Map<String, Object>> positionResult, Date date) {
        int count = 0;
        date = DateTimeUtils.truncateDate((Date)date);
        for (Map<String, Object> each : positionResult) {
            Date effdt = (Date)each.get("feffdt");
            Date leffdt = (Date)each.get("fleffdt");
            if (DateTimeUtils.dayBefore((Date)date, (Date)effdt) || DateTimeUtils.dayAfter((Date)date, (Date)leffdt)) continue;
            count += Integer.parseInt(each.get("fposplancount").toString());
        }
        return count;
    }

    private List<Map<String, Object>> getPositionValues(Context ctx, String adminTempTable) throws BOSException, SQLException {
        StringBuffer selectSql = new StringBuffer();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        selectSql.append("select position.fhistoryrelateid fid ").append(",position.feffdt feffdt ,position.fleffdt,position.FPOSPLANCOUNT FPOSPLANCOUNT ").append(" from t_org_positionhis position ").append(" where position.fadminorgunitid in(").append(" select admin.fhistoryrelateid from ").append(adminTempTable).append(" admin ").append(" where  position.fleffdt >= admin.feffdt and position.feffdt <= admin.fleffdt ").append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        while (rowSet.next()) {
            HashMap<String, Comparable<Integer>> hashMap = new HashMap<String, Comparable<Integer>>();
            hashMap.put("fposplancount", Integer.valueOf(rowSet.getInt("FPOSPLANCOUNT")));
            hashMap.put("feffdt", rowSet.getDate("feffdt"));
            hashMap.put("fleffdt", rowSet.getDate("fleffdt"));
            result.add(hashMap);
        }
        return result;
    }

    private String createAdminTempTable(Context ctx, String adminOrgID, Date beginDate, Date endDate) throws Exception {
        HashSet<String> adminLongNumber = this.getAdminLongNumber(ctx, adminOrgID, beginDate, endDate);
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        StringBuffer inserStr = new StringBuffer();
        String begin = SolidUtil.getValueStringOnly(beginDate);
        String end = SolidUtil.getValueStringOnly(endDate);
        inserStr.append("select * into ").append(tempTableName).append(" from (").append(" select ").append("  CASE  WHEN ( feffdt < ").append(begin).append(" )").append(" THEN ").append(begin).append(" else  feffdt end  feffdt,").append("  CASE  WHEN ( fleffdt > ").append(end).append(" )").append(" THEN ").append(end).append(" else  fleffdt end  fleffdt,").append("fid,fhistoryrelateid").append(" from t_org_adminhis where  fleffdt >=").append(begin).append(" and feffdt <=   ").append(end).append(" and (fhistoryrelateid = '").append(adminOrgID).append("' ");
        for (String each : adminLongNumber) {
            inserStr.append(" or flongnumber like ").append("'").append(each).append("!%").append("'");
        }
        inserStr.append(")");
        inserStr.append(" ) temp ");
        DbUtil.execute((Context)ctx, (String)inserStr.toString());
        return tempTableName;
    }

    private HashSet<String> getAdminLongNumber(Context ctx, String adminOrgID, Date beginDate, Date endDate) throws BOSException {
        HashSet<String> adminLongNumberSet = new HashSet<String>();
        String select = "select fid,flongnumber from t_org_adminhis where fhistoryrelateid = ? and ( fleffdt >= ? and  feffdt <= ? ) ";
        Object[] param = new Object[]{adminOrgID, new Timestamp(beginDate.getTime()), new Timestamp(endDate.getTime())};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)select, (Object[])param);
            while (rowSet.next()) {
                adminLongNumberSet.add(rowSet.getString("flongnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminLongNumberSet;
    }

    private class FlowInOut {
        int flowIn = 0;
        int flowOut = 0;

        private FlowInOut() {
        }

        public int getFlowIn() {
            return this.flowIn;
        }

        public void setFlowIn(int flowIn) {
            this.flowIn = flowIn;
        }

        public int getFlowOut() {
            return this.flowOut;
        }

        public void setFlowOut(int flowOut) {
            this.flowOut = flowOut;
        }
    }
}

