/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryObjectReader;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.app.service.ServiceUtils;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.eas.hr.service.app.util.ServiceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GetHistoryAdminRelateDateService
implements IHRMsfService {
    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String adminOrgID = (String)param.get("adminOrgID");
        String date = (String)param.get("appointDate");
        Date effdt = null;
        try {
            effdt = DateTimeUtils.parseDate((String)((String)param.get("appointDate")), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList result = new ArrayList();
        AdminOrgUnitInfo currentAdmin = (AdminOrgUnitInfo)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getHisValueByCurrentIDAndDate((IObjectPK)new ObjectUuidPK(adminOrgID), effdt);
        String parentId = "";
        if (currentAdmin.getParent() != null) {
            parentId = currentAdmin.getParent().getId().toString();
        }
        List admins = this.getAdminInfos(ctx, currentAdmin, effdt);
        boolean needGetPosition = false;
        HashSet<String> allAdminSet = new HashSet<String>();
        HashSet<String> allResponsePosSet = new HashSet<String>();
        for (int i = 0; i < admins.size(); ++i) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)admins.get(i);
            allAdminSet.add(adminInfo.getId().toString());
            if (adminInfo.getResponPosition() == null) continue;
            allResponsePosSet.add(adminInfo.getResponPosition().getId().toString());
        }
        HashMap<String, String> adminSubs = this.getAdminSubs(ctx, allAdminSet, effdt);
        HashMap<String, HashMap<String, String>> response = ServiceUtils.getPositionsPersonStr(ctx, allResponsePosSet, effdt);
        for (int i = 0; i < admins.size(); ++i) {
            HashMap<String, String> ppInfo;
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)admins.get(i);
            HashMap<String, String> each = new HashMap<String, String>();
            each.put("responname", "");
            if (adminInfo.getResponPosition() != null && (ppInfo = response.get(adminInfo)) != null) {
                String name = ppInfo.get("personName");
                String[] names = name.split(",");
                each.put("responname", names[0]);
            }
            each.put("FID", adminInfo.getId().toString());
            each.put("Fname", adminInfo.getName());
            each.put("Fnumber", adminInfo.getNumber());
            each.put("FSimpleName", ServiceUtil.getStringValue(adminInfo.getSimpleName()));
            each.put("Type", "org");
            each.put("subs", ServiceUtil.getIntValue(adminSubs.get(adminInfo.getId().toString())));
            result.add(each);
            if (adminInfo.getId().toString().equals(adminOrgID)) {
                each.put("FRela", "root");
                if (!adminInfo.isIsLeaf()) continue;
                needGetPosition = true;
                continue;
            }
            if (adminInfo.getId().toString().equals(parentId)) {
                each.put("FRela", "parent");
                continue;
            }
            each.put("FRela", "child");
        }
        return result;
    }

    private HashMap<String, String> getAdminSubs(Context ctx, HashSet<String> allAdminSet, Date appointDate) throws BOSException {
        String dateFilter = SolidUtil.getValueStringOnly(new Timestamp(appointDate.getTime()));
        String select = "select count(*) count ,fparentid from t_org_adminhis  where fparentid in(" + SolidUtil.setToStringFilter(allAdminSet) + ") and feffdt <= " + dateFilter + " and fleffdt >= " + dateFilter;
        select = select + " group by fparentid ";
        HashMap<String, String> subAdmin = new HashMap<String, String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)select);
        try {
            while (rowSet.next()) {
                subAdmin.put(rowSet.getString("fparentid"), "" + rowSet.getInt("count"));
                allAdminSet.remove(rowSet.getString("fparentid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return subAdmin;
    }

    private List getPositionInfos(Context ctx, String adminOrgID, Date effdt) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adminorgunit.id", (Object)adminOrgID));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)effdt, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)effdt, CompareType.GREATER));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("historyrelateid"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("simpleName"));
        view.setSelector(sic);
        List positions = HistoryUtil.getHistoryCollectionRetureCurrent((Context)ctx, (BOSObjectType)new PositionInfo().getBOSType(), (EntityViewInfo)view);
        return positions;
    }

    private List getAdminInfos(Context ctx, AdminOrgUnitInfo adminInfo, Date effdt) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> adminSet = new HashSet<String>();
        adminSet.add(adminInfo.getId().toString());
        if (adminInfo.getParent() != null) {
            adminSet.add(adminInfo.getParent().getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("historyrelateid", adminSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)adminInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)effdt, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)effdt, CompareType.GREATER_EQUALS));
        filter.setMaskString("( #0 or #1 ) and #2 and #3 ");
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("historyrelateid"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("responPosition.id"));
        view.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("longnumber");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        HistoryObjectReader hisoryObjectReader = new HistoryObjectReader();
        List admins = HistoryUtil.getHistoryCollectionRetureCurrent((Context)ctx, (BOSObjectType)new AdminOrgUnitInfo().getBOSType(), (EntityViewInfo)view);
        return admins;
    }
}

