/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.HRJobCategoryCollection;
import com.kingdee.eas.hr.org.HRJobCategoryInfo;
import com.kingdee.eas.hr.org.HRJobFamilyCollection;
import com.kingdee.eas.hr.org.HRJobFamilyInfo;
import com.kingdee.eas.hr.org.HRJobSubCategoryCollection;
import com.kingdee.eas.hr.org.HRJobSubCategoryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GetJobSystem2Service
implements IHRMsfService {
    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        Map fastFilter = (Map)param.get("fastFilter");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        if (fastFilter.size() > 0) {
            for (String key : fastFilter.keySet()) {
                if (fastFilter.get(key) == null || "".equals(fastFilter.get(key))) continue;
                filter.getFilterItems().add(new FilterItemInfo(key, fastFilter.get(key)));
            }
        }
        view.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().add(new SorterItemInfo("index"));
        view.setSorter(sorterItemCollection);
        this.checkParm(ctx, param);
        HRJobFamilyCollection jfColl = this.getJobFamilyCollection(ctx, String.valueOf(fastFilter.get("hrOrgUnit")));
        HRJobCategoryCollection jcColl = this.getJobCategoryCollection(ctx, String.valueOf(fastFilter.get("hrOrgUnit")));
        HRJobSubCategoryCollection jscColl = this.getJobSubCategoryCollection(ctx, String.valueOf(fastFilter.get("hrOrgUnit")));
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (int i = 0; i < jfColl.size(); ++i) {
            HRJobCategoryCollection jcTempColl = this.findJobCategoryCollByJobFamily(jfColl.get(i).getId(), jcColl);
            HashMap<String, String> each = new HashMap<String, String>();
            each.put("jobFamilyId", jfColl.get(i).getId().toString());
            each.put("jobFamilyNum", jfColl.get(i).getNumber());
            each.put("jobFamily", jfColl.get(i).getName());
            each.put("jobCategoryId", "");
            each.put("jobCategoryNum", "");
            each.put("jobCategory", "");
            each.put("jobSubCategoryId", "");
            each.put("jobSubCategoryNum", "");
            each.put("jobSubCategory", "");
            if (jcTempColl.size() == 0) {
                result.add(each);
                continue;
            }
            for (int j = 0; j < jcTempColl.size(); ++j) {
                HashMap tempNode = (HashMap)each.clone();
                tempNode.put("jobCategoryId", jcTempColl.get(j).getId().toString());
                tempNode.put("jobCategoryNum", jcTempColl.get(j).getNumber());
                tempNode.put("jobCategory", jcTempColl.get(j).getName());
                HRJobSubCategoryCollection jscTempColl = this.findJobSubCategoryCollByJobFamily(jcTempColl.get(j).getId(), jscColl);
                if (jscTempColl.size() == 0) {
                    result.add(tempNode);
                    continue;
                }
                for (int indexjsc = 0; indexjsc < jscTempColl.size(); ++indexjsc) {
                    HashMap tempjscNode = (HashMap)tempNode.clone();
                    tempjscNode.put("jobSubCategoryId", jscTempColl.get(indexjsc).getId().toString());
                    tempjscNode.put("jobSubCategoryNum", jscTempColl.get(indexjsc).getNumber());
                    tempjscNode.put("jobSubCategory", jscTempColl.get(indexjsc).getName());
                    result.add(tempjscNode);
                }
            }
        }
        return result;
    }

    private HRJobFamilyCollection getJobFamilyCollection(Context ctx, String hrOrgUnitid) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select jf.fid fid,jf.fname_" + l + " fname,jf.fnumber fnumber from T_HR_HRJobFamilyRelationHR rel inner join T_HR_HRJobFamily jf on rel.FBaseInfoId = jf.fid where rel.fstate in (100)";
        if (!StringUtils.isEmpty((String)hrOrgUnitid)) {
            sql = sql + " and rel.FHrOrgUseId = '" + hrOrgUnitid + "'";
        }
        HRJobFamilyCollection jfColl = new HRJobFamilyCollection();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HRJobFamilyInfo info = new HRJobFamilyInfo();
                info.setId(BOSUuid.read((String)iRowSet.getString("fid")));
                info.setName(iRowSet.getString("fname"));
                info.setNumber(iRowSet.getString("fnumber"));
                jfColl.add(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jfColl;
    }

    private HRJobCategoryCollection getJobCategoryCollection(Context ctx, String hrOrgUnitid) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select jf.fid fid,jf.fname_" + l + " fname,jf.fnumber fnumber, jf.FHRJobFamilyID from T_HR_HRJobCategoryRelationHR rel inner join t_hr_HRJobCategory jf on rel.FBaseInfoId = jf.fid where rel.fstate in (100)";
        if (!StringUtils.isEmpty((String)hrOrgUnitid)) {
            sql = sql + " and rel.FHrOrgUseId = '" + hrOrgUnitid + "'";
        }
        HRJobCategoryCollection jcColl = new HRJobCategoryCollection();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HRJobCategoryInfo info = new HRJobCategoryInfo();
                info.setId(BOSUuid.read((String)iRowSet.getString("fid")));
                info.setName(iRowSet.getString("fname"));
                info.setNumber(iRowSet.getString("fnumber"));
                HRJobFamilyInfo jfInfo = null;
                if (!StringUtils.isEmpty((String)iRowSet.getString("FHRJobFamilyID"))) {
                    jfInfo = new HRJobFamilyInfo();
                    jfInfo.setId(BOSUuid.read((String)iRowSet.getString("FHRJobFamilyID")));
                }
                info.setHrJobFamily(jfInfo);
                jcColl.add(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jcColl;
    }

    private HRJobSubCategoryCollection getJobSubCategoryCollection(Context ctx, String hrOrgUnitid) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select jf.fid fid,jf.fname_" + l + " fname,jf.fnumber fnumber,FHRJobCategoryID from T_HR_HRJobSubCategoryRelaHR rel inner join t_hr_HRJobSubCategory jf on rel.FBaseInfoId = jf.fid where rel.fstate in (100)";
        if (!StringUtils.isEmpty((String)hrOrgUnitid)) {
            sql = sql + " and rel.FHrOrgUseId = '" + hrOrgUnitid + "'";
        }
        HRJobSubCategoryCollection jcColl = new HRJobSubCategoryCollection();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HRJobSubCategoryInfo info = new HRJobSubCategoryInfo();
                info.setId(BOSUuid.read((String)iRowSet.getString("fid")));
                info.setName(iRowSet.getString("fname"));
                info.setNumber(iRowSet.getString("fnumber"));
                HRJobCategoryInfo jcInfo = null;
                if (!StringUtils.isEmpty((String)iRowSet.getString("FHRJobCategoryID"))) {
                    jcInfo = new HRJobCategoryInfo();
                    jcInfo.setId(BOSUuid.read((String)iRowSet.getString("FHRJobCategoryID")));
                }
                info.setHrJobCategory(jcInfo);
                jcColl.add(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jcColl;
    }

    private HRJobSubCategoryCollection findJobSubCategoryCollByJobFamily(BOSUuid id, HRJobSubCategoryCollection jscColl) {
        int i;
        HRJobSubCategoryCollection tempColl = new HRJobSubCategoryCollection();
        for (i = 0; i < jscColl.size(); ++i) {
            if (!jscColl.get(i).getHrJobCategory().getId().equals((Object)id)) continue;
            tempColl.add(jscColl.get(i));
        }
        for (i = 0; i < tempColl.size(); ++i) {
            jscColl.remove(tempColl.get(i));
        }
        return tempColl;
    }

    private HRJobCategoryCollection findJobCategoryCollByJobFamily(BOSUuid id, HRJobCategoryCollection jcColl) {
        int i;
        HRJobCategoryCollection tempColl = new HRJobCategoryCollection();
        for (i = 0; i < jcColl.size(); ++i) {
            if (jcColl.get(i).getHrJobFamily() == null || !jcColl.get(i).getHrJobFamily().getId().equals((Object)id)) continue;
            tempColl.add(jcColl.get(i));
        }
        for (i = 0; i < tempColl.size(); ++i) {
            jcColl.remove(tempColl.get(i));
        }
        return tempColl;
    }

    private void checkParm(Context ctx, Map param) throws EASBizException, BOSException {
        Map fastFilter = (Map)param.get("fastFilter");
        String hrOrgUnitId = "";
        if (fastFilter != null) {
            hrOrgUnitId = String.valueOf(fastFilter.get("hrOrgUnit"));
        }
        try {
            if (!StringUtils.isEmpty((String)hrOrgUnitId)) {
                BOSUuid.read((String)hrOrgUnitId);
            }
        }
        catch (UuidException e) {
            throw new BOSException(e.getMessage() + "hrOrgUnitId is invalid", (Throwable)e);
        }
    }
}

