/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.app.util.ServiceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GetJobsService
implements IHRMsfService {
    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("jobSubCategory.name"));
        sic.add(new SelectorItemInfo("jobSubCategory.id"));
        sic.add(new SelectorItemInfo("jobLevel.number"));
        sic.add(new SelectorItemInfo("jobLevel.name"));
        sic.add(new SelectorItemInfo("lowJobGrade.name"));
        sic.add(new SelectorItemInfo("highJobGrade.name"));
        view.setSelector(sic);
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("jobSubCategory.jobCategory.number");
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        sortInfo = new SorterItemInfo("jobSubCategory.jobCategory.jobFamily.number");
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        view.setSorter(sortCollection);
        HashMap<String, String> jobPlanCount = new HashMap<String, String>();
        HashMap<String, String> jobActualCount = new HashMap<String, String>();
        this.getJobCounts(ctx, jobPlanCount, jobActualCount);
        JobCollection jobColl = JobFactory.getLocalInstance((Context)ctx).getJobCollection(view);
        if (jobColl == null) {
            return result;
        }
        for (int i = 0; i < jobColl.size(); ++i) {
            HashMap<String, String> each = new HashMap<String, String>();
            each.put("JobID", jobColl.get(i).getId().toString());
            each.put("Job", jobColl.get(i).getName());
            if (jobColl.get(i).getJobSubCategory() != null) {
                each.put("JobSubFunctionID", jobColl.get(i).getJobSubCategory().getId().toString());
                each.put("JobSubFunction", jobColl.get(i).getJobSubCategory().getName());
            } else {
                each.put("JobSubFunctionID", "");
                each.put("JobSubFunction", "");
            }
            if (jobColl.get(i).getJobLevel() != null) {
                each.put("JobLevelNumber", jobColl.get(i).getJobLevel().getNumber());
                each.put("JobLevelName", jobColl.get(i).getJobLevel().getName());
            } else {
                each.put("JobLevelNumber", "");
                each.put("JobLevelName", "");
            }
            if (jobColl.get(i).getLowJobGrade() != null) {
                each.put("JobGrade_min", jobColl.get(i).getLowJobGrade().getName());
            } else {
                each.put("JobGrade_min", "");
            }
            if (jobColl.get(i).getHighJobGrade() != null) {
                each.put("JobGrade_max", jobColl.get(i).getHighJobGrade().getName());
            } else {
                each.put("JobGrade_max", "");
            }
            each.put("planCount", ServiceUtil.getIntValue(jobPlanCount.get(jobColl.get(i).getId().toString())));
            each.put("positionCount", ServiceUtil.getIntValue(jobActualCount.get(jobColl.get(i).getId().toString())));
            result.add(each);
        }
        return result;
    }

    private void getJobCounts(Context ctx, HashMap<String, String> jobPlanCount, HashMap<String, String> jobActualCount) throws BOSException {
        String selectStr = "select sum(FPosPlanCount) plancount,sum(FPositionCount) actualcount ,fjobid fjobid from t_hr_positionfact  group by fjobid ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectStr);
        try {
            while (rowSet.next()) {
                jobPlanCount.put(rowSet.getString("fjobid"), "" + rowSet.getInt("plancount"));
                jobPlanCount.put(rowSet.getString("fjobid"), "" + rowSet.getInt("actualcount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

