/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service.mcloud;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IntegrationInitOrgService
implements IHRMsfService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.service.app.service.mcloud.IntegrationInitOrgService");

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String selectSql = "select fid from t_org_admin where fid not in(select fadminorgunitid from t_bd_hrxuntorgmapping) and FIsSealUp=0 ";
        String insertSql = "insert into t_bd_hrxuntorgmapping (FAdminOrgUnitId,FCreateTime) values (?,?)";
        Timestamp timestamp = new Timestamp(new Date().getTime());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            while (rowSet.next()) {
                Object[] objs = new Object[]{rowSet.getString("fid"), timestamp};
                paramList.add(objs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramList);
        }
        HashMap<Object, Object> adminMap = new HashMap();
        HashMap<String, String> fullPathMap = new HashMap<String, String>();
        adminMap = this.prepareAdminMap(ctx);
        String updateSql = "update t_bd_hrxuntorgmapping set FCurrentOrgKey = ? where FAdminOrgUnitId = ? ";
        paramList = new ArrayList();
        for (Map.Entry<Object, Object> entry : adminMap.entrySet()) {
            if ("1".equals(((HashMap)entry.getValue()).get("sealup"))) continue;
            Object[] obj = new Object[]{this.getAdminFullName(((String)entry.getKey()).toString(), adminMap, fullPathMap), ((String)entry.getKey()).toString()};
            paramList.add(obj);
        }
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        }
        return null;
    }

    private HashMap<String, HashMap<String, String>> prepareAdminMap(Context ctx) throws BOSException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, HashMap<String, String>> adminMap = new HashMap<String, HashMap<String, String>>();
        String sql = "select fid,fparentid,fname_" + l + " as fname,FIsSealUp from t_org_admin";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                HashMap<String, String> each = new HashMap<String, String>();
                each.put("id", rowSet.getString("fid"));
                each.put("parent", rowSet.getString("fparentid"));
                each.put("name", rowSet.getString("fname"));
                each.put("sealup", "" + rowSet.getInt("FIsSealUp"));
                adminMap.put(rowSet.getString("fid"), each);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return adminMap;
    }

    private String getAdminFullName(String adminId, HashMap<String, HashMap<String, String>> adminMap, HashMap<String, String> fullPathMap) {
        if (fullPathMap.containsKey(adminId)) {
            return fullPathMap.get(adminId);
        }
        HashMap<String, String> each = adminMap.get(adminId);
        if (each == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)each.get("parent"))) {
            fullPathMap.put(adminId, each.get("name"));
            return each.get("name");
        }
        String parentName = this.getAdminFullName(each.get("parent"), adminMap, fullPathMap);
        String currentName = parentName + "\\" + each.get("name");
        fullPathMap.put(adminId, currentName);
        return currentName;
    }
}

