/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.solid;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.UniqueID;
import com.kingdee.eas.hr.service.SolidFildConfigCollection;
import com.kingdee.eas.hr.service.SolidFildConfigInfo;
import com.kingdee.eas.hr.service.app.solid.SelectSqlParam;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class SelectSqlGenerator {
    Context ctx = null;
    SolidFildConfigCollection coll = null;
    EntityObjectInfo source = null;
    EntityObjectInfo target = null;
    HashMap<String, EntityObjectInfo> relateEntity = new HashMap();
    StringBuffer selectSql = new StringBuffer();
    StringBuffer fromSql = new StringBuffer();
    private final UniqueID aliasIndex;
    SelectSqlParam param = null;

    public SelectSqlGenerator(Context ctx, SelectSqlParam param) {
        this.ctx = ctx;
        this.param = param;
        this.coll = param.getConfigColl();
        this.source = param.getSourceInfo();
        this.target = param.getTargetInfo();
        this.aliasIndex = new UniqueID(0L);
    }

    public String getSql() {
        try {
            this.generateSelect();
        }
        catch (InvalidDAOMetaDataException e) {
            e.printStackTrace();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.selectSql).append(" from ").append(this.fromSql);
        return sql.toString();
    }

    private void generateSelect() throws InvalidDAOMetaDataException {
        SolidFildConfigInfo configInfo = null;
        this.getTableAlias(this.source, "id");
        for (int i = 0; i < this.coll.size(); ++i) {
            if (this.selectSql.length() > 0) {
                this.selectSql.append(",");
            }
            configInfo = this.coll.get(i);
            PropertyInfo sourceProperty = null;
            EntityObjectInfo tempSource = null;
            if (StringUtils.isEmpty((String)configInfo.getSourceEntity())) {
                tempSource = this.source;
            } else {
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
                tempSource = loader.getEntity((IMetaDataPK)new MetaDataPK(configInfo.getSourceEntity()));
            }
            sourceProperty = SolidUtil.getPropertyByName(tempSource, configInfo.getSourceField());
            PropertyInfo targetProperty = SolidUtil.getPropertyByName(this.target, configInfo.getTargetField());
            ColumnInfo col = targetProperty.getMappingField();
            String targetName = col.getName();
            if (sourceProperty.getMappingField().isMultilingual()) {
                if (col.isMultilingual()) {
                    targetName = col.getName() + "_" + LocaleUtils.locale_l1.getDisplayName();
                }
                this.selectSql.append(" ").append("\"").append(this.getTableAlias(tempSource, configInfo.getSourceField())).append("\"").append(".").append(sourceProperty.getMappingField().getName() + "_").append(LocaleUtils.locale_l1.getDisplayName()).append(" as ").append(targetName);
                this.selectSql.append(",");
                if (col.isMultilingual()) {
                    targetName = col.getName() + "_" + LocaleUtils.locale_l2.getDisplayName();
                }
                this.selectSql.append(" ").append("\"").append(this.getTableAlias(tempSource, configInfo.getSourceField())).append("\"").append(".").append(sourceProperty.getMappingField().getName() + "_").append(LocaleUtils.locale_l2.getDisplayName()).append(" as ").append(targetName);
                this.selectSql.append(",");
                if (col.isMultilingual()) {
                    targetName = col.getName() + "_" + LocaleUtils.locale_l3.getDisplayName();
                }
                this.selectSql.append(" ").append("\"").append(this.getTableAlias(tempSource, configInfo.getSourceField())).append("\"").append(".").append(sourceProperty.getMappingField().getName() + "_").append(LocaleUtils.locale_l3.getDisplayName()).append(" as ").append(targetName);
                continue;
            }
            this.selectSql.append(" ").append("\"").append(this.getTableAlias(tempSource, configInfo.getSourceField())).append("\"").append(".").append(sourceProperty.getMappingField().getName()).append(" as ").append(targetName);
        }
    }

    String getTableAlias(EntityObjectInfo bo, String columnName) throws InvalidDAOMetaDataException {
        String alias;
        if (StringUtils.isEmpty((String)columnName)) {
            return "";
        }
        boolean needSpecial = false;
        if (!bo.getName().equals(this.source.getName())) {
            needSpecial = true;
            if (!this.param.getTableMapping().containsKey(bo.getFullName())) {
                alias = "t" + this.aliasIndex.next();
                this.param.getTableMapping().put(bo.getFullName(), alias);
                this.fromSql.append(" left join ").append(bo.getTable().getName()).append(" as ").append(alias).append("  on  ").append("\"").append(this.param.getTableMapping().get("")).append("\"").append(".").append("FID");
                String mappingFieldName = "";
                mappingFieldName = bo.getPropertyByNameRuntime("person") != null ? bo.getPropertyByNameRuntime("person").getMappingField().getName() : bo.getPropertyByNameRuntime("employee").getMappingField().getName();
                this.fromSql.append(" = ").append("\"").append(alias).append("\"").append(".").append(mappingFieldName);
            }
        }
        if (columnName.indexOf(".") >= 0) {
            String[] splits = columnName.split("\\.");
            StringBuffer path = new StringBuffer();
            StringBuffer pre = new StringBuffer();
            for (int i = 0; i < splits.length - 1; ++i) {
                if (path.length() > 0) {
                    path.append(".");
                }
                path.append(splits[i]);
                if (this.param.getTableMapping().get(path.toString()) == null) {
                    String alias2 = "t" + this.aliasIndex.next();
                    this.param.getTableMapping().put(path.toString(), alias2);
                    EntityObjectInfo tempBO = SolidUtil.getLinkObjectByName(bo, path.toString());
                    PropertyInfo property = SolidUtil.getPropertyByName(bo, path.toString());
                    String boTableAlias = this.param.getTableMapping().get(pre.toString());
                    this.fromSql.append(" left join ").append(tempBO.getTable().getName()).append(" as ").append(alias2).append("  on  ").append("\"").append(boTableAlias).append("\"").append(".").append(property.getMappingField().getName()).append(" = ").append("\"").append(alias2).append("\"").append(".").append("FID");
                }
                pre = new StringBuffer(path);
            }
            return this.param.getTableMapping().get(path.toString());
        }
        if (needSpecial) {
            return this.param.getTableMapping().get(bo.getFullName());
        }
        if (this.param.getTableMapping().get("") == null) {
            alias = "t" + this.aliasIndex.next();
            this.param.getTableMapping().put("", alias);
            this.fromSql.append(bo.getTable().getName()).append(" as ").append(alias).append(" ");
        }
        return this.param.getTableMapping().get("");
    }

    private void appendSelect(String sourceField, String sourceTableAlias, String alias) {
        if (this.selectSql.length() > 0) {
            this.selectSql.append(" ,");
        }
        this.selectSql.append("\"").append(sourceTableAlias).append("\"").append(".").append(sourceField).append(" as ").append(alias);
    }
}

