/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.solid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.ModifyLogCollection;
import com.kingdee.eas.hr.service.ModifyLogFactory;
import com.kingdee.eas.hr.service.ModifyLogInfo;
import com.kingdee.eas.hr.service.SolidFacadeFactory;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.notice.NoticeObserver;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class SolidPartFromDB {
    Set<String> personSet = new HashSet<String>();
    Set<String> positionSet = new HashSet<String>();
    Set<String> adminSet = new HashSet<String>();
    Set<String> recordIdSet = new HashSet<String>();
    private static final Logger logger = Logger.getLogger(SolidPartFromDB.class);

    public void solidPartByDBReason(Context ctx) throws BOSException, EASBizException {
        this.prepare(ctx);
        this.updatePart(ctx);
    }

    public void solidPart(Context ctx, ConcurrentHashMap<String, ModifyLogInfo> queue) {
        HashSet<String> positionOptSet = new HashSet<String>();
        HashSet<String> adminOptSet = new HashSet<String>();
        HashSet<String> personOptSet = new HashSet<String>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SolidPartFromDB solidPart begin queue.size = " + queue.size()));
        }
        Iterator<Map.Entry<String, ModifyLogInfo>> iter = queue.entrySet().iterator();
        int i = 1;
        ModifyLogInfo logInfo = null;
        while (iter.hasNext()) {
            Map.Entry<String, ModifyLogInfo> entry = iter.next();
            logInfo = entry.getValue();
            if (FactTypeEnum.ADMIN.equals((Object)logInfo.getType())) {
                this.adminSet.add(logInfo.getObjectID());
                adminOptSet.add(logInfo.getObjectID() + "@" + logInfo.getMethod());
            } else if (FactTypeEnum.POSITION.equals((Object)logInfo.getType())) {
                this.positionSet.add(logInfo.getObjectID());
                positionOptSet.add(logInfo.getObjectID() + "@" + logInfo.getMethod());
            } else if (FactTypeEnum.PERSON.equals((Object)logInfo.getType())) {
                this.personSet.add(logInfo.getObjectID());
                personOptSet.add(logInfo.getObjectID() + "@" + logInfo.getMethod());
            } else {
                this.personSet.add(logInfo.getObjectID());
                personOptSet.add(logInfo.getObjectID() + "@" + logInfo.getMethod());
            }
            ctx.put((Object)"operateUserID", (Object)logInfo.getUserID());
            if ((i + 1) % 100 != 0) continue;
            try {
                if (this.isFactDataImmediate(ctx)) {
                    this.adjustPosition(ctx);
                    this.updateByID(ctx);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.personSet = new HashSet<String>();
            this.positionSet = new HashSet<String>();
            this.adminSet = new HashSet<String>();
        }
        try {
            if (this.isFactDataImmediate(ctx)) {
                this.adjustPosition(ctx);
                this.updateByID(ctx);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("solid update modify error " + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            HashMap<String, HashSet<String>> queryParam = new HashMap<String, HashSet<String>>();
            queryParam.put("person", personOptSet);
            queryParam.put("position", positionOptSet);
            queryParam.put("orgUnit", adminOptSet);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("SolidPartFromDB.solidPart personsize={0},person={1}", personOptSet.size(), personOptSet));
                logger.debug((Object)MessageFormat.format("SolidPartFromDB.solidPart positionsize={0}, position={1}", positionOptSet.size(), positionOptSet));
                logger.debug((Object)MessageFormat.format("SolidPartFromDB.solidPart orgUnitsize={0}, orgUnit={1}", adminOptSet.size(), adminOptSet));
            }
            NoticeObserver.getInstance((Context)ctx).sendNotice(ctx, queryParam);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean isFactDataImmediate(Context ctx) throws BOSException {
        String selectSql = "select FVALUE from t_hr_hrinit where fKey = 'IS_Fact_IM'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        boolean isFactImmediate = true;
        try {
            if (rs.next()) {
                String value = rs.getString(1);
                isFactImmediate = Boolean.valueOf(value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isFactImmediate;
    }

    private void updatePart(Context ctx) throws BOSException, EASBizException {
        if (this.recordIdSet.size() == 0) {
            return;
        }
        this.adjustPosition(ctx);
        this.updateByID(ctx);
        this.updateRecordAlreadyProcess(ctx);
    }

    private void updateRecordAlreadyProcess(Context ctx) throws BOSException {
        String updateSql = "update t_hr_modifylog set fstate = 1 where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (String each : this.recordIdSet) {
            paramList.add(new Object[]{each});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
    }

    private void updateByID(Context ctx) throws BOSException, EASBizException {
        SolidFacadeFactory.getLocalInstance(ctx).personModify((HashSet)this.personSet);
        SolidFacadeFactory.getLocalInstance(ctx).positionModify((HashSet)this.positionSet);
        SolidFacadeFactory.getLocalInstance(ctx).adminModify((HashSet)this.adminSet);
    }

    private void adjustPosition(Context ctx) throws BOSException {
        IRowSet rowSet;
        if (this.personSet.size() > 0) {
            String personStr = SolidUtil.setToStringFilter(this.personSet);
            String dateFilter = SolidUtil.getValueStringOnly(new Timestamp(new Date().getTime()));
            String oldPosition = " select person.fpositionid fpositionid,position.FAdminOrgUnitID fadminorgunitid from t_hr_personfact person  inner join t_hr_positionfact position on position.fpositionid = person.fpositionid where fpersonid  in (" + personStr + ")";
            String newpersonRelatePosition = " select relation.fpositionid fpositionid,position.FAdminOrgUnitID fadminorgunitid from  t_hr_emporgrelation  relation  inner join t_org_position position on position.fid = relation.fpositionid where relation.FEFFDT  <=  " + dateFilter + " and  relation.FLEFFDT  >  " + dateFilter + " and relation.fpersonid in (" + personStr + ")";
            String relatePosition = oldPosition + " union all " + newpersonRelatePosition;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)relatePosition);
            try {
                while (rowSet.next()) {
                    this.positionSet.add(rowSet.getString("fpositionid"));
                    this.adminSet.add(rowSet.getString("fadminorgunitid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (this.positionSet.size() > 0) {
            String positionStr = SolidUtil.setToStringFilter(this.positionSet);
            String relateAdmins = "select fid fadminorgunitid  from t_org_admin where FResponPositionID  in( " + positionStr + ") union all select fadminorgunitid from t_hr_adminorgunitfact  where FResponPositionID  in( " + positionStr + ") union all select fadminorgunitid fadminorgunitid  from t_org_position where fid  in( " + positionStr + ") union all select fadminorgunitid from t_hr_positionfact  where fpositionid  in( " + positionStr + ")";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)relateAdmins);
            try {
                while (rowSet.next()) {
                    this.adminSet.add(rowSet.getString("fadminorgunitid"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void prepare(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0)));
        view.setFilter(filter);
        ModifyLogCollection coll = ModifyLogFactory.getLocalInstance(ctx).getModifyLogCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            this.recordIdSet.add(coll.get(i).getId().toString());
            if (FactTypeEnum.ADMIN.equals((Object)coll.get(i).getType())) {
                this.adminSet.add(coll.get(i).getObjectID());
            } else if (FactTypeEnum.POSITION.equals((Object)coll.get(i).getType())) {
                this.positionSet.add(coll.get(i).getObjectID());
            } else if (FactTypeEnum.PERSON.equals((Object)coll.get(i).getType())) {
                this.personSet.add(coll.get(i).getObjectID());
            } else {
                this.personSet.add(coll.get(i).getObjectID());
            }
            if ((i + 1) % 100 != 0) continue;
            this.updatePart(ctx);
            this.personSet = new HashSet<String>();
            this.positionSet = new HashSet<String>();
            this.adminSet = new HashSet<String>();
            this.recordIdSet = new HashSet<String>();
        }
    }
}

