/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.solid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.SolidFildConfigCollection;
import com.kingdee.eas.hr.service.SolidFildConfigFactory;
import com.kingdee.eas.hr.service.app.solid.SelectSqlGenerator;
import com.kingdee.eas.hr.service.app.solid.SelectSqlParam;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;

public class SolidSelectHelper {
    public SelectSqlParam getSelectSql(Context ctx, FactTypeEnum type) throws BOSException {
        EntityObjectInfo info = this.getMainObject(ctx, type);
        EntityObjectInfo targetInfo = SolidUtil.getTargetObject(ctx, type);
        SolidFildConfigCollection configColl = this.getSolidFildColl(ctx, type);
        SelectSqlParam param = new SelectSqlParam();
        param.setSourceInfo(info);
        param.setTargetInfo(targetInfo);
        param.setConfigColl(configColl);
        String sql = this.generateSql(ctx, param);
        param.setSql(" select " + sql);
        param.setSelectSql(sql);
        return param;
    }

    private String generateSql(Context ctx, SelectSqlParam param) {
        SelectSqlGenerator generater = new SelectSqlGenerator(ctx, param);
        return generater.getSql();
    }

    private SolidFildConfigCollection getSolidFildColl(Context ctx, FactTypeEnum type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(type.getValue())));
        view.setFilter(filter);
        return SolidFildConfigFactory.getLocalInstance(ctx).getSolidFildConfigCollection(view);
    }

    private EntityObjectInfo getMainObject(Context ctx, FactTypeEnum type) {
        String entityName = null;
        if (FactTypeEnum.ADMIN.equals((Object)type)) {
            entityName = "com.kingdee.eas.basedata.org.app.AdminOrgUnit";
        } else if (FactTypeEnum.POSITION.equals((Object)type)) {
            entityName = "com.kingdee.eas.basedata.org.app.Position";
        } else if (FactTypeEnum.PERSON.equals((Object)type)) {
            entityName = "com.kingdee.eas.basedata.person.app.Person";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
    }
}

