/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.solid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.SolidFildConfigCollection;
import com.kingdee.eas.hr.service.app.solid.InsertParam;
import com.kingdee.eas.hr.service.app.solid.ObjectLinkProperty;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SolidUtil {
    public static String setToStringFilter(Set<String> set) {
        if (set == null || set.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String each : set) {
            sb.append("'").append(each).append("'").append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static EntityObjectInfo getTargetObject(Context ctx, FactTypeEnum type) {
        String entityName = null;
        if (FactTypeEnum.ADMIN.equals((Object)type)) {
            entityName = "com.kingdee.eas.hr.service.app.AdminOrgUnitFact";
        } else if (FactTypeEnum.POSITION.equals((Object)type)) {
            entityName = "com.kingdee.eas.hr.service.app.PositionFact";
        } else if (FactTypeEnum.PERSON.equals((Object)type)) {
            entityName = "com.kingdee.eas.hr.service.app.PersonFact";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
    }

    public static EntityObjectInfo getSourceObject(Context ctx, FactTypeEnum type) {
        String entityName = null;
        if (FactTypeEnum.ADMIN.equals((Object)type)) {
            entityName = "com.kingdee.eas.basedata.org.app.AdminOrgUnit";
        } else if (FactTypeEnum.POSITION.equals((Object)type)) {
            entityName = "com.kingdee.eas.basedata.org.app.Position";
        } else if (FactTypeEnum.PERSON.equals((Object)type)) {
            entityName = "com.kingdee.eas.basedata.person.app.Person";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
    }

    public static int getAdminMaxLevel(Context ctx) throws BOSException {
        String sql = "select max(flevel) maxlevel from t_org_admin ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return rowSet.getInt("maxlevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    public static PropertyInfo getPropertyByName(EntityObjectInfo bo, String name) throws InvalidDAOMetaDataException {
        String[] nameList = StringUtils.fastSplit((String)name, (String)".");
        if (nameList == null || nameList.length < 1) {
            throw new InvalidDAOMetaDataException("selector item is null");
        }
        EntityObjectInfo tmpBo = bo;
        PropertyInfo fld = null;
        for (int i = 0; i < nameList.length; ++i) {
            if (fld != null) {
                if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation((EntityObjectInfo)tmpBo, (LinkPropertyInfo)((LinkPropertyInfo)fld));
                    tmpBo = relation.getChildObject(tmpBo);
                } else {
                    throw new InvalidDAOMetaDataException("can't get field of this name:" + name + " object:" + bo.getName());
                }
            }
            fld = tmpBo.getPropertyByNameRuntime(nameList[i]);
        }
        return fld;
    }

    public static RelationshipInfo getLinkObjectRelationByName(EntityObjectInfo bo, String name) throws InvalidDAOMetaDataException {
        String[] nameList = StringUtils.fastSplit((String)name, (String)".");
        if (nameList == null || nameList.length < 1) {
            throw new InvalidDAOMetaDataException("selector item is null");
        }
        EntityObjectInfo tmpBo = bo;
        PropertyInfo fld = null;
        RelationshipInfo relation = null;
        for (int i = 0; i < nameList.length; ++i) {
            if (fld != null) {
                if (fld instanceof LinkPropertyInfo) {
                    relation = ImplUtils.getRTRelation((EntityObjectInfo)tmpBo, (LinkPropertyInfo)((LinkPropertyInfo)fld));
                    tmpBo = relation.getChildObject(tmpBo);
                } else {
                    throw new InvalidDAOMetaDataException("can't get field of this name:" + name + " object:" + bo.getName());
                }
            }
            fld = tmpBo.getPropertyByNameRuntime(nameList[i]);
        }
        return relation;
    }

    public static ObjectLinkProperty getLinkObjectRelationInfoByName(EntityObjectInfo bo, String name) throws InvalidDAOMetaDataException {
        String[] nameList = StringUtils.fastSplit((String)name, (String)".");
        if (nameList == null || nameList.length < 1) {
            throw new InvalidDAOMetaDataException("selector item is null");
        }
        ObjectLinkProperty prope = new ObjectLinkProperty();
        EntityObjectInfo tmpBo = bo;
        PropertyInfo fld = null;
        RelationshipInfo relation = null;
        for (int i = 0; i < nameList.length; ++i) {
            fld = tmpBo.getPropertyByNameRuntime(nameList[i]);
            if (fld == null) continue;
            if (fld instanceof LinkPropertyInfo) {
                relation = ImplUtils.getRTRelation((EntityObjectInfo)tmpBo, (LinkPropertyInfo)((LinkPropertyInfo)fld));
                tmpBo = relation.getChildObject(tmpBo);
                prope.setParentObj(relation.getParentObject(tmpBo));
                prope.setChildObj(tmpBo);
                prope.setLinkProperty(fld);
                continue;
            }
            throw new InvalidDAOMetaDataException("can't get field of this name:" + name + " object:" + bo.getName());
        }
        return prope;
    }

    public static EntityObjectInfo getLinkObjectByName(EntityObjectInfo bo, String name) throws InvalidDAOMetaDataException {
        String[] nameList = StringUtils.fastSplit((String)name, (String)".");
        if (nameList == null || nameList.length < 1) {
            throw new InvalidDAOMetaDataException("selector item is null");
        }
        EntityObjectInfo tmpBo = bo;
        PropertyInfo fld = null;
        RelationshipInfo relation = null;
        for (int i = 0; i < nameList.length; ++i) {
            fld = tmpBo.getPropertyByNameRuntime(nameList[i]);
            if (fld == null) continue;
            if (fld instanceof LinkPropertyInfo) {
                relation = ImplUtils.getRTRelation((EntityObjectInfo)tmpBo, (LinkPropertyInfo)((LinkPropertyInfo)fld));
                tmpBo = relation.getChildObject(tmpBo);
                continue;
            }
            throw new InvalidDAOMetaDataException("can't get field of this name:" + name + " object:" + bo.getName());
        }
        return tmpBo;
    }

    public static InsertParam generateInsertColumns(SolidFildConfigCollection coll, EntityObjectInfo target) {
        InsertParam param = new InsertParam();
        for (int columnIndex = 0; columnIndex < coll.size(); ++columnIndex) {
            if (columnIndex > 0) {
                param.getColumnStr().append(",");
                param.getValuesStr().append(",");
            }
            PropertyInfo propertyInfo = target.getPropertyByNameRuntime(coll.get(columnIndex).getTargetField());
            ColumnInfo col = target.getTable().getColumnByNameRuntime(propertyInfo.getMappingField().getName());
            if (col.isMultilingual()) {
                param.getColumnStr().append(col.getName() + "_" + LocaleUtils.locale_l1.getDisplayName());
                param.getValuesStr().append(" ? ");
                param.getColumnStr().append(",");
                param.getValuesStr().append(",");
                param.getColumnStr().append(col.getName() + "_" + LocaleUtils.locale_l2.getDisplayName());
                param.getValuesStr().append(" ? ");
                param.getColumnStr().append(",");
                param.getValuesStr().append(",");
                param.getColumnStr().append(col.getName() + "_" + LocaleUtils.locale_l3.getDisplayName());
                param.getValuesStr().append(" ? ");
                continue;
            }
            param.getColumnStr().append(col.getName());
            param.getValuesStr().append(" ? ");
        }
        return param;
    }

    public static String getValueString(Object value) {
        StringBuffer sql = new StringBuffer();
        sql.append(SolidUtil.getValueStringOnly(value)).append(",");
        return sql.toString();
    }

    public static String getValueStringOnly(Object value) {
        StringBuffer sql = new StringBuffer();
        if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            sql.append(value.toString()).append("");
        } else if (value instanceof Boolean) {
            sql.append(value.toString().equalsIgnoreCase("true") ? "1" : "0");
        } else if (value instanceof Timestamp || value instanceof Date || value instanceof Time || value instanceof java.util.Date) {
            String val = null;
            if (value instanceof Timestamp) {
                val = DateTimeUtils.format((java.util.Date)((Timestamp)value), (String)"yyyy-MM-dd HH:mm:ss");
                sql.append("{ts ").append(SolidUtil.appendQuotedConst(val)).append("}");
            } else if (value instanceof Date) {
                val = DateTimeUtils.format((java.util.Date)((Date)value), (String)"yyyy-MM-dd");
                sql.append("{d ").append(SolidUtil.appendQuotedConst(val)).append("}");
            } else if (value instanceof Time) {
                val = DateTimeUtils.format((java.util.Date)((Time)value), (String)"HH:mm:ss");
                sql.append("{t ").append(SolidUtil.appendQuotedConst(val)).append("}");
            } else {
                val = DateTimeUtils.format((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                sql.append("{ts ").append(SolidUtil.appendQuotedConst(val)).append("}");
            }
        } else {
            sql.append(SolidUtil.appendQuotedConst(value.toString())).append("");
        }
        return sql.toString();
    }

    public static String appendQuotedConst(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append('\'').append(name).append('\'');
        return sb.toString();
    }

    public static PropertyInfo getJoinColumn(EntityObjectInfo target) {
        if (target.getFullName().equals("com.kingdee.eas.hr.service.app.AdminOrgUnitFact")) {
            return target.getPropertyByNameRuntime("adminorgunitid");
        }
        if (target.getFullName().equals("com.kingdee.eas.hr.service.app.PositionFact")) {
            return target.getPropertyByNameRuntime("positionID");
        }
        if (target.getFullName().equals("com.kingdee.eas.hr.service.app.PersonFact")) {
            return target.getPropertyByNameRuntime("person");
        }
        return target.getPropertyByNameRuntime("id");
    }

    public static PropertyInfo getJoinColumn(EntityObjectInfo child, EntityObjectInfo parent) {
        if (parent.getFullName().equals("com.kingdee.eas.hr.service.app.AdminOrgUnitFact") && child.getFullName().equals("com.kingdee.eas.hr.service.app.PositionFact")) {
            return child.getPropertyByNameRuntime("adminOrgUnit");
        }
        if (parent.getFullName().equals("com.kingdee.eas.hr.service.app.PositionFact") && child.getFullName().equals("com.kingdee.eas.hr.service.app.PersonFact")) {
            return child.getPropertyByNameRuntime("position");
        }
        if (parent.getFullName().equals("com.kingdee.eas.hr.service.app.AdminOrgUnitFact") && child.getFullName().equals("com.kingdee.eas.hr.service.app.PersonFact")) {
            return child.getPropertyByNameRuntime("adminOrgUnit");
        }
        if (parent.getFullName().equals("com.kingdee.eas.hr.service.app.PositionFact") && child.getFullName().equals("com.kingdee.eas.hr.service.app.AdminOrgUnitFact")) {
            return child.getPropertyByNameRuntime("responPosition");
        }
        return null;
    }

    public static String appendIn(FilterItemInfo fp, PropertyInfo prop, boolean isInclude) {
        StringBuffer sql = new StringBuffer();
        sql.append(isInclude ? " in " : " not in ");
        if (fp.getCompareValue() instanceof Set) {
            HashSet set = (HashSet)fp.getCompareValue();
            if (set.size() > 0) {
                assert (set.size() < 1024) : "set size must less 1024";
                sql.append("(");
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (prop instanceof OwnPropertyInfo) {
                        Object obj;
                        DataType type = ((OwnPropertyInfo)prop).getDataType();
                        if (type.equals((Object)DataType.STRING) || type.equals((Object)DataType.DATE) || type.equals((Object)DataType.BOSUUID)) {
                            obj = it.next();
                            if (obj != null && obj.toString() != null) {
                                sql.append(SolidUtil.appendQuotedConst(obj.toString().replaceAll("'", "''"))).append(",");
                                continue;
                            }
                            sql.append(SolidUtil.appendQuotedConst("")).append(",");
                            continue;
                        }
                        if (type.equals((Object)DataType.BOOLEAN)) {
                            String val = it.next().toString();
                            if (val.equalsIgnoreCase("true")) {
                                sql.append("1,");
                                continue;
                            }
                            if (!val.equalsIgnoreCase("false")) continue;
                            sql.append("0,");
                            continue;
                        }
                        obj = it.next();
                        if (obj != null && obj.toString() != null) {
                            sql.append(obj.toString()).append(",");
                            continue;
                        }
                        sql.append(SolidUtil.appendQuotedConst("")).append(",");
                        continue;
                    }
                    sql.append(SolidUtil.getValueString(it.next()));
                }
                if (sql.toString().lastIndexOf(",") == sql.toString().length() - 1) {
                    sql.deleteCharAt(sql.toString().length() - 1);
                }
                sql.append(")");
            }
        } else {
            sql.append(prop.toString());
        }
        return sql.toString();
    }
}

