/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.standby.IStandbyPersonPlan;
import com.kingdee.eas.hr.standby.IStandbyPersonWish;
import com.kingdee.eas.hr.standby.PersonPlanBizBillEntryCollection;
import com.kingdee.eas.hr.standby.PersonPlanBizBillEntryFactory;
import com.kingdee.eas.hr.standby.PersonPlanBizBillEntryInfo;
import com.kingdee.eas.hr.standby.PersonPlanBizBillInfo;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonPlanCollection;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.StandbyPersonWishCollection;
import com.kingdee.eas.hr.standby.StandbyPersonWishFactory;
import com.kingdee.eas.hr.standby.StandbyPersonWishInfo;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.app.AbstractPersonPlanBizBillControllerBean;
import com.kingdee.eas.hr.standby.app.PersonPlanBillBizBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonPlanBizBillControllerBean
extends AbstractPersonPlanBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.standby.app.PersonPlanBizBillControllerBean");

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.standby.app.PersonPlanBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return PersonPlanBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new PersonPlanBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String personId = ((PersonPlanBizBillEntryInfo)entry).getPerson().getId().toString();
        IStandbyPersonPlan iPersonPlan = StandbyPersonPlanFactory.getLocalInstance(ctx);
        StringBuffer personPlanStr = new StringBuffer("where employee = '");
        personPlanStr.append(personId);
        personPlanStr.append("' and billId = '");
        personPlanStr.append(((PersonPlanBizBillEntryInfo)entry).getBill().getId().toString());
        personPlanStr.append("'");
        StandbyPersonPlanCollection ppCol = iPersonPlan.getStandbyPersonPlanCollection(personPlanStr.toString());
        if (ppCol != null && ppCol.size() > 0) {
            int size = ppCol.size();
            for (int i = 0; i < size; ++i) {
                StandbyPersonPlanInfo ppInfo = ppCol.get(i);
                ppInfo.setIsAudited(true);
                iPersonPlan.update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), (CoreBaseInfo)ppInfo);
            }
        }
        IStandbyPersonWish iPersonWish = StandbyPersonWishFactory.getLocalInstance(ctx);
        StringBuffer personWishStr = new StringBuffer("where employee = '");
        personWishStr.append(personId);
        personWishStr.append("' and billId = '");
        personWishStr.append(((PersonPlanBizBillEntryInfo)entry).getBill().getId().toString());
        personWishStr.append("'");
        StandbyPersonWishCollection pwCol = iPersonWish.getStandbyPersonWishCollection(personWishStr.toString());
        if (pwCol != null && pwCol.size() > 0) {
            int size = pwCol.size();
            for (int i = 0; i < size; ++i) {
                StandbyPersonWishInfo pwInfo = pwCol.get(i);
                pwInfo.setIsAudited(true);
                iPersonWish.update((IObjectPK)new ObjectUuidPK(pwInfo.getId()), (CoreBaseInfo)pwInfo);
            }
        }
        super._entryEffect(ctx, entry);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonPlanBizBillInfo ppbbInfo = (PersonPlanBizBillInfo)model;
        IStandbyPersonPlan standbyPersonPlan = StandbyPersonPlanFactory.getLocalInstance(ctx);
        IStandbyPersonWish standbyPersonWish = StandbyPersonWishFactory.getLocalInstance(ctx);
        this.checkEntry(ctx, ppbbInfo);
        IObjectPK billId = super._addnew(ctx, model);
        ppbbInfo.setId(BOSUuid.read((String)billId.toString()));
        HashMap ppbbMap = (HashMap)ppbbInfo.get("planAndWish");
        HashMap planMap = (HashMap)ppbbMap.get("personPlan");
        for (Map.Entry entry : planMap.entrySet()) {
            HashMap ppMap = (HashMap)entry.getValue();
            for (Map.Entry entry1 : ppMap.entrySet()) {
                StandbyPersonPlanInfo ppInfo = (StandbyPersonPlanInfo)entry1.getValue();
                ppInfo.setIsAudited(false);
                ppInfo.setBillId(ppbbInfo);
                standbyPersonPlan.addnew((IObjectPK)new ObjectUuidPK(ppInfo.getId()), (CoreBaseInfo)ppInfo);
            }
        }
        HashMap wishMap = (HashMap)ppbbMap.get("personWish");
        for (Map.Entry entry : wishMap.entrySet()) {
            HashMap pwMap = (HashMap)entry.getValue();
            for (Map.Entry entry1 : pwMap.entrySet()) {
                StandbyPersonWishInfo pwInfo = (StandbyPersonWishInfo)entry1.getValue();
                pwInfo.setIsAudited(false);
                pwInfo.setBillId(ppbbInfo);
                standbyPersonWish.addnew((IObjectPK)new ObjectUuidPK(pwInfo.getId()), (CoreBaseInfo)pwInfo);
            }
        }
        ppbbInfo.setApplyDate(new Date());
        return billId;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PersonPlanBizBillInfo ppbbInfo = (PersonPlanBizBillInfo)super._getValue(ctx, pk);
        HashMap ppbbMap = new HashMap();
        HashMap<String, HashMap> planMap = new HashMap<String, HashMap>();
        HashMap<String, HashMap> wishMap = new HashMap<String, HashMap>();
        PersonPlanBizBillEntryInfo ppbbeInfo = null;
        PersonPlanBizBillEntryCollection ppbbeCol = ppbbInfo.getEntrys();
        int size = ppbbeCol.size();
        for (int i = 0; i < size; ++i) {
            ppbbeInfo = ppbbeCol.get(i);
            BOSUuid personId = ppbbeInfo.getPerson().getId();
            HashMap ppMap = this.getPersonPlanByPersonId(ctx, personId, ppbbInfo.getId().toString());
            String planKey = "personPlan~" + personId.toString();
            planMap.put(planKey, ppMap);
            HashMap pwMap = this.getPersonWishByPersonId(ctx, personId, ppbbInfo.getId().toString());
            String wishKey = "personWish~" + personId.toString();
            wishMap.put(wishKey, pwMap);
        }
        ppbbMap.put("personPlan", planMap);
        ppbbMap.put("personWish", wishMap);
        ppbbInfo.put("planAndWish", ppbbMap);
        return ppbbInfo;
    }

    private HashMap getPersonPlanByPersonId(Context ctx, BOSUuid personId, String billId) throws BOSException {
        HashMap<String, StandbyPersonPlanInfo> ppMap = new HashMap<String, StandbyPersonPlanInfo>();
        String ppSql = "select * from T_HR_StandbyPersonPlan where FEmployeeID = '" + personId.toString() + "' and FBillId = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ppSql);
        StandbyTrainingItemInfo trainingItemInfo = null;
        StandbyPersonPlanInfo ppInfo = null;
        IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
        try {
            while (rs.next()) {
                ppInfo = new StandbyPersonPlanInfo();
                ppInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                ppInfo.setEmployee(iP.getPersonInfo((IObjectPK)new ObjectUuidPK(personId)));
                ppInfo.setTarget(rs.getString("FTarget_L2"));
                if (rs.getString("FTrainingItemID") != null) {
                    String trainingItemSql = "select FName_l2, FNumber from T_HR_StandbyTrainingItem where fid = '" + rs.getString("FTrainingItemID") + "'";
                    IRowSet trainingItemRs = DbUtil.executeQuery((Context)ctx, (String)trainingItemSql);
                    while (trainingItemRs.next()) {
                        trainingItemInfo = new StandbyTrainingItemInfo();
                        trainingItemInfo.setId(BOSUuid.read((String)rs.getString("FTrainingItemID")));
                        trainingItemInfo.setName(trainingItemRs.getString("FName_l2"));
                        trainingItemInfo.setNumber(trainingItemRs.getString("FNumber"));
                        ppInfo.setTrainingItem(trainingItemInfo);
                    }
                }
                ppInfo.setSummary(rs.getString("FSummary_L2"));
                ppInfo.setMethod(rs.getString("FMethod_L2"));
                ppInfo.setDescription(rs.getString("FDescription_L2"));
                ppInfo.setBeginDate(rs.getDate("FBeginDate"));
                ppInfo.setEndDate(rs.getDate("FEndDate"));
                ppInfo.setIsAudited(rs.getBoolean("FIsAudited"));
                ppMap.put(rs.getString("FID"), ppInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ppMap;
    }

    private HashMap getPersonWishByPersonId(Context ctx, BOSUuid personId, String billId) throws BOSException {
        HashMap<String, StandbyPersonWishInfo> pwMap = new HashMap<String, StandbyPersonWishInfo>();
        String pwSql = "select * from T_HR_StandbyPersonWish where FEmployeeID = '" + personId.toString() + "' and FBillId = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)pwSql);
        StandbyPersonWishInfo pwInfo = null;
        IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
        try {
            while (rs.next()) {
                pwInfo = new StandbyPersonWishInfo();
                pwInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                pwInfo.setCareerPlan(rs.getString("FCareerPlan_L2"));
                pwInfo.setExcellence(rs.getString("FExcellence_L2"));
                pwInfo.setShortage(rs.getString("FShortage_L2"));
                pwInfo.setRequest(rs.getString("FRequest_L2"));
                if (rs.getString("FToPositionID") != null) {
                    String toPositionSql = "select FName_l2, FNumber from T_ORG_Position where fid = '" + rs.getString("FToPositionID") + "'";
                    IRowSet toPositionRs = DbUtil.executeQuery((Context)ctx, (String)toPositionSql);
                    while (toPositionRs.next()) {
                        PositionInfo positionInfo = new PositionInfo();
                        positionInfo.setId(BOSUuid.read((String)rs.getString("FToPositionID")));
                        positionInfo.setName(toPositionRs.getString("FName_l2"));
                        positionInfo.setNumber(toPositionRs.getString("FNumber"));
                        pwInfo.setToPosition(positionInfo);
                    }
                }
                pwInfo.setEmployee(iP.getPersonInfo((IObjectPK)new ObjectUuidPK(personId)));
                pwInfo.setIsAudited(rs.getBoolean("FIsAudited"));
                pwMap.put(rs.getString("FID"), pwInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return pwMap;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashMap ppbbMap = null;
        HashMap planMap = null;
        HashMap wishMap = null;
        IStandbyPersonPlan standbyPersonPlan = StandbyPersonPlanFactory.getLocalInstance(ctx);
        IStandbyPersonWish standbyPersonWish = StandbyPersonWishFactory.getLocalInstance(ctx);
        PersonPlanBizBillInfo ppbbInfo = (PersonPlanBizBillInfo)this._getValue(ctx, pk);
        if (ppbbInfo.get("planAndWish") != null) {
            ppbbMap = (HashMap)ppbbInfo.get("planAndWish");
            planMap = (HashMap)ppbbMap.get("personPlan");
            wishMap = (HashMap)ppbbMap.get("personWish");
            if (!planMap.isEmpty()) {
                for (Map.Entry entry : planMap.entrySet()) {
                    HashMap ppMap = (HashMap)entry.getValue();
                    if (ppMap.isEmpty()) continue;
                    for (Map.Entry entry1 : ppMap.entrySet()) {
                        StandbyPersonPlanInfo ppInfo = (StandbyPersonPlanInfo)entry1.getValue();
                        standbyPersonPlan.delete((IObjectPK)new ObjectUuidPK(ppInfo.getId()));
                    }
                }
            }
            if (!wishMap.isEmpty()) {
                for (Object wishKey : wishMap.keySet()) {
                    HashMap pwMap = (HashMap)wishMap.get(wishKey);
                    if (pwMap.isEmpty()) continue;
                    for (Object pwKey : pwMap.keySet()) {
                        StandbyPersonWishInfo pwInfo = (StandbyPersonWishInfo)pwMap.get(pwKey);
                        standbyPersonWish.delete((IObjectPK)new ObjectUuidPK(pwInfo.getId()));
                    }
                }
            }
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._delete(ctx, pk);
        this._addnew(ctx, model);
    }

    private void checkEntry(Context ctx, PersonPlanBizBillInfo pbInfo) throws BOSException, EASBizException {
        PersonPlanBizBillEntryInfo pbeInfo1 = null;
        PersonPlanBizBillEntryInfo pbeInfo2 = null;
        int count = pbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            pbeInfo1 = pbInfo.getEntrys().get(i);
            int size = pbInfo.getEntrys().size();
            for (int j = 0; j < size; ++j) {
                pbeInfo2 = pbInfo.getEntrys().get(j);
                if (i == j) continue;
                boolean result = false;
                if (pbeInfo1.getPerson().equals((Object)pbeInfo2.getPerson())) {
                    if (pbeInfo1.getToAdminOrg() != null && pbeInfo2.getToAdminOrg() != null && pbeInfo1.getToAdminOrg().equals((Object)pbeInfo2.getToAdminOrg())) {
                        result = true;
                    }
                    if (pbeInfo1.getToPosition() != null && pbeInfo2.getToPosition() != null && pbeInfo1.getToPosition().equals((Object)pbeInfo2.getToPosition())) {
                        result = true;
                    }
                }
                if (!result) continue;
                throw new StandbyException(StandbyException.STANDBYPERSON_REPEAT, new Object[]{i + 1, j + 1});
            }
            StringBuffer sql = new StringBuffer("select ppb.FNumber, ppb.FID from T_HR_StandbyPPBizBillEntry ppe ");
            sql.append("inner join T_HR_StandByPPBizBill ppb on ppe.FBillID = ppb.FID where ppe.FPersonID = '");
            if (pbeInfo1.getToAdminOrg() != null) {
                sql.append(pbeInfo1.getPerson().getId().toString());
                sql.append("' and ppe.FToAdminOrgID = '");
                sql.append(pbeInfo1.getToAdminOrg().getId().toString());
                sql.append("' and ppe.FStandbyTypeID = '");
                sql.append(pbeInfo1.getStandbyType().getId().toString());
                sql.append("' and (ppb.FBillState in (0, 1, 2) or (ppb.FBillState = 3 and ppe.FBizDate >= ");
                sql.append(HRUtil.getCurrentDate());
                sql.append("))");
            } else {
                sql.append(pbeInfo1.getPerson().getId().toString());
                sql.append("' and ppe.FToPositionID = '");
                sql.append(pbeInfo1.getToPosition().getId().toString());
                sql.append("' and ppe.FStandbyTypeID = '");
                sql.append(pbeInfo1.getStandbyType().getId().toString());
                sql.append("' and (ppb.FBillState in (0, 1, 2) or (ppb.FBillState = 3 and ppe.FBizDate >= ");
                sql.append(HRUtil.getCurrentDate());
                sql.append("))");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) continue;
                String billNumber = rs.getString(1);
                throw new StandbyException(StandbyException.STANDBYPERSON_ISUSED, new Object[]{i + 1, billNumber});
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

