/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.IStandbyPersonAuditRecord;
import com.kingdee.eas.hr.standby.IStandbyPersonCourse;
import com.kingdee.eas.hr.standby.IStandbyPersonPlan;
import com.kingdee.eas.hr.standby.IStandbyPersonWish;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordFactory;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonCourseFactory;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonWishFactory;
import com.kingdee.eas.hr.standby.StandbyTypeFactory;
import com.kingdee.eas.hr.standby.StandbyTypeInfo;
import com.kingdee.eas.hr.standby.app.AbstractStandbyPersonControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class StandbyPersonControllerBean
extends AbstractStandbyPersonControllerBean {
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("employee.name"));
        StandbyPersonInfo info = this.getStandbyPersonInfo(ctx, pk, selector);
        if (info.getEmployee() != null) {
            return info.getEmployee().getName();
        }
        return "";
    }

    protected void _addBatchStandbyPerson(Context ctx, IObjectCollection standbyPersonCol) throws BOSException, EASBizException {
        StandbyPersonCollection infos = (StandbyPersonCollection)standbyPersonCol;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            StandbyPersonInfo sbPerInfo = infos.get(i);
            if (!this.checkBatchInputValidate(ctx, sbPerInfo)) continue;
            this.addnew(ctx, (CoreBaseInfo)sbPerInfo);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandbyPersonInfo sbPerInfo = (StandbyPersonInfo)model;
        sbPerInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        Locale l1 = LocaleUtils.getLocale((String)"L1");
        Locale l2 = LocaleUtils.getLocale((String)"L2");
        Locale l3 = LocaleUtils.getLocale((String)"L3");
        String toStandbyAudit = sbPerInfo.getToStandbyAudit();
        Locale locale = ctx.getLocale();
        if (locale.equals(l2)) {
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l1);
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l2);
            sbPerInfo.setToStandbyAudit(STConverter.sc2tc((String)toStandbyAudit), l3);
        } else if (locale.equals(l3)) {
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l1);
            sbPerInfo.setToStandbyAudit(STConverter.tc2sc((String)toStandbyAudit), l2);
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l3);
        } else {
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l1);
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l2);
            sbPerInfo.setToStandbyAudit(toStandbyAudit, l3);
        }
        String toStandbyReason = sbPerInfo.getToStandbyReason();
        if (locale.equals(l2)) {
            sbPerInfo.setToStandbyReason(toStandbyReason, l1);
            sbPerInfo.setToStandbyReason(toStandbyReason, l2);
            sbPerInfo.setToStandbyReason(STConverter.sc2tc((String)toStandbyReason), l3);
        } else if (locale.equals(l3)) {
            sbPerInfo.setToStandbyReason(toStandbyReason, l1);
            sbPerInfo.setToStandbyReason(STConverter.tc2sc((String)toStandbyReason), l2);
            sbPerInfo.setToStandbyReason(toStandbyReason, l3);
        } else {
            sbPerInfo.setToStandbyReason(toStandbyReason, l1);
            sbPerInfo.setToStandbyReason(toStandbyReason, l2);
            sbPerInfo.setToStandbyReason(toStandbyReason, l3);
        }
        return super._addnew(ctx, (IObjectValue)sbPerInfo);
    }

    protected void _deleteStandbyPersonAndOther(Context ctx, String sbPerId, boolean isReserve) throws BOSException, EASBizException {
        if (!isReserve) {
            StandbyPersonInfo sbPerInfo = this.getStandbyPersonInfo(ctx, (IObjectPK)new ObjectUuidPK(sbPerId));
            String empId = sbPerInfo.getEmployee().getId().toString();
            this.deleteStandbyPersonOtherInfos(ctx, empId);
        }
        this.delete(ctx, (IObjectPK)new ObjectUuidPK(sbPerId));
    }

    private void deleteStandbyPersonOtherInfos(Context ctx, String empId) throws BOSException, EASBizException {
        IStandbyPersonCourse iCour = StandbyPersonCourseFactory.getLocalInstance(ctx);
        FilterInfo courFilter = new FilterInfo();
        courFilter.getFilterItems().add(new FilterItemInfo("plan.employee", (Object)empId));
        iCour.delete(courFilter);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)empId));
        IStandbyPersonPlan iPlan = StandbyPersonPlanFactory.getLocalInstance(ctx);
        iPlan.delete(filter);
        IStandbyPersonWish iWish = StandbyPersonWishFactory.getLocalInstance(ctx);
        iWish.delete(filter);
        IStandbyPersonAuditRecord iAudit = StandbyPersonAuditRecordFactory.getLocalInstance(ctx);
        iAudit.delete(filter);
    }

    private boolean isExistPersonToPosition(Context ctx, String employeeID, String positionID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)employeeID));
        filter.getFilterItems().add(new FilterItemInfo("toPosition", (Object)positionID));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        IStandbyPerson iPer = StandbyPersonFactory.getLocalInstance(ctx);
        return iPer.exists(filter);
    }

    private boolean isExistPersonToUnit(Context ctx, String employeeID, String toUnitId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)employeeID));
        filter.getFilterItems().add(new FilterItemInfo("toUnit", (Object)toUnitId));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        IStandbyPerson iPer = StandbyPersonFactory.getLocalInstance(ctx);
        return iPer.exists(filter);
    }

    private int getPersonCountByToPosition(Context ctx, String positionID) throws BOSException {
        int iCount = 0;
        IStandbyPerson iPer = StandbyPersonFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toPosition", (Object)positionID));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        view.setFilter(filter);
        StandbyPersonCollection perCol = iPer.getStandbyPersonCollection(view);
        if (perCol != null) {
            iCount = perCol.size();
        }
        return iCount;
    }

    protected int _getToPositionAndToUnitCountByPerson(Context ctx, String employeeID) throws BOSException {
        int iCount = 0;
        IStandbyPerson iPer = StandbyPersonFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)employeeID));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        view.setFilter(filter);
        StandbyPersonCollection perCol = iPer.getStandbyPersonCollection(view);
        if (perCol != null) {
            iCount = perCol.size();
        }
        return iCount;
    }

    private boolean checkBatchInputValidate(Context ctx, StandbyPersonInfo sbPerInfo) throws EASBizException, BOSException {
        StandbyTypeInfo sbTypeInfo = sbPerInfo.getStandbyType();
        PositionInfo toPosInfo = sbPerInfo.getToPosition();
        PersonInfo empInfo = sbPerInfo.getEmployee();
        AdminOrgUnitInfo toUnitInfo = sbPerInfo.getToUnit();
        String empId = empInfo.getId().toString();
        String empName = null;
        if (empInfo.getName() != null) {
            empName = empInfo.getName();
        } else {
            PersonInfo newEmpInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(empId));
            empName = newEmpInfo.getName();
        }
        String sbTypeId = sbTypeInfo.getId().toString();
        String toPosId = null;
        String toPosName = null;
        if (toPosInfo != null) {
            toPosId = toPosInfo.getId().toString();
            if (toPosInfo.getName() != null) {
                toPosName = toPosInfo.getName();
            } else {
                PositionInfo newToPosInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(toPosId));
                toPosName = newToPosInfo.getName();
            }
        }
        String toUnitId = null;
        String toUnitName = null;
        if (toUnitInfo != null) {
            toUnitId = toUnitInfo.getId().toString();
            toUnitName = toUnitInfo.getName();
        }
        PositionInfo primaryPos = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(empInfo.getId());
        if (toPosId != null && toPosId.equals(primaryPos.getId().toString())) {
            throw new StandbyException(StandbyException.TOPOSITION_CANNOT_EQUAL_EMPPOSITION_WITH_PARAM, new Object[]{empName});
        }
        if (toPosId != null && this.getPersonCountByToPosition(ctx, toPosId) >= 3) {
            throw new StandbyException(StandbyException.TOPOSITION_HAVEMORETHAN_THREE, new Object[]{toPosName});
        }
        if (this.getToPositionAndToUnitCountByPerson(ctx, empId) >= 3) {
            throw new StandbyException(StandbyException.EMPLOYEE_HAVEMORE_THREE, new Object[]{empName});
        }
        if (toPosId != null && this.isExistPersonToPosition(ctx, empId, toPosId)) {
            throw new StandbyException(StandbyException.EMPLOYEE_ALREADY_ON_TOPOSITION, new Object[]{empName, toPosName});
        }
        if (toUnitId != null && this.isExistPersonToUnit(ctx, empId, toUnitId)) {
            throw new StandbyException(StandbyException.EMPLOYEE_ALREADY_ON_TOUNIT, new Object[]{empName, toUnitName});
        }
        if (this.isExistDiffType(ctx, empId, sbTypeId)) {
            throw new StandbyException(StandbyException.EMPLOYEE_CANNOT_HAVE_DIFFTYPE, new Object[]{empName});
        }
        return true;
    }

    private boolean isExistDiffType(Context ctx, String empID, String sbTypeId) throws BOSException {
        StandbyPersonInfo sbPerInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)empID));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        view.setFilter(filter);
        IStandbyPerson iPer = StandbyPersonFactory.getLocalInstance(ctx);
        StandbyPersonCollection sbPerCol = iPer.getStandbyPersonCollection(view);
        return sbPerCol.size() > 0 && !(sbPerInfo = sbPerCol.get(0)).getStandbyType().getId().toString().equals(sbTypeId);
    }

    protected void _updateStandbyPersonInfo(Context ctx, String empId, ArrayList toPositionList, String standbyTypeId) throws BOSException, EASBizException {
        IStandbyPerson iPer = StandbyPersonFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)empId));
        filter.getFilterItems().add(new FilterItemInfo("toUnit", null));
        filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)1));
        view.setFilter(filter);
        StandbyPersonCollection sbPerCol = iPer.getStandbyPersonCollection(view);
        StandbyPersonInfo sbPerInfo = null;
        HashMap newToPosMap = null;
        String newToPosId = null;
        int newToPosLevel = 0;
        Date newToPosDate = null;
        int size = sbPerCol.size();
        int length = toPositionList.size();
        for (int j = 0; j < size; ++j) {
            sbPerInfo = sbPerCol.get(j);
            boolean isDelete = true;
            for (int i = 0; i < length; ++i) {
                newToPosMap = (HashMap)toPositionList.get(i);
                newToPosId = newToPosMap.get("toPosId").toString();
                if (!sbPerInfo.getToPosition().getId().toString().equals(newToPosId)) continue;
                isDelete = false;
            }
            if (!isDelete) continue;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(sbPerInfo.getId()));
        }
        for (int i = 0; i < length; ++i) {
            newToPosMap = (HashMap)toPositionList.get(i);
            newToPosId = newToPosMap.get("toPosId").toString();
            newToPosLevel = (Integer)newToPosMap.get("toPosLevel");
            newToPosDate = (Date)newToPosMap.get("toPosDate");
            boolean isExistToPos = false;
            for (int j = 0; j < size; ++j) {
                sbPerInfo = sbPerCol.get(j);
                if (!sbPerInfo.getToPosition().getId().toString().equals(newToPosId)) continue;
                sbPerInfo.setToPositionLevel(newToPosLevel);
                sbPerInfo.setToPositionDate(newToPosDate);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(sbPerInfo.getId()), (CoreBaseInfo)sbPerInfo);
                isExistToPos = true;
                break;
            }
            if (isExistToPos) continue;
            sbPerInfo = new StandbyPersonInfo();
            PersonInfo perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)empId));
            PositionInfo toPosInfo = new PositionInfo();
            toPosInfo.setId(BOSUuid.read((String)newToPosId));
            StandbyTypeInfo sbTypeInfo = new StandbyTypeInfo();
            sbTypeInfo.setId(BOSUuid.read((String)standbyTypeId));
            sbPerInfo.setStandbyType(sbTypeInfo);
            sbPerInfo.setEmployee(perInfo);
            sbPerInfo.setToPosition(toPosInfo);
            sbPerInfo.setToPositionLevel(newToPosLevel);
            sbPerInfo.setToPositionDate(newToPosDate);
            sbPerInfo.setIsStandby(1);
            if (!this.checkBatchInputValidate(ctx, sbPerInfo)) continue;
            this.addnew(ctx, (CoreBaseInfo)sbPerInfo);
        }
        String sql = "update t_hr_StandbyPerson set FStandbyTypeID = '" + standbyTypeId + "' where FEmployeeID = '" + empId + "' and FIsStandby = " + 1;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void _standbyPersonToCommon(Context ctx, ArrayList toCommonList, boolean isReserve) throws BOSException, EASBizException {
        StandbyPersonInfo sbPerInfo = null;
        int size = toCommonList.size();
        for (int i = 0; i < size; ++i) {
            String empId;
            HashMap map = (HashMap)toCommonList.get(i);
            String sbPerId = map.get("id").toString();
            ObjectUuidPK pkId = new ObjectUuidPK(sbPerId);
            String strAudit = map.get("toCommonAudit").toString();
            String strReason = map.get("toCommonReason").toString();
            Object endTime = map.get("endTime");
            sbPerInfo = this.getStandbyPersonInfo(ctx, (IObjectPK)pkId);
            sbPerInfo.setToCommonAudit(strAudit);
            sbPerInfo.setToCommonReason(strReason);
            sbPerInfo.setIsStandby(0);
            if (endTime instanceof Date) {
                sbPerInfo.setEndTime((Date)endTime);
            }
            this.update(ctx, (IObjectPK)pkId, (CoreBaseInfo)sbPerInfo);
            if (isReserve || this.getToPositionAndToUnitCountByPerson(ctx, empId = sbPerInfo.getEmployee().getId().toString()) >= 2) continue;
            this.deleteStandbyPersonOtherInfos(ctx, empId);
        }
    }

    protected HashMap _getStandbyPersonInfoByPerson(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PersonInfo person = (PersonInfo)personInfo;
        PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()));
        map.put("pInfo", pInfo);
        if (personInfo.get("standbyPerson") != null) {
            PersonPositionInfo ppInfo;
            StandbyPersonInfo sInfo = (StandbyPersonInfo)personInfo.get("standbyPerson");
            BOSUuid toPositionId = null;
            BOSUuid toUnitId = null;
            BOSUuid standbyTypeId = null;
            if (sInfo != null) {
                if (sInfo.getToPosition() != null) {
                    toPositionId = sInfo.getToPosition().getId();
                    PositionInfo tpInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(toPositionId));
                    map.put("toPosition", tpInfo);
                    AdminOrgUnitInfo tpuInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(tpInfo.getAdminOrgUnit().getId()));
                    map.put("toPositionUnit", tpuInfo);
                }
                if (sInfo.getToUnit() != null) {
                    toUnitId = sInfo.getToUnit().getId();
                    AdminOrgUnitInfo tuInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(toUnitId));
                    map.put("toUnit", tuInfo);
                }
                if (sInfo.getStandbyType() != null) {
                    standbyTypeId = sInfo.getStandbyType().getId();
                    StandbyTypeInfo stInfo = StandbyTypeFactory.getLocalInstance(ctx).getStandbyTypeInfo((IObjectPK)new ObjectUuidPK(standbyTypeId));
                    map.put("standbyType", stInfo);
                }
            }
            if ((ppInfo = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionInfo("where person = '" + person.getId().toString() + "'")) != null) {
                PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(ppInfo.getPrimaryPosition().getId()));
                map.put("position", positionInfo);
                AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(ppInfo.getPersonDep().getId()));
                map.put("admin", adminInfo);
            }
        }
        return map;
    }

    protected void _verifyStandbyPerson(Context ctx, StandbyPersonInfo standbyPerson) throws BOSException, EASBizException {
        this.checkBatchInputValidate(ctx, standbyPerson);
    }

    protected Map _getCountByPosition(Context ctx, Set set) throws BOSException, EASBizException {
        Iterator iterator = set.iterator();
        StringBuffer ids = new StringBuffer();
        while (iterator.hasNext()) {
            ids.append("'").append(iterator.next()).append("',");
        }
        String positionIds = ids.substring(0, ids.length() - 1);
        StringBuffer sql = new StringBuffer();
        sql.append("select ftopositionid,count(ftopositionid)  from T_HR_StandbyPerson").append(" where FIsStandby=1 and ftopositionid in (").append(positionIds).append(")  group by ftopositionid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                map.put(rs.getString(1), rs.getInt(2));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

