/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.standby.IStandbyPersonCourse;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonCourseCollection;
import com.kingdee.eas.hr.standby.StandbyPersonCourseFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanCollection;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.app.AbstractStandbyPersonPlanControllerBean;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class StandbyPersonPlanControllerBean
extends AbstractStandbyPersonPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.standby.app.StandbyPersonPlanControllerBean");

    protected void _updateBatchPersonPlan(Context ctx, IObjectCollection standbyPersonPlanCol, ArrayList deleteIds) throws BOSException, EASBizException {
        int size = deleteIds.size();
        for (int i = 0; i < size; ++i) {
            String planId = deleteIds.get(i).toString();
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(planId));
        }
        StandbyPersonPlanCollection planCol = (StandbyPersonPlanCollection)standbyPersonPlanCol;
        int size2 = planCol.size();
        for (int i = 0; i < size2; ++i) {
            StandbyPersonPlanInfo planInfo = planCol.get(i);
            planInfo.setIsAudited(true);
            ObjectUuidPK planId = new ObjectUuidPK(planInfo.getId());
            if (this.exists(ctx, (IObjectPK)planId)) {
                this.update(ctx, (IObjectPK)planId, (CoreBaseInfo)planInfo);
                continue;
            }
            this.addnew(ctx, (CoreBaseInfo)planInfo);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(ctx, (StandbyPersonPlanInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verify(ctx, (StandbyPersonPlanInfo)model);
        super._addnew(ctx, pk, model);
    }

    private void verify(Context ctx, StandbyPersonPlanInfo planInfo) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee", (Object)planInfo.getEmployee().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("trainingItem.id", (Object)planInfo.getTrainingItem().getId().toString()));
        if (this.exists(ctx, filter)) {
            throw new StandbyException(StandbyException.PLANPROJECT_CANNOT_DUP);
        }
    }

    protected boolean _isRefrencedByCourse(Context ctx, String planId) throws BOSException, EASBizException {
        IStandbyPersonCourse iCour = StandbyPersonCourseFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("plan", (Object)planId));
        view.setFilter(filter);
        StandbyPersonCourseCollection courCol = iCour.getStandbyPersonCourseCollection(view);
        return courCol.size() > 0;
    }
}

