/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.state.DepartureBillEntryCollection;
import com.kingdee.eas.hr.state.DepartureBillEntryInfo;
import com.kingdee.eas.hr.state.DepartureBillException;
import com.kingdee.eas.hr.state.DepartureBillInfo;
import com.kingdee.eas.hr.state.DepartureFactory;
import com.kingdee.eas.hr.state.DepartureInfo;
import com.kingdee.eas.hr.state.IDeparture;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;

public class DepartureBillBizBean
extends HRAffairBillBizBean {
    public void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        DepartureBillEntryInfo entryInfo = (DepartureBillEntryInfo)entry;
        this.addDeparture(ctx, entryInfo);
    }

    private void addDeparture(Context ctx, DepartureBillEntryInfo entryInfo) throws BOSException, EASBizException {
        IDeparture iDeparture = DepartureFactory.getLocalInstance(ctx);
        DepartureInfo departureInfo = this.getDepartureInfo(ctx, entryInfo);
        try {
            iDeparture.addnew((CoreBaseInfo)departureInfo);
        }
        catch (BOSException e) {
            throw new DepartureBillException(DepartureBillException.ADD_DEPARTURE_FAIL);
        }
        catch (EASBizException e) {
            throw new DepartureBillException(DepartureBillException.ADD_DEPARTURE_FAIL);
        }
    }

    private DepartureInfo getDepartureInfo(Context ctx, DepartureBillEntryInfo entryInfo) throws BOSException, EASBizException {
        DepartureInfo departureInfo = new DepartureInfo();
        if (entryInfo == null) {
            throw new DepartureBillException(DepartureBillException.ENTRY_NO_EXIST);
        }
        departureInfo.setHrOrgUnit(entryInfo.getBill().getHrOrgUnit());
        departureInfo.setDepartureBill(entryInfo.getBill());
        departureInfo.setPerson(entryInfo.getApplier());
        departureInfo.setAdminOrg(entryInfo.getAdminOrg());
        departureInfo.setPosition(entryInfo.getPosition());
        departureInfo.setStartDate(entryInfo.getStartDate());
        departureInfo.setEndDate(entryInfo.getEndDate());
        departureInfo.setReason(entryInfo.getReason());
        departureInfo.setDestination(entryInfo.getDestination());
        departureInfo.setDepartureType(entryInfo.getDepartureType());
        departureInfo.setBgcdNum(entryInfo.getBgcdNum());
        departureInfo.setBgcOrg(entryInfo.getBgcOrg());
        departureInfo.setBgcTerm(entryInfo.getBgcTerm());
        departureInfo.setAreSource(entryInfo.getFareSource());
        departureInfo.setOrgGroupUnit(entryInfo.getOrgGroupUnit());
        departureInfo.setGroupPosition(entryInfo.getGroupPosition());
        departureInfo.setHealthStatus(entryInfo.getHealthStatus());
        departureInfo.setSignContractStatus(entryInfo.getSignContractStatus());
        departureInfo.setRemark(entryInfo.getRemark());
        departureInfo.setDaysCount(new BigDecimal(0));
        departureInfo.setIsSelect(0);
        departureInfo.setAccompanier(entryInfo.getAccompanier());
        return departureInfo;
    }

    public IObjectValue formatDate(Context ctx, IObjectValue model) {
        DepartureBillInfo info = (DepartureBillInfo)model;
        DepartureBillEntryCollection collection = info.getEntrys();
        for (int i = 0; i < collection.size(); ++i) {
            Date startDate = collection.get(i).getStartDate();
            Date endDate = collection.get(i).getEndDate();
            info.getEntrys().get(i).setStartDate(DateTimeUtils.truncateDate((Date)startDate));
            info.getEntrys().get(i).setEndDate(DateTimeUtils.truncateDate((Date)endDate));
        }
        return info;
    }

    public void _personPlanChek(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }
}

