/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.state.DepartureCollection;
import com.kingdee.eas.hr.state.DepartureFactory;
import com.kingdee.eas.hr.state.DepartureInfo;
import com.kingdee.eas.hr.state.DepartureReportBillEntryCollection;
import com.kingdee.eas.hr.state.DepartureReportBillEntryInfo;
import com.kingdee.eas.hr.state.DepartureReportEventException;
import com.kingdee.eas.hr.state.DepartureReportInfo;
import com.kingdee.eas.hr.state.IDeparture;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class DepartureReportBillBizBean
extends HRAffairBillBizBean {
    public void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        DepartureReportBillEntryInfo entryInfo = (DepartureReportBillEntryInfo)entry;
        this.updateDepartureInfo(ctx, entryInfo);
    }

    protected EntityViewInfo getEntityViewInfo(DepartureReportBillEntryInfo drBillEntryInfo) {
        if (drBillEntryInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo departureItemInfo = new FilterItemInfo("departureBill.id", (Object)drBillEntryInfo.getDepartureBill().getId(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(departureItemInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)drBillEntryInfo.getApplier().getId(), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1");
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    protected DepartureInfo getDepartureInfo(IDeparture iDao, DepartureReportBillEntryInfo drBillEntryInfo) throws BOSException, DepartureReportEventException {
        EntityViewInfo viewInfo = this.getEntityViewInfo(drBillEntryInfo);
        if (viewInfo == null) {
            throw new DepartureReportEventException(DepartureReportEventException.DEPARTUREREPORTBILLENTRY_EMPTY);
        }
        DepartureCollection departureCon = iDao.getDepartureCollection(viewInfo);
        DepartureInfo departureInfo = departureCon.get(0);
        if (departureInfo == null) {
            throw new DepartureReportEventException(DepartureReportEventException.DEPARTUREBILL_EMPTY);
        }
        departureInfo.setStartDate(drBillEntryInfo.getStartDate());
        departureInfo.setEndDate(drBillEntryInfo.getEndDate());
        departureInfo.setReason(drBillEntryInfo.getReason());
        departureInfo.setDestination(drBillEntryInfo.getDestination());
        departureInfo.setDepartureType(drBillEntryInfo.getDepartureType());
        departureInfo.setDaysCount(drBillEntryInfo.getDaysCount());
        departureInfo.setAbnormalCir(drBillEntryInfo.getAbnormalCir());
        departureInfo.setAppraise(drBillEntryInfo.getAppraise());
        departureInfo.setHonestyEvaluate(drBillEntryInfo.getHonestyEvaluate());
        departureInfo.setRemark(drBillEntryInfo.getRemark());
        return departureInfo;
    }

    protected void updateDepartureInfo(Context ctx, DepartureReportBillEntryInfo drBillEntryInfo) throws BOSException, EASBizException {
        IDeparture iDao = DepartureFactory.getLocalInstance(ctx);
        DepartureInfo departureInfo = this.getDepartureInfo(iDao, drBillEntryInfo);
        iDao.update((IObjectPK)new ObjectUuidPK(departureInfo.getId()), (CoreBaseInfo)departureInfo);
    }

    public void updateDepartureIsSelectedAttr(Context ctx, IObjectValue model, int isSelect) throws BOSException, EASBizException {
        String departureBillId = null;
        String departureApplierId = null;
        DepartureReportInfo info = (DepartureReportInfo)model;
        DepartureReportBillEntryCollection connection = info.getEntrys();
        for (int i = 0; i < connection.size(); ++i) {
            departureBillId = connection.get(i).getDepartureBill().getId().toString();
            departureApplierId = connection.get(i).getApplier().getId().toString();
            this.updateAttr(ctx, departureBillId, departureApplierId, isSelect);
        }
    }

    public void updateAttr(Context ctx, String departureBillId, String departureApplierId, int isSelect) throws BOSException, EASBizException {
        DepartureInfo info;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo departureItemInfo = new FilterItemInfo("departureBill.id", (Object)departureBillId, CompareType.EQUALS);
        filterInfo.getFilterItems().add(departureItemInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)departureApplierId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        viewInfo.setFilter(filterInfo);
        IDeparture iDao = DepartureFactory.getLocalInstance(ctx);
        DepartureCollection connection = iDao.getDepartureCollection(viewInfo);
        if (connection != null) {
            info = connection.get(0);
            if (info == null) {
                throw new DepartureReportEventException(DepartureReportEventException.DEPARTUREBILL_EMPTY);
            }
        } else {
            throw new DepartureReportEventException(DepartureReportEventException.DEPARTUREBILL_EMPTY);
        }
        info.setIsSelect(isSelect);
        iDao.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    public IObjectValue formatDate(Context ctx, IObjectValue model) {
        DepartureReportInfo info = (DepartureReportInfo)model;
        DepartureReportBillEntryCollection collection = info.getEntrys();
        for (int i = 0; i < collection.size(); ++i) {
            Date startDate = collection.get(i).getStartDate();
            Date endDate = collection.get(i).getEndDate();
            info.getEntrys().get(i).setStartDate(DateTimeUtils.truncateDate((Date)startDate));
            info.getEntrys().get(i).setEndDate(DateTimeUtils.truncateDate((Date)endDate));
        }
        return info;
    }

    public void _personPlanChek(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }
}

