/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.tobacco.DsynConfigCollection;
import com.kingdee.eas.hr.tobacco.DsynConfigFactory;
import com.kingdee.eas.hr.tobacco.DsynConfigInfo;
import com.kingdee.eas.hr.tobacco.IDsynConfig;
import com.kingdee.eas.hr.tobacco.app.AbstractDsynConfigControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DsynConfigControllerBean
extends AbstractDsynConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.tobacco.app.DsynConfigControllerBean");
    private static boolean start = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _dsynServer(Context ctx, String args) throws BOSException {
        if (start) {
            return;
        }
        Connection conn = null;
        CallableStatement call = null;
        try {
            start = true;
            conn = EJBFactory.getConnection((Context)ctx);
            EntityViewInfo vInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("state", (Object)Boolean.TRUE);
            vInfo.setFilter(filter);
            IDsynConfig iDsynConfig = DsynConfigFactory.getLocalInstance(ctx);
            DsynConfigCollection dsynCofigColl = iDsynConfig.getDsynConfigCollection(vInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            SelectorItemInfo sItemInfo = new SelectorItemInfo("msg");
            selector.add(sItemInfo);
            for (int i = 0; i < dsynCofigColl.size(); ++i) {
                try {
                    DsynConfigInfo dsyn = dsynCofigColl.get(i);
                    String procName = dsyn.getProcedure().trim();
                    String callStr = "{ call " + procName + "() }";
                    try {
                        call = conn.prepareCall(callStr);
                        call.execute();
                        dsyn.setMsg("\u6210\u529f\u8f6c\u50a8");
                        iDsynConfig.updatePartial((CoreBaseInfo)dsyn, selector);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage());
                        dsyn.setMsg("\u8f6c\u50a8\u53d1\u751f\u9519\u8bef:" + e.getMessage());
                        iDsynConfig.updatePartial((CoreBaseInfo)dsyn, selector);
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((Statement)call);
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage());
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        finally {
            start = false;
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        super._update(ctx, pk, model);
    }
}

