/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.tobacco.PersonPageInfo;
import com.kingdee.eas.hr.tobacco.TobaccoException;
import com.kingdee.eas.hr.tobacco.app.AbstractPersonPageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PersonPageControllerBean
extends AbstractPersonPageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.tobacco.app.PersonPageControllerBean");

    public IObjectPK _submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PersonPageInfo info = (PersonPageInfo)model;
        if (info.getJoinPolityDetail() != null && info.getJoinPolityDetail().length() > 10) {
            throw new TobaccoException(TobaccoException.JOINPOLITY_IS_TOOLONG);
        }
        if (info.getId() != null) {
            PersonPageInfo oldInfo = this.getPersonPageInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            info.setCurSpecDuty(oldInfo.getCurSpecDuty());
            info.setCurCertifyCompetency(oldInfo.getCurCertifyCompetency());
        }
        this.updateSort(ctx, (CoreBaseInfo)info);
        return super._submit(ctx, (IObjectValue)info);
    }

    private void updateSort(Context ctx, CoreBaseInfo info) throws BOSException, EASBizException {
        PersonPageInfo personPage = (PersonPageInfo)info;
        int innerCode = personPage.getInnerCode();
        if (innerCode <= 0 || personPage.getPerson() == null) {
            return;
        }
        String personId = personPage.getPerson().getId().toString();
        StringBuffer sql = new StringBuffer("select fInnerCode from T_HR_PersonPage where fpersonId=?");
        IRowSet codeRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
        try {
            int oldInnerCode = 0;
            if (codeRs.next()) {
                oldInnerCode = codeRs.getInt(1);
            }
            if (innerCode == oldInnerCode) {
                return;
            }
            sql = new StringBuffer("select fpersondep from T_HR_PersonPosition where fpersonId=?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
            if (rs.next()) {
                String depId = rs.getString(1);
                sql.setLength(0);
                sql.append(" select top 1 B.findex           ").append(" from T_HR_PersonPage A                        ").append(" join t_bd_person B on A.fpersonId=B.fid       ").append(" where A.fpersonId in                          ").append(" (select fpersonId from T_HR_PersonPosition    ").append(" where fpersondep=? and fpersonId!=?)          ").append(" and A.FInnerCode>=?                           ").append(" order by A.FInnerCode                         ");
                IRowSet afterRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{depId, personId, innerCode});
                int index = 0;
                if (afterRs.next()) {
                    index = afterRs.getInt(1) + 1;
                } else {
                    sql.setLength(0);
                    sql.append(" select top 1 B.findex       ").append(" from T_HR_PersonPage A                  ").append(" join t_bd_person B on A.fpersonId=B.fid ").append(" where A.fpersonId in                          ").append(" (select fpersonId from T_HR_PersonPosition    ").append(" where fpersondep=? and fpersonId!=?)          ").append(" and A.FInnerCode<=? and A.FInnerCode>0        ").append(" order by A.FInnerCode desc                    ");
                    IRowSet beforeRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{depId, personId, innerCode});
                    if (beforeRs.next()) {
                        index = beforeRs.getInt(1) + 1;
                    } else {
                        sql.setLength(0);
                        sql.append(" select MAX(A.findex) from                          ").append(" t_bd_person A                                      ").append(" INNER JOIN T_ORG_PositionMember POSITIONMEMBER     ").append(" ON A.FID = POSITIONMEMBER.FPersonID                ").append(" INNER JOIN T_ORG_Position POSITION                 ").append(" ON POSITIONMEMBER.FPositionID = POSITION.FID       ").append(" LEFT OUTER JOIN T_PM_OrgRange ORGRANGE             ").append(" ON POSITION.FAdminOrgUnitID = ORGRANGE.FOrgID      ").append(" LEFT OUTER JOIN T_ORG_UnitRelation OUFULLRELA      ").append(" ON POSITION.FAdminOrgUnitID=OUFULLRELA.FFromUnitID ").append(" where A.fid in                                     ").append(" (select fpersonId from T_HR_PersonPosition         ").append(" where fpersondep in                                ").append(" (select fid from t_org_admin where flongnumber<    ").append(" (select flongnumber from t_org_admin               ").append(" where fid=(select fAdminOrgUnitid                  ").append(" from T_ORG_Position where fid=                     ").append(" (select fpositionId from T_ORG_PositionMember      ").append(" where fpersonid=?                                  ").append(" and fisprimary=1)))))                              ").append(" and OUFULLRELA.FTypeRelationID=                    ").append(" '00000000-0000-0000-0000-0000000000100FE9F8B5'     ").append(" AND ORGRANGE.FType = 20                            ");
                        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
                        index = allRs.next() ? allRs.getInt(1) + 1 : 1;
                    }
                }
                if (oldInnerCode != 0 && oldInnerCode < innerCode) {
                    sql.setLength(0);
                    sql.append(" update T_HR_PersonPage                         ").append(" set fInnerCode=fInnerCode-1 where fpersonId in ").append(" (select fpersonId from T_HR_PersonPosition     ").append(" where fpersondep=(select fpersondep            ").append("from T_HR_PersonPosition where fpersonId=?))    ").append(" and fInnerCode>=? and finnerCode<=?             ");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId, oldInnerCode, innerCode});
                }
                sql.setLength(0);
                sql.append(" select fInnerCode,fpersonId                  ").append(" from T_HR_PersonPage where fpersonId in      ").append(" (select fpersonId from T_HR_PersonPosition   ").append(" where fpersondep=? and fpersonId!=?)         ").append(" and fInnerCode>=?                            ").append(" order by fInnerCode                          ");
                IRowSet updateRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{depId, personId, innerCode});
                ArrayList<Object[]> updateList = new ArrayList<Object[]>();
                String[] persons = new String[updateRs.size() + 1];
                int personIndex = 0;
                persons[personIndex] = personId;
                while (updateRs.next()) {
                    String personStr = updateRs.getString(2);
                    updateList.add(new Object[]{++innerCode, updateRs.getInt(1), personStr});
                    persons[++personIndex] = personStr;
                }
                sql.setLength(0);
                sql.append("update T_HR_PersonPage set fInnerCode=? where fInnerCode=? and fpersonId=?");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updateList);
                if (index != 0) {
                    PersonFactory.getLocalInstance((Context)ctx).insertPersons(index, persons);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    public static void updateOldPositionSort(Context ctx, String personId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_PersonPage                         ").append(" set fInnerCode=fInnerCode-1 where fpersonId in ").append(" (select fpersonId from T_HR_PersonPosition     ").append(" where fpersondep=(select fpersondep            ").append("from T_HR_PersonPosition where fpersonId=?))    ").append(" and fInnerCode>                                ").append(" (select fInnerCode from T_HR_PersonPage        ").append(" where fpersonId=?)                             ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId, personId});
        sql.setLength(0);
        sql.append(" update T_HR_PersonPage                         ").append(" set fInnerCode=0 where fpersonId=?            ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
        sql.setLength(0);
        sql.append(" update t_bd_person              ").append(" set findex=findex-1             ").append(" where findex>                   ").append(" (select findex from t_bd_person ").append(" where fid=?)                    ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{personId});
    }

    @Override
    public void _initSort(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_hr_personpage(fid,fpersonid)              ").append(" select newbosid('E668AC89'),fid from t_bd_person        ").append(" where fid not in(select fpersonid from t_hr_personpage) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" select fid from T_ORG_Admin ").append(" order by flongnumber                        ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<Object[]> allPersonList = new ArrayList<Object[]>();
            int allIndex = 1;
            ArrayList<Object[]> personList = new ArrayList<Object[]>();
            while (rs.next()) {
                sql.setLength(0);
                sql.append(" select A.fid from t_bd_person A ").append(" join T_HR_PersonPosition B      ").append(" on A.fid=B.FPersonID            ").append(" where B.fpersondep=?            ").append(" order by A.fbirthday            ");
                IRowSet personRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rs.getString(1)});
                int innerIndex = 1;
                while (personRs.next()) {
                    String personId = personRs.getString(1);
                    personList.add(new Object[]{innerIndex++, personId});
                    allPersonList.add(new Object[]{allIndex++, personId});
                }
            }
            DbUtil.executeBatch((Context)ctx, (String)"update T_HR_PersonPage set finnercode=? where fpersonid=?", personList);
            DbUtil.executeBatch((Context)ctx, (String)"update t_bd_person set findex=? where fid=?", allPersonList);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }
}

