/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.tobacco.IPersonPage;
import com.kingdee.eas.hr.tobacco.PersonPageFactory;
import com.kingdee.eas.hr.tobacco.PersonPageInfo;
import com.kingdee.eas.hr.tobacco.SpecialTechPageInfo;
import com.kingdee.eas.hr.tobacco.TobaccoException;
import com.kingdee.eas.hr.tobacco.WorkerPageFactory;
import com.kingdee.eas.hr.tobacco.app.AbstractSpecialTechPageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class SpecialTechPageControllerBean
extends AbstractSpecialTechPageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.tobacco.app.SpecialTechPageControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateOldValue(ctx, pk, model, false);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateOldValue(ctx, null, model, false);
        return super._addnew(ctx, model);
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateOldValue(ctx, pk, null, true);
        super._delete(ctx, pk);
    }

    private void updateOldValue(Context ctx, IObjectPK pk, IObjectValue model, boolean isDel) throws BOSException, EASBizException {
        SpecialTechPageInfo info = null;
        if (model != null) {
            info = (SpecialTechPageInfo)model;
        }
        if (info == null && pk != null) {
            info = this.getSpecialTechPageInfo(ctx, pk);
        }
        if (info == null || info.getSpecDuty() == null || info.getPerson() == null) {
            return;
        }
        String personId = info.getPerson().getId().toString();
        String curSpecDutyId = info.getSpecDuty().getId().toString();
        if (info.isIsCurrentEmp()) {
            boolean isWorkerPageCurrentEmp = WorkerPageFactory.getLocalInstance(ctx).exists("where person.id='" + personId + "' and isCurrentEmp=1");
            if (isWorkerPageCurrentEmp) {
                throw new TobaccoException(TobaccoException.WORKERPAGE_CURRENT_EXIST);
            }
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_SpecialTechPage SET FIsCurrentEmp=0 WHERE FPersonId=?", (Object[])new Object[]{personId});
            if (isDel) {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPage SET FCurSpecDutyID=null WHERE FPersonID=?", (Object[])new Object[]{personId});
            } else {
                IPersonPage iPersonPage = PersonPageFactory.getLocalInstance(ctx);
                boolean hasPersonPage = iPersonPage.exists("where person.id='" + personId + "'");
                if (hasPersonPage) {
                    DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPage SET FCurSpecDutyID=? WHERE FPersonID=?", (Object[])new Object[]{curSpecDutyId, personId});
                } else {
                    PersonPageInfo personPageInfo = new PersonPageInfo();
                    personPageInfo.setCurSpecDuty(info.getSpecDuty());
                    personPageInfo.setPerson(info.getPerson());
                    iPersonPage.addnew((CoreBaseInfo)personPageInfo);
                }
            }
        } else {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPage SET FCurSpecDutyID=null WHERE FPersonID=? and FCurSpecDutyID=?", (Object[])new Object[]{personId, curSpecDutyId});
        }
        if (info.isIsTopSpecDuty()) {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_SpecialTechPage SET FIsTopSpecDuty=0 WHERE FPersonId=?", (Object[])new Object[]{personId});
            if (isDel) {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_Person SET FHighestTechPostID=null WHERE FID=?", (Object[])new Object[]{personId});
            } else {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_Person SET FHighestTechPostID=? WHERE FID=?", (Object[])new Object[]{curSpecDutyId, personId});
            }
        } else {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_Person SET FHighestTechPostID=null WHERE FID=? and FHighestTechPostID=?", (Object[])new Object[]{personId, curSpecDutyId});
        }
    }
}

