/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.tobacco.IPersonPage;
import com.kingdee.eas.hr.tobacco.PersonPageFactory;
import com.kingdee.eas.hr.tobacco.PersonPageInfo;
import com.kingdee.eas.hr.tobacco.SpecialTechPageFactory;
import com.kingdee.eas.hr.tobacco.TobaccoException;
import com.kingdee.eas.hr.tobacco.WorkerPageInfo;
import com.kingdee.eas.hr.tobacco.app.AbstractWorkerPageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class WorkerPageControllerBean
extends AbstractWorkerPageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.tobacco.app.WorkerPageControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateOldValue(ctx, pk, model, false);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateOldValue(ctx, null, model, false);
        return super._addnew(ctx, model);
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateOldValue(ctx, pk, null, true);
        super._delete(ctx, pk);
    }

    private void updateOldValue(Context ctx, IObjectPK pk, IObjectValue model, boolean isDel) throws BOSException, EASBizException {
        WorkerPageInfo info = null;
        if (model != null) {
            info = (WorkerPageInfo)model;
        }
        if (info == null && pk != null) {
            info = this.getWorkerPageInfo(ctx, pk);
        }
        if (info == null || info.getCertifyCompetency() == null || info.getPerson() == null) {
            return;
        }
        String personId = info.getPerson().getId().toString();
        String curCertifyCompetencyId = info.getCertifyCompetency().getId().toString();
        if (info.isIsCurrentEmp()) {
            boolean isSpecialTechPageCurrentEmp = SpecialTechPageFactory.getLocalInstance(ctx).exists("where person.id='" + personId + "' and isCurrentEmp=1");
            if (isSpecialTechPageCurrentEmp) {
                throw new TobaccoException(TobaccoException.SPECIALTECH_CURRENT_EXIST);
            }
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_WorkerPage SET FIsCurrentEmp=0 WHERE FPersonId=?", (Object[])new Object[]{personId});
            if (isDel) {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPage SET FCurCertifyCompetencyID=null WHERE FPersonID=?", (Object[])new Object[]{personId});
            } else {
                IPersonPage iPersonPage = PersonPageFactory.getLocalInstance(ctx);
                boolean hasPersonPage = iPersonPage.exists("where person.id='" + personId + "'");
                if (hasPersonPage) {
                    DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPage SET FCurCertifyCompetencyID=? WHERE FPersonID=?", (Object[])new Object[]{curCertifyCompetencyId, personId});
                } else {
                    PersonPageInfo personPageInfo = new PersonPageInfo();
                    personPageInfo.setCurCertifyCompetency(info.getCertifyCompetency());
                    personPageInfo.setPerson(info.getPerson());
                    iPersonPage.addnew((CoreBaseInfo)personPageInfo);
                }
            }
        } else {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPage SET FCurCertifyCompetencyID=null WHERE FPersonID=? and FCurCertifyCompetencyID=?", (Object[])new Object[]{personId, curCertifyCompetencyId});
        }
        if (info.isIsHighestCompetency()) {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_WorkerPage SET FIsHighestCompetency=0 WHERE FPersonId=?", (Object[])new Object[]{personId});
            if (isDel) {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_Person SET FHighestCompetencyID=null WHERE FID=?", (Object[])new Object[]{personId});
            } else {
                DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_Person SET FHighestCompetencyID=? WHERE FID=?", (Object[])new Object[]{curCertifyCompetencyId, personId});
            }
        } else {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_Person SET FHighestCompetencyID=null WHERE FID=? and FHighestCompetencyID=?", (Object[])new Object[]{personId, curCertifyCompetencyId});
        }
    }
}

