/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.IRequirement;
import com.kingdee.eas.hr.train.IRequirementFacade;
import com.kingdee.eas.hr.train.IRequirementIssue;
import com.kingdee.eas.hr.train.IRequirementResponse;
import com.kingdee.eas.hr.train.RequirementCourseTypeEnum;
import com.kingdee.eas.hr.train.RequirementEntryCollection;
import com.kingdee.eas.hr.train.RequirementEntryInfo;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueCollection;
import com.kingdee.eas.hr.train.RequirementIssueFactory;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.RequirementResponseCollection;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.ResponseAppointedCourseCollection;
import com.kingdee.eas.hr.train.ResponseAppointedCourseInfo;
import com.kingdee.eas.hr.train.ResponseSuggestCourseCollection;
import com.kingdee.eas.hr.train.ResponseSuggestCourseInfo;
import com.kingdee.eas.hr.train.TrainAssistant;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.web.ResponseCalculateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class RequirementAssistant {
    private static final Logger logger = Logger.getLogger((String)RequirementAssistant.class.getName());

    public static FilterInfo getRequirementResponseFilter(String personId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("receiver.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("issueEntry.state", (Object)new Integer(20)));
        filterInfo.setMaskString("#0 and #1");
        return filterInfo;
    }

    public static RequirementResponseInfo createRequirementResponseInfo(String requirementId, UserInfo userInfo) throws EASBizException, BOSException {
        return RequirementAssistant.createRequirementResponseInfo(null, requirementId, userInfo);
    }

    public static RequirementResponseInfo createRequirementResponseInfo(Context ctx, String requirementId, UserInfo userInfo) throws EASBizException, BOSException {
        RequirementInfo requirementInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Entry.*"));
        sic.add(new SelectorItemInfo("Entry.course.*"));
        sic.add(new SelectorItemInfo("Entry.course.treeid.name"));
        sic.add(new SelectorItemInfo("Entry.trainItem.*"));
        sic.add(new SelectorItemInfo("Entry.trainItem.treeid.name"));
        sic.add(new SelectorItemInfo("Entry.courseType.name"));
        IRequirement iRequirement = null;
        iRequirement = ctx != null ? RequirementFactory.getLocalInstance(ctx) : RequirementFactory.getRemoteInstance();
        requirementInfo = iRequirement.getRequirementInfo((IObjectPK)new ObjectUuidPK(requirementId), sic);
        RequirementResponseInfo info = new RequirementResponseInfo();
        info.setCreator(userInfo);
        info.setRequirement(requirementInfo);
        RequirementEntryCollection requirementEntrys = requirementInfo.getEntry();
        if (requirementEntrys != null && requirementEntrys.size() > 0) {
            ResponseAppointedCourseInfo appointedCourseInfo = null;
            int size = requirementEntrys.size();
            for (int i = 0; i < size; ++i) {
                appointedCourseInfo = new ResponseAppointedCourseInfo();
                appointedCourseInfo.setRequirementEntry(requirementEntrys.get(i));
                appointedCourseInfo.setSeq(i + 1);
                appointedCourseInfo.setHighCount(0);
                appointedCourseInfo.setMiddleCount(1);
                appointedCourseInfo.setLowCount(0);
                info.getAppointedCourse().add(appointedCourseInfo);
            }
        }
        info.setState(RequirementResponseEnum.UN_RESPONSE);
        PersonInfo personInfo = userInfo.getPerson();
        info.setResponser(personInfo);
        AdminOrgUnitInfo orgUnitInfo = null;
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)personInfo)) {
            IPerson iPerson = null;
            iPerson = ctx != null ? PersonFactory.getLocalInstance((Context)ctx) : PersonFactory.getRemoteInstance();
            orgUnitInfo = iPerson.getPrimaryAdminOrgUnit(BOSUuid.read((String)personInfo.getId().toString()));
        }
        info.setAdminOrgUnit(orgUnitInfo);
        return info;
    }

    public static boolean generateResponse(RequirementResponseInfo requirementResponseInfo, String requirementId, Set responserIds) throws BOSException, EASBizException {
        return RequirementAssistant.generateResponse(null, requirementResponseInfo, requirementId, responserIds);
    }

    public static boolean generateResponse(Context ctx, RequirementResponseInfo requirementResponseInfo, String requirementId, Set responserIds) throws BOSException, EASBizException {
        boolean result = false;
        IRequirementFacade iRequirementFacade = null;
        iRequirementFacade = ctx != null ? RequirementFacadeFactory.getLocalInstance(ctx) : RequirementFacadeFactory.getRemoteInstance();
        Map summary = iRequirementFacade.getResponseSummary(requirementId, responserIds);
        if (summary != null && summary.size() > 0) {
            Map suggestCourseCounts;
            result = true;
            Map appointedCourseCounts = (Map)summary.get("appointed");
            if (appointedCourseCounts != null && appointedCourseCounts.size() > 0) {
                ResponseAppointedCourseCollection appointedCourses = requirementResponseInfo.getAppointedCourse();
                ResponseAppointedCourseInfo responseAppointedCourseInfo = null;
                int size = appointedCourses.size();
                for (int i = 0; i < size; ++i) {
                    responseAppointedCourseInfo = appointedCourses.get(i);
                    RequirementAssistant.setCourseCount((IObjectValue)responseAppointedCourseInfo, (Map)appointedCourseCounts.get(responseAppointedCourseInfo.getRequirementEntry().getId().toString()));
                }
            }
            if ((suggestCourseCounts = (Map)summary.get("suggest")) != null && suggestCourseCounts.size() > 0) {
                ResponseSuggestCourseCollection suggestCourses = requirementResponseInfo.getSuggestCourse();
                ResponseSuggestCourseCollection oldsuggestCourses = (ResponseSuggestCourseCollection)((Object)suggestCourses.clone());
                suggestCourses.clear();
                ResponseSuggestCourseInfo responseSuggestCourseInfo = null;
                Object[] keys2 = null;
                for (Object[] keys2 : suggestCourseCounts.keySet()) {
                    responseSuggestCourseInfo = RequirementAssistant.getSuggestCourseInfo(oldsuggestCourses, keys2);
                    if (responseSuggestCourseInfo == null) {
                        responseSuggestCourseInfo = new ResponseSuggestCourseInfo();
                        responseSuggestCourseInfo.setTrainSubject((String)keys2[0]);
                        responseSuggestCourseInfo.setCourseType((TrainCourseTreeInfo)keys2[1]);
                    }
                    RequirementAssistant.setCourseCount((IObjectValue)responseSuggestCourseInfo, (Map)suggestCourseCounts.get(keys2));
                    suggestCourses.add(responseSuggestCourseInfo);
                }
            }
        }
        return result;
    }

    private static void setCourseCount(IObjectValue info, Map counts) {
        Integer count = (Integer)counts.get("highCount");
        info.setInt("highCount", count.intValue());
        count = (Integer)counts.get("middleCount");
        info.setInt("middleCount", count.intValue());
        count = (Integer)counts.get("lowCount");
        info.setInt("lowCount", count.intValue());
    }

    private static ResponseSuggestCourseInfo getSuggestCourseInfo(ResponseSuggestCourseCollection suggestCourses, Object[] keys) {
        ResponseSuggestCourseInfo info = null;
        TrainCourseTreeInfo trainCourseTreeInfo = null;
        int size = suggestCourses.size();
        for (int i = 0; i < size; ++i) {
            info = suggestCourses.get(i);
            if (info == null || !keys[0].equals(info.getTrainSubject()) || TrainCommonUtils.isEmpty((CoreBaseInfo)info.getCourseType())) continue;
            trainCourseTreeInfo = (TrainCourseTreeInfo)keys[1];
            if (!info.getCourseType().getId().equals((Object)trainCourseTreeInfo.getId())) continue;
            return info;
        }
        return null;
    }

    public static RequirementResponseInfo assembleRequirementResponseInfo(HttpServletRequest request) throws ParseException {
        String adminOrgUnitId;
        String responserId;
        String requirementId;
        RequirementResponseInfo responseInfo = new RequirementResponseInfo();
        String id = RequirementAssistant.handleCharacter(request.getParameter("id"));
        if (!TrainCommonUtils.isEmpty(id)) {
            responseInfo.setId(BOSUuid.read((String)id));
        }
        if (!TrainCommonUtils.isEmpty(requirementId = RequirementAssistant.handleCharacter(request.getParameter("requirementId")))) {
            RequirementInfo requirementInfo = new RequirementInfo();
            requirementInfo.setId(BOSUuid.read((String)requirementId));
            responseInfo.setRequirement(requirementInfo);
        }
        if (!TrainCommonUtils.isEmpty(responserId = RequirementAssistant.handleCharacter(request.getParameter("responserId")))) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)responserId));
            responseInfo.setResponser(personInfo);
        }
        if (!TrainCommonUtils.isEmpty(adminOrgUnitId = RequirementAssistant.handleCharacter(request.getParameter("adminOrgUnitId")))) {
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitId));
            responseInfo.setAdminOrgUnit(adminOrgUnitInfo);
        }
        String state = request.getParameter("responsestate");
        RequirementResponseEnum responseState = RequirementResponseEnum.getEnum(Integer.parseInt(state));
        responseInfo.setState(responseState);
        String calculateTime = request.getParameter("calculateTime");
        if (!TrainCommonUtils.isEmpty(calculateTime)) {
            Timestamp time = new Timestamp(DateTimeUtils.parseDate((String)calculateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            responseInfo.setCalculateTime(time);
        }
        int index = 0;
        ResponseAppointedCourseInfo appointedCourseInfo = null;
        RequirementEntryInfo requirementEntryInfo = null;
        while (true) {
            String count;
            appointedCourseInfo = new ResponseAppointedCourseInfo();
            String requirementEntryId = RequirementAssistant.handleCharacter(request.getParameter(RequirementAssistant.getKey("appointedCourse", index, "requirementEntryId")));
            if (TrainCommonUtils.isEmpty(requirementEntryId)) break;
            requirementEntryInfo = new RequirementEntryInfo();
            requirementEntryInfo.setId(BOSUuid.read((String)requirementEntryId));
            appointedCourseInfo.setRequirementEntry(requirementEntryInfo);
            String appointedCourseId = RequirementAssistant.handleCharacter(request.getParameter(RequirementAssistant.getKey("appointedCourse", index, "id")));
            if (!TrainCommonUtils.isEmpty(appointedCourseId)) {
                appointedCourseInfo.setId(BOSUuid.read((String)appointedCourseId));
            }
            appointedCourseInfo.setHighCount(TrainCommonUtils.isEmpty(count = request.getParameter(RequirementAssistant.getKey("appointedCourse", index, "highCount"))) ? 0 : Integer.parseInt(count));
            count = request.getParameter(RequirementAssistant.getKey("appointedCourse", index, "middleCount"));
            appointedCourseInfo.setMiddleCount(TrainCommonUtils.isEmpty(count) ? 0 : Integer.parseInt(count));
            count = request.getParameter(RequirementAssistant.getKey("appointedCourse", index, "lowCount"));
            appointedCourseInfo.setLowCount(TrainCommonUtils.isEmpty(count) ? 0 : Integer.parseInt(count));
            String suggest = request.getParameter(RequirementAssistant.getKey("appointedCourse", index, "suggest"));
            appointedCourseInfo.setSuggest(suggest);
            appointedCourseInfo.put("rowIndex", String.valueOf(index));
            responseInfo.getAppointedCourse().add(appointedCourseInfo);
            ++index;
        }
        int suggestCourseCount = Integer.parseInt(request.getParameter("suggestCourseCount"));
        ResponseSuggestCourseInfo suggestCourseInfo = null;
        TrainCourseTreeInfo courseTypeInfo = null;
        RequirementCourseTypeEnum courseTypeEnum2 = null;
        for (index = 0; index < suggestCourseCount; ++index) {
            String cost;
            String type;
            String courseTypeId;
            String courseName = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "trainSubject"));
            if (TrainCommonUtils.isEmpty(courseName)) continue;
            suggestCourseInfo = new ResponseSuggestCourseInfo();
            suggestCourseInfo.setTrainSubject(courseName);
            String suggestCourseId = RequirementAssistant.handleCharacter(request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "id")));
            if (!TrainCommonUtils.isEmpty(suggestCourseId)) {
                appointedCourseInfo.setId(BOSUuid.read((String)suggestCourseId));
            }
            if (!TrainCommonUtils.isEmpty(courseTypeId = RequirementAssistant.handleCharacter(request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "courseTypeId"))))) {
                courseTypeInfo = new TrainCourseTreeInfo();
                courseTypeInfo.setId(BOSUuid.read((String)courseTypeId));
                suggestCourseInfo.setCourseType(courseTypeInfo);
            }
            if (!TrainCommonUtils.isEmpty(type = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "type")))) {
                List enumList = RequirementCourseTypeEnum.getEnumList();
                for (RequirementCourseTypeEnum courseTypeEnum2 : enumList) {
                    if (!type.equals(courseTypeEnum2.getAlias())) continue;
                    suggestCourseInfo.setType(courseTypeEnum2);
                }
            }
            suggestCourseInfo.setObject(request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "object")));
            suggestCourseInfo.setRemark(request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "remark")));
            String count = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "highCount"));
            suggestCourseInfo.setHighCount(TrainCommonUtils.isEmpty(count) ? 0 : Integer.parseInt(count));
            count = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "middleCount"));
            suggestCourseInfo.setMiddleCount(TrainCommonUtils.isEmpty(count) ? 0 : Integer.parseInt(count));
            count = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "lowCount"));
            suggestCourseInfo.setLowCount(TrainCommonUtils.isEmpty(count) ? 0 : Integer.parseInt(count));
            String startDate = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "startDate"));
            if (!TrainCommonUtils.isEmpty(startDate)) {
                suggestCourseInfo.setStartDate(DateTimeUtils.parseDate((String)startDate, (String)"yyyy-MM-dd"));
            }
            if (!TrainCommonUtils.isEmpty(cost = request.getParameter(RequirementAssistant.getKey("suggestCourse", index, "cost")))) {
                suggestCourseInfo.setCost(new BigDecimal(cost));
            }
            suggestCourseInfo.put("rowIndex", String.valueOf(index));
            responseInfo.getSuggestCourse().add(suggestCourseInfo);
        }
        return responseInfo;
    }

    private static String getKey(String course, int index, String property) {
        StringBuffer sb = new StringBuffer();
        sb.append(course);
        sb.append("[");
        sb.append(index);
        sb.append("].");
        sb.append(property);
        return sb.toString();
    }

    public static String handleCharacter(String source) {
        if (!TrainCommonUtils.isEmpty(source)) {
            source = source.replaceAll(" ", "+");
        }
        return source;
    }

    public static Object responseCalculate(Context ctx, String requirementId, String responserId) {
        Map summary = null;
        try {
            Set responserIds = RequirementFacadeFactory.getLocalInstance(ctx).getRequirementReceivers(requirementId, responserId);
            summary = RequirementFacadeFactory.getLocalInstance(ctx).getResponseSummary(requirementId, responserIds);
        }
        catch (Exception e) {
            logger.info((Object)e.getCause());
        }
        if (summary != null && summary.size() > 0) {
            return RequirementAssistant.assembleResult(summary);
        }
        ResponseCalculateInfo message = new ResponseCalculateInfo();
        String str = ResourceBase.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"RESPONSED_EMPTY", (Locale)ctx.getLocale());
        message.setMessage(MessageFormat.format(str, ResourceBase.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"CALCULATE_TEXT", (Locale)ctx.getLocale())));
        return message;
    }

    private static Object assembleResult(Map summary) {
        ArrayList<Object> list = new ArrayList<Object>();
        Map appointedCourseCounts = (Map)summary.get("appointed");
        ArrayList<Object> appointedList = new ArrayList<Object>();
        if (appointedCourseCounts != null && appointedCourseCounts.size() > 0) {
            Iterator it = appointedCourseCounts.keySet().iterator();
            String key = null;
            while (it.hasNext()) {
                key = (String)it.next();
                appointedList.add(RequirementAssistant.assembleResultElement(key, (Map)appointedCourseCounts.get(key)));
            }
        }
        list.add(appointedList);
        Map suggestCourseCounts = (Map)summary.get("suggest");
        ArrayList<Object> suggestList = new ArrayList<Object>();
        if (suggestCourseCounts != null && suggestCourseCounts.size() > 0) {
            Iterator it = suggestCourseCounts.keySet().iterator();
            Object[] keys = null;
            while (it.hasNext()) {
                keys = (Object[])it.next();
                suggestList.add(RequirementAssistant.assembleResultElement(RequirementAssistant.assembleSuggestCourseKey(keys), (Map)suggestCourseCounts.get(keys)));
            }
        }
        list.add(suggestList);
        list.add(DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return list;
    }

    private static Object assembleSuggestCourseKey(Object[] keys) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(keys[0]);
        ResponseCalculateInfo info = new ResponseCalculateInfo();
        TrainCourseTreeInfo trainCourseTreeInfo = (TrainCourseTreeInfo)keys[1];
        info.setId(trainCourseTreeInfo.getId().toString());
        info.setName(trainCourseTreeInfo.getName());
        list.add(info);
        return list;
    }

    private static Object assembleResultElement(Object key, Map counts) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(key);
        Integer[] array = new Integer[]{(Integer)counts.get("highCount"), (Integer)counts.get("middleCount"), (Integer)counts.get("lowCount")};
        list.add(array);
        return list;
    }

    public static boolean responserIsModified(RequirementResponseInfo responseInfo) {
        return RequirementAssistant.responserIsModified(null, responseInfo);
    }

    public static boolean responserIsModified(Context ctx, RequirementResponseInfo responseInfo) {
        boolean returnValue = false;
        if (responseInfo != null && responseInfo.getCalculateTime() != null) {
            String requirementId = responseInfo.getRequirement().getId().toString();
            String publisherId = responseInfo.getResponser().getId().toString();
            Set receivers = null;
            try {
                IRequirementFacade iRequirementFacade = null;
                iRequirementFacade = ctx == null ? RequirementFacadeFactory.getRemoteInstance() : RequirementFacadeFactory.getLocalInstance(ctx);
                receivers = iRequirementFacade.getRequirementReceivers(requirementId, publisherId);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (receivers != null && receivers.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.getSelector().add(new SelectorItemInfo("id"));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
                filterInfo.getFilterItems().add(new FilterItemInfo("responser.id", (Object)receivers, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("lastUpdateTime", (Object)responseInfo.getCalculateTime(), CompareType.GREATER));
                viewInfo.setFilter(filterInfo);
                try {
                    IRequirementResponse iRequirementResponse = null;
                    iRequirementResponse = ctx == null ? RequirementResponseFactory.getRemoteInstance() : RequirementResponseFactory.getLocalInstance(ctx);
                    RequirementResponseCollection collection = iRequirementResponse.getRequirementResponseCollection(viewInfo);
                    if (collection != null && collection.size() > 0) {
                        returnValue = true;
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return returnValue;
    }

    public static RequirementIssueInfo getRootIssueInfo(String requirementId, Context ctx) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isRoot", (Object)new Integer(1)));
        viewInfo.setFilter(filterInfo);
        IRequirementIssue requirementIssueFactory = null;
        requirementIssueFactory = ctx != null ? RequirementIssueFactory.getLocalInstance(ctx) : RequirementIssueFactory.getRemoteInstance();
        RequirementIssueCollection collection = requirementIssueFactory.getRequirementIssueCollection(viewInfo);
        RequirementIssueInfo info = null;
        if (collection != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static String getIssueId(String requirementId, boolean isCreatorOrSameOrg, Context ctx) throws Exception {
        String requirementIssueId = null;
        if (isCreatorOrSameOrg) {
            RequirementIssueInfo issueInfo = RequirementAssistant.getRootIssueInfo(requirementId, ctx);
            if (!TrainCommonUtils.isEmpty((CoreBaseInfo)issueInfo)) {
                requirementIssueId = issueInfo.getId().toString();
            }
        } else {
            String currentPersonId = TrainAssistant.getCurrentPersonId(ctx);
            requirementIssueId = RequirementAssistant.getIssueId(requirementId, currentPersonId, ctx);
        }
        return requirementIssueId;
    }

    public static String getIssueId(String requirementId, String personId, Context ctx) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("publisher.id", (Object)personId));
        viewInfo.setFilter(filterInfo);
        IRequirementIssue requirementIssueFactory = null;
        requirementIssueFactory = ctx != null ? RequirementIssueFactory.getLocalInstance(ctx) : RequirementIssueFactory.getRemoteInstance();
        RequirementIssueCollection collection = requirementIssueFactory.getRequirementIssueCollection(viewInfo);
        String id = null;
        if (collection != null && collection.size() > 0) {
            id = collection.get(0).getId().toString();
        }
        return id;
    }
}

