/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.SysCateCollection;
import com.kingdee.eas.hr.train.SysCateCourseEntryCollection;
import com.kingdee.eas.hr.train.SysCateCourseEntryFactory;
import com.kingdee.eas.hr.train.SysCateFactory;
import com.kingdee.eas.hr.train.SysCateInfo;
import com.kingdee.eas.hr.train.SysCateJobEntryCollection;
import com.kingdee.eas.hr.train.SysCateJobGradeEntryCollection;
import com.kingdee.eas.hr.train.SysCatePostionEntryCollection;
import com.kingdee.eas.hr.train.SysCateTechPostEntryCollection;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CoursePersonHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.CoursePersonHelper");

    public static Map getCoursePerson(Context ctx, List courseIds, String isRequired) throws BOSException {
        HashMap map = new HashMap();
        Iterator it = courseIds.iterator();
        while (it.hasNext()) {
            map.put(it.next(), new TreeSet());
        }
        logger.info((Object)"\u5f00\u59cb\u4ece\u804c\u5458\u5e94\u4fee\u8bfe\u7a0b\u4e2d\u53d6\u5b66\u5458\uff1a");
        CoursePersonHelper.getPersonsFromEmployeeCourse(ctx, courseIds, isRequired, map);
        logger.info((Object)("getCoursePerson map1:" + map));
        logger.info((Object)"\u5f00\u59cb\u4ece\u57f9\u8bad\u4f53\u7cfb\u4e2d\u53d6\u5b66\u5458\uff1a");
        CoursePersonHelper.getPersonsFromSysCate(ctx, courseIds, isRequired, map);
        logger.info((Object)("getCoursePerson map2:" + map));
        return map;
    }

    public static void getPersonsFromEmployeeCourse(Context ctx, List courseIds, String isRequired, Map map) throws BOSException {
        HashSet<String> courses = new HashSet<String>();
        for (String courseId : courseIds) {
            courses.clear();
            courses.add(courseId);
            logger.info((Object)("getPersonsFromEmployeeCourse courseId:" + courseId));
            CoursePersonHelper.getEmployeeCoursePersons(ctx, courses, isRequired, (Set)map.get(courseId));
            logger.info((Object)("getPersonsFromEmployeeCourse map.get(courseId):" + map.get(courseId)));
        }
    }

    public static void getEmployeeCoursePersons(Context ctx, Set courseIds, String isRequired, Set personIds) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainCourse.id", (Object)courseIds, CompareType.INCLUDE));
        Integer requiredValue = null;
        if ("true".equals(isRequired)) {
            requiredValue = 1;
        }
        if ("false".equals(isRequired)) {
            requiredValue = 0;
        }
        if (requiredValue != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isRequired", (Object)requiredValue));
        }
        FilterInfo hrFilterInfo = TrainUtilsServer.getHROrgUnitAndOrgRangeFilter(ctx, "hrOrgUnit.id", "adminOrgUnit.id");
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            filterInfo.mergeFilter(hrFilterInfo, "AND");
        } else {
            filterInfo = hrFilterInfo;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "EmployeeCoursePersonQuery"));
        iqec.setObjectView(viewInfo);
        logger.info((Object)("getEmployeeCoursePersons sql:" + iqec.getSQL()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        try {
            while (rowSet.next()) {
                personIds.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String buildString(Collection collection) {
        StringBuffer sb = new StringBuffer();
        if (collection != null && collection.size() > 0) {
            int index = 0;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                if (index++ != 0) {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(it.next());
                sb.append("'");
            }
        }
        return sb.toString();
    }

    public static void getPersonsFromSysCate(Context ctx, List courseIds, String isRequired, Map map) throws BOSException {
        HashSet<String> courses = new HashSet<String>();
        for (String courseId : courseIds) {
            courses.clear();
            courses.add(courseId);
            logger.info((Object)("getPersonsFromSysCate courseId:" + courseId));
            logger.info((Object)("getPersonsFromSysCate map.get(courseId)1:" + map.get(courseId)));
            CoursePersonHelper.getSysCatePersons(ctx, courses, isRequired, (Set)map.get(courseId));
            logger.info((Object)("getPersonsFromSysCate map.get(courseId)2:" + map.get(courseId)));
        }
    }

    public static void getSysCatePersons(Context ctx, Set courseIds, String isRequired, Set personIds) throws BOSException {
        SysCateCollection sysCates = CoursePersonHelper.getSysCates(ctx, courseIds, isRequired);
        logger.info((Object)("getSysCatePersons sysCates:" + (Object)((Object)sysCates)));
        if (sysCates != null && sysCates.size() > 0) {
            HashSet<String> positionIds = null;
            HashSet<String> jobIds = null;
            HashSet<String> techIds = null;
            HashSet<String> jobGradeIds = null;
            for (int i = 0; i < sysCates.size(); ++i) {
                SysCateJobGradeEntryCollection jobGradeCol;
                SysCateTechPostEntryCollection techCol;
                SysCateJobEntryCollection jobCol;
                SysCateInfo sysCateInfo = sysCates.get(i);
                SysCatePostionEntryCollection positionCol = sysCateInfo.getPostionEntry();
                if (positionCol != null && positionCol.size() > 0) {
                    if (positionIds == null) {
                        positionIds = new HashSet<String>();
                    }
                    for (int j = 0; j < positionCol.size(); ++j) {
                        positionIds.add(positionCol.get(j).getPosition().getId().toString());
                    }
                }
                if ((jobCol = sysCateInfo.getJobEntry()) != null && jobCol.size() > 0) {
                    if (jobIds == null) {
                        jobIds = new HashSet<String>();
                    }
                    for (int j = 0; j < jobCol.size(); ++j) {
                        jobIds.add(jobCol.get(j).getJob().getId().toString());
                    }
                }
                if ((techCol = sysCateInfo.getTechPostEntry()) != null && techCol.size() > 0) {
                    if (techIds == null) {
                        techIds = new HashSet<String>();
                    }
                    for (int j = 0; j < techCol.size(); ++j) {
                        techIds.add(techCol.get(j).getTechPost().getId().toString());
                    }
                }
                if ((jobGradeCol = sysCateInfo.getJobGrade()) == null || jobGradeCol.size() <= 0) continue;
                if (jobGradeIds == null) {
                    jobGradeIds = new HashSet<String>();
                }
                for (int j = 0; j < jobGradeCol.size(); ++j) {
                    jobGradeIds.add(jobGradeCol.get(j).getJobGrade().getId().toString());
                }
            }
            logger.info((Object)("getSysCatePersons positionIds:" + positionIds));
            logger.info((Object)("getSysCatePersons jobIds:" + jobIds));
            logger.info((Object)("getSysCatePersons techIds:" + techIds));
            logger.info((Object)("getSysCatePersons jobGradeIds:" + jobGradeIds));
            logger.info((Object)("getSysCatePersons personIds1:" + personIds));
            CoursePersonHelper.getPersonBySysCate(ctx, personIds, positionIds, jobIds, techIds, jobGradeIds);
            logger.info((Object)("getSysCatePersons personIds2:" + personIds));
        }
    }

    public static void getPersonBySysCate(Context ctx, Set result, Set positionIds, Set jobIds, Set techIds, Set jobGradeIds) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        if (positionIds != null && positionIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Position.id", (Object)positionIds, CompareType.INCLUDE));
        }
        if (jobIds != null && jobIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)jobIds, CompareType.INCLUDE));
        }
        if (techIds != null && techIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TechnialPost.id", (Object)techIds, CompareType.INCLUDE));
        }
        if (jobGradeIds != null && jobGradeIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("jobGrade.id", (Object)jobGradeIds, CompareType.INCLUDE));
        }
        logger.info((Object)("getPersonBySysCate filterInfo:" + filterInfo));
        logger.info((Object)("getPersonBySysCate FilterUtility.hasFilterItem(filterInfo):" + FilterUtility.hasFilterItem((FilterInfo)filterInfo)));
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                if (i != 0) {
                    str.append(" or ");
                }
                str.append("#");
                str.append(i);
            }
            filterInfo.setMaskString(str.toString());
            String userID = null;
            userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(userID, "AdminOrgUnit.id"));
            viewInfo.setFilter(filterInfo);
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainPersonQuery"));
            iqec.setObjectView(viewInfo);
            logger.info((Object)("getPersonBySysCate sql:" + iqec.getSQL()));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
            try {
                while (rowSet.next()) {
                    result.add(rowSet.getString("id"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static SysCateCollection getSysCates(Context ctx, Set courseIds, String isRequired) throws BOSException {
        SysCateCollection collection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("JobEntry.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("JobEntry.Job.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("PostionEntry.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("PostionEntry.Position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TechPostEntry.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TechPostEntry.TechPost.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("jobGrade.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("jobGrade.jobGrade.id"));
        FilterInfo filterInfo = new FilterInfo();
        Set sysCateIds = CoursePersonHelper.getSysCateCondiction(ctx, courseIds, isRequired);
        if (sysCateIds != null && sysCateIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sysCateIds, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            collection = SysCateFactory.getLocalInstance(ctx).getSysCateCollection(viewInfo);
        }
        return collection;
    }

    public static Set getSysCateCondiction(Context ctx, Set courseIds, String isRequired) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)courseIds, CompareType.INCLUDE));
        if ("true".equals(isRequired)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("IsRequired", (Object)1));
        }
        if ("false".equals(isRequired)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("IsRequired", (Object)0));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        viewInfo.setFilter(filterInfo);
        SysCateCourseEntryCollection collection = SysCateCourseEntryFactory.getLocalInstance(ctx).getSysCateCourseEntryCollection(viewInfo);
        TreeSet<String> result = null;
        if (collection != null && collection.size() > 0) {
            result = new TreeSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                result.add(collection.get(i).getParent().getId().toString());
            }
        }
        return result;
    }

    public static Set assemblePersonIds(List courseIds, Map map) {
        TreeSet<String> personIds = new TreeSet<String>();
        Object[] ids = courseIds.toArray();
        for (String id : (Set)map.get(ids[0])) {
            boolean all = true;
            if (ids.length > 1) {
                for (int i = 1; i < ids.length; ++i) {
                    Set set = (Set)map.get(ids[i]);
                    if (set.contains(id)) continue;
                    all = false;
                    break;
                }
            }
            if (!all) continue;
            personIds.add(id);
        }
        return personIds;
    }

    public static void compareToTrainRecord(Context ctx, List courseIds, Set personIds) throws BOSException {
        logger.info((Object)("compareToTrainRecord courseIds:" + courseIds));
        logger.info((Object)("compareToTrainRecord personIds:" + personIds));
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FEmployeeId from T_HR_TRAINCOURSERECORD where FIsPassed = ");
        sql.append(10);
        sql.append(" and FTrainCourseId in (");
        sql.append(CoursePersonHelper.buildString(courseIds));
        sql.append(")");
        sql.append(" and FHROrgUnitID = '");
        sql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        sql.append("'");
        logger.info((Object)("compareToTrainRecord sql:" + sql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> passedPersonId = new HashSet<String>();
        try {
            while (rowSet.next()) {
                passedPersonId.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("compareToTrainRecord passedPersonId:" + passedPersonId));
        if (passedPersonId.size() > 0) {
            Iterator it = passedPersonId.iterator();
            while (it.hasNext()) {
                personIds.remove(it.next());
            }
        }
    }
}

