/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.CourseKindInfo;
import com.kingdee.eas.hr.train.EmployeeCourseEntryCollection;
import com.kingdee.eas.hr.train.EmployeeCourseEntryInfo;
import com.kingdee.eas.hr.train.EmployeeCourseInfo;
import com.kingdee.eas.hr.train.SysCateInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.app.AbstractEmployeeCourseControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmployeeCourseControllerBean
extends AbstractEmployeeCourseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.EmployeeCourseControllerBean");

    protected IObjectCollection _getCoursesFromSysCate(Context ctx, String employeeId) throws BOSException {
        Set[] positions = this.getPositions(ctx, employeeId);
        Set technicals = this.getTechnicals(ctx, employeeId);
        String jobGradeId = this.getPersonJobGrade(ctx, employeeId);
        IRowSet rowSet = this.getSysCateCourses(ctx, positions, technicals, jobGradeId);
        return this.assembleEmployeeCourseEntrys(rowSet);
    }

    private Set[] getPositions(Context ctx, String employeeId) throws BOSException {
        HashSet[] result = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.job.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        viewInfo.setFilter(filterInfo);
        PositionMemberCollection collection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            result = new HashSet[2];
            HashSet<String> positionIds = new HashSet<String>();
            HashSet<String> jobIds = new HashSet<String>();
            PositionMemberInfo info = null;
            for (int i = 0; i < collection.size(); ++i) {
                info = collection.get(i);
                if (info.getPosition() == null || info.getPosition().getId() == null) continue;
                positionIds.add(info.getPosition().getId().toString());
                if (info.getPosition().getJob() == null || info.getPosition().getJob().getId() == null) continue;
                jobIds.add(info.getPosition().getJob().getId().toString());
            }
            if (positionIds.size() > 0) {
                result[0] = positionIds;
            }
            if (jobIds.size() > 0) {
                result[1] = jobIds;
            }
        }
        return result;
    }

    private Set getTechnicals(Context ctx, String employeeId) throws BOSException {
        HashSet<String> result = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("technicalPost.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isHighTechnical", (Object)1));
        viewInfo.setFilter(filterInfo);
        PersonTechnicalPostCollection collection = PersonTechnicalPostFactory.getLocalInstance((Context)ctx).getPersonTechnicalPostCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            result = new HashSet<String>();
            PersonTechnicalPostInfo info = collection.get(0);
            if (info.getTechnicalPost() != null && info.getTechnicalPost().getId() != null) {
                result.add(info.getTechnicalPost().getId().toString());
            }
        }
        return result;
    }

    private String getPersonJobGrade(Context ctx, String employeeId) throws BOSException {
        PersonPositionInfo personPositionInfo;
        String jobGradeId = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("jobGrade.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        viewInfo.setFilter(filterInfo);
        PersonPositionCollection collection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(viewInfo);
        if (collection.size() > 0 && (personPositionInfo = collection.get(0)).getJobGrade() != null && personPositionInfo.getJobGrade().getId() != null) {
            jobGradeId = personPositionInfo.getJobGrade().getId().toString();
        }
        return jobGradeId;
    }

    private IRowSet getSysCateCourses(Context ctx, Set[] positions, Set technicals, String jobGradeId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("CourseEntry.IsRequired"));
        viewInfo.getSelector().add(new SelectorItemInfo("CourseEntry.trainItem.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("CourseEntry.trainItem.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("trainCourseTree.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("courseKind.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.CourseTarget"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.CourseHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.CourseHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.Content"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.CourseJoinner"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.description"));
        FilterInfo filterInfo = new FilterInfo();
        if (positions != null) {
            if (positions[0] != null && positions[0].size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("PostionEntry.Position.id", (Object)positions[0], CompareType.INCLUDE));
            }
            if (positions[1] != null && positions[1].size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("JobEntry.Job.id", (Object)positions[1], CompareType.INCLUDE));
            }
        }
        if (technicals != null && technicals.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TechPostEntry.TechPost.id", (Object)technicals, CompareType.INCLUDE));
        }
        if (jobGradeId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("JobGrade.id", (Object)jobGradeId, CompareType.EQUALS));
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                if (i != 0) {
                    str.append(" or ");
                }
                str.append("#");
                str.append(i);
            }
            filterInfo.setMaskString(str.toString());
            filterInfo.mergeFilter(TrainUtilsServer.getHRFilterInfo(ctx, "HrOrgUnit.id"), "AND");
        } else {
            filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, "HrOrgUnit.id");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.create((BOSObjectType)new SysCateInfo().getBOSType())));
        }
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(new SorterItemInfo("CourseEntry.trainItem.id"));
        viewInfo.getSorter().add(new SorterItemInfo("TrainCourse.id"));
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "SysCateQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        return rowSet;
    }

    private EmployeeCourseEntryCollection assembleEmployeeCourseEntrys(IRowSet rowSet) throws BOSException {
        EmployeeCourseEntryCollection result = new EmployeeCourseEntryCollection();
        try {
            String trainCourseId = null;
            String trainItemId = null;
            EmployeeCourseEntryInfo entry = null;
            TrainCourseInfo trainCourse = null;
            TrainCourseTreeInfo courseTreeInfo = null;
            CourseKindInfo courseKindInfo = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String courseKindName;
                trainCourseId = rowSet.getString("TrainCourse.id");
                if (trainCourseId == null || trainCourseId.length() == 0) continue;
                entry = new EmployeeCourseEntryInfo();
                trainCourse = new TrainCourseInfo();
                trainCourse.setId(BOSUuid.read((String)trainCourseId));
                trainCourse.setName(rowSet.getString("TrainCourse.name"));
                trainCourse.setNumber(rowSet.getString("TrainCourse.number"));
                String courseTypeName = rowSet.getString("trainCourseTree.name");
                if (courseTypeName != null && courseTypeName.length() > 0) {
                    courseTreeInfo = new TrainCourseTreeInfo();
                    courseTreeInfo.setName(courseTypeName);
                    trainCourse.setTreeid(courseTreeInfo);
                }
                if ((courseKindName = rowSet.getString("courseKind.name")) != null && courseKindName.length() > 0) {
                    courseKindInfo = new CourseKindInfo();
                    courseKindInfo.setName(courseKindName);
                    trainCourse.setCourseKind(courseKindInfo);
                }
                trainCourse.setCourseHour(rowSet.getBigDecimal("TrainCourse.CourseHour"));
                int hourUnit = rowSet.getInt("TrainCourse.CourseHourUnit");
                if (hourUnit > 0) {
                    trainCourse.setCourseHourUnit(CourseHourUnitEnum.getEnum(hourUnit));
                }
                trainCourse.setContent(rowSet.getString("TrainCourse.Content"));
                trainCourse.setCourseTarget(rowSet.getString("TrainCourse.CourseTarget"));
                trainCourse.setCourseJoinner(rowSet.getString("TrainCourse.CourseJoinner"));
                trainCourse.setDescription(rowSet.getString("TrainCourse.description"));
                entry.setCourse(trainCourse);
                trainItemId = rowSet.getString("CourseEntry.trainItem.id");
                TrainItemInfo trainItem = null;
                if (trainItemId != null && trainItemId.length() > 0) {
                    trainItem = new TrainItemInfo();
                    trainItem.setId(BOSUuid.read((String)trainItemId));
                    trainItem.setName(rowSet.getString("CourseEntry.trainItem.name"));
                }
                entry.setTrainItem(trainItem);
                entry.setIsRequired(rowSet.getBoolean("CourseEntry.IsRequired"));
                entry.setFromSysCate(true);
                if (this.isExist(entry, result)) continue;
                result.add(entry);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean isExist(EmployeeCourseEntryInfo entry, EmployeeCourseEntryCollection collection) {
        boolean result = false;
        if (collection != null && collection.size() > 0) {
            String entryItemId = null;
            String infoItemId = null;
            for (int i = 0; i < collection.size(); ++i) {
                EmployeeCourseEntryInfo info = collection.get(i);
                if (!entry.getCourse().getId().toString().equals(info.getCourse().getId().toString())) continue;
                entryItemId = "";
                if (entry.getTrainItem() != null) {
                    entryItemId = entry.getTrainItem().getId().toString();
                }
                infoItemId = "";
                if (info.getTrainItem() != null) {
                    infoItemId = info.getTrainItem().getId().toString();
                }
                if (!entryItemId.equals(infoItemId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("employee.name"));
        sic.add(new SelectorItemInfo("employee.number"));
        EmployeeCourseInfo employeeCourseInfo = (EmployeeCourseInfo)this._getValue(ctx, pk, sic);
        return employeeCourseInfo.getLogInfo();
    }
}

