/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.InstructorTypeFactory;
import com.kingdee.eas.hr.train.InstructorTypeInfo;
import com.kingdee.eas.hr.train.TrainResourceException;
import com.kingdee.eas.hr.train.app.AbstractInstructorTypeControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import org.apache.log4j.Logger;

public class InstructorTypeControllerBean
extends AbstractInstructorTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.InstructorTypeControllerBean");
    private static final String PARENT_ID = "parent";
    private static final String HR_ORG_UNIT = "hrOrgUnit.id";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        return super._submit(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, this.getNoDupNameParentFilter(ctx, model, PARENT_ID))) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    private FilterInfo getNoDupNameParentFilter(Context ctx, IObjectValue model, String parent) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        String strId = null;
        if (dataBaseInfo.get(parent) != null) {
            strId = ((DataBaseInfo)dataBaseInfo.get(parent)).getId().toString();
        }
        String parentId = parent + ".id";
        filter.getFilterItems().add(new FilterItemInfo(parentId, (Object)strId, CompareType.EQUALS));
        FilterInfo cuFilter = this.getFilterForDefaultCU(ctx, model);
        if (FilterUtility.hasFilterItem((FilterInfo)cuFilter)) {
            filter.mergeFilter(cuFilter, "AND");
        }
        return filter;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, this.getNoDupNumberFilter(ctx, model))) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private FilterInfo getNoDupNumberFilter(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo cuFilter;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (FilterUtility.hasFilterItem((FilterInfo)(cuFilter = this.getFilterForDefaultCU(ctx, model)))) {
            filter.mergeFilter(cuFilter, "AND");
        }
        return filter;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            if (ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()))) {
                throw new TrainResourceException(TrainResourceException.CAN_NOT_DELETE_INSTRUCTORTYPE);
            }
            CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)InstructorTypeFactory.getLocalInstance(ctx), InstructorTypeInfo.class.getName());
            super._delete(ctx, pk);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((InstructorTypeInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((InstructorTypeInfo)model));
        return super._addnew(ctx, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, HR_ORG_UNIT);
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            return filterInfo;
        }
        return super.getFilterForDefaultCU(ctx, model);
    }
}

