/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.train.QuestionInquiryFactory;
import com.kingdee.eas.hr.train.TrainResourceException;
import com.kingdee.eas.hr.train.app.AbstractQuertionInquiryTreeControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import org.apache.log4j.Logger;

public class QuertionInquiryTreeControllerBean
extends AbstractQuertionInquiryTreeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.QuertionInquiryTreeControllerBean");
    private static final String HR_ORG_UNIT = "hrOrgUnit.id";
    private static final String PARENT_ID = "parent";

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            if (this.hasOption(ctx, pk)) {
                throw new TrainResourceException(TrainResourceException.CAN_NOT_DEL_INQUIRY);
            }
            super._delete(ctx, pk);
        }
    }

    private boolean hasOption(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean returnValue = false;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)pk.toString()));
        if (QuestionInquiryFactory.getLocalInstance(ctx).exists(filterInfo)) {
            returnValue = true;
        }
        return returnValue;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, TrainUtilsServer.getNoDupNumberHROFilter(ctx, model, HR_ORG_UNIT))) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, TrainUtilsServer.getNoDupNameParentFilter(ctx, model, HR_ORG_UNIT, PARENT_ID))) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }
}

