/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementIssueCollection;
import com.kingdee.eas.hr.train.RequirementIssueEntryCollection;
import com.kingdee.eas.hr.train.RequirementIssueEntryFactory;
import com.kingdee.eas.hr.train.RequirementIssueEntryInfo;
import com.kingdee.eas.hr.train.RequirementIssueFactory;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.app.AbstractRequirementFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementFacadeControllerBean
extends AbstractRequirementFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.RequirementFacadeControllerBean");
    private static final String APPOINTED_COURSE_QUERY = "ResponseAppointedCourseQuery";
    private static final String SUGGEST_COURSE_QUERY = "ResponseSuggestCourseQuery";

    protected Set _getRequirementReceivers(Context ctx, String requirementId, String publisherId) throws BOSException, EASBizException {
        HashSet<String> receivers = null;
        RequirementIssueEntryCollection issueEntrys = this.getPublishedIssueEntrys(ctx, requirementId, publisherId);
        if (issueEntrys != null && issueEntrys.size() > 0) {
            receivers = new HashSet<String>();
            int size = issueEntrys.size();
            for (int i = 0; i < size; ++i) {
                receivers.add(issueEntrys.get(i).getPerson().getId().toString());
            }
        }
        return receivers;
    }

    private RequirementIssueEntryCollection getPublishedIssueEntrys(Context ctx, String requirementId, String publisherId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.publisher.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        if (publisherId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.publisher.id", (Object)publisherId));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        viewInfo.setFilter(filterInfo);
        try {
            return RequirementIssueEntryFactory.getLocalInstance(ctx).getRequirementIssueEntryCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
            return null;
        }
    }

    protected IRowSet _getResponseDetail(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append("t.adminOrgUnitId, ");
            sql.append("t.adminOrgUnitNumber, ");
            sql.append("t.adminOrgUnitLongNumber, ");
            sql.append("t.adminOrgUnitName, ");
            sql.append("t.adminOrgUnitDisplayName, ");
            sql.append("t.responserId, ");
            sql.append("t.responserName, ");
            sql.append("t.positionName, ");
            sql.append("t.type, ");
            sql.append("t.seq, ");
            sql.append("t.contentType, ");
            sql.append("t.contentName, ");
            sql.append("sum(t.highCount) as highCount, ");
            sql.append("sum(t.middleCount) as middleCount, ");
            sql.append("sum(t.lowCount) as lowCount");
            sql.append(" from ");
            sql.append("(");
            sql.append(this.getInnerSQL(ctx, filterInfo, APPOINTED_COURSE_QUERY));
            sql.append(" union ");
            sql.append(this.getInnerSQL(ctx, filterInfo, SUGGEST_COURSE_QUERY));
            sql.append(") as t");
            sql.append(" group by ");
            sql.append("t.adminOrgUnitId, ");
            sql.append("t.adminOrgUnitNumber, ");
            sql.append("t.adminOrgUnitLongNumber, ");
            sql.append("t.adminOrgUnitName, ");
            sql.append("t.adminOrgUnitDisplayName, ");
            sql.append("t.responserId, ");
            sql.append("t.responserName, ");
            sql.append("t.positionName, ");
            sql.append("t.type, ");
            sql.append("t.seq, ");
            sql.append("t.contentType, ");
            sql.append("t.contentName");
            sql.append(" order by t.adminOrgUnitLongNumber,t.responserName, t.type, t.seq");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        return rowSet;
    }

    protected IRowSet _getResponseSummary(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append("t.adminOrgUnitId, ");
            sql.append("t.adminOrgUnitNumber, ");
            sql.append("t.adminOrgUnitLongNumber, ");
            sql.append("t.adminOrgUnitName, ");
            sql.append("t.adminOrgUnitDisplayName, ");
            sql.append("t.type, ");
            sql.append("t.seq, ");
            sql.append("t.contentType, ");
            sql.append("t.contentName, ");
            sql.append("sum(t.highCount) as highCount, ");
            sql.append("sum(t.middleCount) as middleCount, ");
            sql.append("sum(t.lowCount) as lowCount");
            sql.append(" from ");
            sql.append("(");
            sql.append(this.getInnerSQL(ctx, filterInfo, APPOINTED_COURSE_QUERY));
            sql.append(" union ");
            sql.append(this.getInnerSQL(ctx, filterInfo, SUGGEST_COURSE_QUERY));
            sql.append(") as t");
            sql.append(" group by ");
            sql.append("t.adminOrgUnitId, ");
            sql.append("t.adminOrgUnitNumber, ");
            sql.append("t.adminOrgUnitLongNumber, ");
            sql.append("t.adminOrgUnitName, ");
            sql.append("t.adminOrgUnitDisplayName, ");
            sql.append("t.type, ");
            sql.append("t.seq, ");
            sql.append("t.contentType, ");
            sql.append("t.contentName");
            sql.append(" order by t.adminOrgUnitLongNumber, t.type, t.seq");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        return rowSet;
    }

    private String getInnerSQL(Context ctx, FilterInfo filterInfo, String queryName) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        exec.setObjectView(viewInfo);
        return exec.getSQL();
    }

    protected Map _getResponseSummary(Context ctx, String requirementId, Set responserIds) throws BOSException, EASBizException {
        HashMap summary = null;
        if (requirementId != null && responserIds != null && !responserIds.isEmpty()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("requirementId", (Object)requirementId));
            filterInfo.getFilterItems().add(new FilterItemInfo("responserId", (Object)responserIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
            viewInfo.setFilter(filterInfo);
            try {
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "ResponseAppointedCourseSummaryQuery");
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
                exec.setObjectView(viewInfo);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL());
                if (rowSet.size() > 0) {
                    summary = new HashMap();
                    HashMap<String, Map> appointedCourses = new HashMap<String, Map>();
                    summary.put("appointed", appointedCourses);
                    String key = null;
                    while (rowSet.next()) {
                        key = rowSet.getString("requirementEntry.id");
                        appointedCourses.put(key, this.assembleCountMap(rowSet));
                    }
                }
                queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "ResponseSuggestCourseSummaryQuery");
                exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
                exec.setObjectView(viewInfo);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL());
                if (rowSet.size() > 0) {
                    if (summary == null) {
                        summary = new HashMap();
                    }
                    HashMap<Object[], Map> suggestCourses = new HashMap<Object[], Map>();
                    summary.put("suggest", suggestCourses);
                    Object[] keys = null;
                    TrainCourseTreeInfo trainCourseTreeInfo = null;
                    while (rowSet.next()) {
                        keys = new Object[2];
                        keys[0] = rowSet.getString("trainSubject");
                        trainCourseTreeInfo = new TrainCourseTreeInfo();
                        trainCourseTreeInfo.setId(BOSUuid.read((String)rowSet.getString("courseTypeId")));
                        trainCourseTreeInfo.setName(rowSet.getString("courseTypeName"));
                        keys[1] = trainCourseTreeInfo;
                        suggestCourses.put(keys, this.assembleCountMap(rowSet));
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return summary;
    }

    private Map assembleCountMap(IRowSet rowSet) throws SQLException {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("highCount", rowSet.getInt("highCount"));
        counts.put("middleCount", rowSet.getInt("middleCount"));
        counts.put("lowCount", rowSet.getInt("lowCount"));
        return counts;
    }

    protected List _getRequirementByResponser(Context ctx, String responserId, int start, int pageCount) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "RequirementResponseListQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(RequirementAssistant.getRequirementResponseFilter(responserId));
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery(start, pageCount);
        try {
            return this.assembleList(rowSet, exec.getRowCount());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List assembleList(IRowSet rowSet, int rowCount) throws SQLException {
        ArrayList<Object> list = null;
        if (rowSet == null) {
            return list;
        }
        list = new ArrayList<Object>();
        list.add(String.valueOf(rowCount));
        int columnCount = 9;
        String[] strs = null;
        while (rowSet.next()) {
            strs = new String[columnCount];
            int index = 0;
            strs[index++] = rowSet.getString("id");
            strs[index++] = rowSet.getString("requirementResponse.id");
            strs[index++] = rowSet.getString("state");
            strs[index++] = rowSet.getString("number");
            strs[index++] = rowSet.getString("name");
            strs[index++] = rowSet.getString("adminOrgUnit.displayName");
            strs[index++] = rowSet.getString("requirementResponse.state");
            strs[index++] = DateTimeUtils.format((Date)rowSet.getDate("startDate"), (String)"yyyy-MM-dd");
            strs[index++] = DateTimeUtils.format((Date)rowSet.getDate("endDate"), (String)"yyyy-MM-dd");
            list.add(strs);
        }
        return list;
    }

    protected boolean _isAsPublisher(Context ctx, String requirementId, String personId) throws BOSException, EASBizException {
        boolean isPublisher = false;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("parent.isRoot"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.publisher.id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.publisher.id", (Object)personId));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
            viewInfo.setFilter(filterInfo);
            RequirementIssueEntryCollection entrys = RequirementIssueEntryFactory.getLocalInstance(ctx).getRequirementIssueEntryCollection(viewInfo);
            if (entrys != null && entrys.size() > 0) {
                RequirementIssueEntryInfo info = entrys.get(0);
                isPublisher = !info.getParent().isIsRoot();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
        }
        return isPublisher;
    }

    protected Set _getRequirementAllResponsers(Context ctx, String requirementId, String publisherId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("isRoot"));
        viewInfo.getSelector().add(new SelectorItemInfo("publisher.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.state"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        viewInfo.setFilter(filterInfo);
        FilterInfo entryFilter = new FilterInfo(EntryFilterType.NORMAL);
        entryFilter.setEntryName("entry");
        entryFilter.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        viewInfo.getEntryFilters().add(entryFilter);
        RequirementIssueCollection issueInfos = RequirementIssueFactory.getLocalInstance(ctx).getRequirementIssueCollection(viewInfo);
        HashSet receiverIds = null;
        if (issueInfos != null && issueInfos.size() > 0) {
            HashMap<String, RequirementIssueInfo> publisherMap = new HashMap<String, RequirementIssueInfo>();
            int size = issueInfos.size();
            for (int i = 0; i < size; ++i) {
                publisherMap.put(issueInfos.get(i).getPublisher().getId().toString(), issueInfos.get(i));
            }
            receiverIds = new HashSet();
            RequirementIssueInfo info = (RequirementIssueInfo)publisherMap.get(publisherId);
            if (info != null) {
                this.handleReceiver(info, publisherMap, receiverIds);
                logger.info((Object)("_getRequirementAllResponsers  info:" + info));
                logger.info((Object)("_getRequirementAllResponsers  publisherMap:" + publisherMap));
            }
        }
        return receiverIds;
    }

    private void handleReceiver(RequirementIssueInfo info, Map publisherMap, Set receiverIds) {
        logger.info((Object)("handleReceiver info" + info));
        String personId = null;
        RequirementIssueEntryCollection entrys = info.getEntry();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            if (entrys.get(i).getPerson() == null) continue;
            personId = entrys.get(i).getPerson().getId().toString();
            receiverIds.add(personId);
            info = (RequirementIssueInfo)publisherMap.get(personId);
            publisherMap.remove(personId);
            logger.info((Object)("personId" + personId));
            logger.info((Object)("publisherMap.get(personId) info" + info));
            if (info == null || info.isIsRoot()) continue;
            this.handleReceiver(info, publisherMap, receiverIds);
        }
    }
}

