/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.IRequirement;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueEntryCollection;
import com.kingdee.eas.hr.train.RequirementIssueEntryFactory;
import com.kingdee.eas.hr.train.RequirementIssueEntryInfo;
import com.kingdee.eas.hr.train.RequirementIssueException;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.app.AbstractRequirementIssueControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequirementIssueControllerBean
extends AbstractRequirementIssueControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.RequirementIssueControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private static final String ROOT = "root";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkPublishCondition(ctx, model);
        this.handleEntrys(ctx, model);
        RequirementIssueInfo info = (RequirementIssueInfo)model;
        info.setCloseDate(DateTimeUtils.truncateDate((Date)info.getCloseDate()));
        return super._submit(ctx, model);
    }

    private void checkPublishCondition(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementIssueInfo issueInfo = (RequirementIssueInfo)model;
        RequirementIssueEntryCollection entrys = issueInfo.getEntry();
        if (entrys.size() <= 0) {
            return;
        }
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < entrys.size(); ++i) {
            personIds.add(entrys.get(i).getPerson().getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("parent.publisher.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.requirement.id", (Object)issueInfo.getRequirement().getId().toString()));
        if (issueInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)issueInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filterInfo);
        RequirementIssueEntryCollection existRecords = RequirementIssueEntryFactory.getLocalInstance(ctx).getRequirementIssueEntryCollection(viewInfo);
        if (existRecords != null && existRecords.size() > 0) {
            Set deletedReceiverIds;
            String requirementId = issueInfo.getRequirement().getId().toString();
            RequirementIssueEntryCollection allReceiverRecords = this.getPublishRang(ctx, requirementId);
            Map publisherReceiverMap = this.assemblePublisherReceiverMap(allReceiverRecords);
            RequirementIssueEntryCollection realRepeatedRecords = this.getRealRepeatedRecords(existRecords, publisherReceiverMap, deletedReceiverIds = this.getIssueDeletedReceiverIds(ctx, issueInfo, personIds));
            if (realRepeatedRecords != null && realRepeatedRecords.size() > 0) {
                throw new RequirementIssueException(RequirementIssueException.DUPLICATE_PUBLISHOBJECT_SUBMIT, new Object[]{this.assembleErrorMessage(ctx, realRepeatedRecords)});
            }
            this.deleteIssueEntrys(ctx, existRecords);
        }
    }

    private RequirementIssueEntryCollection getPublishRang(Context ctx, String requirementId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("parent.publisher.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.isRoot"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        viewInfo.setFilter(filterInfo);
        return RequirementIssueEntryFactory.getLocalInstance(ctx).getRequirementIssueEntryCollection(viewInfo);
    }

    private Map assemblePublisherReceiverMap(RequirementIssueEntryCollection collection) {
        HashMap<String, String> map = null;
        if (collection != null && collection.size() > 0) {
            map = new HashMap<String, String>();
            RequirementIssueEntryInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                map.put(info.getPerson().getId().toString(), info.getParent().getPublisher().getId().toString());
                if (!info.getParent().isIsRoot()) continue;
                map.put(ROOT, info.getParent().getPublisher().getId().toString());
            }
        }
        return map;
    }

    private Set getIssueDeletedReceiverIds(Context ctx, RequirementIssueInfo issueInfo, Set personIds) throws EASBizException, BOSException {
        HashSet<String> deletedReceiverIds = null;
        if (issueInfo.getId() != null) {
            deletedReceiverIds = new HashSet<String>();
            RequirementIssueInfo dbInfo = this.getRequirementIssueInfo(ctx, (IObjectPK)new ObjectUuidPK(issueInfo.getId().toString()));
            RequirementIssueEntryCollection collection = dbInfo.getEntry();
            String id = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                id = collection.get(i).getPerson().getId().toString();
                if (personIds.contains(id)) continue;
                deletedReceiverIds.add(id);
            }
        }
        return deletedReceiverIds;
    }

    private RequirementIssueEntryCollection getRealRepeatedRecords(RequirementIssueEntryCollection existRecords, Map publisherReceiverMap, Set deletedReceiverIds) {
        RequirementIssueEntryCollection realRepeated = null;
        RequirementIssueEntryInfo entry = null;
        int size = existRecords.size();
        for (int i = 0; i < size; ++i) {
            entry = existRecords.get(i);
            if (this.isDiscarded(entry.getPerson().getId().toString(), publisherReceiverMap) || deletedReceiverIds != null && deletedReceiverIds.contains(entry.getParent().getPublisher().getId().toString())) continue;
            if (realRepeated == null) {
                realRepeated = new RequirementIssueEntryCollection();
            }
            realRepeated.add(entry);
        }
        return realRepeated;
    }

    private boolean isDiscarded(String receiverId, Map publisherReceiverMap) {
        String publisherId = (String)publisherReceiverMap.get(receiverId);
        String rootPublisherId = (String)publisherReceiverMap.get(ROOT);
        if (TrainCommonUtils.isEmpty(publisherId)) {
            return true;
        }
        if (publisherId.equals(rootPublisherId)) {
            return false;
        }
        return this.isDiscarded(publisherId, publisherReceiverMap);
    }

    private void deleteIssueEntrys(Context ctx, RequirementIssueEntryCollection existRecords) throws EASBizException, BOSException {
        if (existRecords == null || existRecords.size() == 0) {
            return;
        }
        IObjectPK[] pks = new IObjectPK[existRecords.size()];
        int size = existRecords.size();
        for (int i = 0; i < size; ++i) {
            pks[i] = new ObjectUuidPK(existRecords.get(i).getId().toString());
        }
        RequirementIssueEntryFactory.getLocalInstance(ctx).delete(pks);
    }

    private String assembleErrorMessage(Context ctx, RequirementIssueEntryCollection existRecords) {
        StringBuffer message = new StringBuffer();
        Locale locale = ctx.getLocale();
        String str = ResourceBase.getString((String)RESOURCE, (String)"ERROR_MESSAGE", (Locale)locale);
        String split = ResourceBase.getString((String)RESOURCE, (String)"SPLIT", (Locale)locale);
        String comma = ResourceBase.getString((String)RESOURCE, (String)"COMMA", (Locale)locale);
        if (existRecords != null && existRecords.size() > 0) {
            String publisher = null;
            String objects = null;
            String value = null;
            HashMap<String, String> map = new HashMap<String, String>();
            int size = existRecords.size();
            for (int i = 0; i < size; ++i) {
                publisher = existRecords.get(i).getParent().getPublisher().getName();
                value = (String)map.get(publisher);
                value = value == null ? existRecords.get(i).getPerson().getName() : value + split + existRecords.get(i).getPerson().getName();
                map.put(publisher, value);
            }
            int index = 0;
            Object[] arguments = null;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                if (index++ != 0) {
                    message.append(comma);
                }
                Map.Entry entry = it.next();
                publisher = (String)entry.getKey();
                objects = (String)map.get(publisher);
                arguments = new Object[]{objects, publisher};
                message.append(MessageFormat.format(str, arguments));
            }
        }
        return message.toString();
    }

    private void handleEntrys(Context ctx, IObjectValue model) {
        RequirementIssueInfo issueInfo = (RequirementIssueInfo)model;
        RequirementIssueEntryCollection entrys = issueInfo.getEntry();
        if (entrys.size() <= 0) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            RequirementIssueEntryInfo entry = entrys.get(i);
            if (entry.getId() != null) continue;
            entry.setRequirement(issueInfo.getRequirement());
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("requirement.name"));
        sic.add(new SelectorItemInfo("publisher.name"));
        RequirementIssueInfo issueInfo = (RequirementIssueInfo)this._getValue(ctx, pk, sic);
        return issueInfo.getLogInfo();
    }

    protected IObjectPK _publish(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementIssueInfo requirementIssueInfo = (RequirementIssueInfo)model;
        RequirementInfo requirementInfo = requirementIssueInfo.getRequirement();
        SelectorItemCollection sic = new SelectorItemCollection();
        if (!requirementIssueInfo.isIsRoot()) {
            String requirementId = requirementInfo.getId().toString();
            String publisherId = requirementIssueInfo.getPublisher().getId().toString();
            sic.add(new SelectorItemInfo("state"));
            RequirementResponseInfo responseInfo = RequirementResponseFactory.getLocalInstance(ctx).getRequirementResponseInfo(requirementId, publisherId, sic);
            if (responseInfo != null && RequirementResponseEnum.RESPONSED.equals((Object)responseInfo.getState())) {
                throw new RequirementIssueException(RequirementIssueException.RESPONSE_COMPLATED);
            }
        }
        boolean responseEndDateModified = false;
        if (requirementIssueInfo.getId() != null) {
            sic.clear();
            sic.add(new SelectorItemInfo("closeDate"));
            RequirementIssueInfo dbInfo = this.getRequirementIssueInfo(ctx, (IObjectPK)new ObjectUuidPK(requirementIssueInfo.getId().toString()), sic);
            if (!dbInfo.getCloseDate().equals(requirementIssueInfo.getCloseDate())) {
                responseEndDateModified = true;
            }
        }
        RequirementIssueEntryCollection entrys = requirementIssueInfo.getEntry();
        RequirementIssueEntryInfo entryInfo = null;
        ArrayList<String> receiveIds = new ArrayList<String>();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entrys.get(i);
            if (responseEndDateModified) {
                receiveIds.add(entryInfo.getPerson().getId().toString());
            } else if (!RequirementStateEnum.PUBLISHED.equals((Object)entryInfo.getState())) {
                receiveIds.add(entryInfo.getPerson().getId().toString());
            }
            entryInfo.setState(RequirementStateEnum.PUBLISHED);
        }
        IObjectPK pk = null;
        try {
            if (receiveIds.size() > 0) {
                requirementIssueInfo.setPublishDate(new Date());
            }
            pk = this._submit(ctx, (IObjectValue)requirementIssueInfo);
        }
        catch (RequirementIssueException e) {
            throw new RequirementIssueException(RequirementIssueException.PUBLISH_FAIL, new Object[]{e.getMessage(ctx.getLocale())});
        }
        if (receiveIds.size() > 0) {
            HashMap<String, String> messageMap = new HashMap<String, String>();
            String str = ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_TITLE", (Locale)ctx.getLocale());
            String title = MessageFormat.format(str, requirementInfo.getName());
            str = ResourceBase.getString((String)RESOURCE, (String)"MESSAGE_CONTENT", (Locale)ctx.getLocale());
            String closeDate = DateTimeUtils.format((Date)requirementIssueInfo.getCloseDate(), (String)"yyyy-MM-dd");
            String content = MessageFormat.format(str, requirementInfo.getName(), closeDate);
            messageMap.put("title", title);
            messageMap.put("sender", requirementIssueInfo.getPublisher().getName());
            messageMap.put("body", content);
            TrainActivityFacadeFactory.getLocalInstance(ctx).sendMessage(receiveIds, messageMap);
        }
        ObjectUuidPK requirementPK = new ObjectUuidPK(requirementInfo.getId().toString());
        sic.clear();
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        IRequirement iRequirement = RequirementFactory.getLocalInstance(ctx);
        requirementInfo = iRequirement.getRequirementInfo((IObjectPK)requirementPK, sic);
        if (RequirementStateEnum.UN_PUBLISH.equals((Object)requirementInfo.getState())) {
            requirementInfo.setState(RequirementStateEnum.PUBLISHED);
            iRequirement.update((IObjectPK)requirementPK, (CoreBaseInfo)requirementInfo);
        }
        return pk;
    }
}

