/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.AbstractTrainActivityInfo;
import com.kingdee.eas.hr.train.EquipmentByTrainActFactory;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActDeptStudentFactory;
import com.kingdee.eas.hr.train.TrainActParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainActivityException;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainActivityMessageFactory;
import com.kingdee.eas.hr.train.TrainActivityOrganigerFactory;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseCostFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.app.AbstractTrainActivityControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TrainActivityControllerBean
extends AbstractTrainActivityControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainActivityControllerBean");
    private static final String IS_NEED_WORKFLOW = "IS_NEED_WORK_FLOW_AUDITED";
    private static final String TABLE_NAME = " T_HR_TrainActivity ";

    protected void _delete(Context ctx, IObjectPK trainActivityId) throws BOSException, EASBizException {
        if (trainActivityId == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityId.toString()));
        EquipmentByTrainActFactory.getLocalInstance(ctx).delete(fi);
        TrainActParticipantScopeFactory.getLocalInstance(ctx).delete(fi);
        TrainActivityMessageFactory.getLocalInstance(ctx).delete(fi);
        TrainActivityOrganigerFactory.getLocalInstance(ctx).delete(fi);
        TrainActDeptStudentFactory.getLocalInstance(ctx).delete(fi);
        if (ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)trainActivityId.toString()))) {
            throw new TrainActivityException(TrainActivityException.CANNOT_DEL_TRAINACTIVITY);
        }
        CodingRuleServerHelper.recycleNumber(ctx, trainActivityId, (ICoreBase)TrainActivityFactory.getLocalInstance(ctx), TrainActivityInfo.class.getName());
        super._delete(ctx, trainActivityId);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainActivityInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainActivityInfo)model));
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model, boolean isDelete) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        AbstractTrainActivityInfo formerInfo = null;
        TrainActivityInfo info = (TrainActivityInfo)model;
        if (info.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("planActivity.id"));
            sic.add(new SelectorItemInfo("trainExePriod.id"));
            sic.add(new SelectorItemInfo("trainItem.id"));
            formerInfo = this.getTrainActivityInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), sic);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (isDelete && formerInfo != null && info.getPlanActivity() != null && !info.getPlanActivity().getId().toString().equals(formerInfo.getPlanActivity().getId().toString())) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)pk.toString()));
            TrainStudentCourseFactory.getLocalInstance(ctx).delete(filterInfo);
            TrainCourseCostFactory.getLocalInstance(ctx).delete(filterInfo);
            filterInfo.getFilterItems().clear();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)pk.toString()));
            TrainActCourseFactory.getLocalInstance(ctx).delete(filterInfo);
            TrainStudentFactory.getLocalInstance(ctx).delete(filterInfo);
        }
        boolean planOrExePeriodChange = false;
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getPlanActivity())) {
            if (formerInfo == null) {
                planOrExePeriodChange = true;
            } else if (TrainCommonUtils.isEmpty((CoreBaseInfo)formerInfo.getPlanActivity()) || !info.getPlanActivity().getId().equals((Object)formerInfo.getPlanActivity().getId())) {
                planOrExePeriodChange = true;
            } else if (!(TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainExePriod()) || !TrainCommonUtils.isEmpty((CoreBaseInfo)formerInfo.getTrainExePriod()) && info.getTrainExePriod().getId().equals((Object)formerInfo.getTrainExePriod().getId()))) {
                planOrExePeriodChange = true;
            }
        }
        if (planOrExePeriodChange) {
            TrainActivityFacadeFactory.getLocalInstance(ctx).createTrainActivity(info.getPlanActivity().getId().toString(), pk.toString());
        }
        if (TrainCommonUtils.isEmpty((CoreBaseInfo)info.getPlanActivity()) && !TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainItem()) && (formerInfo == null || TrainCommonUtils.isEmpty((CoreBaseInfo)formerInfo.getTrainItem()) || !info.getTrainItem().getId().equals((Object)formerInfo.getTrainItem().getId()))) {
            TrainActivityFacadeFactory.getLocalInstance(ctx).createTrainActCourse(info.getTrainItem().getId().toString(), pk.toString());
        }
        return pk;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainActivityInfo info = (TrainActivityInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filter.getFilterItems().add(new FilterItemInfo("belongOrgUnit.id", (Object)info.getBelongOrgUnit().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            throw new TrainActivityException(TrainActivityException.NAME_DUP_ORG_EXCEPTION);
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filter;
    }

    protected void _deleteForPlanActivity(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        if (trainActivityId == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActivityId.toString()));
        TrainCourseCostFactory.getLocalInstance(ctx).delete(fi);
        fi.getFilterItems().clear();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId.toString()));
        TrainActCourseFactory.getLocalInstance(ctx).delete(fi);
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(trainActivityId));
    }

    protected boolean _isNeedWorkFlow(Context ctx) throws BOSException, EASBizException {
        String hrID;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String value = iParam.getParamValue((IObjectPK)new ObjectUuidPK(hrID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()), IS_NEED_WORKFLOW);
        return !"false".equals(value);
    }

    protected void _setAuditPass(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.PASS);
        TrainActivityFacadeFactory.getLocalInstance(ctx).auditTrainActivity(id.toString());
    }

    protected void _setAudited(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.AUDITING);
    }

    protected void _setAuditing(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.AUDITING);
    }

    protected void _setDeniedAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.UNPASS);
    }

    protected void _setNotAudited(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.UNAUDITED);
    }

    protected void _setUnSubmit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.UNSUBMIT);
    }

    private void setAuditState(Context ctx, BOSUuid id, TrainAuditStateEnum state) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainActivity SET FAuditState = ? , FAuditorID = ?  WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, state.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)id.toString());
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

