/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MAGroupEntryCollection;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.NewEmployeeCollection;
import com.kingdee.eas.hr.train.ITrainActOrgsScope;
import com.kingdee.eas.hr.train.ITrainActivity;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActDeptStudentFactory;
import com.kingdee.eas.hr.train.TrainActOrgsScopeCollection;
import com.kingdee.eas.hr.train.TrainActOrgsScopeFactory;
import com.kingdee.eas.hr.train.TrainActOrgsScopeInfo;
import com.kingdee.eas.hr.train.TrainActParticipantScopeCollection;
import com.kingdee.eas.hr.train.TrainActParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityException;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainActivityMessageCollection;
import com.kingdee.eas.hr.train.TrainActivityMessageFactory;
import com.kingdee.eas.hr.train.TrainActivityMessageInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseCostCollection;
import com.kingdee.eas.hr.train.TrainCourseCostFactory;
import com.kingdee.eas.hr.train.TrainCourseCostInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainExePeriodFactory;
import com.kingdee.eas.hr.train.TrainExePeriodInfo;
import com.kingdee.eas.hr.train.TrainItemCourseCollection;
import com.kingdee.eas.hr.train.TrainItemCourseFactory;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanCourseCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseFactory;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanCourseTrainPlanCourseCostCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseTrainPlanCourseCostInfo;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.TrainStudentInfo;
import com.kingdee.eas.hr.train.TrainStudentTypeEnum;
import com.kingdee.eas.hr.train.app.AbstractTrainActivityFacadeControllerBean;
import com.kingdee.eas.hr.train.app.CoursePersonHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainActivityFacadeControllerBean
extends AbstractTrainActivityFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainActivityFacadeControllerBean");

    protected void _sendMessage(Context ctx, String trainActivityId) throws BOSException, EASBizException {
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    protected void _sendMessage(Context ctx, List idList, Map messageMap) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = TrainActivityFacadeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        BOSUuid[] userIds = null;
        logger.info((Object)("_sendMessage  idList:" + idList));
        userIds = this.getUsersByPerson(ctx, idList);
        if (userIds != null) {
            int length = userIds.length;
            for (int j = 0; j < length; ++j) {
                if (userIds[j] == null) continue;
                Message message = MessageFactory.newMessage((String)"kingdee.workflow");
                message.setIntHeader("type", 0);
                message.setIntHeader("bizType", 0);
                message.setIntHeader("sourceStatus", 0);
                message.setIntHeader("priority", 10);
                message.setStringHeader("databaseCenter", ctx.getAIS());
                message.setStringHeader("solution", ctx.getSolution());
                for (Locale locale2 : lcla) {
                    message.setLocaleStringHeader("title", (String)messageMap.get("title"), locale2);
                    message.setLocaleStringHeader("sender", (String)messageMap.get("sender"), locale2);
                    message.setLocaleStringHeader("body", (String)messageMap.get("body"), locale2);
                }
                message.setStringHeader("receiver", userIds[j].toString());
                senderAgent.sendMessage(message);
            }
        }
    }

    private BOSUuid[] getUsersByPerson(Context ctx, List idList) throws BOSException, EASBizException {
        HashSet idSet = new HashSet(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        BOSUuid[] userIDs = null;
        UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection(evi);
        logger.info((Object)("getUsersByPerson users :" + users));
        if (users.size() > 0) {
            userIDs = new BOSUuid[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                userIDs[i] = users.get(i).getId();
            }
        }
        return userIDs;
    }

    private BOSUuid[] getUsersByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        BOSUuid[] userIDs = null;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection users = iUser.getCollection("where person='" + personId + "'");
        if (users.size() > 0) {
            userIDs = new BOSUuid[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                userIDs[i] = users.get(i).getId();
            }
        }
        return userIDs;
    }

    protected Map _getCostAndStudentAmoutMap(Context ctx, String trainActCourseId) throws BOSException, EASBizException {
        HashMap<String, Number> map = new HashMap<String, Number>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        TrainStudentCourseCollection trainStudentCourseCollection = TrainStudentCourseFactory.getLocalInstance(ctx).getTrainStudentCourseCollection(evi);
        int studentCount = 0;
        if (trainStudentCourseCollection != null) {
            studentCount = trainStudentCourseCollection.size();
        }
        map.put("StudentCount", studentCount);
        evi.getSelector().add(new SelectorItemInfo("cost"));
        TrainCourseCostCollection coll = TrainCourseCostFactory.getLocalInstance(ctx).getTrainCourseCostCollection(evi);
        TrainCourseCostInfo info = null;
        BigDecimal totalCost = new BigDecimal("0.00");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getCost() == null) continue;
            totalCost = totalCost.add(info.getCost());
        }
        map.put("CourseCost", totalCost);
        return map;
    }

    protected void _referPlanCourse(Context ctx, Set trainPlanCourseIdSet, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)trainPlanCourseIdSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("StartDate"));
        evi.getSelector().add(new SelectorItemInfo("EndDate"));
        evi.getSelector().add(new SelectorItemInfo("LessonHour"));
        evi.getSelector().add(new SelectorItemInfo("timeUnit"));
        evi.getSelector().add(new SelectorItemInfo("TrainAddress"));
        evi.getSelector().add(new SelectorItemInfo("Cost"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainingMethod.id"));
        evi.getSelector().add(new SelectorItemInfo("chanelCours.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainPlanCourseCost.ChargeStand"));
        evi.getSelector().add(new SelectorItemInfo("TrainPlanCourseCost.Count"));
        evi.getSelector().add(new SelectorItemInfo("TrainPlanCourseCost.TotalCost"));
        evi.getSelector().add(new SelectorItemInfo("TrainPlanCourseCost.Remark"));
        evi.getSelector().add(new SelectorItemInfo("TrainPlanCourseCost.ChargeItem.id"));
        evi.getSelector().add(new SelectorItemInfo("chanelE1.id"));
        TrainPlanCourseCollection coll = TrainPlanCourseFactory.getLocalInstance(ctx).getTrainPlanCourseCollection(evi);
        TrainActCourseCollection actCourseColl = this.getTrainActCourseCollection(ctx, trainActivityId);
        HashSet<String> existIDSet = new HashSet<String>();
        int size = actCourseColl.size();
        for (int i = 0; i < size; ++i) {
            existIDSet.add(actCourseColl.get(i).getTrainCourse().getId().toString());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_HR_TrainActCourse (FID, FControlUnitID, FStartDate, FEndDate, FCourseHour, FCourseHourUnit, FTotalCost, FTrainCourseID, FTrainingMethodID, FChannelCourseID, FTrainActivityID,FCourseState) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String id = null;
            TrainPlanCourseInfo info = null;
            HashMap<String, String> idMap = new HashMap<String, String>();
            int size2 = coll.size();
            for (int i = 0; i < size2; ++i) {
                info = (TrainPlanCourseInfo)coll.getObject(i);
                if (info.getTrainCourse() == null || existIDSet.contains(info.getTrainCourse().getId().toString())) continue;
                id = BOSUuid.create((BOSObjectType)new TrainActCourseInfo().getBOSType()).toString();
                idMap.put(info.getId().toString(), id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pstmt.setTimestamp(3, info.getStartDate() == null ? null : new Timestamp(info.getStartDate().getTime()));
                pstmt.setTimestamp(4, info.getEndDate() == null ? null : new Timestamp(info.getEndDate().getTime()));
                pstmt.setBigDecimal(5, info.getLessonHour());
                pstmt.setInt(6, info.getTimeUnit().getValue());
                pstmt.setBigDecimal(7, info.getCost());
                if (info.getTrainCourse() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)info.getTrainCourse().getId().toString());
                } else {
                    pstmt.setString(8, null);
                }
                if (info.getTrainingMethod() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)9, (String)info.getTrainingMethod().getId().toString());
                } else {
                    pstmt.setString(9, null);
                }
                if (info.getChanelE1() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)10, (String)info.getChanelE1().getId().toString());
                } else {
                    pstmt.setString(10, null);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)11, (String)trainActivityId);
                pstmt.setInt(12, 20);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "INSERT INTO T_HR_TrainCourseCost (FID, FControlUnitID, FTrainActCourseID, FChargeItemID, FChargeStand, FCount, FCost) VALUES (?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql2);
            String courseCostId = null;
            TrainPlanCourseTrainPlanCourseCostInfo costInfo = null;
            int size3 = coll.size();
            for (int i = 0; i < size3; ++i) {
                info = (TrainPlanCourseInfo)coll.getObject(i);
                if (info.getTrainCourse() == null || existIDSet.contains(info.getTrainCourse().getId().toString())) continue;
                TrainPlanCourseTrainPlanCourseCostCollection costColl = info.getTrainPlanCourseCost();
                int count = costColl.size();
                for (int j = 0; j < count; ++j) {
                    costInfo = costColl.get(j);
                    courseCostId = BOSUuid.create((BOSObjectType)new TrainCourseCostInfo().getBOSType()).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)courseCostId);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)((String)idMap.get(info.getId().toString())));
                    if (costInfo.getChargeItem() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)costInfo.getChargeItem().getId().toString());
                    } else {
                        pstmt.setString(4, null);
                    }
                    pstmt.setString(5, costInfo.getChargeStand());
                    pstmt.setString(6, String.valueOf(costInfo.getCount()));
                    pstmt.setBigDecimal(7, costInfo.getTotalCost());
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private TrainActCourseCollection getTrainActCourseCollection(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        return TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
    }

    protected void _auditTrainActivity(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        if (trainActivityId == null) {
            return;
        }
        this.checkTrainCourse(ctx, trainActivityId, TrainActivityException.CANNOT_AUDIT_TRAINACTIVITY_ON_NOCOURSE);
        String sql = "UPDATE T_HR_TrainActivity SET FAuditorID = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainActivityId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        this._setTrainActivityStatus(ctx, trainActivityId, TrainActStateEnum.APPROVED);
        this.dealLogInfo(ctx, trainActivityId, "train_TrainActivity_audit");
    }

    private void checkTrainCourse(Context ctx, String trainActivityId, NumericExceptionSubItem numericExceptionSubItem) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        TrainActCourseCollection coll = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
        if (coll == null || coll.size() == 0) {
            throw new TrainActivityException(numericExceptionSubItem);
        }
    }

    protected void _startTrainActivity(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        if (trainActivityId == null) {
            return;
        }
        this._setTrainActivityStatus(ctx, trainActivityId, TrainActStateEnum.RUNNING);
        this.dealLogInfo(ctx, trainActivityId, "train_TrainActivity_start");
    }

    private void setNewEmployeeComplete(Context ctx, String trainActivityId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        viewInfo.setFilter(filterInfo);
        TrainStudentCourseCollection collection = TrainStudentCourseFactory.getLocalInstance(ctx).getTrainStudentCourseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            HashSet<String> studentIds = new HashSet<String>();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                studentIds.add(collection.get(i).getPerson().getId().toString());
            }
            this.newEmpDao(ctx, studentIds);
        }
    }

    private Set createTrainRecord(Context ctx, TrainActivityInfo trainActivityInfo, TrainActCourseCollection courseColl, TrainStudentCollection studentColl, Set recordExtIds) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashSet<String> idSet = new HashSet<String>();
        BOSObjectType bosType = new TrainCourseRecordExtendsInfo().getBOSType();
        try {
            String sql = "INSERT INTO T_HR_TrainCourseRecord (FID, FControlUnitID, FEmployeeID, FTrainActivityID, FTrainItemID, FOrgUnitID, FActBeginDate, FActEndDate, FActCost, FActTrainAddress, FActDescription, FTrainCourseID, FTrainInstructorID, FTrainChannelID, FTrainMethodID, FBeginDateTime, FEndDateTime, FCourseHour, FCourseHourUnit, FNeedExam, FPassStand, FAssessMethodID, FHROrgUnitID, FCreatorID, FCreateTime, FLastUpdateTime, FActNeedExam, FActAssessMethodID, FActPassStandard, FActIsPassed, FIsPassed, FActTrainMethodID, FCourseCost,FTrainType,FTrainCatagoryID,FActTrainCatagoryID,FTrainingCategoryID,FActTrainingCategoryID,FActTrainType,FActGiveCertificate,FGiveCertificate,FRecordExtendsID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainActCourseInfo courseInfo = null;
            TrainStudentInfo studentInfo = null;
            ArrayList<String> personIds = new ArrayList<String>();
            ArrayList<String> tempPersonIds = new ArrayList<String>();
            int activityRecordCount = 0;
            int count = studentColl.size();
            for (int j = 0; j < count; ++j) {
                studentInfo = studentColl.get(j);
                if (tempPersonIds.contains(studentInfo.getPerson().getId().toString())) continue;
                tempPersonIds.add(studentInfo.getPerson().getId().toString());
                tempPersonIds.add(studentInfo.getPerson().getId().toString());
                if (studentInfo.getOrgStudent() == null || studentInfo.getPosiStudent() == null || studentInfo.getType() == null || studentInfo.getType().equals((Object)TrainStudentTypeEnum.IN_SUPPORT)) continue;
                ++activityRecordCount;
            }
            int size = courseColl.size();
            for (int i = 0; i < size; ++i) {
                int j;
                courseInfo = courseColl.get(i);
                int recordCount = 0;
                personIds.clear();
                int count2 = studentColl.size();
                for (j = 0; j < count2; ++j) {
                    studentInfo = studentColl.get(j);
                    if (personIds.contains(studentInfo.getPerson().getId().toString())) continue;
                    personIds.add(studentInfo.getPerson().getId().toString());
                    if (studentInfo.getOrgStudent() == null || studentInfo.getPosiStudent() == null || studentInfo.getType() == null || studentInfo.getType().equals((Object)TrainStudentTypeEnum.IN_SUPPORT)) continue;
                    ++recordCount;
                }
                personIds.clear();
                count2 = studentColl.size();
                for (j = 0; j < count2; ++j) {
                    studentInfo = studentColl.get(j);
                    if (personIds.contains(studentInfo.getPerson().getId().toString())) continue;
                    personIds.add(studentInfo.getPerson().getId().toString());
                    if (studentInfo.getOrgStudent() == null || studentInfo.getPosiStudent() == null || studentInfo.getType() == null || studentInfo.getType().equals((Object)TrainStudentTypeEnum.IN_SUPPORT)) continue;
                    String id = BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString();
                    idSet.add(id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    if (studentInfo.getPerson() == null) {
                        pstmt.setString(3, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)studentInfo.getPerson().getId().toString());
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)trainActivityInfo.getId().toString());
                    if (trainActivityInfo.getTrainItem() == null) {
                        pstmt.setString(5, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)trainActivityInfo.getTrainItem().getId().toString());
                    }
                    if (trainActivityInfo.getOrgUnit() == null) {
                        pstmt.setString(6, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)trainActivityInfo.getOrgUnit().getId().toString());
                    }
                    if (trainActivityInfo.getTrainStartDate() == null) {
                        pstmt.setDate(7, null);
                    } else {
                        pstmt.setDate(7, new java.sql.Date(trainActivityInfo.getTrainStartDate().getTime()));
                    }
                    if (trainActivityInfo.getTrainEndDate() == null) {
                        pstmt.setDate(8, null);
                    } else {
                        pstmt.setDate(8, new java.sql.Date(trainActivityInfo.getTrainEndDate().getTime()));
                    }
                    BigDecimal actCost = trainActivityInfo.getBudgetCost();
                    if (actCost != null) {
                        actCost = actCost.divide(new BigDecimal(activityRecordCount), 4);
                    }
                    pstmt.setBigDecimal(9, actCost);
                    pstmt.setString(10, trainActivityInfo.getTrainAddress());
                    pstmt.setString(11, trainActivityInfo.getDescription());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)12, (String)courseInfo.getTrainCourse().getId().toString());
                    if (courseInfo.getChannelCourse() == null || courseInfo.getChannelCourse().getInstructor() == null) {
                        pstmt.setString(13, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)13, (String)courseInfo.getChannelCourse().getInstructor().getId().toString());
                    }
                    if (trainActivityInfo.getTrainChanne() == null) {
                        pstmt.setString(14, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)14, (String)trainActivityInfo.getTrainChanne().getId().toString());
                    }
                    if (courseInfo.getTrainingMethod() == null) {
                        pstmt.setString(15, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)15, (String)courseInfo.getTrainingMethod().getId().toString());
                    }
                    if (courseInfo.getStartDate() == null) {
                        pstmt.setTimestamp(16, null);
                    } else {
                        pstmt.setTimestamp(16, new Timestamp(courseInfo.getStartDate().getTime()));
                    }
                    if (courseInfo.getEndDate() == null) {
                        pstmt.setTimestamp(17, null);
                    } else {
                        pstmt.setTimestamp(17, new Timestamp(courseInfo.getEndDate().getTime()));
                    }
                    pstmt.setBigDecimal(18, courseInfo.getCourseHour());
                    if (courseInfo.getCourseHourUnit() == null) {
                        pstmt.setNull(19, 4);
                    } else {
                        pstmt.setInt(19, courseInfo.getCourseHourUnit().getValue());
                    }
                    pstmt.setBoolean(20, courseInfo.isNeedExam());
                    pstmt.setBigDecimal(21, courseInfo.getPassStand());
                    if (courseInfo.getAssessMethod() == null) {
                        pstmt.setString(22, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)22, (String)courseInfo.getAssessMethod().getId().toString());
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)23, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)24, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    pstmt.setTimestamp(25, new Timestamp(System.currentTimeMillis()));
                    pstmt.setTimestamp(26, new Timestamp(System.currentTimeMillis()));
                    pstmt.setBoolean(27, trainActivityInfo.isNeedAssess());
                    if (trainActivityInfo.getAssessMethod() != null && trainActivityInfo.getAssessMethod().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)28, (String)trainActivityInfo.getAssessMethod().getId().toString());
                    } else {
                        pstmt.setString(28, null);
                    }
                    pstmt.setBigDecimal(29, trainActivityInfo.getPassStand());
                    pstmt.setInt(30, 10);
                    pstmt.setInt(31, 10);
                    if (trainActivityInfo.getTrainMethod() != null && trainActivityInfo.getTrainMethod().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)32, (String)trainActivityInfo.getTrainMethod().getId().toString());
                    } else {
                        pstmt.setString(32, null);
                    }
                    BigDecimal courseCost = courseInfo.getTotalCost();
                    if (courseCost != null) {
                        courseCost = courseCost.divide(new BigDecimal(recordCount), 4);
                    }
                    pstmt.setBigDecimal(33, courseCost);
                    if (trainActivityInfo.getTrainType() != null) {
                        pstmt.setString(34, trainActivityInfo.getTrainType().getValue());
                    }
                    if (trainActivityInfo.getTrainCatagory() != null && trainActivityInfo.getTrainCatagory().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)35, (String)trainActivityInfo.getTrainCatagory().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)36, (String)trainActivityInfo.getTrainCatagory().getId().toString());
                    } else {
                        pstmt.setString(35, null);
                        pstmt.setString(36, null);
                    }
                    if (trainActivityInfo.getTrainingCategor() != null && trainActivityInfo.getTrainingCategor().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)37, (String)trainActivityInfo.getTrainingCategor().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)38, (String)trainActivityInfo.getTrainingCategor().getId().toString());
                    } else {
                        pstmt.setString(37, null);
                        pstmt.setString(38, null);
                    }
                    if (trainActivityInfo.getTrainType() != null) {
                        pstmt.setString(39, trainActivityInfo.getTrainType().getValue());
                    }
                    pstmt.setBoolean(40, trainActivityInfo.isNeedCertifcate());
                    pstmt.setBoolean(41, trainActivityInfo.isNeedCertifcate());
                    String id_extends = BOSUuid.create((BOSObjectType)bosType).toString();
                    pstmt.setString(42, id_extends);
                    String[] str = new String[]{id_extends, studentInfo.getOrgStudent().getId().toString(), studentInfo.getPosiStudent().getId().toString(), trainActivityInfo.getTrainContent()};
                    recordExtIds.add(str);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return recordExtIds;
    }

    private void createTrainActivityRecordExt(Context ctx, Set idSet_ext) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_HR_TrainCourseRecordExtends (FID, FOrgStudentID, FPosiStudentID,FTrainContent,FActIsApproved,FIsApproved) VALUES (?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            for (String[] str : idSet_ext) {
                pstmt.setString(1, str[0]);
                pstmt.setString(2, str[1]);
                pstmt.setString(3, str[2]);
                pstmt.setString(4, str[3]);
                pstmt.setBoolean(5, Boolean.FALSE);
                pstmt.setBoolean(6, Boolean.FALSE);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private Set createTrainActivityRecord(Context ctx, TrainActivityInfo trainActivityInfo, TrainActCourseCollection courseColl, Set recordExtIds) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashSet<String> idSet = new HashSet<String>();
        BOSObjectType bosType = new TrainCourseRecordExtendsInfo().getBOSType();
        try {
            TrainStudentCourseCollection studentCourseCollection;
            int i;
            String sql = "INSERT INTO T_HR_TrainCourseRecord (FID, FControlUnitID, FEmployeeID, FTrainActivityID, FTrainItemID, FOrgUnitID, FActBeginDate, FActEndDate, FActCost, FActTrainAddress, FActDescription, FTrainCourseID, FTrainInstructorID, FTrainChannelID, FTrainMethodID, FBeginDateTime, FEndDateTime, FCourseHour, FCourseHourUnit, FNeedExam, FPassStand, FAssessMethodID, FHROrgUnitID, FCreatorID, FCreateTime, FLastUpdateTime, FActNeedExam, FActAssessMethodID, FActPassStandard, FActIsPassed, FIsPassed, FActTrainMethodID, FCourseCost,FTrainType,FTrainCatagoryID,FActTrainCatagoryID,FTrainingCategoryID,FActTrainingCategoryID,FActTrainType,FActGiveCertificate,FGiveCertificate,FRecordExtendsID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainActCourseInfo courseInfo = null;
            TrainStudentCourseInfo studentCourseInfo = null;
            ArrayList<String> personIds = new ArrayList<String>();
            String personId = null;
            int activityRecordCount = 0;
            int size = courseColl.size();
            for (i = 0; i < size; ++i) {
                courseInfo = courseColl.get(i);
                studentCourseCollection = this.getTrainStudentCourseCollection(ctx, courseInfo.getId().toString());
                int count = studentCourseCollection.size();
                for (int j = 0; j < count; ++j) {
                    studentCourseInfo = studentCourseCollection.get(j);
                    if (studentCourseInfo.getOrgStudent() == null || studentCourseInfo.getPosiStudent() == null || studentCourseInfo.getType() == null || studentCourseInfo.getType().equals((Object)TrainStudentTypeEnum.IN_SUPPORT) || studentCourseInfo.getPerson() != null && personIds.contains(personId = studentCourseInfo.getPerson().getId().toString())) continue;
                    personIds.add(personId);
                    ++activityRecordCount;
                }
            }
            size = courseColl.size();
            for (i = 0; i < size; ++i) {
                int j;
                courseInfo = courseColl.get(i);
                studentCourseCollection = this.getTrainStudentCourseCollection(ctx, courseInfo.getId().toString());
                int recordCount = 0;
                personIds.clear();
                int count = studentCourseCollection.size();
                for (j = 0; j < count; ++j) {
                    studentCourseInfo = studentCourseCollection.get(j);
                    if (studentCourseInfo.getOrgStudent() == null || studentCourseInfo.getPosiStudent() == null || studentCourseInfo.getType() == null || studentCourseInfo.getType().equals((Object)TrainStudentTypeEnum.IN_SUPPORT) || studentCourseInfo.getPerson() != null && personIds.contains(personId = studentCourseInfo.getPerson().getId().toString())) continue;
                    personIds.add(personId);
                    ++recordCount;
                }
                personIds.clear();
                count = studentCourseCollection.size();
                for (j = 0; j < count; ++j) {
                    studentCourseInfo = studentCourseCollection.get(j);
                    if (studentCourseInfo.getOrgStudent() == null || studentCourseInfo.getPosiStudent() == null || studentCourseInfo.getType() == null || studentCourseInfo.getType().equals((Object)TrainStudentTypeEnum.IN_SUPPORT)) continue;
                    String id = BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString();
                    idSet.add(id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    if (studentCourseInfo.getPerson() == null) {
                        pstmt.setString(3, null);
                    } else {
                        personId = studentCourseInfo.getPerson().getId().toString();
                        if (personIds.contains(personId)) continue;
                        personIds.add(personId);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)personId);
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)trainActivityInfo.getId().toString());
                    if (trainActivityInfo.getTrainItem() == null) {
                        pstmt.setString(5, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)trainActivityInfo.getTrainItem().getId().toString());
                    }
                    if (trainActivityInfo.getOrgUnit() == null) {
                        pstmt.setString(6, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)trainActivityInfo.getOrgUnit().getId().toString());
                    }
                    if (trainActivityInfo.getTrainStartDate() == null) {
                        pstmt.setDate(7, null);
                    } else {
                        pstmt.setDate(7, new java.sql.Date(trainActivityInfo.getTrainStartDate().getTime()));
                    }
                    if (trainActivityInfo.getTrainEndDate() == null) {
                        pstmt.setDate(8, null);
                    } else {
                        pstmt.setDate(8, new java.sql.Date(trainActivityInfo.getTrainEndDate().getTime()));
                    }
                    BigDecimal actCost = trainActivityInfo.getBudgetCost();
                    if (actCost != null) {
                        actCost = actCost.divide(new BigDecimal(activityRecordCount), 4);
                    }
                    pstmt.setBigDecimal(9, actCost);
                    pstmt.setString(10, trainActivityInfo.getTrainAddress());
                    pstmt.setString(11, trainActivityInfo.getDescription());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)12, (String)courseInfo.getTrainCourse().getId().toString());
                    if (courseInfo.getChannelCourse() == null || courseInfo.getChannelCourse().getInstructor() == null) {
                        pstmt.setString(13, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)13, (String)courseInfo.getChannelCourse().getInstructor().getId().toString());
                    }
                    if (trainActivityInfo.getTrainChanne() == null) {
                        pstmt.setString(14, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)14, (String)trainActivityInfo.getTrainChanne().getId().toString());
                    }
                    if (courseInfo.getTrainingMethod() == null) {
                        pstmt.setString(15, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)15, (String)courseInfo.getTrainingMethod().getId().toString());
                    }
                    if (courseInfo.getStartDate() == null) {
                        pstmt.setTimestamp(16, null);
                    } else {
                        pstmt.setTimestamp(16, new Timestamp(courseInfo.getStartDate().getTime()));
                    }
                    if (courseInfo.getEndDate() == null) {
                        pstmt.setTimestamp(17, null);
                    } else {
                        pstmt.setTimestamp(17, new Timestamp(courseInfo.getEndDate().getTime()));
                    }
                    pstmt.setBigDecimal(18, courseInfo.getCourseHour());
                    if (courseInfo.getCourseHourUnit() == null) {
                        pstmt.setNull(19, 4);
                    } else {
                        pstmt.setInt(19, courseInfo.getCourseHourUnit().getValue());
                    }
                    pstmt.setBoolean(20, courseInfo.isNeedExam());
                    pstmt.setBigDecimal(21, courseInfo.getPassStand());
                    if (courseInfo.getAssessMethod() == null) {
                        pstmt.setString(22, null);
                    } else {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)22, (String)courseInfo.getAssessMethod().getId().toString());
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)23, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)24, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    pstmt.setTimestamp(25, new Timestamp(System.currentTimeMillis()));
                    pstmt.setTimestamp(26, new Timestamp(System.currentTimeMillis()));
                    pstmt.setBoolean(27, trainActivityInfo.isNeedAssess());
                    if (trainActivityInfo.getAssessMethod() != null && trainActivityInfo.getAssessMethod().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)28, (String)trainActivityInfo.getAssessMethod().getId().toString());
                    } else {
                        pstmt.setString(28, null);
                    }
                    pstmt.setBigDecimal(29, trainActivityInfo.getPassStand());
                    pstmt.setInt(30, 10);
                    pstmt.setInt(31, 10);
                    if (trainActivityInfo.getTrainMethod() != null && trainActivityInfo.getTrainMethod().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)32, (String)trainActivityInfo.getTrainMethod().getId().toString());
                    } else {
                        pstmt.setString(32, null);
                    }
                    BigDecimal courseCost = courseInfo.getTotalCost();
                    if (courseCost != null) {
                        courseCost = courseCost.divide(new BigDecimal(recordCount), 4);
                    }
                    pstmt.setBigDecimal(33, courseCost);
                    if (trainActivityInfo.getTrainType() != null) {
                        pstmt.setString(34, trainActivityInfo.getTrainType().getValue());
                    }
                    if (trainActivityInfo.getTrainCatagory() != null && trainActivityInfo.getTrainCatagory().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)35, (String)trainActivityInfo.getTrainCatagory().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)36, (String)trainActivityInfo.getTrainCatagory().getId().toString());
                    } else {
                        pstmt.setString(35, null);
                        pstmt.setString(36, null);
                    }
                    if (trainActivityInfo.getTrainingCategor() != null && trainActivityInfo.getTrainingCategor().getId() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)37, (String)trainActivityInfo.getTrainingCategor().getId().toString());
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)38, (String)trainActivityInfo.getTrainingCategor().getId().toString());
                    } else {
                        pstmt.setString(37, null);
                        pstmt.setString(38, null);
                    }
                    if (trainActivityInfo.getTrainType() != null) {
                        pstmt.setString(39, trainActivityInfo.getTrainType().getValue());
                    }
                    pstmt.setBoolean(40, trainActivityInfo.isNeedCertifcate());
                    pstmt.setBoolean(41, trainActivityInfo.isNeedCertifcate());
                    String id_extends = BOSUuid.create((BOSObjectType)bosType).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)42, (String)id_extends);
                    String[] str = new String[]{id_extends, studentCourseInfo.getOrgStudent().getId().toString(), studentCourseInfo.getPosiStudent().getId().toString(), trainActivityInfo.getTrainContent()};
                    recordExtIds.add(str);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return recordExtIds;
    }

    private TrainStudentCourseCollection getTrainStudentCourseCollection(Context ctx, String trainActCourseId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("Type"));
        evi.getSelector().add(new SelectorItemInfo("OrgStudent.id"));
        evi.getSelector().add(new SelectorItemInfo("PosiStudent.id"));
        evi.getSelector().add(new SelectorItemInfo("Person.id"));
        return TrainStudentCourseFactory.getLocalInstance(ctx).getTrainStudentCourseCollection(evi);
    }

    private TrainStudentCollection getTrainStudentColllection(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("Type"));
        evi.getSelector().add(new SelectorItemInfo("Person.id"));
        evi.getSelector().add(new SelectorItemInfo("OrgStudent.id"));
        evi.getSelector().add(new SelectorItemInfo("PosiStudent.id"));
        return TrainStudentFactory.getLocalInstance(ctx).getTrainStudentCollection(evi);
    }

    private TrainActCourseCollection getTrainActCourseColllection(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        fi.getFilterItems().add(new FilterItemInfo("CourseState", (Object)10, CompareType.NOTEQUALS));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("ChannelCourse.Instructor.id"));
        evi.getSelector().add(new SelectorItemInfo("ChannelCourse.trainChannel.id"));
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.trainAddress"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.target"));
        return TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
    }

    protected void _setTrainActivityStatus(Context ctx, String trainActivityId, TrainActStateEnum status) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainActivity SET FTrainActState = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, status.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainActivityId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected BigDecimal _getChargeItemsTotalCost(Context ctx, String trainActCourseId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("cost"));
        TrainCourseCostCollection coll = TrainCourseCostFactory.getLocalInstance(ctx).getTrainCourseCostCollection(evi);
        TrainCourseCostInfo info = null;
        BigDecimal totalCost = null;
        if (coll.size() > 0) {
            totalCost = new BigDecimal("0.00");
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getCost() == null) continue;
            totalCost = totalCost.add(info.getCost());
        }
        return totalCost;
    }

    protected void _createTrainActivity(Context ctx, String trainPlanActivityId, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainPlanActivity.id", (Object)trainPlanActivityId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("StartDate"));
        sic.add(new SelectorItemInfo("EndDate"));
        sic.add(new SelectorItemInfo("LessonHour"));
        sic.add(new SelectorItemInfo("Cost"));
        sic.add(new SelectorItemInfo("timeUnit"));
        sic.add(new SelectorItemInfo("TrainCourse.id"));
        sic.add(new SelectorItemInfo("TrainingMethod.id"));
        sic.add(new SelectorItemInfo("chanelE1.id"));
        sic.add(new SelectorItemInfo("TrainPlanCourseCost.ChargeItem.id"));
        sic.add(new SelectorItemInfo("TrainPlanCourseCost.ChargeStand"));
        sic.add(new SelectorItemInfo("TrainPlanCourseCost.Count"));
        sic.add(new SelectorItemInfo("TrainPlanCourseCost.TotalCost"));
        TrainPlanCourseCollection courseColl = TrainPlanCourseFactory.getLocalInstance(ctx).getTrainPlanCourseCollection(evi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        TrainActCourseCollection actCourseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(viewInfo);
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> mapIds = new HashMap<String, String>();
        int size = actCourseColl.size();
        for (int i = 0; i < size; ++i) {
            if (actCourseColl.get(i).getTrainCourse() == null) continue;
            idSet.add(actCourseColl.get(i).getTrainCourse().getId().toString());
            mapIds.put(actCourseColl.get(i).getTrainCourse().getId().toString(), actCourseColl.get(i).getId().toString());
        }
        ITrainActivity iTrainActivity = TrainActivityFactory.getLocalInstance(ctx);
        TrainActivityInfo trainActivityInfo = iTrainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId));
        TrainExePeriodInfo trainExePeriodInfo = null;
        if (trainActivityInfo.getTrainExePriod() != null) {
            trainExePeriodInfo = TrainExePeriodFactory.getLocalInstance(ctx).getTrainExePeriodInfo((IObjectPK)new ObjectUuidPK(trainActivityInfo.getTrainExePriod().getId()));
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmtCost = null;
        PreparedStatement pstmtExePeriod = null;
        String actId = null;
        try {
            String sql = "INSERT INTO T_HR_TrainActCourse (FID,FControlUnitID,FStartDate,FEndDate,FCourseHour,FCourseHourUnit,FTotalCost,FTrainCourseID,FTrainingMethodID,FChannelCourseID,FTrainActivityID,FCourseState) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            String updateSql = "update T_HR_TrainActCourse SET FStartDate = ?, FEndDate= ? WHERE FID = ?";
            String sqlCost = "INSERT INTO T_HR_TrainCourseCost (FID, FControlUnitID, FTrainActCourseID, FChargeItemID, FChargeStand,FCount,FCost) VALUES (?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmtCost = conn.prepareStatement(sqlCost);
            pstmtExePeriod = conn.prepareStatement(updateSql);
            TrainPlanCourseInfo courseInfo = null;
            TrainPlanCourseTrainPlanCourseCostInfo costInfo = null;
            String courseId = null;
            String costId = null;
            int size2 = courseColl.size();
            for (int i = 0; i < size2; ++i) {
                courseInfo = courseColl.get(i);
                if (courseInfo.getTrainCourse() == null) continue;
                if (idSet.contains(courseInfo.getTrainCourse().getId().toString())) {
                    actId = mapIds.get(courseInfo.getTrainCourse().getId().toString()).toString();
                    if (trainExePeriodInfo != null && trainActivityInfo.getTrainExePriod() != null) {
                        pstmtExePeriod.setTimestamp(1, new Timestamp(trainExePeriodInfo.getStartDate().getTime()));
                        pstmtExePeriod.setTimestamp(2, new Timestamp(trainExePeriodInfo.getEndDate().getTime()));
                    } else {
                        pstmtExePeriod.setNull(1, SQLType.DATETIME.getSQLType());
                        pstmtExePeriod.setNull(2, SQLType.DATETIME.getSQLType());
                    }
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmtExePeriod, (int)3, (String)actId);
                    pstmtExePeriod.executeUpdate();
                    continue;
                }
                courseId = BOSUuid.create((BOSObjectType)new TrainActCourseInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)courseId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                if (courseInfo.getStartDate() != null) {
                    pstmt.setTimestamp(3, new Timestamp(courseInfo.getStartDate().getTime()));
                } else if (trainExePeriodInfo != null && trainExePeriodInfo.getStartDate() != null) {
                    pstmt.setTimestamp(3, new Timestamp(trainExePeriodInfo.getStartDate().getTime()));
                } else if (trainActivityInfo.getTrainStartDate() != null) {
                    pstmt.setTimestamp(3, new Timestamp(trainActivityInfo.getTrainStartDate().getTime()));
                }
                if (courseInfo.getEndDate() != null) {
                    pstmt.setTimestamp(4, new Timestamp(courseInfo.getEndDate().getTime()));
                } else if (trainExePeriodInfo != null && trainExePeriodInfo.getEndDate() != null) {
                    pstmt.setTimestamp(4, new Timestamp(trainExePeriodInfo.getEndDate().getTime()));
                } else if (trainActivityInfo.getTrainEndDate() != null) {
                    pstmt.setTimestamp(4, new Timestamp(trainActivityInfo.getTrainEndDate().getTime()));
                }
                pstmt.setBigDecimal(5, courseInfo.getLessonHour());
                if (courseInfo.getTimeUnit() == null) {
                    pstmt.setNull(6, 4);
                } else {
                    pstmt.setInt(6, courseInfo.getTimeUnit().getValue());
                }
                pstmt.setBigDecimal(7, courseInfo.getCost());
                if (courseInfo.getTrainCourse() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)8, (String)courseInfo.getTrainCourse().getId().toString());
                } else {
                    pstmt.setString(8, null);
                }
                if (courseInfo.getTrainingMethod() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)9, (String)courseInfo.getTrainingMethod().getId().toString());
                } else {
                    pstmt.setString(9, null);
                }
                if (courseInfo.getChanelE1() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)10, (String)courseInfo.getChanelE1().getId().toString());
                } else {
                    pstmt.setString(10, null);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)11, (String)trainActivityId);
                pstmt.setInt(12, 20);
                pstmt.addBatch();
                TrainPlanCourseTrainPlanCourseCostCollection costColl = courseInfo.getTrainPlanCourseCost();
                int count = costColl.size();
                for (int j = 0; j < count; ++j) {
                    costInfo = costColl.get(j);
                    costId = BOSUuid.create((BOSObjectType)new TrainCourseCostInfo().getBOSType()).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmtCost, (int)1, (String)costId);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmtCost, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmtCost, (int)3, (String)courseId);
                    if (costInfo.getChargeItem() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmtCost, (int)4, (String)costInfo.getChargeItem().getId().toString());
                    } else {
                        pstmtCost.setString(4, null);
                    }
                    pstmtCost.setString(5, costInfo.getChargeStand());
                    pstmtCost.setBigDecimal(6, costInfo.getCount());
                    pstmtCost.setBigDecimal(7, costInfo.getTotalCost());
                    pstmtCost.addBatch();
                }
            }
            pstmt.executeBatch();
            pstmtCost.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtExePeriod);
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtExePeriod);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _createTrainActCourse(Context ctx, String trainItemId, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)trainItemId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("course.id"));
        sic.add(new SelectorItemInfo("courseHour"));
        sic.add(new SelectorItemInfo("courseHourUnit"));
        TrainItemCourseCollection courseColl = TrainItemCourseFactory.getLocalInstance(ctx).getTrainItemCourseCollection(evi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        TrainActCourseCollection actCourseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(viewInfo);
        HashSet<String> idSet = new HashSet<String>();
        TrainActCourseInfo trainActCourseInfo = null;
        int size = actCourseColl.size();
        for (int i = 0; i < size; ++i) {
            trainActCourseInfo = actCourseColl.get(i);
            if (trainActCourseInfo.getTrainCourse() == null) continue;
            idSet.add(trainActCourseInfo.getTrainCourse().getId().toString());
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("trainStartDate"));
        selectors.add(new SelectorItemInfo("trainEndDate"));
        selectors.add(new SelectorItemInfo("needDivide"));
        TrainActivityInfo trainActivityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), selectors);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_HR_TrainActCourse (FID,FControlUnitID,FCourseHour,FCourseHourUnit,FTrainCourseID,FTrainActivityID,FStartDate,FEndDate,FCourseState) VALUES (?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainItemCourseInfo courseInfo = null;
            String courseId = null;
            int size2 = courseColl.size();
            for (int i = 0; i < size2; ++i) {
                courseInfo = courseColl.get(i);
                if (courseInfo.getCourse() == null || idSet.contains(courseInfo.getCourse().getId().toString())) continue;
                courseId = BOSUuid.create((BOSObjectType)new TrainActCourseInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)courseId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pstmt.setBigDecimal(3, courseInfo.getCourseHour());
                if (courseInfo.getCourseHourUnit() == null) {
                    pstmt.setNull(4, 4);
                } else {
                    pstmt.setInt(4, courseInfo.getCourseHourUnit().getValue());
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseInfo.getCourse().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)trainActivityId);
                pstmt.setDate(7, new java.sql.Date(trainActivityInfo.getTrainStartDate().getTime()));
                pstmt.setDate(8, new java.sql.Date(trainActivityInfo.getTrainEndDate().getTime()));
                pstmt.setInt(9, 20);
                pstmt.addBatch();
                if (!trainActivityInfo.isNeedDivide()) continue;
                this.insertTrainStudentCourse(ctx, courseId, trainActivityId);
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void insertTrainStudentCourse(Context ctx, String trainActCourseId, String trainActivityId) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            StringBuffer sqlBuffer = new StringBuffer("SELECT distinct FcontrolUnitID,FPersonID,FType,FOrgStudentID,FPosiStudentID FROM T_HR_TrainStudentCourse ");
            sqlBuffer.append("where FTrainActCourseID in (select top 1 fid from T_HR_TrainActCourse where FTrainActivityID='");
            sqlBuffer.append(trainActivityId).append("' and FID != '").append(trainActCourseId).append("')");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("insert into T_HR_TrainStudentCourse (FID,FcontrolUnitID,FTrainActCourseID,FPersonID,FType,FOrgStudentID,FPosiStudentID) values(?,?,?,?,?,?,?)");
            while (rowSet.next()) {
                String id = BOSUuid.create((BOSObjectType)new TrainStudentCourseInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                pstmt.setString(2, rowSet.getString("FcontrolUnitID"));
                pstmt.setString(3, trainActCourseId);
                pstmt.setString(4, rowSet.getString("FPersonID"));
                pstmt.setString(5, rowSet.getString("FType"));
                pstmt.setString(6, rowSet.getString("FOrgStudentID"));
                pstmt.setString(7, rowSet.getString("FPosiStudentID"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Set _getCoursePerson(Context ctx, List courseIds, String isRequired) throws BOSException, EASBizException {
        logger.info((Object)("courseIds\uff1a" + courseIds));
        logger.info((Object)"\u5f00\u59cb\u53d6\u5b66\u5458\uff1a");
        Map map = CoursePersonHelper.getCoursePerson(ctx, courseIds, isRequired);
        logger.info((Object)("_getCoursePerson map\uff1a" + map));
        Set personIds = CoursePersonHelper.assemblePersonIds(courseIds, map);
        logger.info((Object)("_getCoursePerson personIds:" + personIds));
        CoursePersonHelper.compareToTrainRecord(ctx, courseIds, personIds);
        return personIds;
    }

    protected Set _getAllCoursePerson(Context ctx, List courseIds, String isRequired) throws BOSException, EASBizException {
        HashSet courses = new HashSet(courseIds);
        HashSet personIds = new HashSet();
        CoursePersonHelper.getEmployeeCoursePersons(ctx, courses, isRequired, personIds);
        CoursePersonHelper.getSysCatePersons(ctx, courses, isRequired, personIds);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isPassed", (Object)10));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", new HashSet(courseIds), CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainCourseIsPassPersonQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                personIds.remove(rowSet.getString("Employee.id"));
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        return personIds;
    }

    protected Set _getSignupAllPerson(Context ctx, String activityId) throws BOSException, EASBizException {
        HashSet<String> personIds = null;
        TrainActCourseCollection actCourses = this.getTrainActCourseCollection(ctx, activityId);
        if (actCourses != null && actCourses.size() > 0) {
            ArrayList<String> trainCourseIds = new ArrayList<String>();
            for (int i = 0; i < actCourses.size(); ++i) {
                TrainCourseInfo trainCourse = actCourses.get(i).getTrainCourse();
                if (TrainCommonUtils.isEmpty((CoreBaseInfo)trainCourse)) continue;
                trainCourseIds.add(actCourses.get(i).getTrainCourse().getId().toString());
            }
            if (trainCourseIds.size() == 0) {
                return personIds;
            }
            StringBuffer sql = this.buildSQL(activityId, trainCourseIds);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                personIds = new HashSet<String>();
                while (rowSet.next()) {
                    personIds.add(rowSet.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return personIds;
    }

    private StringBuffer buildSQL(String activityId, List trainCourseIds) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("select t2.FEmployeeID from (");
        sql.append("select t1.FEmployeeID");
        for (i = 0; i < trainCourseIds.size(); ++i) {
            sql.append(", ");
            sql.append("max(t1.courseId");
            sql.append(i);
            sql.append(") as max_courseId");
            sql.append(i);
        }
        sql.append(" from (");
        sql.append("select FEmployeeID");
        for (i = 0; i < trainCourseIds.size(); ++i) {
            sql.append(", ");
            sql.append("case FCourseID when '");
            sql.append(trainCourseIds.get(i));
            sql.append("'");
            sql.append(" then FCourseID else '-1' end as courseId");
            sql.append(i);
        }
        sql.append(" from T_HR_TrainSigner where FTrainActID = '");
        sql.append(activityId);
        sql.append("'");
        sql.append(") as t1");
        sql.append(" group by t1.FEmployeeID");
        sql.append(") as t2");
        sql.append(" where ");
        for (i = 0; i < trainCourseIds.size(); ++i) {
            if (i != 0) {
                sql.append(" and ");
            }
            sql.append("max_courseId");
            sql.append(i);
            sql.append("= '");
            sql.append(trainCourseIds.get(i));
            sql.append("'");
        }
        return sql;
    }

    protected Map _getActStudentCount(Context ctx, Set trainActivityIds) throws BOSException, EASBizException {
        HashMap<String, String> result = null;
        if (trainActivityIds != null && trainActivityIds.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FTrainActivityID, count(t.FEmployeeID) from ");
            sql.append("(Select distinct FTrainActivityID, FEmployeeID from T_HR_TrainCourseRecord");
            sql.append(" where FTrainActivityID in (");
            int index = 0;
            Iterator it = trainActivityIds.iterator();
            while (it.hasNext()) {
                if (index++ != 0) {
                    sql.append(",");
                }
                sql.append("'");
                sql.append(it.next().toString());
                sql.append("'");
            }
            sql.append(")) t group by t.FTrainActivityID");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                result = new HashMap<String, String>();
                while (rowSet.next()) {
                    result.put(rowSet.getString(1), rowSet.getString(2));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    protected String _sendMessageForNotice(Context ctx, List idList, Map messageMap) throws BOSException, EASBizException {
        TrainActivityFacadeFactory.getLocalInstance(ctx).sendMessage(idList, messageMap);
        Locale[] lcla = TrainActivityFacadeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        String personId = null;
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        msgInfo.setReceiveTime(cuttentDate);
        msgInfo.setSendTime(cuttentDate);
        msgInfo.setType(MsgType.ONLINE);
        msgInfo.setBizType(MsgBizType.ONLINE);
        msgInfo.setPriority(MsgPriority.MIDDLE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        String bosID = (String)messageMap.get("bosID");
        for (Locale locale2 : lcla) {
            msgInfo.setTitle((String)messageMap.get("title"), locale2);
            msgInfo.setSender((String)messageMap.get("sender"), locale2);
            msgInfo.setBody((String)messageMap.get("body"), locale2);
        }
        IBMCMessage iBMCMessage = null;
        iBMCMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
        msgInfo.setId(BOSUuid.create((BOSObjectType)msgInfo.getBOSType()));
        BoAttchAssoInfo boInfo = null;
        IBoAttchAsso iBoAttchAsso = null;
        BoAttchAssoCollection coll = null;
        iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BoID", (Object)bosID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        coll = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(viewInfo);
        Object pk = null;
        BOSUuid[] userIds = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            personId = (String)idList.get(i);
            userIds = this.getUsersByPerson(ctx, personId);
            if (userIds == null || userIds.length == 0) continue;
            int length = userIds.length;
            for (int j = 0; j < length; ++j) {
                if (userIds[j] == null) continue;
                msgInfo.setReceiver(userIds[j].toString());
                try {
                    msgInfo.setId(null);
                    pk = iBMCMessage.addnew((CoreBaseInfo)msgInfo);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                try {
                    if (coll == null || coll.size() <= 0) continue;
                    for (int k = 0; k < coll.size(); ++k) {
                        boInfo = new BoAttchAssoInfo();
                        boInfo = coll.get(k);
                        boInfo = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoInfo((IObjectPK)new ObjectStringPK(boInfo.getId().toString()));
                        boInfo.setId(null);
                        boInfo.setBoID(pk.toString());
                        iBoAttchAsso.addnew(boInfo);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(bosID);
        if (pk == null) {
            return null;
        }
        return pk.toString();
    }

    protected void _updateTrainActivityBudgetCost(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TotalCost"));
        viewInfo.setFilter(filter);
        TrainActCourseCollection actCourses = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(viewInfo);
        BigDecimal total = new BigDecimal("0.00");
        if (actCourses != null && actCourses.size() > 0) {
            for (int i = 0; i < actCourses.size(); ++i) {
                if (actCourses.get(i).getTotalCost() == null) continue;
                total = total.add(actCourses.get(i).getTotalCost());
            }
        }
        ITrainActivity iTrainActivity = TrainActivityFactory.getLocalInstance(ctx);
        TrainActivityInfo trainActivityInfo = iTrainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId));
        trainActivityInfo.setBudgetCost(total);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("BudgetCost");
        iTrainActivity.updatePartial((CoreBaseInfo)trainActivityInfo, sic);
    }

    protected Map _getActPublishData(Context ctx, String trainActivityId, String publisherId) throws BOSException, EASBizException {
        if (TrainCommonUtils.isEmpty(trainActivityId) || TrainCommonUtils.isEmpty(publisherId)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String packageString = "com.kingdee.eas.hr.train.app.";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityId));
        IRowSet rowSet = TrainUtilsServer.getRowSet(ctx, packageString + "TrainActivityOrganigerForManagerQuery", filterInfo);
        result.put("actOrgsInfo", rowSet);
        rowSet = TrainUtilsServer.getRowSet(ctx, packageString + "TrainActCourseForManagerQuery", filterInfo);
        result.put("relationInfo", rowSet);
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)publisherId));
        rowSet = TrainUtilsServer.getRowSet(ctx, packageString + "TrainActParticipantScopeQuery", filterInfo);
        result.put("participantScope", rowSet);
        rowSet = TrainUtilsServer.getRowSet(ctx, packageString + "TrainActOrgsScopeQuery", filterInfo);
        result.put("publishGroupScope", rowSet);
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)publisherId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("sendPerson.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("sendPerson.name"));
        TrainActivityMessageCollection collection = TrainActivityMessageFactory.getLocalInstance(ctx).getTrainActivityMessageCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            result.put("activityMessage", collection.get(0));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgPerson.name"));
        sic.add(new SelectorItemInfo("trainingCategor.name"));
        TrainActivityInfo trainActivityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), sic);
        result.put("trainActivity", trainActivityInfo);
        sic.clear();
        sic.add(new SelectorItemInfo("entrys.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entrys.studentNumber"));
        sic.add(new SelectorItemInfo("entrys.remark"));
        IObjectValue model = TrainActDeptStudentFactory.getLocalInstance(ctx).getValueByActivityId(trainActivityId, sic);
        result.put("actDeptAssignInfo", model);
        return result;
    }

    protected IObjectPK _saveActPublishInfo(Context ctx, IObjectValue trainActivityInfo, IObjectValue trainActMessageInfo, Collection publishGroups) throws BOSException, EASBizException {
        TrainActivityFactory.getLocalInstance(ctx).save((CoreBaseInfo)((TrainActivityInfo)trainActivityInfo));
        this.submitPublishGroup(ctx, trainActivityInfo, trainActMessageInfo, publishGroups);
        return TrainActivityMessageFactory.getLocalInstance(ctx).submit((CoreBaseInfo)((TrainActivityMessageInfo)trainActMessageInfo));
    }

    private void submitPublishGroup(Context ctx, IObjectValue trainActivityInfo, IObjectValue trainActMessageInfo, Collection publishGroups) throws BOSException, EASBizException {
        ITrainActOrgsScope iTrainActOrgsScope = TrainActOrgsScopeFactory.getLocalInstance(ctx);
        String trainActivityId = ((TrainActivityInfo)trainActivityInfo).getId().toString();
        PersonInfo sender = ((TrainActivityMessageInfo)trainActMessageInfo).getSendPerson();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)sender.getId().toString()));
        if (publishGroups != null && publishGroups.size() > 0) {
            int i;
            int size;
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("MaGroup.id"));
            TrainActOrgsScopeCollection collection = iTrainActOrgsScope.getTrainActOrgsScopeCollection(viewInfo);
            Iterator it = null;
            boolean exist = false;
            MAGroupInfo groupInfo = null;
            TrainActOrgsScopeInfo scopeInfo = null;
            if (collection != null && collection.size() > 0) {
                HashSet<String> deleteGroupId = new HashSet<String>();
                size = collection.size();
                for (i = 0; i < size; ++i) {
                    scopeInfo = collection.get(i);
                    it = publishGroups.iterator();
                    exist = false;
                    while (it.hasNext()) {
                        groupInfo = (MAGroupInfo)it.next();
                        if (groupInfo == null || !groupInfo.getId().equals((Object)scopeInfo.getMaGroup().getId())) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    deleteGroupId.add(scopeInfo.getMaGroup().getId().toString());
                }
                if (deleteGroupId.size() > 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("MaGroup.id", deleteGroupId, CompareType.INCLUDE));
                    iTrainActOrgsScope.delete(filterInfo);
                }
            }
            it = publishGroups.iterator();
            CoreBaseCollection osCol = new CoreBaseCollection();
            while (it.hasNext()) {
                groupInfo = (MAGroupInfo)it.next();
                exist = false;
                if (collection != null && collection.size() > 0) {
                    size = collection.size();
                    for (i = 0; i < size; ++i) {
                        scopeInfo = collection.get(i);
                        if (groupInfo == null || !groupInfo.getId().equals((Object)scopeInfo.getMaGroup().getId())) continue;
                        exist = true;
                        break;
                    }
                }
                if (exist) continue;
                scopeInfo = new TrainActOrgsScopeInfo();
                scopeInfo.setTrainActivity((TrainActivityInfo)trainActivityInfo);
                scopeInfo.setSendPerson(sender);
                scopeInfo.setMaGroup(groupInfo);
                osCol.add((CoreBaseInfo)scopeInfo);
            }
            if (osCol.size() > 0) {
                iTrainActOrgsScope.submitBatchData(osCol);
            }
        } else {
            iTrainActOrgsScope.delete(filterInfo);
        }
    }

    protected IObjectPK _publishTrainActivity(Context ctx, IObjectValue trainActivityInfo, IObjectValue trainActMessageInfo, Collection publishGroups, boolean sendMail) throws BOSException, EASBizException {
        TrainActivityInfo actInfo = (TrainActivityInfo)trainActivityInfo;
        TrainActivityMessageInfo messageInfo = (TrainActivityMessageInfo)trainActMessageInfo;
        PersonCollection persons = this.getReceivePerson(ctx, actInfo, messageInfo.getSendPerson(), publishGroups);
        if (persons != null && persons.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                idList.add(persons.get(i).getId().toString());
            }
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("title", messageInfo.getTitle());
            messageMap.put("sender", messageInfo.getSendPerson().getName());
            messageMap.put("body", messageInfo.getContent());
            TrainActivityFacadeFactory.getLocalInstance(ctx).sendMessage(idList, messageMap);
            if (sendMail) {
                HashSet<String> mailSet = new HashSet<String>();
                String mail = null;
                int size2 = persons.size();
                for (int i = 0; i < size2; ++i) {
                    mail = persons.get(i).getEmail();
                    if (mail == null || mail.indexOf("@") <= 0) continue;
                    mailSet.add(mail);
                }
                TrainActParticipantScopeFactory.getLocalInstance(ctx).sendMail(messageInfo.getSendPerson().getId().toString(), mailSet, messageInfo.getTitle(), messageInfo.getContent());
            }
        }
        actInfo.setIsSent(true);
        return this._saveActPublishInfo(ctx, trainActivityInfo, trainActMessageInfo, publishGroups);
    }

    private PersonCollection getReceivePerson(Context ctx, TrainActivityInfo actInfo, PersonInfo sendPerson, Collection publishGroups) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)actInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)sendPerson.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("Person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("Person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("Person.email"));
        TrainActParticipantScopeCollection scopeCollection = TrainActParticipantScopeFactory.getLocalInstance(ctx).getTrainActParticipantScopeCollection(viewInfo);
        PersonCollection personCollection = new PersonCollection();
        PersonInfo personInfo = null;
        if (scopeCollection != null && scopeCollection.size() > 0) {
            int size = scopeCollection.size();
            for (int i = 0; i < size; ++i) {
                personInfo = scopeCollection.get(i).getPerson();
                if (personInfo == null) continue;
                personCollection.add(personInfo);
            }
        }
        if (publishGroups != null && publishGroups.size() > 0) {
            filterInfo = new FilterInfo();
            HashSet<String> groupIds = new HashSet<String>();
            Iterator it = publishGroups.iterator();
            MAGroupInfo groupInfo = null;
            while (it.hasNext()) {
                groupInfo = (MAGroupInfo)it.next();
                if (groupInfo == null) continue;
                groupIds.add(groupInfo.getId().toString());
            }
            if (groupIds.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", groupIds, CompareType.INCLUDE));
                viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filterInfo);
                viewInfo.getSelector().add(new SelectorItemInfo("personnel.id"));
                viewInfo.getSelector().add(new SelectorItemInfo("personnel.name"));
                viewInfo.getSelector().add(new SelectorItemInfo("personnel.email"));
                MAGroupEntryCollection groupEntryCollection = MAGroupEntryFactory.getLocalInstance((Context)ctx).getMAGroupEntryCollection(viewInfo);
                if (groupEntryCollection != null && groupEntryCollection.size() > 0) {
                    int size = groupEntryCollection.size();
                    for (int i = 0; i < size; ++i) {
                        personInfo = groupEntryCollection.get(i).getPersonnel();
                        if (personInfo == null) continue;
                        personCollection.add(personInfo);
                    }
                }
            }
        }
        return personCollection;
    }

    protected void _change_newEmployeeState(Context ctx, NewEmployeeCollection newEmployeeCollection) throws BOSException, EASBizException {
        if (newEmployeeCollection == null || newEmployeeCollection.isEmpty()) {
            return;
        }
        if (newEmployeeCollection != null && newEmployeeCollection.size() > 0) {
            HashSet<String> studentIds = new HashSet<String>();
            for (int i = newEmployeeCollection.size() - 1; i >= 0; --i) {
                studentIds.add(newEmployeeCollection.get(i).getId().toString());
            }
            this.newEmpDao(ctx, studentIds);
        }
    }

    private void newEmpDao(Context ctx, Set studentIds) throws BOSException {
        StringBuffer sql = new StringBuffer("update t_hr_newemployee set FTrainIsComplete = 1 where FPersonID in");
        sql.append("(");
        sql.append(TrainCommonUtils.collectionToStrings(studentIds));
        sql.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _finishTrainActivity(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        if (trainActivityId == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("trainItem.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("trainContent"));
        sic.add(new SelectorItemInfo("TrainChannel.*"));
        TrainActivityInfo info = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), sic);
        Set recordExtIds = new HashSet();
        if (!info.isNeedDivide()) {
            TrainActCourseCollection courseColl = this.getTrainActCourseColllection(ctx, trainActivityId);
            recordExtIds = this.createTrainActivityRecord(ctx, info, courseColl, recordExtIds);
        } else {
            TrainActCourseCollection courseColl = this.getTrainActCourseColllection(ctx, trainActivityId);
            TrainStudentCollection studentColl = this.getTrainStudentColllection(ctx, trainActivityId);
            recordExtIds = this.createTrainRecord(ctx, info, courseColl, studentColl, recordExtIds);
        }
        this.createTrainActivityRecordExt(ctx, recordExtIds);
        this.updateTrainCourseRecordExt(ctx, trainActivityId);
        this._setTrainActivityStatus(ctx, trainActivityId, TrainActStateEnum.CLOSED);
        this.setNewEmployeeComplete(ctx, trainActivityId);
        this.setfinishTrainActCourse(ctx, trainActivityId);
        this.dealLogInfo(ctx, trainActivityId, "train_TrainActivity_finish");
    }

    private void updateTrainCourseRecordExt(Context ctx, String trainActivityId) throws BOSException {
        String sql = "update T_HR_TrainCourseRecordExtends SET FActIsApproved = ? WHERE FID IN (Select FRecordExtendsID FROM T_HR_TrainCourseRecord WHERE FTrainActivityID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBoolean(1, Boolean.FALSE);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainActivityId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void setfinishTrainActCourse(Context ctx, String trainActivityId) throws BOSException {
        String sql = "update T_HR_TrainActCourse SET FCourseState = ? WHERE FTrainActivityID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 10);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainActivityId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected HashSet _getHRRange(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        sql.append("select forgId from T_PM_OrgRange where ftype = ");
        sql.append(10);
        sql.append("and fuserid = '");
        sql.append(userID);
        sql.append("' ");
        sql.append(" and forgId in (select fid from T_ORG_HRO)");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rows.next()) {
                set.add(rows.getString("forgId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    protected void _finishTrainActCourse(Context ctx, String trainActCourseID) throws BOSException, EASBizException {
        if (trainActCourseID == null) {
            return;
        }
        TrainActivityInfo trainActivityInfo = null;
        Set recordExtIds = new HashSet();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("TrainActivity.id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ChannelCourse.Instructor.id"));
        sic.add(new SelectorItemInfo("ChannelCourse.trainChannel.id"));
        sic.add(new SelectorItemInfo("TrainCourse.id"));
        sic.add(new SelectorItemInfo("TrainActivity.id"));
        sic.add(new SelectorItemInfo("TrainActivity.trainAddress"));
        sic.add(new SelectorItemInfo("TrainActivity.target"));
        TrainActCourseInfo courseInfo = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(trainActCourseID), sic);
        TrainActCourseCollection courseColl = new TrainActCourseCollection();
        courseColl.add(courseInfo);
        trainActivityInfo = this.getTrainInfo(ctx, courseInfo.getTrainActivity().getId().toString());
        this.checkEmptyForStudent(ctx, trainActivityInfo, trainActCourseID);
        this.setFinishByTrainActCourse(ctx, trainActCourseID);
        if (!trainActivityInfo.isNeedDivide()) {
            recordExtIds = this.createTrainActivityRecord(ctx, trainActivityInfo, courseColl, recordExtIds);
        } else {
            TrainStudentCollection studentColl = this.getTrainStudentColllection(ctx, trainActivityInfo.getId().toString());
            recordExtIds = this.createTrainRecord(ctx, trainActivityInfo, courseColl, studentColl, recordExtIds);
        }
        this.createTrainActivityRecordExt(ctx, recordExtIds);
    }

    private void checkEmptyForStudent(Context ctx, TrainActivityInfo trainActivityInfo, String trainActCourseID) throws TrainActivityException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        AbstractObjectCollection studentColl = null;
        int studentCount = 0;
        if (!trainActivityInfo.isNeedDivide()) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseID));
            evi.getSelector().add(new SelectorItemInfo("Person.id"));
            studentColl = TrainStudentCourseFactory.getLocalInstance(ctx).getTrainStudentCourseCollection(evi);
            if (studentColl != null && studentColl.size() > 0) {
                HashSet<String> students = new HashSet<String>();
                for (int i = 0; i < studentColl.size(); ++i) {
                    students.add(((TrainStudentCourseCollection)studentColl).get(i).getPerson().getId().toString());
                }
                studentCount = students.size();
            }
        } else {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityInfo.getId().toString()));
            evi.getSelector().add(new SelectorItemInfo("id"));
            studentColl = TrainStudentFactory.getLocalInstance(ctx).getTrainStudentCollection(evi);
            if (studentColl != null) {
                studentCount = studentColl.size();
            }
        }
        if (studentCount == 0) {
            throw new TrainActivityException(TrainActivityException.CANNOT_ENDCOURSE);
        }
    }

    private TrainActivityInfo getTrainInfo(Context ctx, String trainActivityID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("trainItem.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("trainContent"));
        sic.add(new SelectorItemInfo("TrainChannel.*"));
        TrainActivityInfo info = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityID), sic);
        return info;
    }

    private void setFinishByTrainActCourse(Context ctx, String trainActCourseID) throws BOSException {
        String sql = "UPDATE T_HR_TrainActCourse SET FCourseState = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 10);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainActCourseID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void dealLogInfo(Context ctx, String loggerID, String loggerItem) throws BOSException, EASBizException {
        if (loggerID == null || loggerItem == null) {
            return;
        }
        TrainActivityInfo actInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(loggerID));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TrainActivityFactory.getLocalInstance(ctx).getType(), null, (String)(actInfo.getNumber() + " " + actInfo.getName()), (String)loggerItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void _reAudit(Context ctx, String trainActivityId, TrainAuditStateEnum auditStatus, TrainActStateEnum activityStatus) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainActivity SET FAuditState = ?,FTrainActState = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, auditStatus.getValue());
            pstmt.setInt(2, activityStatus.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)trainActivityId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

