/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.app.AbstractTrainActivityReportFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainActivityReportFacadeControllerBean
extends AbstractTrainActivityReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainActivityReportFacadeControllerBean");
    private String curHROrgUnitID = null;
    private String curUserID = null;

    protected Collection _getDeptActStudentCountInfos(Context ctx, Date startDate, Date endDate, IObjectValue adminOrgUnit, Set trainActivityIds, boolean includeCourse, Set trainCourseIds) throws BOSException, EASBizException {
        this.curHROrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        this.curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select TOP 1000 r.orgId, r.orgName, r.orgLongNumber, r.orgIsLeaf, r.orgLevel, r.actName, r.actId");
        if (includeCourse) {
            sql.append(" ,r.courseName, r.courseId");
        }
        sql.append(" ,max(deptNumber) deptNumber, max(signupNumber) signupNumber, max(mustNumber) mustNumber, max(factNumber) factNumber from (");
        sql.append(this.getDeptStudentCount(ctx, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds));
        sql.append(" union all ");
        sql.append(this.getSignupCount(ctx, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds));
        sql.append(" union all ");
        sql.append(this.getFormalStudentCount(ctx, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds));
        sql.append(" union all ");
        sql.append(this.getFactStudentCount(ctx, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds));
        sql.append(") r group by r.orgId, r.orgName, r.orgLongnumber, r.orgIsLeaf, r.orgLevel, r.actName, r.actId");
        if (includeCourse) {
            sql.append(",r.courseName, r.courseId");
        }
        sql.append(" order by r.orgLongnumber, r.actName");
        if (includeCourse) {
            sql.append(",r.courseName");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList result = new ArrayList();
        HashMap<String, Object> row = null;
        try {
            while (rowSet.next()) {
                row = new HashMap<String, Object>();
                row.put("orgId", rowSet.getString("orgId"));
                row.put("orgName", rowSet.getString("orgName"));
                row.put("orgLongNumber", rowSet.getString("orgLongNumber"));
                row.put("orgIsLeaf", rowSet.getBoolean("orgIsLeaf"));
                row.put("orgLevel", rowSet.getInt("orgLevel"));
                row.put("actName", rowSet.getString("actName"));
                row.put("actId", rowSet.getString("actId"));
                if (includeCourse) {
                    row.put("courseName", rowSet.getString("courseName"));
                    row.put("courseId", rowSet.getString("courseId"));
                }
                row.put("deptNumber", rowSet.getInt("deptNumber"));
                row.put("signupNumber", rowSet.getInt("signupNumber"));
                row.put("mustNumber", rowSet.getInt("mustNumber"));
                row.put("factNumber", Integer.valueOf(rowSet.getString("factNumber")));
                result.add(row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getDeptStudentCount(Context ctx, Date startDate, Date endDate, IObjectValue adminOrgUnit, Set trainActivityIds, boolean includeCourse, Set trainCourseIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("select org.FID orgId, org.fname_");
        sql.append(ctx.getLocale().toString());
        sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
        sql.append(ctx.getLocale().toString());
        sql.append(" actName, act.FID actId");
        if (includeCourse) {
            sql.append(", course.fName_");
            sql.append(ctx.getLocale().toString());
            sql.append(" courseName, course.FID courseId");
        }
        sql.append(", entry.fstudentnumber deptNumber, 0 signupNumber, 0 mustNumber, 0 factNumber");
        sql.append(" from T_HR_TrainActDeptStudententry entry");
        sql.append(" inner join T_HR_TrainActDeptStudent dept on dept.fid = entry.FParentID");
        sql.append(" inner join t_hr_trainactivity act on act.fid = dept.FTrainActivityID");
        sql.append(" inner join T_ORG_Admin org on org.fid = entry.FAdminOrgUnitID");
        if (includeCourse) {
            sql.append(" inner join t_hr_trainActCourse actCourse on actCourse.ftrainactivityid = act.fid");
            sql.append(" inner join t_hr_trainCourse course on course.fid = actCourse.FTrainCourseID");
        }
        this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
        return sql.toString();
    }

    private String getSignupCount(Context ctx, Date startDate, Date endDate, IObjectValue adminOrgUnit, Set trainActivityIds, boolean includeCourse, Set trainCourseIds) {
        StringBuffer sql = new StringBuffer();
        if (includeCourse) {
            sql.append("select m.orgId orgId, m.orgName orgName, m.orgLongNumber orgLongNumber, m.orgIsLeaf orgIsLeaf, m.orgLevel orgLevel, m.actName actName, m.actId actId, m.courseName courseName, m.courseId courseId, 0 deptNumber, count(*) signupNumber, 0 mustNumber, 0 factNumber from ");
            sql.append(" (select distinct org.FID orgId, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" actName, act.FID actId, course.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" courseName, course.FID courseId, person.FID ");
            sql.append(" from T_HR_TrainSignupForm main ");
            sql.append(" inner join T_HR_TrainSignupFormEntry sub on sub.FParentID = main.fid");
            sql.append(" inner join t_hr_trainactivity act on act.fid = main.FTrainActID");
            sql.append(" inner join t_bd_person person on person.fid = sub.FAttendeeID");
            sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = person.fid");
            sql.append(" inner join T_ORG_Admin org on org.fid = pp.FPersonDep");
            sql.append(" inner join t_hr_trainCourse course on course.fid = sub.FCourseID");
            this.appendSQLSplit(sql);
            sql.append(" main.FAuditState = ");
            sql.append(40);
            this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
            sql.append(" ) m group by m.orgId, m.orgName, m.orgLongNumber, m.orgIsLeaf, m.orgLevel, m.actName, m.actId, m.courseName, m.courseId");
        } else {
            sql.append("select m.orgId, m.orgName, m.orgLongNumber, m.orgIsLeaf, m.orgLevel, m.actName, m.actId, 0 deptNumber, count(*) signupNumber, 0 mustNumber, 0 factNumber from (");
            sql.append("select distinct org.FID orgId, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" actName, act.FID actId, person.FID from T_HR_TrainSignupForm main");
            sql.append(" inner join T_HR_TrainSignupFormEntry sub on sub.FParentID = main.fid");
            sql.append(" inner join t_hr_trainactivity act on act.fid = main.FTrainActID");
            sql.append(" inner join t_bd_person person on person.fid = sub.FAttendeeID");
            sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = person.fid");
            sql.append(" inner join T_ORG_Admin org on org.fid = pp.FPersonDep");
            this.appendSQLSplit(sql);
            sql.append(" main.FAuditState = ");
            sql.append(40);
            this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
            sql.append(" ) m group by m.orgId, m.orgName, m.orgLongNumber, m.orgIsLeaf, m.orgLevel, m.actName, m.actId");
        }
        return sql.toString();
    }

    private String getFormalStudentCount(Context ctx, Date startDate, Date endDate, IObjectValue adminOrgUnit, Set trainActivityIds, boolean includeCourse, Set trainCourseIds) {
        StringBuffer sql = new StringBuffer();
        if (includeCourse) {
            sql.append("select org.FID orgId, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" actName, act.FID actId, course.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" courseName, course.FID courseId, 0 deptNumber, 0 signupNumber, count(*) mustNumber, 0 factNumber from t_hr_TrainStudentCourse sc");
            sql.append(" inner join t_hr_trainActCourse actCourse on actCourse.fid = sc.FTrainActCourseID");
            sql.append(" inner join t_hr_trainactivity act on act.fid = actCourse.ftrainactivityid");
            sql.append(" inner join t_bd_person person on person.fid = sc.FPersonID");
            sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = person.fid");
            sql.append(" inner join T_ORG_Admin org on org.fid = pp.FPersonDep");
            sql.append(" inner join t_hr_trainCourse course on course.fid = actCourse.FTrainCourseID");
            this.appendSQLSplit(sql);
            sql.append(" sc.FType = ");
            sql.append(10);
            this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
            sql.append(" group by org.FID, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(",");
            sql.append(" org.flongnumber, org.FIsLeaf, org.FLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(",");
            sql.append(" act.FID, course.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(",");
            sql.append("course.FID");
        } else {
            sql.append("select orgId, orgName, orgLongNumber, orgIsLeaf, orgLevel, actName, actId, 0 deptNumber, 0 signupNumber, count(*) mustNumber, 0 factNumber from (");
            sql.append("select distinct org.FID orgId, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" actName, act.FID actId, person.FID from t_hr_TrainStudentCourse sc");
            sql.append(" inner join t_hr_trainActCourse actCourse on actCourse.fid = sc.FTrainActCourseID");
            sql.append(" inner join t_hr_trainactivity act on act.fid = actCourse.ftrainactivityid");
            sql.append(" inner join t_bd_person person on person.fid = sc.FPersonID");
            sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = person.fid");
            sql.append(" inner join T_ORG_Admin org on org.fid = pp.FPersonDep");
            this.appendSQLSplit(sql);
            sql.append(" sc.FType = ");
            sql.append(10);
            this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
            sql.append(" ) m group by m.orgId, m.orgName, m.orgLongNumber, m.orgIsLeaf, m.orgLevel, m.actName, m.actId");
        }
        return sql.toString();
    }

    private String getFactStudentCount(Context ctx, Date startDate, Date endDate, IObjectValue adminOrgUnit, Set trainActivityIds, boolean includeCourse, Set trainCourseIds) {
        StringBuffer sql = new StringBuffer();
        if (includeCourse) {
            sql.append("select org.FID orgId, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" actName, act.FID actId, course.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" courseName, course.FID courseId, 0 deptNumber, 0 signupNumber, 0 mustNumber, count(*) factNumber from t_hr_TrainCourseRecord record ");
            sql.append(" inner join t_hr_trainactivity act on act.fid = record.FTRAINACTIVITYID");
            sql.append(" inner join t_bd_person person on person.fid = record.FEMPLOYEEID");
            sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = person.fid");
            sql.append(" inner join T_ORG_Admin org on org.fid = pp.FPersonDep");
            sql.append(" inner join t_hr_trainCourse course on course.fid = record.FTrainCourseID");
            this.appendSQLSplit(sql);
            sql.append(" record.FAttendAll = 1");
            this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
            sql.append(" group by org.FID, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(",");
            sql.append(" org.flongnumber, org.FIsLeaf, org.FLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(",");
            sql.append(" act.FID, course.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(",");
            sql.append(" course.FID");
        } else {
            sql.append("select orgId, orgName, orgLongNumber, orgIsLeaf, orgLevel, actName, actId, 0 deptNumber, 0 signupNumber, 0 mustNumber, count(*) factNumber from (");
            sql.append("select distinct org.FID orgId, org.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" orgName, org.flongnumber orgLongNumber, org.FIsLeaf orgIsLeaf, org.FLevel orgLevel, act.fname_");
            sql.append(ctx.getLocale().toString());
            sql.append(" actName, act.FID actId, person.FID from t_hr_TrainCourseRecord record ");
            sql.append(" inner join t_hr_trainactivity act on act.fid = record.FTRAINACTIVITYID");
            sql.append(" inner join t_bd_person person on person.fid = record.FEMPLOYEEID");
            sql.append(" inner join T_HR_PersonPosition pp on pp.FPersonID = person.fid");
            sql.append(" inner join T_ORG_Admin org on org.fid = pp.FPersonDep");
            this.appendSQLSplit(sql);
            sql.append(" record.FActAttendAll = 1");
            this.appendCondition(sql, startDate, endDate, adminOrgUnit, trainActivityIds, includeCourse, trainCourseIds);
            sql.append(" ) m group by m.orgId, m.orgName, m.orgLongNumber, m.orgIsLeaf, m.orgLevel, m.actName, m.actId");
        }
        return sql.toString();
    }

    private void appendCondition(StringBuffer sql, Date startDate, Date endDate, IObjectValue adminOrgUnit, Set trainActivityIds, boolean includeCourse, Set trainCourseIds) {
        AdminOrgUnitInfo orgInfo;
        this.appendSQLSplit(sql);
        sql.append("act.FTrainActState = ");
        sql.append(50);
        if (startDate != null) {
            this.appendSQLSplit(sql);
            sql.append(" act.FTrainEndDate >= {");
            sql.append(DateTimeUtils.format((Date)startDate));
            sql.append("}");
        }
        if (endDate != null) {
            this.appendSQLSplit(sql);
            sql.append(" act.FTrainEndDate <= {");
            sql.append(DateTimeUtils.format((Date)endDate));
            sql.append("}");
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)(orgInfo = (AdminOrgUnitInfo)adminOrgUnit))) {
            this.appendSQLSplit(sql);
            sql.append(" org.flongnumber like '");
            sql.append(orgInfo.getLongNumber());
            sql.append("%'");
        }
        if (trainActivityIds != null && trainActivityIds.size() > 0) {
            this.appendSQLSplit(sql);
            sql.append(" act.FID in (");
            sql.append(TrainCommonUtils.collectionToStrings(trainActivityIds));
            sql.append(")");
        } else {
            this.appendSQLSplit(sql);
            sql.append(" act.FHrOrgUnitID = '");
            sql.append(this.curHROrgUnitID);
            sql.append("' and");
            sql.append(" act.FBelongOrgUnitID in (");
            sql.append(this.getAdminOrgUnitRangSQL());
            sql.append(")");
        }
        if (includeCourse && trainCourseIds != null && trainCourseIds.size() > 0) {
            this.appendSQLSplit(sql);
            sql.append(" course.FID in (");
            sql.append(TrainCommonUtils.collectionToStrings(trainCourseIds));
            sql.append(")");
        }
    }

    private void appendSQLSplit(StringBuffer sql) {
        if (sql.indexOf("where") > 0) {
            sql.append(" and ");
        } else {
            sql.append(" where ");
        }
    }

    private String getAdminOrgUnitRangSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(this.curHROrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(this.curUserID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }
}

