/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChannelCoursE1Factory;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorFactory;
import com.kingdee.eas.hr.train.TrainChanneException;
import com.kingdee.eas.hr.train.TrainChanneFactory;
import com.kingdee.eas.hr.train.TrainChanneInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainEquipmentFactory;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainPlanCourseFactory;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityFactory;
import com.kingdee.eas.hr.train.app.AbstractTrainChanneControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TrainChanneControllerBean
extends AbstractTrainChanneControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainChanneControllerBean");

    protected void _enabled(Context ctx, String trainChannelID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)trainChannelID)) {
            throw new TrainChanneException(TrainChanneException.ID_NOT_NULL);
        }
        SelectorItemCollection collection = new SelectorItemCollection();
        collection.add(new SelectorItemInfo("id"));
        collection.add(new SelectorItemInfo("IsEnabled"));
        TrainChanneInfo info = TrainChanneFactory.getLocalInstance(ctx).getTrainChanneInfo((IObjectPK)new ObjectUuidPK(trainChannelID), collection);
        if (info == null) {
            throw new TrainChanneException(TrainChanneException.ILLEGAL_ID);
        }
        if (info.isIsEnabled()) {
            throw new TrainChanneException(TrainChanneException.ALREADY_ENABLED);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_HR_TrainChanne SET FIsEnabled = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBoolean(1, true);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainChannelID);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.checkIsReference(ctx, pk)) {
            throw new TrainChanneException(TrainChanneException.BIZ_IS_REFERENCED_NOT_DELETE);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainchannel.id", (Object)pk.toString()));
        ChannelCoursE1Factory.getLocalInstance(ctx).delete(filterInfo);
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainChanneFactory.getLocalInstance(ctx), TrainChanneInfo.class.getName());
        super._delete(ctx, pk);
    }

    private boolean checkIsReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainChannel.id", (Object)pk.toString()));
        if (TrainEquipmentFactory.getLocalInstance(ctx).exists(filterInfo)) {
            return true;
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainChannel.id", (Object)pk.toString()));
        if (TrainCourseRecordFactory.getLocalInstance(ctx).exists(filterInfo)) {
            return true;
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("channelCourse.trainChannel.id", (Object)pk.toString()));
        if (TrainActCourseParticipatorFactory.getLocalInstance(ctx).exists(filterInfo)) {
            return true;
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainChannel.id", (Object)pk.toString()));
        if (TrainPlanTrainPlanActivityFactory.getLocalInstance(ctx).exists(filterInfo)) {
            return true;
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("chanelE1.trainchannel.id", (Object)pk.toString()));
        return TrainPlanCourseFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainChanneInfo)model));
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainChanneInfo)model));
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainChanneInfo info = (TrainChanneInfo)model;
        String name = info.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new TrainChanneException(TrainChanneException.CHANNEL_NAME_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainChanneFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainChanneException(TrainChanneException.CHANNEL_NAME_NOT_DUP);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainChanneInfo info = (TrainChanneInfo)model;
        String number = info.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new TrainChanneException(TrainChanneException.CHANNEL_NUMBER_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainChanneFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainChanneException(TrainChanneException.CHANNEL_NUMBER_NOT_DUP);
        }
    }

    protected boolean _setEnable(Context ctx, String trainChannelID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(trainChannelID);
        TrainChanneInfo courseInfo = TrainChanneFactory.getLocalInstance(ctx).getTrainChanneInfo((IObjectPK)pk);
        if (!courseInfo.isIsEnabled()) {
            throw new TrainException(TrainException.TRAINCOURSE_ISENABLED);
        }
        courseInfo.setIsEnabled(false);
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)courseInfo);
        return true;
    }

    protected boolean _setDisnable(Context ctx, String trainChannelID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(trainChannelID);
        TrainChanneInfo courseInfo = TrainChanneFactory.getLocalInstance(ctx).getTrainChanneInfo((IObjectPK)pk);
        if (!(!courseInfo.isIsEnabled())) {
            throw new TrainException(TrainException.TRAINCOURSE_ISDISABLED);
        }
        courseInfo.setIsEnabled(true);
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)courseInfo);
        return true;
    }
}

