/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.CourseKindCollection;
import com.kingdee.eas.hr.train.CourseKindFactory;
import com.kingdee.eas.hr.train.ICourseKind;
import com.kingdee.eas.hr.train.ITrainCourse;
import com.kingdee.eas.hr.train.TrainCourseCollection;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseImportException;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TrainCourseDataTransmission
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger((String)TrainCourseDataTransmission.class.getName());
    private static final String RESOURCEPATH = "com.kingdee.eas.hr.train.TrainResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TrainCourseFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable table, Context ctx) throws TaskExternalException {
        TrainCourseInfo trainCourseInfo = new TrainCourseInfo();
        DecimalFormat df = new DecimalFormat("#.00");
        Object value = table.get("name");
        if (value == null || value.toString().trim().length() <= 0) {
            try {
                throw new TrainCourseImportException(TrainCourseImportException.NAME_NOT_NULL);
            }
            catch (TrainCourseImportException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        trainCourseInfo.setName(value.toString());
        value = table.get("number");
        if (value != null) {
            trainCourseInfo.setNumber(value.toString());
        }
        this.setAdminOrgUnitInfo(ctx, trainCourseInfo, table);
        value = table.get("courseTarget");
        if (value != null) {
            trainCourseInfo.setCourseTarget(value.toString());
        }
        if ((value = table.get("isPublic")) != null && value.toString().length() > 0) {
            if ("true".equalsIgnoreCase(value.toString().trim())) {
                trainCourseInfo.setIsPublic(true);
            } else if ("false".equalsIgnoreCase(value.toString().trim())) {
                trainCourseInfo.setIsPublic(false);
            } else {
                try {
                    throw new TrainCourseImportException(TrainCourseImportException.IS_VIEW_ERROR);
                }
                catch (TrainCourseImportException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
        }
        if ((value = table.get("courseHour")) != null && value.toString().trim().length() > 0) {
            if (this.isDoubleOrInt(value.toString())) {
                double d = Double.parseDouble(value.toString());
                trainCourseInfo.setCourseHour(new BigDecimal(df.format(d)));
            } else {
                try {
                    throw new TrainCourseImportException(TrainCourseImportException.COURSEHOUR_ERROR);
                }
                catch (TrainCourseImportException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
        }
        if ((value = table.get("courseHourUnit")) != null && value.toString().trim().length() > 0) {
            try {
                int i;
                if (this.isInt(value.toString())) {
                    i = Integer.parseInt(value.toString());
                    if (i != 1 && i != 2 && i != 3) {
                        throw new TrainCourseImportException(TrainCourseImportException.COURSEUNIT_ERROR);
                    }
                } else {
                    throw new TrainCourseImportException(TrainCourseImportException.COURSEUNIT_ERROR);
                }
                trainCourseInfo.setCourseHourUnit(CourseHourUnitEnum.getEnum(i));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        if ((value = table.get("content")) != null && value.toString().trim().length() > 0) {
            trainCourseInfo.setContent(value.toString());
        }
        if ((value = table.get("courseJoinner")) != null && value.toString().trim().length() > 0) {
            trainCourseInfo.setCourseJoinner(value.toString());
        }
        if ((value = table.get("courseCost")) != null && value.toString().trim().length() > 0) {
            if (this.isDoubleOrInt(value.toString())) {
                double d = Double.parseDouble(value.toString());
                trainCourseInfo.setCourseCost(new BigDecimal(df.format(d)));
            } else {
                try {
                    throw new TrainCourseImportException(TrainCourseImportException.COURSECOST_ERROR);
                }
                catch (TrainCourseImportException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
        }
        if ((value = table.get("courseKind")) != null && value.toString().trim().length() > 0) {
            try {
                ICourseKind courseKindDao = CourseKindFactory.getLocalInstance(ctx);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("name", (Object)value.toString().trim()));
                evi.setFilter(fi);
                CourseKindCollection coll = courseKindDao.getCourseKindCollection(evi);
                if (coll == null || coll.size() <= 0) {
                    throw new TrainCourseImportException(TrainCourseImportException.COURSEKIND_NAME_ERROR);
                }
                trainCourseInfo.setCourseKind(coll.get(0));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        if ((value = table.get("description")) != null) {
            trainCourseInfo.setDescription(value.toString());
        }
        return trainCourseInfo;
    }

    private void setAdminOrgUnitInfo(Context ctx, TrainCourseInfo trainCourseInfo, Hashtable table) throws TaskExternalException {
        DataToken value = (DataToken)table.get("orgUnitNumber");
        String orgUnitNumber = value.toString();
        if (StringUtils.isEmpty((String)orgUnitNumber)) {
            StringBuffer sb = new StringBuffer(value.desc);
            sb.append(" ");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.train.TrainVerifyResource", (String)"CanNotBeNull", (Locale)ctx.getLocale()));
            throw new TaskExternalException(sb.toString());
        }
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)orgUnitNumber));
            filterInfo.mergeFilter(TrainUtilsServer.getAdminRangeFilterInfo(ctx, "id"), "AND");
            viewInfo.setFilter(filterInfo);
            AdminOrgUnitCollection collection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
            if (collection == null || collection.isEmpty()) {
                String message = MessageFormat.format(ResourceBase.getString((String)RESOURCEPATH, (String)"orgUnitNumberError", (Locale)ctx.getLocale()), orgUnitNumber);
                throw new TaskExternalException(message);
            }
            trainCourseInfo.setOrgUnit(collection.get(0));
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        DecimalFormat df = new DecimalFormat("#.00");
        Hashtable<String, String> hs = new Hashtable<String, String>();
        try {
            boolean isPublic;
            int i;
            String courseHour;
            String value = rs.getString("name");
            if (value != null && value.toString().trim().length() > 0) {
                hs.put("name", rs.getString("name"));
            }
            if ((value = rs.getString("number")) != null && value.toString().trim().length() > 0) {
                hs.put("number", rs.getString("number"));
            }
            if ((value = rs.getString("CourseTarget")) != null && value.toString().trim().length() > 0) {
                hs.put("courseTarget", value);
            }
            if ((value = (courseHour = rs.getString("CourseHour"))) != null && value.toString().trim().length() > 0) {
                if (this.isDoubleOrInt(courseHour)) {
                    double i2 = Double.parseDouble(value.toString());
                    hs.put("courseHour", df.format(i2));
                } else {
                    hs.put("courseHour", courseHour);
                }
            }
            if ((value = rs.getString("CourseHourUnit")) != null && value.toString().trim().length() > 0 && this.isInt(value.toString()) && ((i = Integer.parseInt(value.toString())) == 1 || i == 2 || i == 3)) {
                hs.put("courseHourUnit", value);
            }
            if ((value = rs.getString("Content")) != null && value.toString().trim().length() > 0) {
                hs.put("content", value);
            }
            if ((value = rs.getString("CourseJoinner")) != null && value.toString().trim().length() > 0) {
                hs.put("courseJoinner", value);
            }
            if (isPublic = rs.getBoolean("isPublic")) {
                hs.put("isPublic", "true");
            } else {
                hs.put("isPublic", "false");
            }
            value = rs.getString("courseCost");
            if (value != null && value.toString().trim().length() > 0) {
                if (this.isDoubleOrInt(value.toString())) {
                    double i3 = Double.parseDouble(value.toString());
                    hs.put("courseCost", df.format(i3));
                } else {
                    hs.put("courseCost", value);
                }
            }
            if ((value = rs.getString("CourseKind.name")) != null && value.toString().trim().length() > 0) {
                hs.put("courseKind", value);
            }
            if ((value = rs.getString("description")) != null && value.toString().trim().length() > 0) {
                hs.put("description", value);
            }
            if (!StringUtils.isEmpty((String)(value = rs.getString("orgUnit.number")))) {
                hs.put("orgUnitNumber", value);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return hs;
    }

    public void submit(CoreBaseInfo info, Context ctx) throws TaskExternalException {
        Object trainCourseType;
        TrainCourseInfo trainCourseInfo = (TrainCourseInfo)info;
        if (trainCourseInfo.getCourseCost() != null) {
            trainCourseInfo.setCourseCost(trainCourseInfo.getCourseCost().setScale(2, 4));
        }
        if (trainCourseInfo.getCourseHour() != null) {
            trainCourseInfo.setCourseHour(trainCourseInfo.getCourseHour().setScale(2, 4));
        }
        if ((trainCourseType = this.getContextParameter("trainCourseType")) != null && trainCourseType instanceof TrainCourseTreeInfo) {
            try {
                if (this.isSltImportUpdate()) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)trainCourseInfo.getName()));
                    filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                    ITrainCourse trainCourseDAO = TrainCourseFactory.getLocalInstance(ctx);
                    if (trainCourseDAO.exists(filter)) {
                        EntityViewInfo evi = new EntityViewInfo();
                        evi.setFilter(filter);
                        TrainCourseCollection coll = trainCourseDAO.getTrainCourseCollection(evi);
                        int j = coll.size();
                        for (int i = 0; i < j; ++i) {
                            TrainCourseInfo cInfo = coll.get(i);
                            if (cInfo.isIsEnable()) {
                                throw new TrainCourseImportException(TrainCourseImportException.CAN_NOT_UPDATE_ENABLED_COURSE);
                            }
                            cInfo.setCourseTarget(trainCourseInfo.getCourseTarget());
                            cInfo.setCourseHour(trainCourseInfo.getCourseHour());
                            cInfo.setCourseHourUnit(trainCourseInfo.getCourseHourUnit());
                            cInfo.setContent(trainCourseInfo.getContent());
                            cInfo.setCourseJoinner(trainCourseInfo.getCourseJoinner());
                            cInfo.setIsPublic(trainCourseInfo.isIsPublic());
                            cInfo.setCourseCost(trainCourseInfo.getCourseCost());
                            cInfo.setCourseKind(trainCourseInfo.getCourseKind());
                            cInfo.setDescription(trainCourseInfo.getDescription());
                            cInfo.setOrgUnit(trainCourseInfo.getOrgUnit());
                            trainCourseDAO.update((IObjectPK)new ObjectUuidPK(cInfo.getId().toString()), (CoreBaseInfo)cInfo);
                        }
                    } else {
                        this.addNewTrainCourse(info, ctx, trainCourseInfo, trainCourseType);
                    }
                } else {
                    this.addNewTrainCourse(info, ctx, trainCourseInfo, trainCourseType);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException("BOSException:" + e.getMessage());
            }
        }
    }

    private void addNewTrainCourse(CoreBaseInfo info, Context ctx, TrainCourseInfo trainCourseInfo, Object trainCourseType) throws Exception {
        trainCourseInfo.setTreeid((TrainCourseTreeInfo)trainCourseType);
        HROrgUnitInfo hrUnit = ContextUtil.getCurrentHRUnit((Context)ctx);
        trainCourseInfo.setIsEnable(true);
        trainCourseInfo.setHrOrgUnit(hrUnit);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ITrainCourse trainCourseDao = TrainCourseFactory.getLocalInstance(ctx);
        if (StringUtil.isEmptyString((String)trainCourseInfo.getNumber())) {
            if (codingRuleManager.isExist((IObjectValue)trainCourseInfo, hrUnit.getId().toString())) {
                String number = codingRuleManager.getNumber((IObjectValue)trainCourseInfo, hrUnit.getId().toString());
                trainCourseInfo.setNumber(number);
            } else {
                long time = System.currentTimeMillis();
                Random r = new Random();
                String number = String.valueOf(time) + r.nextInt();
                trainCourseInfo.setNumber(number);
            }
        }
        if (this.isSltImportUpdate()) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("name", (Object)trainCourseInfo.getName()));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrUnit.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)trainCourseInfo.getOrgUnit().getId().toString()));
            if (trainCourseDao.exists(fi)) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(fi);
                TrainCourseCollection coll = trainCourseDao.getTrainCourseCollection(evi);
                int j = coll.size();
                for (int i = 0; i < j; ++i) {
                    TrainCourseInfo temp = coll.get(i);
                    trainCourseInfo.setId(temp.getId());
                    trainCourseDao.update((IObjectPK)new ObjectUuidPK(temp.getId().toString()), (CoreBaseInfo)trainCourseInfo);
                }
            } else {
                trainCourseDao.submit(info);
            }
        } else {
            trainCourseDao.submit(info);
        }
    }

    private boolean isInt(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        String regex = "^[1-9][0-9]*$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    private boolean isDoubleOrInt(String str) {
        String regex = "^[0-9]+(.[0-9]+)?$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

