/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.IPersonCertification;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.train.ITrainStudentCourse;
import com.kingdee.eas.hr.train.PersonCheckUpFactory;
import com.kingdee.eas.hr.train.PersonCheckUpInfo;
import com.kingdee.eas.hr.train.PersonEvaluEnum;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainRecordException;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainRewardsCollection;
import com.kingdee.eas.hr.train.TrainRewardsFactory;
import com.kingdee.eas.hr.train.TrainRewardsInfo;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.TrainStudentInfo;
import com.kingdee.eas.hr.train.TrainStudentTypeEnum;
import com.kingdee.eas.hr.train.TrainThoughtCollection;
import com.kingdee.eas.hr.train.TrainThoughtFactory;
import com.kingdee.eas.hr.train.TrainThoughtInfo;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.app.AbstractTrainCourseRecordControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainCourseRecordControllerBean
extends AbstractTrainCourseRecordControllerBean {
    private static Logger logger = Logger.getLogger(TrainCourseRecordControllerBean.class);
    private static final String TABLEEXTENDS_NAME = " T_HR_TrainCourseRecordExtends ";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model, false);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model, false);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        TrainCourseRecordInfo trainCourseRecordInfo = (TrainCourseRecordInfo)objectValue;
        if (TrainCommonUtils.isEmpty((CoreBaseInfo)trainCourseRecordInfo.getHrOrgUnit())) {
            trainCourseRecordInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (trainCourseRecordInfo.getRecordExtends() == null) {
            trainCourseRecordInfo.setRecordExtends(new TrainCourseRecordExtendsInfo());
        }
        if (trainCourseRecordInfo.getActTrainType() == null) {
            if (trainCourseRecordInfo.getTrainType() == null) {
                trainCourseRecordInfo.setActTrainType(TrainTypeEnum.INNERTRAINTYPE);
            } else {
                trainCourseRecordInfo.setActTrainType(trainCourseRecordInfo.getTrainType());
            }
        }
        if (trainCourseRecordInfo.getTrainType() == null) {
            if (trainCourseRecordInfo.getActTrainType() == null) {
                trainCourseRecordInfo.setTrainType(TrainTypeEnum.INNERTRAINTYPE);
            } else {
                trainCourseRecordInfo.setTrainType(trainCourseRecordInfo.getActTrainType());
            }
        }
        if (trainCourseRecordInfo.getHrOrgUnit() == null) {
            trainCourseRecordInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)trainCourseRecordInfo);
        try {
            this.setUnAudit(ctx, (IObjectValue)trainCourseRecordInfo);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return pk;
    }

    private void updateSameTrainActivity(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        TrainCourseRecordInfo trainCourseRecordInfo = (TrainCourseRecordInfo)objectValue;
        TrainActivityInfo trainActivityInfo = trainCourseRecordInfo.getTrainActivity();
        if (trainActivityInfo == null) {
            return;
        }
        TrainActCourseCollection courseColl = this.getTrainActCourseColllection(ctx, trainActivityInfo.getId().toString());
        if (courseColl == null || courseColl.size() == 0) {
            return;
        }
        this.updateSameActInfo(ctx, trainCourseRecordInfo);
        this.updateSameActInfoByEmployee(ctx, trainCourseRecordInfo);
        this.updateSameActInfoByExt(ctx, trainCourseRecordInfo);
        this.updateSameActInfoByExtEmployee(ctx, trainCourseRecordInfo);
    }

    private void updateSameActInfoByExt(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo) throws BOSException {
        String sql = "UPDATE T_HR_TrainCourseRecordExtends SET FTrainContent = ? WHERE FID in ( select FRecordExtendsID from t_hr_traincourserecord where FTrainActivityID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (trainCourseRecordInfo.getRecordExtends() != null) {
                pstmt.setString(1, trainCourseRecordInfo.getRecordExtends().getTrainContent());
            } else {
                pstmt.setString(1, null);
            }
            pstmt.setString(2, trainCourseRecordInfo.getTrainActivity().getId().toString());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateSameActInfo(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo) throws BOSException {
        String sql = "UPDATE T_HR_TrainCourseRecord SET FTrainItemID = ?, FOrgUnitID = ?, FActBeginDate = ?, FActEndDate = ?, FActTrainMethodID = ?, FActHour = ?, FActHourUnit = ?, FActPassStandard = ?, FActAssessMethodID = ?, FActTrainAddress = ?, FActShouldAttend = ?, FActTrainingCategoryID = ?, FActTrainCatagoryID = ?  ,FTrainChannelID = ? WHERE FTrainActivityID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            if (trainCourseRecordInfo.getTrainItem() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getTrainItem().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainCourseRecordInfo.getOrgUnit() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getOrgUnit().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainCourseRecordInfo.getActBeginDate() != null) {
                pstmt.setDate(index++, new Date(trainCourseRecordInfo.getActBeginDate().getTime()));
            } else {
                pstmt.setDate(index++, null);
            }
            if (trainCourseRecordInfo.getActEndDate() != null) {
                pstmt.setDate(index++, new Date(trainCourseRecordInfo.getActEndDate().getTime()));
            } else {
                pstmt.setDate(index++, null);
            }
            if (trainCourseRecordInfo.getActTrainMethod() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getActTrainMethod().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActHour());
            if (trainCourseRecordInfo.getActHourUnit() != null) {
                pstmt.setInt(index++, trainCourseRecordInfo.getActHourUnit().getValue());
            } else {
                pstmt.setNull(index++, 4);
            }
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActPassStandard());
            if (trainCourseRecordInfo.getActAssessMethod() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getActAssessMethod().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            pstmt.setString(index++, trainCourseRecordInfo.getActTrainAddress());
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActShouldAttend());
            if (trainCourseRecordInfo.getActTrainingCategory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getActTrainingCategory().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainCourseRecordInfo.getActTrainCategory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getActTrainCategory().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainCourseRecordInfo.getTrainChannel() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getTrainChannel().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getTrainActivity().getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateSameActInfoByExtEmployee(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo) throws BOSException {
        String sql = "UPDATE T_HR_TrainCourseRecordExtends SET FActAssessValue = ?, FOrgStudentID = ?, FPosiStudentID = ? WHERE FID in ( select FRecordExtendsID from t_hr_traincourserecord where FEmployeeID = ? and FTrainActivityID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (trainCourseRecordInfo.getRecordExtends() != null) {
                pstmt.setString(1, trainCourseRecordInfo.getRecordExtends().getActAssessValue());
                if (trainCourseRecordInfo.getRecordExtends().getOrgStudent() != null) {
                    pstmt.setString(2, trainCourseRecordInfo.getRecordExtends().getOrgStudent().getId().toString());
                } else {
                    pstmt.setString(2, null);
                }
                if (trainCourseRecordInfo.getRecordExtends().getPosiStudent() != null) {
                    pstmt.setString(3, trainCourseRecordInfo.getRecordExtends().getPosiStudent().getId().toString());
                } else {
                    pstmt.setString(3, null);
                }
            } else {
                pstmt.setString(1, null);
                pstmt.setString(2, null);
                pstmt.setString(3, null);
            }
            pstmt.setString(4, trainCourseRecordInfo.getEmployee().getId().toString());
            pstmt.setString(5, trainCourseRecordInfo.getTrainActivity().getId().toString());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateSameCourseInfoByExt(Context ctx, IObjectValue obj, boolean isAddNew) throws BOSException {
        String sql = isAddNew ? "UPDATE T_HR_TrainCourseRecordExtends SET FTrainContent = ?, FAssessValue = ?, FOrgStudentID = ?, FPosiStudentID = ?, FIsApproved = ?, FActIsApproved = ? WHERE FID in ( select FRecordExtendsID from t_hr_traincourserecord where FEmployeeID = ? and FTrainCourseID = ?)" : "UPDATE T_HR_TrainCourseRecordExtends SET FTrainContent = ?, FAssessValue = ?, FOrgStudentID = ?, FPosiStudentID = ? WHERE FID in ( select FRecordExtendsID from t_hr_traincourserecord where FEmployeeID = ? and FTrainCourseID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        TrainCourseRecordInfo trainCourseRecordInfo = (TrainCourseRecordInfo)obj;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (trainCourseRecordInfo.getRecordExtends() != null) {
                pstmt.setString(1, trainCourseRecordInfo.getRecordExtends().getTrainContent());
                pstmt.setString(2, trainCourseRecordInfo.getRecordExtends().getAssessValue());
                if (trainCourseRecordInfo.getRecordExtends().getOrgStudent() != null && trainCourseRecordInfo.getRecordExtends().getOrgStudent().getId() != null) {
                    pstmt.setString(3, trainCourseRecordInfo.getRecordExtends().getOrgStudent().getId().toString());
                } else {
                    pstmt.setString(3, null);
                }
                if (trainCourseRecordInfo.getRecordExtends().getPosiStudent() != null) {
                    pstmt.setString(4, trainCourseRecordInfo.getRecordExtends().getPosiStudent().getId().toString());
                } else {
                    pstmt.setString(4, null);
                }
            } else {
                pstmt.setString(1, null);
                pstmt.setString(2, null);
                pstmt.setString(3, null);
                pstmt.setString(4, null);
            }
            if (isAddNew) {
                pstmt.setBoolean(5, Boolean.FALSE);
                pstmt.setBoolean(6, Boolean.FALSE);
                pstmt.setString(7, trainCourseRecordInfo.getEmployee().getId().toString());
                pstmt.setString(8, trainCourseRecordInfo.getTrainCourse().getId().toString());
            } else {
                pstmt.setString(5, trainCourseRecordInfo.getEmployee().getId().toString());
                pstmt.setString(6, trainCourseRecordInfo.getTrainCourse().getId().toString());
            }
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateSameActInfoByEmployee(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo) throws BOSException, EASBizException, SQLDataException {
        String sql = "UPDATE T_HR_TrainCourseRecord SET FActCost = ?, FActScore = ?, FResponserEvalu = ?, FOrgUnitScore = ?, FActNeedExam = ?, FActAssessScore = ?, FActIsPassed = ?, FActAttendAll = ?, FActAbsentType = ?, FActActualAttend = ?, FActAbsent = ?, FActAbsentHour = ?, FActAbsHourUnit = ?,FActDescription = ? , FActTrainingCategoryID = ?, FActTrainCatagoryID = ? , FActEnterPersonInfo = ?,FGiveCertificate =?  WHERE FEmployeeID = ? AND FTrainActivityID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActCost());
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActScore());
            if (trainCourseRecordInfo.getResponserEvalu() == null) {
                pstmt.setNull(index++, 4);
            } else {
                pstmt.setInt(index++, trainCourseRecordInfo.getResponserEvalu().getValue());
            }
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getOrgUnitScore());
            pstmt.setBoolean(index++, trainCourseRecordInfo.isActNeedExam());
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActAssessScore());
            if (trainCourseRecordInfo.getActIsPassed() == null) {
                pstmt.setNull(index++, 4);
            } else {
                pstmt.setInt(index++, trainCourseRecordInfo.getActIsPassed().getValue());
            }
            pstmt.setBoolean(index++, trainCourseRecordInfo.isActAttendAll());
            if (trainCourseRecordInfo.getActAbsentType() == null) {
                pstmt.setNull(index++, 4);
            } else {
                pstmt.setInt(index++, trainCourseRecordInfo.getActAbsentType().getValue());
            }
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActActualAttend());
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActAbsent());
            pstmt.setBigDecimal(index++, trainCourseRecordInfo.getActAbsentHour());
            if (trainCourseRecordInfo.getActAbsHourUnit() == null) {
                pstmt.setNull(index++, 4);
            } else {
                pstmt.setInt(index++, trainCourseRecordInfo.getActAbsHourUnit().getValue());
            }
            pstmt.setString(index++, trainCourseRecordInfo.getActDescription());
            if (trainCourseRecordInfo.getActTrainingCategory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getActTrainingCategory().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainCourseRecordInfo.getActTrainCategory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getActTrainCategory().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            pstmt.setBoolean(index++, trainCourseRecordInfo.isActEnterPersonInfo());
            pstmt.setBoolean(index++, trainCourseRecordInfo.isActGiveCertificate());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getEmployee().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getTrainActivity().getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _submit(Context ctx, IObjectValue trainCourseRecord, boolean isTrainActivityRecord) throws BOSException, EASBizException {
        TrainCourseRecordInfo trainCourseRecordInfo = (TrainCourseRecordInfo)trainCourseRecord;
        TrainActivityInfo trainActivityInfo = trainCourseRecordInfo.getTrainActivity();
        if (trainActivityInfo == null) {
            this._submit(ctx, trainCourseRecord);
            return;
        }
        if (isTrainActivityRecord) {
            PersonInfo personInfo = trainCourseRecordInfo.getEmployee();
            TrainActCourseCollection courseColl = this.getTrainActCourseColllection(ctx, trainActivityInfo.getId().toString());
            this.createTrainActivityRecord(ctx, trainActivityInfo, personInfo, courseColl, trainCourseRecordInfo);
            this.updateSameTrainActivity(ctx, trainCourseRecord);
        }
    }

    private Set createTrainActivityRecord(Context ctx, TrainCourseRecordInfo courseRecordInfo, TrainActCourseCollection courses) throws EASBizException, BOSException {
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        IObjectPK pk = null;
        if (courses != null && courses.size() > 0) {
            TrainActCourseInfo actCourse = null;
            TrainCourseRecordInfo newInfo = null;
            for (int i = 0; i < courses.size(); ++i) {
                actCourse = courses.get(i);
                newInfo = this.assembleRecordInfo(courseRecordInfo, actCourse);
                if (courseRecordInfo.getId() != null && i == 0) {
                    newInfo.setId(courseRecordInfo.getId());
                }
                pk = this._submit(ctx, (IObjectValue)newInfo);
                ids.add(pk);
            }
        } else {
            pk = this._submit(ctx, (IObjectValue)courseRecordInfo);
            ids.add(pk);
        }
        return ids;
    }

    private TrainCourseRecordInfo assembleRecordInfo(TrainCourseRecordInfo courseRecordInfo, TrainActCourseInfo actCourse) {
        TrainCourseRecordInfo info = (TrainCourseRecordInfo)courseRecordInfo.clone();
        info.setId(null);
        info.setTrainCourse(actCourse.getTrainCourse());
        if (actCourse.getChannelCourse() != null) {
            info.setTrainInstructor(actCourse.getChannelCourse().getInstructor());
            info.setTrainChannel(actCourse.getChannelCourse().getTrainChannel());
        }
        info.setTrainMethod(actCourse.getTrainingMethod());
        if (actCourse.getStartDate() != null) {
            info.setBeginDateTime(new Timestamp(actCourse.getStartDate().getTime()));
        }
        if (actCourse.getEndDate() != null) {
            info.setEndDateTime(new Timestamp(actCourse.getEndDate().getTime()));
        }
        info.setCourseHour(actCourse.getCourseHour());
        if (actCourse.getCourseHourUnit() != null) {
            info.setCourseHourUnit(actCourse.getCourseHourUnit());
        }
        info.setCourseCost(actCourse.getTotalCost());
        info.setNeedExam(actCourse.isNeedExam());
        info.setPassStand(actCourse.getPassStand());
        info.setAssessMethod(actCourse.getAssessMethod());
        info.setIsPassed(TrainRecordIsPassedEnum.PASSED);
        info.setTrainType(info.getActTrainType());
        info.setTrainingCategory(info.getActTrainingCategory());
        info.setTrainCategory(info.getActTrainCategory());
        info.setEnterPersonInfo(info.isActEnterPersonInfo());
        info.setGiveCertificate(info.isActGiveCertificate());
        return info;
    }

    private Set createTrainActivityRecord(Context ctx, TrainActivityInfo trainActivityInfo, PersonInfo personInfo, TrainActCourseCollection courseColl, TrainCourseRecordInfo courseRecordInfo) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sql = "INSERT INTO T_HR_TrainCourseRecord (FID, FControlUnitID, FEmployeeID, FTrainActivityID, FTrainItemID, FOrgUnitID, FActBeginDate, FActEndDate, FActCost, FActTrainAddress, FActDescription, FTrainCourseID, FTrainInstructorID, FTrainChannelID, FTrainMethodID, FBeginDateTime, FEndDateTime, FCourseHour, FCourseHourUnit, FCourseCost, FNeedExam, FPassStand, FAssessMethodID, FHROrgUnitID, FCreatorID, FCreateTime, FLastUpdateTime,FActAttendAll,FActActualAttend,FActAbsentType,FActAbsent,FActAbsentHour,FActAbsHourUnit,FActTrainMethodID,FTrainChannelID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainActCourseInfo courseInfo = null;
            int size = courseColl.size();
            for (int i = 0; i < size; ++i) {
                courseInfo = courseColl.get(i);
                if (this.isExistTrainRecord(ctx, trainActivityInfo.getId().toString(), personInfo.getId().toString(), courseInfo.getTrainCourse().getId().toString())) continue;
                String id = BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString();
                idSet.add(id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)personInfo.getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)trainActivityInfo.getId().toString());
                if (courseRecordInfo.getTrainItem() == null) {
                    pstmt.setString(5, null);
                } else {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseRecordInfo.getTrainItem().getId().toString());
                }
                if (courseRecordInfo.getOrgUnit() == null) {
                    pstmt.setString(6, null);
                } else {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)courseRecordInfo.getOrgUnit().getId().toString());
                }
                if (courseRecordInfo.getActBeginDate() == null) {
                    pstmt.setDate(7, null);
                } else {
                    pstmt.setDate(7, new Date(courseRecordInfo.getActBeginDate().getTime()));
                }
                if (courseRecordInfo.getActEndDate() == null) {
                    pstmt.setDate(8, null);
                } else {
                    pstmt.setDate(8, new Date(courseRecordInfo.getActEndDate().getTime()));
                }
                pstmt.setBigDecimal(9, courseRecordInfo.getActCost());
                pstmt.setString(10, courseRecordInfo.getActTrainAddress());
                pstmt.setString(11, courseRecordInfo.getActDescription());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)12, (String)courseInfo.getTrainCourse().getId().toString());
                if (courseInfo.getChannelCourse() == null || courseInfo.getChannelCourse().getInstructor() == null) {
                    pstmt.setString(13, null);
                } else {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)13, (String)courseInfo.getChannelCourse().getInstructor().getId().toString());
                }
                if (courseInfo.getChannelCourse() == null) {
                    pstmt.setString(14, null);
                } else {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)14, (String)courseInfo.getChannelCourse().getTrainChannel().getId().toString());
                }
                if (courseInfo.getTrainingMethod() == null) {
                    pstmt.setString(15, null);
                } else {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)15, (String)courseInfo.getTrainingMethod().getId().toString());
                }
                if (courseInfo.getStartDate() == null) {
                    pstmt.setTimestamp(16, null);
                } else {
                    pstmt.setTimestamp(16, new Timestamp(courseInfo.getStartDate().getTime()));
                }
                if (courseInfo.getEndDate() == null) {
                    pstmt.setTimestamp(17, null);
                } else {
                    pstmt.setTimestamp(17, new Timestamp(courseInfo.getEndDate().getTime()));
                }
                pstmt.setBigDecimal(18, courseInfo.getCourseHour());
                if (courseInfo.getCourseHourUnit() == null) {
                    pstmt.setNull(19, 4);
                } else {
                    pstmt.setInt(19, courseInfo.getCourseHourUnit().getValue());
                }
                pstmt.setBigDecimal(20, courseInfo.getTotalCost());
                pstmt.setBoolean(21, courseInfo.isNeedExam());
                pstmt.setBigDecimal(22, courseInfo.getPassStand());
                if (courseInfo.getAssessMethod() == null) {
                    pstmt.setString(23, null);
                } else {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)23, (String)courseInfo.getAssessMethod().getId().toString());
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)24, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)25, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                pstmt.setTimestamp(26, new Timestamp(System.currentTimeMillis()));
                pstmt.setTimestamp(27, new Timestamp(System.currentTimeMillis()));
                pstmt.setBoolean(28, courseRecordInfo.isActAttendAll());
                pstmt.setBigDecimal(29, courseRecordInfo.getActActualAttend());
                if (courseRecordInfo.getActAbsentType() == null) {
                    pstmt.setNull(30, 4);
                } else {
                    pstmt.setInt(30, courseRecordInfo.getActAbsentType().getValue());
                }
                pstmt.setBigDecimal(31, courseRecordInfo.getActAbsent());
                pstmt.setBigDecimal(32, courseRecordInfo.getActAbsentHour());
                if (courseRecordInfo.getActAbsHourUnit() == null) {
                    pstmt.setNull(33, 4);
                } else {
                    pstmt.setInt(33, courseRecordInfo.getActAbsHourUnit().getValue());
                }
                if (courseRecordInfo.getTrainChannel() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)35, (String)courseRecordInfo.getTrainChannel().getId().toString());
                } else {
                    pstmt.setString(35, null);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return idSet;
    }

    private boolean isExistTrainRecord(Context ctx, String trainActivityId, String personId, String trainCourseId) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        fi.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)personId));
        fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseId));
        return this.existRecord(ctx, fi);
    }

    private TrainActCourseCollection getTrainActCourseColllection(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("ChannelCourse.Instructor.id"));
        evi.getSelector().add(new SelectorItemInfo("ChannelCourse.trainChannel.id"));
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.trainAddress"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.target"));
        evi.getSelector().add(new SelectorItemInfo("TrainActivity.trainContent"));
        evi.getSelector().add(new SelectorItemInfo("TrainCourse.name"));
        return TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
    }

    private void checkDup(Context ctx, IObjectValue objectValue, boolean isTrainActivity) throws EASBizException, BOSException {
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        FilterInfo filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, "hrOrgUnit.id");
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)recordInfo.getEmployee().getId().toString()));
        if (recordInfo.getTrainActivity() != null && recordInfo.getTrainActivity().getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)recordInfo.getTrainActivity().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("BeginDateTime", (Object)recordInfo.getBeginDateTime()));
            filterInfo.getFilterItems().add(new FilterItemInfo("EndDateTime", (Object)recordInfo.getEndDateTime()));
        }
        if (recordInfo.getId() != null) {
            Set<String> recordIds = null;
            if (isTrainActivity && recordInfo.getTrainActivity() != null && recordInfo.getTrainActivity().getId() != null) {
                recordIds = this.getRecordIdsByAct(ctx, recordInfo);
            }
            if (recordIds == null || recordIds.size() == 0) {
                recordIds = new HashSet<String>();
                recordIds.add(recordInfo.getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", recordIds, CompareType.NOTINCLUDE));
        }
        if (!isTrainActivity) {
            String courseId = null;
            if (recordInfo.getTrainCourse() != null && recordInfo.getTrainCourse().getId() != null) {
                courseId = recordInfo.getTrainCourse().getId().toString();
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", courseId));
        }
        if (this.existRecord(ctx, filterInfo)) {
            StringBuffer str = new StringBuffer();
            if (recordInfo.getTrainActivity() != null && recordInfo.getTrainActivity().getName() != null) {
                str.append(this._getPropertyAlias(ctx, recordInfo, "TrainActivity"));
                str.append(recordInfo.getTrainActivity().getName());
            }
            if (recordInfo.getTrainCourse() != null && recordInfo.getTrainCourse().getName() != null) {
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(this._getPropertyAlias(ctx, recordInfo, "TrainCourse"));
                str.append(recordInfo.getTrainCourse().getName());
            }
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{str.toString()});
        }
    }

    private Set getRecordIdsByAct(Context ctx, TrainCourseRecordInfo recordInfo) throws BOSException, EASBizException {
        HashSet<String> result = new HashSet<String>();
        TrainCourseRecordInfo oldInfo = (TrainCourseRecordInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(recordInfo.getId().toString()));
        if (oldInfo.getTrainActivity() != null && oldInfo.getTrainActivity().getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, "hrOrgUnit.id");
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)oldInfo.getEmployee().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)oldInfo.getTrainActivity().getId().toString()));
            viewInfo.setFilter(filterInfo);
            TrainCourseRecordCollection collection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
            for (int i = 0; i < collection.size(); ++i) {
                result.add(collection.get(i).getId().toString());
            }
        } else {
            result.add(recordInfo.getId().toString());
        }
        return result;
    }

    private boolean existRecord(Context ctx, FilterInfo filterInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.setFilter(filterInfo);
        TrainCourseRecordCollection collection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        return collection != null && collection.size() > 0;
    }

    private void updateCourse(Context ctx, IObjectValue objectValue) throws BOSException {
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        this.updateTypeCourse(ctx, recordInfo);
    }

    private void updateTypeCourse(Context ctx, TrainCourseRecordInfo recordInfo) throws BOSException {
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_HR_TrainCourseRecord set FActTrainType = ?,FTrainType = ?, FTrainActivityID = ?,FTrainPlanActivityID = ?,FTrainPlanID =?");
            sql.append(" where FID = ?");
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            int index = 1;
            if (TrainTypeEnum.INNERTRAINTYPE.equals((Object)recordInfo.getTrainType())) {
                if (recordInfo.getTrainType() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainType().getValue());
                } else {
                    pstm.setString(index++, null);
                }
                if (recordInfo.getTrainType() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainType().getValue());
                } else {
                    pstm.setString(index++, null);
                }
                if (recordInfo.getTrainActivity() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainActivity().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
                pstm.setNull(index++, 12);
                pstm.setNull(index++, 12);
            } else if (TrainTypeEnum.OUTTRAINTYPE.equals((Object)recordInfo.getTrainType())) {
                if (recordInfo.getTrainType() != null) {
                    pstm.setString(index++, recordInfo.getTrainType().getValue());
                } else {
                    pstm.setString(index++, null);
                }
                if (recordInfo.getTrainType() != null) {
                    pstm.setString(index++, recordInfo.getTrainType().getValue());
                } else {
                    pstm.setString(index++, null);
                }
                if (recordInfo.getTrainActivity() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainActivity().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
                if (recordInfo.getTrainPlanActivity() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainPlanActivity().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
                if (recordInfo.getTrainPlan() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainPlan().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getId().toString());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    private void updateSameCourse(Context ctx, IObjectValue objectValue) throws BOSException {
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        if (recordInfo.getTrainActivity() != null && recordInfo.getTrainCourse() != null) {
            this.batchUpdateCourseRecord(ctx, recordInfo);
            this.batchUpdateOrgUnitandChannel(ctx, recordInfo);
        }
    }

    private void batchUpdateCourseRecord(Context ctx, TrainCourseRecordInfo recordInfo) throws BOSException {
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_HR_TrainCourseRecord set FTrainChannelID = ?, FTrainInstructorID = ?, FTrainMethodID = ?, ");
            sql.append("FCourseHour = ?, FCourseHourUnit = ?, FBeginDateTime = ?, FEndDateTime = ?, ");
            sql.append("FAssessMethodID = ?, FPassStand = ?, FTrainAddress = ?,");
            sql.append("FTrainCatagoryID = ?, FTrainingCategoryID = ?");
            sql.append(" where FTrainActivityID = ? and FTrainCourseID = ?");
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            int index = 1;
            if (recordInfo.getTrainChannel() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainChannel().getId().toString());
            } else {
                pstm.setNull(index++, 12);
            }
            if (recordInfo.getTrainInstructor() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainInstructor().getId().toString());
            } else {
                pstm.setNull(index++, 12);
            }
            if (recordInfo.getTrainMethod() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainMethod().getId().toString());
            } else {
                pstm.setNull(index++, 12);
            }
            if (recordInfo.getCourseHour() != null) {
                pstm.setBigDecimal(index++, recordInfo.getCourseHour());
            } else {
                pstm.setNull(index++, 3);
            }
            if (recordInfo.getCourseHourUnit() != null) {
                pstm.setInt(index++, recordInfo.getCourseHourUnit().getValue());
            } else {
                pstm.setNull(index++, 4);
            }
            if (recordInfo.getBeginDateTime() != null) {
                pstm.setTimestamp(index++, recordInfo.getBeginDateTime());
            } else {
                pstm.setNull(index++, 93);
            }
            if (recordInfo.getEndDateTime() != null) {
                pstm.setTimestamp(index++, recordInfo.getEndDateTime());
            } else {
                pstm.setNull(index++, 93);
            }
            if (recordInfo.getAssessMethod() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getAssessMethod().getId().toString());
            } else {
                pstm.setNull(index++, 12);
            }
            if (recordInfo.getPassStand() != null) {
                pstm.setBigDecimal(index++, recordInfo.getPassStand());
            } else {
                pstm.setNull(index++, 3);
            }
            pstm.setString(index++, recordInfo.getTrainAddress());
            if (recordInfo.getTrainCategory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainCategory().getId().toString());
            } else {
                pstm.setString(index++, null);
            }
            if (recordInfo.getTrainingCategory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainingCategory().getId().toString());
            } else {
                pstm.setString(index++, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainActivity().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainCourse().getId().toString());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    private void batchUpdateOrgUnitandChannel(Context ctx, TrainCourseRecordInfo recordInfo) throws BOSException {
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_HR_TrainCourseRecord set FTrainChannelID = ?, FOrgUnitID = ?");
            sql.append(" where FTrainActivityID = ? ");
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            int index = 1;
            if (recordInfo.getTrainChannel() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainChannel().getId().toString());
            } else {
                pstm.setNull(index++, 12);
            }
            if (recordInfo.getOrgUnit() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getOrgUnit().getId().toString());
            } else {
                pstm.setString(index++, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)recordInfo.getTrainActivity().getId().toString());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    protected void _updateActContractID(Context ctx, String recordId, String empContractId) throws BOSException, EASBizException {
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        contractInfo.setId(BOSUuid.read((String)empContractId));
        TrainCourseRecordCollection collection = this.getCourseRecordCollection(ctx, recordId);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                TrainCourseRecordInfo info = collection.get(i);
                info.setActContract(contractInfo);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
            }
        } else {
            TrainCourseRecordInfo info = new TrainCourseRecordInfo();
            info.setId(BOSUuid.read((String)recordId));
            if (!StringUtils.isEmpty((String)empContractId)) {
                info.setActContract(contractInfo);
            } else {
                info.setActContract(null);
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(recordId), (IObjectValue)info);
        }
    }

    private TrainCourseRecordCollection getCourseRecordCollection(Context ctx, String recordId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Employee.id"));
        sic.add(new SelectorItemInfo("TrainActivity.id"));
        sic.add(new SelectorItemInfo("actCertificate.id"));
        TrainCourseRecordInfo info = (TrainCourseRecordInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(recordId), sic);
        TrainCourseRecordCollection collection = null;
        if (info.getTrainActivity() != null) {
            collection = this.getCourseRecordCollection(ctx, info);
        }
        return collection;
    }

    private TrainCourseRecordCollection getCourseRecordCollection(Context ctx, TrainCourseRecordInfo info) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)info.getEmployee().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)info.getTrainActivity().getId().toString()));
        viewInfo.setFilter(fi);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actContract.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.id"));
        TrainCourseRecordCollection collection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        return collection;
    }

    protected void _updateCourseContractID(Context ctx, String recordId, String contractId) throws BOSException, EASBizException {
        TrainCourseRecordInfo info = new TrainCourseRecordInfo();
        info.setId(BOSUuid.read((String)recordId));
        if (!StringUtils.isEmpty((String)contractId)) {
            EmployeeContractInfo contractInfo = new EmployeeContractInfo();
            contractInfo.setId(BOSUuid.read((String)contractId));
            info.setEmpContract(contractInfo);
        } else {
            info.setEmpContract(null);
        }
        this._update(ctx, (IObjectPK)new ObjectUuidPK(recordId), (IObjectValue)info);
    }

    protected void _updateActCertifyID(Context ctx, String recordId, String personCertifId) throws BOSException, EASBizException {
        if (recordId == null) {
            return;
        }
        TrainCourseRecordCollection collection = this.getCourseRecordCollection(ctx, recordId);
        if (personCertifId != null) {
            PersonCertificationInfo cationInfo = new PersonCertificationInfo();
            cationInfo.setId(BOSUuid.read((String)personCertifId));
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    TrainCourseRecordInfo info = collection.get(i);
                    info.setActCertificate(cationInfo);
                    this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
                }
            } else {
                TrainCourseRecordInfo info = new TrainCourseRecordInfo();
                info.setId(BOSUuid.read((String)recordId));
                if (!StringUtils.isEmpty((String)personCertifId)) {
                    info.setActCertificate(cationInfo);
                } else {
                    info.setActCertificate(null);
                }
                this._update(ctx, (IObjectPK)new ObjectUuidPK(recordId), (IObjectValue)info);
            }
        } else if (collection.size() != 0 && collection.get(0).getActCertificate() != null) {
            String certificateId = collection.get(0).getActCertificate().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("actCertificate.id"));
            for (int i = 0; i < collection.size(); ++i) {
                TrainCourseRecordInfo info = collection.get(i);
                info.setActCertificate(null);
                this.updatePartial(ctx, (CoreBaseInfo)info, sic);
            }
            PersonCertificationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(certificateId));
        }
    }

    protected void _updateCourseCertifyID(Context ctx, String recordId, String certifyId) throws BOSException, EASBizException {
        if (recordId == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("EmpCertificatio.id"));
        TrainCourseRecordInfo info = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(recordId), sic);
        if (info == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)certifyId)) {
            PersonCertificationInfo cationInfo = new PersonCertificationInfo();
            cationInfo.setId(BOSUuid.read((String)certifyId));
            info.setEmpCertificatio(cationInfo);
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        } else if (info != null && info.getEmpCertificatio() != null) {
            String cId = info.getEmpCertificatio().getId().toString();
            info.setEmpCertificatio(null);
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
            PersonCertificationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(cId));
        }
    }

    protected String _isTrainRecordExist(Context ctx, String trainCourseId, String empId, String trainActiviryId, Timestamp beginDateTime, Timestamp endDateTime) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _submitTrainCourseRecord(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        this.checkDup(ctx, objectValue, false);
        this.checkCourse(ctx, objectValue, false);
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        this.setTrainRecordDefaultValues(ctx, recordInfo);
        TrainCourseRecordInfo orgDbInfo = null;
        boolean flag = false;
        if (recordInfo.getId() != null) {
            flag = true;
            orgDbInfo = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(recordInfo.getId().toString()));
        }
        if (recordInfo.getTrainActivity() == null) {
            recordInfo.setActBeginDate(null);
            recordInfo.setActEndDate(null);
        }
        TrainActivityInfo trainActivityInfo = recordInfo.getTrainActivity();
        PersonInfo personInfo = recordInfo.getEmployee();
        TrainStudentInfo studentInfo = new TrainStudentInfo();
        studentInfo.setTrainActivity(trainActivityInfo);
        studentInfo.setPerson(personInfo);
        studentInfo.setType(TrainStudentTypeEnum.FORMAL);
        studentInfo.setOrgStudent(recordInfo.getRecordExtends().getOrgStudent());
        studentInfo.setPosiStudent(recordInfo.getRecordExtends().getPosiStudent());
        TrainStudentFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)studentInfo);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)recordInfo.getTrainCourse().getId().toString()));
        if (trainActivityInfo != null && trainActivityInfo.getId().toString() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityInfo.getId().toString()));
        }
        ev.setFilter(filterInfo);
        ev.getSelector().add(new SelectorItemInfo("*"));
        TrainActCourseCollection coll = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(ev);
        TrainStudentCourseInfo trainStudentCourseInfo = new TrainStudentCourseInfo();
        ITrainStudentCourse iTrainStudentCourse = TrainStudentCourseFactory.getLocalInstance(ctx);
        if (coll != null && coll.size() > 0) {
            trainStudentCourseInfo.setTrainActCourse(coll.get(0));
        }
        trainStudentCourseInfo.setPerson(personInfo);
        trainStudentCourseInfo.setType(TrainStudentTypeEnum.FORMAL);
        trainStudentCourseInfo.setOrgStudent(recordInfo.getRecordExtends().getOrgStudent());
        trainStudentCourseInfo.setPosiStudent(recordInfo.getRecordExtends().getPosiStudent());
        iTrainStudentCourse.addnew((CoreBaseInfo)trainStudentCourseInfo);
        IObjectPK pk = this._submit(ctx, (IObjectValue)recordInfo);
        this.updateSameCourse(ctx, objectValue);
        this.updateSameCourseInfoByExt(ctx, objectValue, flag);
        this.updateCourse(ctx, objectValue);
        if (flag && recordInfo.isEnterPersonInfo() && !orgDbInfo.isEnterPersonInfo()) {
            this.updateTrainActCourseEnterInfo(ctx, recordInfo);
        }
        return pk;
    }

    private void setTrainRecordDefaultValues(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo) throws BOSException, EASBizException {
        TrainCourseRecordInfo recordInfo;
        TrainCourseRecordCollection records;
        String trainActivityId;
        if (trainCourseRecordInfo.getId() == null && "TrainCourseRecord".equals(trainCourseRecordInfo.get("come_from")) && trainCourseRecordInfo.getTrainActivity() != null) {
            trainActivityId = trainCourseRecordInfo.getTrainActivity().getId().toString();
            records = this.getCourseRecords(ctx, trainCourseRecordInfo.getEmployee().getId().toString(), trainActivityId);
            if (records != null && records.size() > 0) {
                recordInfo = records.get(0);
                if (recordInfo.getRecordExtends() != null && recordInfo.getRecordExtends().getPosiStudent() != null && recordInfo.getRecordExtends().getOrgStudent() != null) {
                    trainCourseRecordInfo.getRecordExtends().setPosiStudent(recordInfo.getRecordExtends().getPosiStudent());
                    trainCourseRecordInfo.getRecordExtends().setOrgStudent(recordInfo.getRecordExtends().getOrgStudent());
                    trainCourseRecordInfo.getRecordExtends().setTrainContent(recordInfo.getRecordExtends().getTrainContent());
                    trainCourseRecordInfo.getRecordExtends().setActAssessValue(recordInfo.getRecordExtends().getActAssessValue());
                }
                this.setTrainRecordProperties((CoreBaseInfo)trainCourseRecordInfo, (CoreBaseInfo)records.get(0));
            } else {
                records = this.getCourseRecords(ctx, null, trainActivityId);
                if (records != null && records.size() > 0) {
                    records.get(0).setActCost(trainCourseRecordInfo.getActCost());
                    this.setTrainRecordProperties((CoreBaseInfo)trainCourseRecordInfo, (CoreBaseInfo)records.get(0));
                } else {
                    TrainActivityInfo trainActivityInfo = this.getTrainActivityInfo(ctx, trainActivityId);
                    this.setTrainRecordPropertiesByActivity(trainCourseRecordInfo, trainActivityInfo);
                }
            }
            if (trainCourseRecordInfo.getActCost() != null && trainCourseRecordInfo.getIsPassed() == null) {
                trainCourseRecordInfo.setIsPassed(TrainRecordIsPassedEnum.PASSED);
            }
            if (trainCourseRecordInfo.getActIsPassed() == null) {
                trainCourseRecordInfo.setActIsPassed(TrainRecordIsPassedEnum.PASSED);
            }
        }
        if (trainCourseRecordInfo.getId() != null && trainCourseRecordInfo.getTrainActivity() != null) {
            trainActivityId = trainCourseRecordInfo.getTrainActivity().getId().toString();
            records = this.getCourseRecordChannel(ctx, trainCourseRecordInfo.getEmployee().getId().toString(), trainActivityId);
            if (records != null && records.size() > 0) {
                recordInfo = records.get(0);
                trainCourseRecordInfo.setTrainChannel(recordInfo.getTrainChannel());
            }
        }
        if (trainCourseRecordInfo.getRecordExtends() != null) {
            PositionInfo positionInfo = null;
            PersonInfo personInfo = trainCourseRecordInfo.getEmployee();
            if (personInfo != null) {
                BOSUuid personId = trainCourseRecordInfo.getEmployee().getId();
                if (trainCourseRecordInfo.getRecordExtends().getPosiStudent() == null) {
                    IRowSet rowSet;
                    positionInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(personId);
                    String sql = "SELECT FID, FGKAdminID FROM T_HR_PersonPosition WHERE FPersonID = '" + personId + "'";
                    if (positionInfo == null && (rowSet = DbUtil.executeQuery((Context)ctx, (String)sql)) != null) {
                        try {
                            positionInfo = new PositionInfo();
                            rowSet.beforeFirst();
                            while (rowSet.next()) {
                                positionInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                                AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                                adminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FGKAdminID")));
                                positionInfo.setAdminOrgUnit(adminOrgUnitInfo);
                            }
                        }
                        catch (SQLException e) {
                            logger.error((Object)e.getMessage());
                        }
                    }
                    trainCourseRecordInfo.getRecordExtends().setPosiStudent(positionInfo);
                }
                if (trainCourseRecordInfo.getRecordExtends().getOrgStudent() == null) {
                    AdminOrgUnitInfo adminOrgUnitInfo = null;
                    adminOrgUnitInfo = positionInfo == null ? PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(trainCourseRecordInfo.getEmployee().getId()) : positionInfo.getAdminOrgUnit();
                    trainCourseRecordInfo.getRecordExtends().setOrgStudent(adminOrgUnitInfo);
                }
            }
        }
    }

    private TrainCourseRecordCollection getCourseRecordChannel(Context ctx, String employeeId, String trainActivityId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.id"));
        FilterInfo filterInfo = new FilterInfo();
        if (employeeId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
    }

    private TrainCourseRecordCollection getCourseRecords(Context ctx, String employeeId, String trainActivityId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainingCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainType"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainAddress"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("actBeginDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actEndDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actPassStandard"));
        viewInfo.getSelector().add(new SelectorItemInfo("actShouldAttend"));
        viewInfo.getSelector().add(new SelectorItemInfo("actNeedExam"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAttendAll"));
        if (employeeId != null) {
            viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent"));
            viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent"));
            viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.trainContent"));
            viewInfo.getSelector().add(new SelectorItemInfo("actActualAttend"));
            viewInfo.getSelector().add(new SelectorItemInfo("actAbsentHour"));
            viewInfo.getSelector().add(new SelectorItemInfo("actAbsHourUnit"));
            viewInfo.getSelector().add(new SelectorItemInfo("actAbsent"));
            viewInfo.getSelector().add(new SelectorItemInfo("actAbsentType"));
            viewInfo.getSelector().add(new SelectorItemInfo("actDescription"));
            viewInfo.getSelector().add(new SelectorItemInfo("actIsPassed"));
            viewInfo.getSelector().add(new SelectorItemInfo("actAssessScore"));
        }
        FilterInfo filterInfo = new FilterInfo();
        if (employeeId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
    }

    private void setTrainRecordProperties(CoreBaseInfo destInfo, CoreBaseInfo srcInfo) {
        if (srcInfo == null || destInfo == null) {
            return;
        }
        Enumeration keys = srcInfo.keys();
        String key = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (key.equalsIgnoreCase("id") || key.equalsIgnoreCase("trainactivity") || key.equalsIgnoreCase("traincourse") || key.equalsIgnoreCase("employee") || key.equalsIgnoreCase("parent")) continue;
            if (key.equalsIgnoreCase("recordExtends")) {
                this.setTrainRecordProperties(((TrainCourseRecordInfo)destInfo).getRecordExtends(), ((TrainCourseRecordInfo)srcInfo).getRecordExtends());
                continue;
            }
            destInfo.put(key, srcInfo.get(key));
        }
    }

    private TrainActivityInfo getTrainActivityInfo(Context ctx, String trainActivityId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("trainChanne.id"));
        sic.add(new SelectorItemInfo("trainItem.id"));
        sic.add(new SelectorItemInfo("trainItem.number"));
        sic.add(new SelectorItemInfo("trainItem.name"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("BudgetCost"));
        sic.add(new SelectorItemInfo("orgPerson.id"));
        sic.add(new SelectorItemInfo("orgPerson.number"));
        sic.add(new SelectorItemInfo("orgPerson.name"));
        sic.add(new SelectorItemInfo("trainAddress"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("needAssess"));
        sic.add(new SelectorItemInfo("passStand"));
        sic.add(new SelectorItemInfo("assessMethod.id"));
        sic.add(new SelectorItemInfo("assessMethod.name"));
        sic.add(new SelectorItemInfo("trainMethod.id"));
        sic.add(new SelectorItemInfo("trainType"));
        sic.add(new SelectorItemInfo("trainCatagory.id"));
        sic.add(new SelectorItemInfo("trainingCategor.id"));
        return TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), sic);
    }

    private void setTrainRecordPropertiesByActivity(TrainCourseRecordInfo trainCourseRecordInfo, TrainActivityInfo trainActivityInfo) {
        trainCourseRecordInfo.setActBeginDate(trainActivityInfo.getTrainStartDate());
        trainCourseRecordInfo.setActEndDate(trainActivityInfo.getTrainEndDate());
        trainCourseRecordInfo.setActCost(trainActivityInfo.getBudgetCost());
        trainCourseRecordInfo.setActTrainAddress(trainActivityInfo.getTrainAddress());
        trainCourseRecordInfo.setActDescription(trainActivityInfo.getDescription());
        trainCourseRecordInfo.setActNeedExam(trainActivityInfo.isNeedExam());
        trainCourseRecordInfo.setActPassStandard(trainActivityInfo.getPassStand());
        trainCourseRecordInfo.setActTrainMethod(trainActivityInfo.getTrainMethod());
        trainCourseRecordInfo.setActTrainType(trainActivityInfo.getTrainType());
        trainCourseRecordInfo.setActTrainingCategory(trainActivityInfo.getTrainingCategor());
        trainCourseRecordInfo.setActTrainCategory(trainActivityInfo.getTrainCatagory());
        if (trainActivityInfo.isNeedAssess()) {
            trainCourseRecordInfo.setActAssessMethod(trainActivityInfo.getAssessMethod());
        }
        trainCourseRecordInfo.setIsPassed(TrainRecordIsPassedEnum.PASSED);
    }

    private void updateTrainActCourseEnterInfo(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainCourseRecord SET FActEnterPersonInfo = ?  WHERE FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            pstmt.setBoolean(index++, trainCourseRecordInfo.isEnterPersonInfo());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IObjectPK submitRecord(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        this.checkDup(ctx, objectValue, false);
        this.checkCourse(ctx, objectValue, false);
        IObjectPK pk = this._submit(ctx, objectValue);
        this.updateSameCourse(ctx, objectValue);
        return pk;
    }

    private void checkCourse(Context ctx, IObjectValue objectValue, boolean isActivity) throws BOSException, EASBizException {
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        TrainActivityInfo activityInfo = recordInfo.getTrainActivity();
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)activityInfo)) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)activityInfo.getId().toString()));
            if (recordInfo.getTrainType() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)recordInfo.getTrainType().getValue()));
            }
            if (!TrainActivityFactory.getLocalInstance(ctx).exists(filterInfo)) {
                throw new TrainRecordException(TrainRecordException.TRAINTYPE_NOT_MATCH);
            }
            TrainCourseInfo courseInfo = recordInfo.getTrainCourse();
            if (!TrainCommonUtils.isEmpty((CoreBaseInfo)activityInfo) && !TrainCommonUtils.isEmpty((CoreBaseInfo)courseInfo)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.getSelector().add(new SelectorItemInfo("id"));
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)activityInfo.getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)courseInfo.getId().toString()));
                viewInfo.setFilter(filterInfo);
                TrainActCourseCollection collection = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(viewInfo);
                if (collection == null || collection.size() == 0) {
                    if (isActivity) {
                        throw new TrainRecordException(TrainRecordException.TRAINACTIVITY_ERROR, new Object[]{activityInfo.getName(), courseInfo.getName()});
                    }
                    throw new TrainRecordException(TrainRecordException.TRAINCOURSE_ERROR, new Object[]{courseInfo.getName(), activityInfo.getName()});
                }
            }
        }
    }

    protected IObjectPK _submitTrainActivityRecord(Context ctx, IObjectValue objectValue, boolean isTrainActivityRecord) throws BOSException, EASBizException {
        TrainCourseRecordCollection collection;
        TrainCourseRecordInfo trainCourseRecordInfo = (TrainCourseRecordInfo)objectValue;
        TrainActivityInfo trainActivityInfo = trainCourseRecordInfo.getTrainActivity();
        PersonInfo personInfo = trainCourseRecordInfo.getEmployee();
        TrainCourseRecordInfo orgDbInfo = null;
        if (trainActivityInfo == null) {
            IObjectPK pk = this._submit(ctx, objectValue);
            return pk;
        }
        if (isTrainActivityRecord) {
            this.checkDup(ctx, objectValue, true);
            IObjectPK pk = null;
            if (trainCourseRecordInfo.getId() == null) {
                TrainStudentInfo studentInfo = new TrainStudentInfo();
                studentInfo.setTrainActivity(trainActivityInfo);
                studentInfo.setPerson(personInfo);
                studentInfo.setType(TrainStudentTypeEnum.FORMAL);
                studentInfo.setOrgStudent(trainCourseRecordInfo.getRecordExtends().getOrgStudent());
                studentInfo.setPosiStudent(trainCourseRecordInfo.getRecordExtends().getPosiStudent());
                TrainStudentFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)studentInfo);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityInfo.getId().toString()));
                evi.setFilter(fi);
                evi.getSelector().add(new SelectorItemInfo("id"));
                TrainActCourseCollection courseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
                TrainActCourseInfo courseInfo = null;
                TrainStudentCourseInfo trainStudentCourseInfo = null;
                ITrainStudentCourse iTrainStudentCourse = TrainStudentCourseFactory.getLocalInstance(ctx);
                int size = courseColl.size();
                for (int i = 0; i < size; ++i) {
                    trainStudentCourseInfo = new TrainStudentCourseInfo();
                    courseInfo = courseColl.get(i);
                    trainStudentCourseInfo.setTrainActCourse(courseInfo);
                    trainStudentCourseInfo.setPerson(personInfo);
                    trainStudentCourseInfo.setType(TrainStudentTypeEnum.FORMAL);
                    trainStudentCourseInfo.setOrgStudent(trainCourseRecordInfo.getRecordExtends().getOrgStudent());
                    trainStudentCourseInfo.setPosiStudent(trainCourseRecordInfo.getRecordExtends().getPosiStudent());
                    iTrainStudentCourse.addnew((CoreBaseInfo)trainStudentCourseInfo);
                }
                pk = this.batchCreateRecord(ctx, trainCourseRecordInfo, trainActivityInfo, personInfo, pk);
            } else {
                TrainCourseRecordInfo dbInfo = (TrainCourseRecordInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(trainCourseRecordInfo.getId().toString()));
                orgDbInfo = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(trainCourseRecordInfo.getId().toString()));
                pk = TrainCommonUtils.isEmpty((CoreBaseInfo)dbInfo.getTrainActivity()) ? this.batchCreateRecord(ctx, trainCourseRecordInfo, trainActivityInfo, personInfo, pk) : this._submit(ctx, objectValue);
                if (!String.valueOf(orgDbInfo.isActEnterPersonInfo()).equals(String.valueOf(trainCourseRecordInfo.isActEnterPersonInfo()))) {
                    this.updateCourseRecordEnterPerson(ctx, trainCourseRecordInfo, trainActivityInfo, personInfo, pk);
                }
            }
            this.updateSameTrainActivity(ctx, objectValue);
            return pk;
        }
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        if (recordInfo.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("TrainCourse.name"));
            TrainCourseRecordInfo dbInfo = (TrainCourseRecordInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(recordInfo.getId().toString()), sic);
            recordInfo.setTrainCourse(dbInfo.getTrainCourse());
        }
        this.checkDup(ctx, (IObjectValue)recordInfo, false);
        this.checkCourse(ctx, (IObjectValue)recordInfo, true);
        if (recordInfo.getId() == null && recordInfo.getTrainActivity() != null && recordInfo.getTrainActivity().getId() != null && (collection = this.getCourseRecordCollection(ctx, recordInfo)) != null && collection.size() > 0) {
            recordInfo.setActContract(collection.get(0).getActContract());
            recordInfo.setActCertificate(collection.get(0).getActCertificate());
        }
        IObjectPK pk = this._submit(ctx, (IObjectValue)recordInfo);
        this.updateSameTrainActivity(ctx, (IObjectValue)recordInfo);
        this.dealTrainRewardsAndThoughts(ctx, trainActivityInfo.getId().toString(), personInfo.getId().toString());
        return pk;
    }

    private void updateCourseRecordEnterPerson(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo, TrainActivityInfo trainActivityInfo, PersonInfo personInfo, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainCourseRecord SET FEnterPersonInfo = ?  WHERE FTrainActivityID = ? AND FEmployeeID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            pstmt.setBoolean(index++, trainCourseRecordInfo.isActEnterPersonInfo());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getTrainActivity().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getEmployee().getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void createBatchCourseRecord(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo, TrainActivityInfo trainActivityInfo) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainCourseRecord SET FTrainType= ?, FTrainingCategoryID = ?, FTrainCatagoryID = ? ,FEnterPersonInfo = ?  WHERE FTrainActivityID = ? AND FEmployeeID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            if (trainActivityInfo.getTrainType() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainType().getValue());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainActivityInfo.getTrainingCategor() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainingCategor().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            if (trainActivityInfo.getTrainCatagory() != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainCatagory().getId().toString());
            } else {
                pstmt.setString(index++, null);
            }
            pstmt.setBoolean(index++, Boolean.TRUE);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getTrainActivity().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainCourseRecordInfo.getEmployee().getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void batchUpdateTrainActivityRecord(Context ctx, Set ids) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainCourseRecord SET FActTrainType= ?, FActTrainingCategoryID = ?, FActTrainCatagoryID = ?,FTrainType= ?, FTrainingCategoryID = ?, FTrainCatagoryID = ?  WHERE FID = ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        TrainActivityInfo trainActivityInfo = null;
        HashSet<String> tempIds = new HashSet<String>();
        String courseId = null;
        String tempCourseId = null;
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            courseId = it.next().toString();
            tempIds.add(courseId);
        }
        TrainCourseRecordInfo info = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(courseId));
        if (info.getTrainActivity() != null) {
            trainActivityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(info.getTrainActivity().getId().toString()));
        }
        try {
            Iterator tempIt = tempIds.iterator();
            while (tempIt.hasNext()) {
                tempCourseId = tempIt.next().toString();
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                int index = 1;
                if (trainActivityInfo.getTrainType() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainType().getValue());
                } else {
                    pstmt.setString(index++, null);
                }
                if (trainActivityInfo.getTrainingCategor() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainingCategor().getId().toString());
                } else {
                    pstmt.setString(index++, null);
                }
                if (trainActivityInfo.getTrainCatagory() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainCatagory().getId().toString());
                } else {
                    pstmt.setString(index++, null);
                }
                if (info.getTrainCourse() != null) {
                    if (trainActivityInfo.getTrainType() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainType().getValue());
                    } else {
                        pstmt.setString(index++, null);
                    }
                    if (trainActivityInfo.getTrainingCategor() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainingCategor().getId().toString());
                    } else {
                        pstmt.setString(index++, null);
                    }
                    if (trainActivityInfo.getTrainCatagory() != null) {
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)trainActivityInfo.getTrainCatagory().getId().toString());
                    } else {
                        pstmt.setString(index++, null);
                    }
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)tempCourseId);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt, conn);
        }
    }

    private IObjectPK batchCreateRecord(Context ctx, TrainCourseRecordInfo trainCourseRecordInfo, TrainActivityInfo trainActivityInfo, PersonInfo personInfo, IObjectPK pk) throws BOSException, EASBizException {
        TrainActCourseCollection courseColl = this.getTrainActCourseColllection(ctx, trainActivityInfo.getId().toString());
        Set ids = this.createTrainActivityRecord(ctx, trainCourseRecordInfo, courseColl);
        if (ids.size() != 0) {
            this.dealTrainRewardsAndThoughts(ctx, trainActivityInfo.getId().toString(), personInfo.getId().toString());
            pk = new ObjectUuidPK(ids.iterator().next().toString());
        }
        return pk;
    }

    private void dealTrainRewardsAndThoughts(Context ctx, String trainActivityId, String personId) throws BOSException, EASBizException {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)personId));
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        TrainCourseRecordCollection trainCourseRecordCollection = this.getTrainCourseRecordCollection(ctx, evi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActRecord.Employee.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActRecord.TrainActivity.id", (Object)trainActivityId));
        viewInfo.setFilter(filterInfo);
        TrainRewardsCollection trainRewardsCollection = TrainRewardsFactory.getLocalInstance(ctx).getTrainRewardsCollection(viewInfo);
        TrainThoughtCollection trainThoughtCollection = TrainThoughtFactory.getLocalInstance(ctx).getTrainThoughtCollection(viewInfo);
        TrainCourseRecordInfo trainCourseRecordInfo = null;
        int size = trainCourseRecordCollection.size();
        for (i = 0; i < size; ++i) {
            trainCourseRecordInfo = trainCourseRecordCollection.get(i);
            if (this.isExistTrainCourseRecord(trainRewardsCollection, trainCourseRecordInfo.getId().toString()) || trainRewardsCollection.size() == 0) continue;
            TrainRewardsInfo trainRewardsInfo = trainRewardsCollection.get(0);
            trainRewardsInfo.setId(null);
            trainRewardsInfo.setTrainActRecord(trainCourseRecordInfo);
            TrainRewardsFactory.getLocalInstance(ctx).submit((CoreBaseInfo)trainRewardsInfo);
        }
        size = trainCourseRecordCollection.size();
        for (i = 0; i < size; ++i) {
            trainCourseRecordInfo = trainCourseRecordCollection.get(i);
            if (this.isExistTrainCourseRecord(trainThoughtCollection, trainCourseRecordInfo.getId().toString()) || trainThoughtCollection.size() == 0) continue;
            TrainThoughtInfo trainThoughtInfo = trainThoughtCollection.get(0);
            trainThoughtInfo.setId(null);
            trainThoughtInfo.setTrainActRecord(trainCourseRecordInfo);
            TrainThoughtFactory.getLocalInstance(ctx).submit((CoreBaseInfo)trainThoughtInfo);
        }
    }

    private boolean isExistTrainCourseRecord(TrainThoughtCollection trainThoughtCollection, String trainCourseRecordId) {
        TrainThoughtInfo trainThoughtInfo = null;
        int size = trainThoughtCollection.size();
        for (int i = 0; i < size; ++i) {
            trainThoughtInfo = trainThoughtCollection.get(i);
            if (trainThoughtInfo.getTrainActRecord() == null || !trainThoughtInfo.getTrainActRecord().getId().toString().equals(trainCourseRecordId)) continue;
            return true;
        }
        return false;
    }

    private boolean isExistTrainCourseRecord(TrainRewardsCollection trainRewardsCollection, String trainCourseRecordId) {
        TrainRewardsInfo trainRewardsInfo = null;
        int size = trainRewardsCollection.size();
        for (int i = 0; i < size; ++i) {
            trainRewardsInfo = trainRewardsCollection.get(i);
            if (trainRewardsInfo.getTrainActRecord() == null || !trainRewardsInfo.getTrainActRecord().getId().toString().equals(trainCourseRecordId)) continue;
            return true;
        }
        return false;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Employee.name"));
        sic.add(new SelectorItemInfo("TrainActivity.name"));
        sic.add(new SelectorItemInfo("TrainCourse.name"));
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)this._getValue(ctx, pk, sic);
        return recordInfo.getLogInfo();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainCouRecord.id", (Object)pk.toString()));
        fi.getFilterItems().add(new FilterItemInfo("TrainActRecord.id", (Object)pk.toString()));
        fi.setMaskString("#0 OR #1");
        TrainRewardsFactory.getLocalInstance(ctx).delete(fi);
        TrainThoughtFactory.getLocalInstance(ctx).delete(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("TrainActivity.id"));
        sic.add(new SelectorItemInfo("Employee.id"));
        sic.add(new SelectorItemInfo("recordExtends.isApproved"));
        TrainCourseRecordInfo info = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo(pk, sic);
        if (!info.getRecordExtends().isIsApproved()) {
            super._delete(ctx, pk);
            try {
                if (info.getTrainActivity() != null) {
                    this.setAuditStateByDelete(ctx, info);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected IObjectPK[] _submitRecordBatch(Context ctx, HashMap recordMap, boolean isActivity, String flag) throws BOSException, EASBizException {
        if (recordMap == null || recordMap.size() == 0) {
            return null;
        }
        if ("evaluRecord".equals(flag)) {
            return this.batchSubmitEvaluScore(ctx, recordMap, isActivity);
        }
        if ("attendence".equals(flag)) {
            IObjectPK[] objs = new IObjectPK[recordMap.size()];
            objs = isActivity ? this.batchSubmitActRecord(ctx, recordMap) : this.batchSubmitCoruseRecord(ctx, recordMap);
            return objs;
        }
        IObjectPK[] objs = new IObjectPK[recordMap.size()];
        objs = isActivity ? this.batchUpdateActCost(ctx, recordMap) : this.batchUpdateCourseCost(ctx, recordMap);
        return objs;
    }

    private IObjectPK[] batchUpdateActCost(Context ctx, HashMap recordMap) throws BOSException {
        IObjectPK[] objs = new IObjectPK[recordMap.size()];
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_trainCourseRecord set FActCost = ?");
        sb.append(" where FID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            TrainCourseRecordInfo courseRecordInfo = null;
            Iterator it = recordMap.values().iterator();
            int index = 0;
            while (it.hasNext()) {
                courseRecordInfo = (TrainCourseRecordInfo)it.next();
                if (courseRecordInfo.getId() == null) continue;
                int i = 1;
                pstmt.setBigDecimal(i++, courseRecordInfo.getActCost());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)i++, (String)courseRecordInfo.getId().toString());
                pstmt.addBatch();
                objs[index++] = new ObjectUuidPK(courseRecordInfo.getId().toString());
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return objs;
    }

    private IObjectPK[] batchSubmitActRecord(Context ctx, HashMap recordMap) throws BOSException {
        IObjectPK[] objs = new IObjectPK[recordMap.size()];
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_trainCourseRecord set FActAttendAll = ?, FActActualAttend = ?, FActAbsentType = ?, FActAbsent = ?, FActAbsentHour = ?, FActAbsHourUnit = ?,FActShouldAttend = ?");
        sb.append(" where FTrainActivityID = ? and FEmployeeID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            TrainCourseRecordInfo courseRecordInfo = null;
            IObjectPK pk = null;
            Iterator it = recordMap.values().iterator();
            int index = 0;
            while (it.hasNext()) {
                courseRecordInfo = (TrainCourseRecordInfo)it.next();
                if (courseRecordInfo.getId() != null) {
                    int i = 1;
                    pstmt.setBoolean(i++, courseRecordInfo.isActAttendAll());
                    pstmt.setBigDecimal(i++, courseRecordInfo.getActActualAttend());
                    if (courseRecordInfo.getActAbsentType() != null) {
                        pstmt.setInt(i++, courseRecordInfo.getActAbsentType().getValue());
                    } else {
                        pstmt.setNull(i++, 4);
                    }
                    pstmt.setBigDecimal(i++, courseRecordInfo.getActAbsent());
                    pstmt.setBigDecimal(i++, courseRecordInfo.getActAbsentHour());
                    if (courseRecordInfo.getActAbsHourUnit() != null) {
                        pstmt.setInt(i++, courseRecordInfo.getActAbsHourUnit().getValue());
                    } else {
                        pstmt.setNull(i++, 4);
                    }
                    pstmt.setBigDecimal(i++, courseRecordInfo.getActShouldAttend());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)i++, (String)courseRecordInfo.getTrainActivity().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)i++, (String)courseRecordInfo.getEmployee().getId().toString());
                    pstmt.addBatch();
                    objs[index++] = new ObjectUuidPK(courseRecordInfo.getId().toString());
                    continue;
                }
                pk = this._submitTrainActivityRecord(ctx, (IObjectValue)courseRecordInfo, true);
                objs[index++] = pk;
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return objs;
    }

    private IObjectPK[] batchSubmitCoruseRecord(Context ctx, HashMap recordMap) throws BOSException {
        IObjectPK[] objs = new IObjectPK[recordMap.size()];
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_trainCourseRecord set FAttendAll = ?, FActualAttend = ?, FAbsentType = ?, FAbsent = ?, FAbsentHour = ?, FAbsentHourUnit = ?, FCourseCost = ?, FShouldAttend = ?");
        sb.append(" where FID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            TrainCourseRecordInfo courseRecordInfo = null;
            IObjectPK pk = null;
            Iterator it = recordMap.values().iterator();
            int index = 0;
            while (it.hasNext()) {
                courseRecordInfo = (TrainCourseRecordInfo)it.next();
                if (courseRecordInfo.getId() != null) {
                    int i = 1;
                    pstmt.setBoolean(i++, courseRecordInfo.isAttendAll());
                    pstmt.setBigDecimal(i++, courseRecordInfo.getActualAttend());
                    if (courseRecordInfo.getAbsentType() != null) {
                        pstmt.setInt(i++, courseRecordInfo.getAbsentType().getValue());
                    } else {
                        pstmt.setNull(i++, 4);
                    }
                    pstmt.setBigDecimal(i++, courseRecordInfo.getAbsent());
                    pstmt.setBigDecimal(i++, courseRecordInfo.getAbsentHour());
                    if (courseRecordInfo.getAbsentHourUnit() != null) {
                        pstmt.setInt(i++, courseRecordInfo.getAbsentHourUnit().getValue());
                    } else {
                        pstmt.setNull(i++, 4);
                    }
                    pstmt.setBigDecimal(i++, courseRecordInfo.getCourseCost());
                    pstmt.setBigDecimal(i++, courseRecordInfo.getShouldAttend());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)i++, (String)courseRecordInfo.getId().toString());
                    pstmt.addBatch();
                    objs[index++] = new ObjectUuidPK(courseRecordInfo.getId().toString());
                    continue;
                }
                pk = this.submitRecord(ctx, (IObjectValue)courseRecordInfo);
                objs[index++] = pk;
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return objs;
    }

    private IObjectPK[] batchSubmitEvaluScore(Context ctx, HashMap recordMap, boolean isActivity) throws BOSException, EASBizException {
        IObjectPK[] objs = new IObjectPK[recordMap.size()];
        Iterator iterator = recordMap.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            TrainCourseRecordInfo courseRecordInfo;
            Map.Entry entry = iterator.next();
            if (isActivity) {
                courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                if (courseRecordInfo.getId() == null) {
                    ((TrainCourseRecordInfo)entry.getValue()).setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                    objs[index] = this._submitTrainActivityRecord(ctx, (IObjectValue)entry.getValue(), true);
                } else {
                    objs[index] = new ObjectUuidPK(courseRecordInfo.getId());
                }
            } else {
                courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                if (courseRecordInfo.getId() == null) {
                    ((TrainCourseRecordInfo)entry.getValue()).setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                    objs[index] = this.submitRecord(ctx, (IObjectValue)entry.getValue());
                    courseRecordInfo.setId(BOSUuid.read((String)objs[index].toString()));
                } else {
                    objs[index] = new ObjectUuidPK(courseRecordInfo.getId());
                }
            }
            ++index;
        }
        if (isActivity) {
            this.batchUpdateActivityEvaluScore(ctx, recordMap);
        } else {
            this.batchUpdateCourseEvaluScore(ctx, recordMap);
        }
        return objs;
    }

    private void batchUpdateActivityEvaluScore(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FActScore = ?, FOrgUnitScore = ?, FResponserEvalu = ? ");
        sql.append(" where FTrainActivityID = ? and  FEmployeeID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                pstmt.setBigDecimal(1, courseRecordInfo.getActScore());
                pstmt.setBigDecimal(2, courseRecordInfo.getOrgUnitScore());
                if (courseRecordInfo.getResponserEvalu() != null) {
                    pstmt.setInt(3, courseRecordInfo.getResponserEvalu().getValue());
                } else {
                    pstmt.setNull(3, 4);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)courseRecordInfo.getTrainActivity().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseRecordInfo.getEmployee().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void batchUpdateCourseEvaluScore(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Map.Entry entry;
        Iterator iterator = recordMap.entrySet().iterator();
        TrainCourseRecordInfo courseRecordInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set ");
        sql.append("FCourseScore = ?, FInstructorScore = ?, FInstructorEvalu = ?, FChannelScore = ? ");
        sql.append(" where FID = ? ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                entry = iterator.next();
                courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                pstmt.setBigDecimal(1, courseRecordInfo.getCourseScore());
                pstmt.setBigDecimal(2, courseRecordInfo.getInstructorScore());
                if (courseRecordInfo.getInstructorEvalu() != null) {
                    pstmt.setInt(3, courseRecordInfo.getInstructorEvalu().getValue());
                } else {
                    pstmt.setNull(3, 4);
                }
                pstmt.setBigDecimal(4, courseRecordInfo.getChannelScore());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseRecordInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        if (courseRecordInfo == null) {
            return;
        }
        if (courseRecordInfo.getTrainActivity() == null) {
            return;
        }
        sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FActScore = ?, FOrgUnitScore = ?, FResponserEvalu = ? ");
        sql.append("  where FTrainActivityID = ? and  FEmployeeID = ? ");
        iterator = recordMap.entrySet().iterator();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                entry = iterator.next();
                courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                pstmt.setBigDecimal(1, courseRecordInfo.getActScore());
                pstmt.setBigDecimal(2, courseRecordInfo.getOrgUnitScore());
                if (courseRecordInfo.getResponserEvalu() != null) {
                    pstmt.setInt(3, courseRecordInfo.getResponserEvalu().getValue());
                } else {
                    pstmt.setNull(3, 4);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)courseRecordInfo.getTrainActivity().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseRecordInfo.getEmployee().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    protected IObjectPK[] _submitScoreRecordBatch(Context ctx, HashMap oldMap, HashMap newMap, boolean isActivity) throws BOSException, EASBizException {
        TrainCourseRecordInfo courseRecordInfo;
        IObjectPK[] objs = new IObjectPK[newMap.size()];
        Iterator iterator = newMap.entrySet().iterator();
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        int index = 0;
        TrainActivityInfo trainActivityInfo = null;
        while (iterator.hasNext()) {
            IObjectPK pk;
            Map.Entry entry = iterator.next();
            courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            if (isActivity) {
                if (courseRecordInfo.getId() == null) {
                    ((TrainCourseRecordInfo)entry.getValue()).setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                    objs[index] = this._submitTrainActivityRecord(ctx, (IObjectValue)entry.getValue(), true);
                } else {
                    objs[index] = new ObjectUuidPK(courseRecordInfo.getId());
                }
                if (courseRecordInfo.getActCertificate() != null) {
                    pk = PersonCertificationFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)courseRecordInfo.getActCertificate());
                    if (courseRecordInfo.getActCertificate().getId() == null) {
                        courseRecordInfo.getActCertificate().setId(BOSUuid.read((String)pk.toString()));
                    }
                }
                ids.add(objs[index]);
                TrainCourseRecordInfo info = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(objs[index].toString()));
                if (info.getTrainActivity() != null) {
                    trainActivityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(info.getTrainActivity().getId().toString()));
                }
                this.createBatchCourseRecord(ctx, courseRecordInfo, trainActivityInfo);
            } else {
                if (courseRecordInfo.getId() == null) {
                    ((TrainCourseRecordInfo)entry.getValue()).setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                    objs[index] = this.submitRecord(ctx, (IObjectValue)entry.getValue());
                    courseRecordInfo.setId(BOSUuid.read((String)objs[index].toString()));
                } else {
                    objs[index] = new ObjectUuidPK(courseRecordInfo.getId());
                }
                ids.add(objs[index]);
                if (courseRecordInfo.getEmpCertificatio() != null) {
                    pk = PersonCertificationFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)courseRecordInfo.getEmpCertificatio());
                    if (courseRecordInfo.getEmpCertificatio().getId() == null) {
                        courseRecordInfo.getEmpCertificatio().setId(BOSUuid.read((String)pk.toString()));
                    }
                }
            }
            ++index;
        }
        if (isActivity) {
            this.batchUpdateActivityScoreRecord(ctx, newMap);
            this.batchUpdateActivityExtendsRecord(ctx, newMap);
        } else {
            this.batchUpdateCourseScoreRecord(ctx, newMap);
            this.batchUpdateCourseExtendsRecord(ctx, newMap);
        }
        for (Map.Entry entry : newMap.entrySet()) {
            courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            if (isActivity) {
                if (courseRecordInfo.getActCertificate() != null || (courseRecordInfo = (TrainCourseRecordInfo)oldMap.get(entry.getKey())).getActCertificate() == null || courseRecordInfo.getActCertificate().getId() == null) continue;
                PersonCertificationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(courseRecordInfo.getActCertificate().getId()));
                continue;
            }
            if (courseRecordInfo.getEmpCertificatio() != null || (courseRecordInfo = (TrainCourseRecordInfo)oldMap.get(entry.getKey())).getEmpCertificatio() == null || courseRecordInfo.getEmpCertificatio().getId() == null) continue;
            PersonCertificationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(courseRecordInfo.getEmpCertificatio().getId()));
        }
        return objs;
    }

    private void batchUpdateCourseScoreRecord(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FNeedExam = ?, FAssessScore = ?, FIsPassed = ?, ");
        sql.append("FEmpCertificatioID = ? ");
        sql.append(" where FID = ? ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                if (courseRecordInfo.isNeedExam()) {
                    pstmt.setInt(1, 1);
                } else {
                    pstmt.setInt(1, 0);
                }
                pstmt.setBigDecimal(2, courseRecordInfo.getAssessScore());
                if (courseRecordInfo.getIsPassed() != null) {
                    pstmt.setInt(3, courseRecordInfo.getIsPassed().getValue());
                } else {
                    pstmt.setNull(3, 4);
                }
                if (courseRecordInfo.getEmpCertificatio() != null && courseRecordInfo.getEmpCertificatio().getId() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)courseRecordInfo.getEmpCertificatio().getId().toString());
                } else {
                    pstmt.setString(4, null);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseRecordInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void batchUpdateCourseExtendsRecord(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecordExtends set FAssessValue = ? ");
        sql.append(" where FID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                if (courseRecordInfo.getRecordExtends() != null) {
                    pstmt.setString(1, courseRecordInfo.getRecordExtends().getAssessValue());
                } else {
                    pstmt.setString(1, null);
                }
                if (courseRecordInfo.getRecordExtends() == null) continue;
                if (courseRecordInfo.getRecordExtends().getId() != null) {
                    pstmt.setString(2, courseRecordInfo.getRecordExtends().getId().toString());
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void batchUpdateActivityScoreRecord(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FActNeedExam = ?, FActAssessScore = ?, FActIsPassed = ?, ");
        sql.append("FActCertificateID = ?, FOrgUnitID = ? ");
        sql.append(" where FTrainActivityID = ? and  FEmployeeID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                if (courseRecordInfo.isActNeedExam()) {
                    pstmt.setInt(1, 1);
                } else {
                    pstmt.setInt(1, 0);
                }
                pstmt.setBigDecimal(2, courseRecordInfo.getActAssessScore());
                if (courseRecordInfo.getActIsPassed() != null) {
                    pstmt.setInt(3, courseRecordInfo.getActIsPassed().getValue());
                } else {
                    pstmt.setNull(3, 4);
                }
                if (courseRecordInfo.getActCertificate() != null && courseRecordInfo.getActCertificate().getId() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)courseRecordInfo.getActCertificate().getId().toString());
                } else {
                    pstmt.setString(4, null);
                }
                if (courseRecordInfo.getOrgUnit() != null) {
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)courseRecordInfo.getOrgUnit().getId().toString());
                } else {
                    pstmt.setString(5, null);
                }
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)6, (String)courseRecordInfo.getTrainActivity().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)7, (String)courseRecordInfo.getEmployee().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void batchUpdateActivityExtendsRecord(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_HR_TrainCourseRecordExtends SET FActAssessValue = ? ");
        sql.append("WHERE FID in ( select FRecordExtendsID from t_hr_traincourserecord where FEmployeeID = ? and FTrainActivityID = ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                if (courseRecordInfo.getRecordExtends() != null) {
                    pstmt.setString(1, courseRecordInfo.getRecordExtends().getActAssessValue());
                } else {
                    pstmt.setString(1, null);
                }
                pstmt.setString(2, courseRecordInfo.getEmployee().getId().toString());
                pstmt.setString(3, courseRecordInfo.getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected BigDecimal _getAverageActScore(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        return this.getAverageValue(ctx, trainActivityId, "FActScore");
    }

    protected BigDecimal _getAverageDeptScore(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        return this.getAverageValue(ctx, trainActivityId, "FOrgUnitScore");
    }

    private BigDecimal getAverageValue(Context ctx, String trainActivityId, String columnName) throws BOSException {
        BigDecimal result = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select avg(r.result) from ");
        sql.append("(");
        sql.append(this.getUniqueSql(trainActivityId, columnName));
        sql.append(") r");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                double value = rowSet.getDouble(1);
                result = new BigDecimal(String.valueOf(value));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getUniqueSql(String trainActivityId, String columnName) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t.FEmployeeid, t.");
        sql.append(columnName);
        sql.append(" result from T_HR_TrainCourseRecord t where t.FTrainActivityID = '");
        sql.append(trainActivityId);
        sql.append("' and t.");
        sql.append(columnName);
        sql.append(" > 0");
        return sql.toString();
    }

    protected Object _getMaxResponserEval(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        PersonEvaluEnum result = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select r.result, count(r.result) number from ");
        sql.append("(");
        sql.append(this.getUniqueSql(trainActivityId, "FResponserEvalu"));
        sql.append(") r");
        sql.append(" group by r.result order by number desc, result");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                int value = rowSet.getInt(1);
                result = PersonEvaluEnum.getEnum(value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected BigDecimal _getInstructorEvalRate(Context ctx, String trainActivityId, String courseId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("instructorEvalu"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse", (Object)courseId));
        viewInfo.setFilter(filterInfo);
        TrainCourseRecordCollection collection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        int count = 0;
        int goodEval = 0;
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                PersonEvaluEnum eval = collection.get(i).getInstructorEvalu();
                if (PersonEvaluEnum.GOOD.equals((Object)eval) || PersonEvaluEnum.VERY_GOOD.equals((Object)eval)) {
                    ++goodEval;
                }
                ++count;
            }
        }
        double rate = 0.0;
        if (count > 0) {
            rate = (double)Math.round((double)goodEval / (double)count * Math.pow(10.0, 4.0)) / Math.pow(10.0, 2.0);
        }
        return new BigDecimal(String.valueOf(rate));
    }

    protected void _submitContactBatch(Context ctx, String trainActivityID, String trainCourseID, IObjectPK[] pks, Map person_Map) throws BOSException, EASBizException {
        if (trainActivityID == null && trainCourseID == null) {
            return;
        }
        if (pks == null || pks.length == 0) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            set.add(pks[i].toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("employee.id"));
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(viewInfo);
        HashSet<String> personSet = new HashSet<String>();
        HashMap<String, String> personToCertificationMap = new HashMap<String, String>();
        int n2 = employeeContractCollection.size();
        for (int i = 0; i < n2; ++i) {
            personSet.add(employeeContractCollection.get(i).getEmployee().getId().toString());
            personToCertificationMap.put(employeeContractCollection.get(i).getEmployee().getId().toString(), employeeContractCollection.get(i).getId().toString());
        }
        if (trainCourseID == null) {
            this.operateBatchActivityRecord(ctx, trainActivityID, personSet, personToCertificationMap, person_Map);
        } else {
            this.operateBatchCourseRecord(ctx, trainActivityID, trainCourseID, personSet, personToCertificationMap);
        }
    }

    private void operateBatchCourseRecord(Context ctx, String trainActivityID, String trainCourseID, HashSet personSet, HashMap personToCertificationMap) throws BOSException, EASBizException {
        EmployeeContractInfo employeeContractInfo;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityID));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        TrainCourseRecordCollection courseRecordCollection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, TrainCourseRecordInfo> recordMap = new HashMap<String, TrainCourseRecordInfo>();
        int n = courseRecordCollection.size();
        for (int i = 0; i < n; ++i) {
            recordMap.put(courseRecordCollection.get(i).getEmployee().getId().toString(), courseRecordCollection.get(i));
            employeeContractInfo = new EmployeeContractInfo();
            employeeContractInfo.setId(BOSUuid.read((String)personToCertificationMap.get(courseRecordCollection.get(i).getEmployee().getId().toString()).toString()));
            courseRecordCollection.get(i).setEmpContract(employeeContractInfo);
            personToCertificationMap.remove(courseRecordCollection.get(i).getEmployee().getId().toString());
        }
        if (personToCertificationMap.size() > 0) {
            for (Map.Entry entry : personToCertificationMap.entrySet()) {
                TrainCourseRecordInfo courseRecordInfo = new TrainCourseRecordInfo();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)entry.getKey().toString()));
                courseRecordInfo.setEmployee(personInfo);
                if (trainActivityID != null) {
                    TrainActivityInfo activityInfo = new TrainActivityInfo();
                    activityInfo.setId(BOSUuid.read((String)trainActivityID));
                    courseRecordInfo.setTrainActivity(activityInfo);
                    courseRecordInfo = this.setRecordDefaultCourseInfo(ctx, courseRecordInfo);
                }
                employeeContractInfo = new EmployeeContractInfo();
                employeeContractInfo.setId(BOSUuid.read((String)entry.getValue().toString()));
                courseRecordInfo.setEmpContract(employeeContractInfo);
                TrainCourseInfo courseInfo = new TrainCourseInfo();
                courseInfo.setId(BOSUuid.read((String)trainCourseID));
                courseRecordInfo.setTrainCourse(courseInfo);
                courseRecordInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                IObjectPK pk = this.submitRecord(ctx, (IObjectValue)courseRecordInfo);
                courseRecordInfo.setId(BOSUuid.read((String)pk.toString()));
                recordMap.put((String)entry.getKey(), courseRecordInfo);
                ids.add(pk.toString());
            }
            this.batchUpdateTrainActivityRecord(ctx, ids);
        }
        this.batchUpdateCourseContact(ctx, recordMap);
    }

    private TrainCourseRecordInfo setRecordDefaultCourseInfo(Context ctx, TrainCourseRecordInfo courseRecordInfo) throws BOSException, EASBizException {
        TrainCourseRecordCollection records = this.getCourseRecords(ctx, courseRecordInfo);
        if (records != null && records.size() > 0) {
            courseRecordInfo = records.get(0);
            courseRecordInfo.setId(null);
        } else {
            this.setRecordDefaultActInfo(ctx, courseRecordInfo, courseRecordInfo.getTrainActivity().getId().toString());
        }
        return courseRecordInfo;
    }

    private TrainCourseRecordCollection getCourseRecords(Context ctx, TrainCourseRecordInfo recordInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessMethod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("trainItem.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actTrainAddress"));
        viewInfo.getSelector().add(new SelectorItemInfo("actNeedExam"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("actHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("actIsPassed"));
        viewInfo.getSelector().add(new SelectorItemInfo("actBeginDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actEndDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actPassStandard"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAttendAll"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsentHour"));
        viewInfo.getSelector().add(new SelectorItemInfo("actShouldAttend"));
        viewInfo.getSelector().add(new SelectorItemInfo("actActualAttend"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsHourUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsent"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAbsentType"));
        viewInfo.getSelector().add(new SelectorItemInfo("actDescription"));
        viewInfo.getSelector().add(new SelectorItemInfo("trainChanne.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)recordInfo.getEmployee().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)recordInfo.getTrainActivity().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
    }

    private void batchUpdateCourseContact(Context ctx, Map recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FEmpContractID = ? ");
        sql.append(" where FID = ? ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)courseRecordInfo.getEmpContract().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)courseRecordInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void operateBatchActivityRecord(Context ctx, String trainActivityID, HashSet personSet, HashMap personToCertificationMap, Map person_Map) throws BOSException, EASBizException {
        EmployeeContractInfo employeeContractInfo;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        TrainCourseRecordCollection courseRecordCollection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, TrainCourseRecordInfo> recordMap = new HashMap<String, TrainCourseRecordInfo>();
        int n = courseRecordCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!personToCertificationMap.containsKey(courseRecordCollection.get(i).getEmployee().getId().toString())) continue;
            recordMap.put(courseRecordCollection.get(i).getEmployee().getId().toString(), courseRecordCollection.get(i));
            employeeContractInfo = new EmployeeContractInfo();
            employeeContractInfo.setId(BOSUuid.read((String)personToCertificationMap.get(courseRecordCollection.get(i).getEmployee().getId().toString()).toString()));
            courseRecordCollection.get(i).setActContract(employeeContractInfo);
            personToCertificationMap.remove(courseRecordCollection.get(i).getEmployee().getId().toString());
        }
        if (personToCertificationMap.size() > 0) {
            for (Map.Entry entry : personToCertificationMap.entrySet()) {
                TrainCourseRecordInfo courseRecordInfo = new TrainCourseRecordInfo();
                PersonInfo personInfo = new PersonInfo();
                TrainCourseRecordExtendsInfo extInfo = new TrainCourseRecordExtendsInfo();
                employeeContractInfo = new EmployeeContractInfo();
                employeeContractInfo.setId(BOSUuid.read((String)entry.getValue().toString()));
                if (person_Map.containsKey(entry.getKey().toString())) {
                    personInfo = (PersonInfo)person_Map.get(entry.getKey().toString());
                }
                extInfo.setPosiStudent((PositionInfo)personInfo.get("primaryPosition"));
                extInfo.setOrgStudent((AdminOrgUnitInfo)personInfo.get("primaryadminorg"));
                courseRecordInfo.setRecordExtends(extInfo);
                courseRecordInfo.setEmployee(personInfo);
                courseRecordInfo.setActContract(employeeContractInfo);
                if (trainActivityID != null) {
                    TrainActivityInfo activityInfo = new TrainActivityInfo();
                    activityInfo.setId(BOSUuid.read((String)trainActivityID));
                    courseRecordInfo.setTrainActivity(activityInfo);
                    courseRecordInfo = this.setRecordDefaultActInfo(ctx, courseRecordInfo, trainActivityID);
                }
                courseRecordInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                IObjectPK pk = this._submitTrainActivityRecord(ctx, (IObjectValue)courseRecordInfo, true);
                recordMap.put((String)entry.getKey(), courseRecordInfo);
                ids.add(pk.toString());
            }
            this.batchUpdateTrainActivityRecord(ctx, ids);
        }
        this.batchUpdateActivityContract(ctx, recordMap);
    }

    private TrainCourseRecordInfo setRecordDefaultActExtInfo(Context ctx, TrainCourseRecordInfo courseRecordInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("recordExtends.OrgStudent.*"));
        sic.add(new SelectorItemInfo("recordExtends.PosiStudent.*"));
        TrainCourseRecordInfo recordInfo = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(courseRecordInfo.getId().toString()), sic);
        return recordInfo;
    }

    private TrainCourseRecordInfo setRecordDefaultActInfo(Context ctx, TrainCourseRecordInfo recordInfo, String trainActivityID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("trainItem.id"));
        sic.add(new SelectorItemInfo("trainItem.number"));
        sic.add(new SelectorItemInfo("trainItem.name"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("BudgetCost"));
        sic.add(new SelectorItemInfo("orgPerson.id"));
        sic.add(new SelectorItemInfo("orgPerson.number"));
        sic.add(new SelectorItemInfo("orgPerson.name"));
        sic.add(new SelectorItemInfo("trainAddress"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("needAssess"));
        sic.add(new SelectorItemInfo("passStand"));
        sic.add(new SelectorItemInfo("assessMethod.id"));
        sic.add(new SelectorItemInfo("assessMethod.name"));
        sic.add(new SelectorItemInfo("trainMethod.id"));
        sic.add(new SelectorItemInfo("trainMethod.name"));
        sic.add(new SelectorItemInfo("trainType"));
        sic.add(new SelectorItemInfo("trainingCategor"));
        sic.add(new SelectorItemInfo("trainCatagory"));
        sic.add(new SelectorItemInfo("trainChanne.id"));
        sic.add(new SelectorItemInfo("trainChanne.name"));
        TrainActivityInfo activityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityID), sic);
        recordInfo.setTrainItem(activityInfo.getTrainItem());
        if (activityInfo.getTrainStartDate() != null) {
            recordInfo.setBeginDateTime(new Timestamp(activityInfo.getTrainStartDate().getTime()));
        }
        if (activityInfo.getTrainEndDate() != null) {
            recordInfo.setEndDateTime(new Timestamp(activityInfo.getTrainEndDate().getTime()));
        }
        if (activityInfo.getOrgUnit() != null) {
            recordInfo.setOrgUnit(activityInfo.getOrgUnit());
        }
        recordInfo.setActCost(activityInfo.getBudgetCost());
        recordInfo.setActTrainAddress(activityInfo.getTrainAddress());
        recordInfo.setActDescription(activityInfo.getDescription());
        recordInfo.setActNeedExam(activityInfo.isNeedExam());
        recordInfo.setActPassStandard(activityInfo.getPassStand());
        recordInfo.setActTrainMethod(activityInfo.getTrainMethod());
        recordInfo.setActAssessMethod(activityInfo.getAssessMethod());
        recordInfo.setActIsPassed(TrainRecordIsPassedEnum.PASSED);
        recordInfo.setIsPassed(TrainRecordIsPassedEnum.PASSED);
        recordInfo.setTrainType(activityInfo.getTrainType());
        recordInfo.setActTrainType(activityInfo.getTrainType());
        recordInfo.setTrainCategory(activityInfo.getTrainCatagory());
        recordInfo.setActTrainCategory(activityInfo.getTrainCatagory());
        recordInfo.setTrainingCategory(activityInfo.getTrainingCategor());
        recordInfo.setActTrainingCategory(activityInfo.getTrainingCategor());
        return recordInfo;
    }

    private void batchUpdateActivityContract(Context ctx, HashMap recordMap) throws BOSException, EASBizException {
        Iterator iterator = recordMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FActContractID = ? ");
        sql.append(" where FTrainActivityID = ? and  FEmployeeID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)courseRecordInfo.getActContract().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)courseRecordInfo.getTrainActivity().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)courseRecordInfo.getEmployee().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _submitContactBatch(Context ctx, Set trainCourseRecordIds, IObjectPK[] contractIds) throws BOSException, EASBizException {
        if (trainCourseRecordIds == null || trainCourseRecordIds.size() == 0 || contractIds == null || contractIds.length == 0) {
            return;
        }
        Map personToContractMap = this.getEmployeeContractMap(ctx, contractIds);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)trainCourseRecordIds, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        TrainCourseRecordCollection collection = this.getTrainCourseRecordCollection(ctx, viewInfo);
        HashMap<BOSUuid, TrainCourseRecordInfo> recordMap = new HashMap<BOSUuid, TrainCourseRecordInfo>();
        TrainCourseRecordInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            info.setEmpContract((EmployeeContractInfo)personToContractMap.get(info.getEmployee().getId().toString()));
            recordMap.put(info.getId(), info);
        }
        this.batchUpdateCourseContact(ctx, recordMap);
    }

    private Map getEmployeeContractMap(Context ctx, IObjectPK[] contractIds) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        int n = contractIds.length;
        for (int i = 0; i < n; ++i) {
            set.add(contractIds[i].toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("employee.id"));
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(viewInfo);
        HashMap<String, EmployeeContractInfo> personToContractMap = new HashMap<String, EmployeeContractInfo>();
        int n2 = employeeContractCollection.size();
        for (int i = 0; i < n2; ++i) {
            personToContractMap.put(employeeContractCollection.get(i).getEmployee().getId().toString(), employeeContractCollection.get(i));
        }
        return personToContractMap;
    }

    protected void _updateActPersonCheckUpID(Context ctx, String recordId, String personCheckUpID) throws BOSException, EASBizException {
        PersonCheckUpInfo personCheckUpinfo = null;
        personCheckUpinfo = PersonCheckUpFactory.getLocalInstance(ctx).getPersonCheckUpInfo((IObjectPK)new ObjectUuidPK(personCheckUpID));
        TrainCourseRecordInfo info = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
        if (personCheckUpinfo != null && personCheckUpinfo.getId() != null) {
            info.setActPersonCheckUp(personCheckUpinfo);
        } else {
            info.setActPersonCheckUp(null);
        }
        this._update(ctx, (IObjectPK)new ObjectUuidPK(recordId), (IObjectValue)info);
    }

    protected void _updatePersonCheckUpID(Context ctx, String recordId, String personCheckUpID) throws BOSException, EASBizException {
        PersonCheckUpInfo personCheckUpinfo = null;
        personCheckUpinfo = PersonCheckUpFactory.getLocalInstance(ctx).getPersonCheckUpInfo((IObjectPK)new ObjectUuidPK(personCheckUpID));
        TrainCourseRecordInfo info = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
        if (personCheckUpinfo != null && personCheckUpinfo.getId() != null) {
            info.setCoursePersonCheckUp(personCheckUpinfo);
        } else {
            info.setCoursePersonCheckUp(null);
        }
        this._update(ctx, (IObjectPK)new ObjectUuidPK(recordId), (IObjectValue)info);
    }

    protected Map _getAverages(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activityAverageActScore", this._getAverageActScore(ctx, trainActivityId));
        map.put("activityAverageDeptScore", this._getAverageDeptScore(ctx, trainActivityId));
        map.put("activityResponserEval", this._getMaxResponserEval(ctx, trainActivityId));
        return map;
    }

    protected void _submitCertificateBatch(Context ctx, String activityId, String courseId, Map map) throws BOSException, EASBizException {
        if (activityId == null || map == null || map.size() <= 0) {
            return;
        }
        boolean isCourseRecord = false;
        if (courseId != null && courseId.length() > 0) {
            isCourseRecord = true;
        }
        SelectorItemCollection cert_sic = new SelectorItemCollection();
        cert_sic.add(new SelectorItemInfo("certificateNumber"));
        cert_sic.add(new SelectorItemInfo("certificateName"));
        cert_sic.add(new SelectorItemInfo("certifyDate"));
        cert_sic.add(new SelectorItemInfo("PeriodValidity"));
        cert_sic.add(new SelectorItemInfo("organ"));
        SelectorItemCollection record_sic = new SelectorItemCollection();
        record_sic.add(new SelectorItemInfo("EmpCertificatio"));
        Set recordIdSet = map.keySet();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("Employee.id"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", recordIdSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        TrainCourseRecordCollection coll = this.getTrainCourseRecordCollection(ctx, evi);
        Object[] params = new String[3];
        IPersonCertification pcDao = PersonCertificationFactory.getLocalInstance((Context)ctx);
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            TrainCourseRecordInfo recordInfo = coll.get(i);
            String recordId = recordInfo.getId().toString();
            PersonCertificationInfo cInfo = (PersonCertificationInfo)map.get(recordId);
            if (cInfo.getId() == null) {
                cInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                pcDao.addnew((CoreBaseInfo)cInfo);
            } else {
                pcDao.updatePartial((CoreBaseInfo)cInfo, cert_sic);
                this.dealCertificateBatchLogInfo(ctx, cInfo, "EmployeeCertify_update");
            }
            if (cInfo.getId() == null) continue;
            if (isCourseRecord) {
                recordInfo.setEmpCertificatio(cInfo);
                this.updatePartial(ctx, (CoreBaseInfo)recordInfo, record_sic);
                continue;
            }
            params[0] = cInfo.getId().toString();
            params[1] = activityId;
            params[2] = recordInfo.getEmployee().getId().toString();
            String sql = "update T_HR_TrainCourseRecord set FActCertificateID = ? where FTrainActivityID = ? and FEmployeeID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    protected void _setActAntiAudited(Context ctx, Set activityIDSet, Set employeeIDSet) throws BOSException, EASBizException {
        this.setActAuditState(ctx, false, activityIDSet, employeeIDSet);
        if (activityIDSet == null || activityIDSet.size() == 0) {
            return;
        }
        String[] idList = new String[activityIDSet.size()];
        ArrayList activityIDList = new ArrayList();
        Iterator it = activityIDSet.iterator();
        while (it.hasNext()) {
            activityIDList.add(it.next());
        }
        int size = idList.length;
        for (int i = 0; i < size; ++i) {
            idList[i] = activityIDList.get(i).toString();
        }
        this.dealActLogInfo(ctx, idList, "train_TrainRecord_unaudit");
    }

    protected void _setActAudited(Context ctx, Set activityIDSet, Set employeeIDSet) throws BOSException, EASBizException {
        this.setActAuditState(ctx, true, activityIDSet, employeeIDSet);
        if (activityIDSet == null || activityIDSet.size() == 0) {
            return;
        }
        String[] idList = new String[activityIDSet.size()];
        ArrayList activityIDList = new ArrayList();
        Iterator it = activityIDSet.iterator();
        while (it.hasNext()) {
            activityIDList.add(it.next());
        }
        int size = idList.length;
        for (int i = 0; i < size; ++i) {
            idList[i] = activityIDList.get(i).toString();
        }
        this.dealActLogInfo(ctx, idList, "train_TrainRecord_audit");
    }

    protected void _setAntiAudited(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.setAuditState(ctx, false, idList);
        this.dealLogInfo(ctx, idList, "train_TrainRecord_unaudit");
    }

    protected void _setAudited(Context ctx, String[] idList) throws BOSException, EASBizException {
        this.setAuditState(ctx, true, idList);
        this.dealLogInfo(ctx, idList, "train_TrainRecord_audit");
    }

    private void setActAuditState(Context ctx, boolean isAudit, Set activityIDSet, Set employeeIDSet) throws BOSException {
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            if (activityIDSet == null || activityIDSet.size() == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE ");
            sb.append(TABLEEXTENDS_NAME);
            sb.append(" SET FIsApproved = ? , FAuditorID = ? , FAuditDate = ?, FActIsApproved = ?");
            sb.append(" WHERE FID IN ( ");
            sb.append("select FRecordExtendsID from t_hr_traincourserecord where FTrainActivityID IN ( ");
            sb.append(TrainUtilsServer.setSetToString(activityIDSet));
            sb.append(" )");
            sb.append(" AND FEmployeeID IN ( ");
            sb.append(TrainUtilsServer.setSetToString(employeeIDSet));
            sb.append(" )");
            sb.append(" )");
            conn = null;
            pstmt = null;
            String auditorID = null;
            Timestamp date = null;
            auditorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            date = new Timestamp(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()).getTime());
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sb.toString());
                if (isAudit) {
                    pstmt.setBoolean(1, Boolean.TRUE);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)auditorID);
                    pstmt.setTimestamp(3, date);
                    pstmt.setBoolean(4, Boolean.TRUE);
                    pstmt.execute();
                    break block6;
                }
                pstmt.setBoolean(1, Boolean.FALSE);
                pstmt.setString(2, null);
                pstmt.setTimestamp(3, null);
                pstmt.setBoolean(4, Boolean.FALSE);
                pstmt.execute();
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void setAuditState(Context ctx, boolean isAudit, String[] idList) throws BOSException {
        PreparedStatement pstmt;
        Connection conn;
        block8: {
            if (idList == null || idList.length <= 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE ");
            sb.append(TABLEEXTENDS_NAME);
            sb.append(" SET FIsApproved = ? , FAuditorID = ? , FAuditDate = ?");
            sb.append(" WHERE FID IN ( ");
            sb.append("select FRecordExtendsID from t_hr_traincourserecord where FID IN ( ");
            for (int i = 0; i < idList.length; ++i) {
                if (i > 0) {
                    sb.append(" , ");
                }
                sb.append("'");
                sb.append(idList[i]);
                sb.append("'");
            }
            sb.append(" )");
            sb.append(" )");
            conn = null;
            pstmt = null;
            String auditorID = null;
            Timestamp date = null;
            auditorID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            date = new Timestamp(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()).getTime());
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sb.toString());
                if (isAudit) {
                    pstmt.setBoolean(1, Boolean.TRUE);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)auditorID);
                    pstmt.setTimestamp(3, date);
                    pstmt.execute();
                    break block8;
                }
                pstmt.setBoolean(1, Boolean.FALSE);
                pstmt.setString(2, null);
                pstmt.setTimestamp(3, null);
                pstmt.execute();
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        this.setAuditByAct(ctx, idList);
        this.updateAuditState(ctx, idList);
    }

    private void setAuditByAct(Context ctx, String[] idList) throws BOSException {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(TABLEEXTENDS_NAME);
        sb.append(" SET FActIsApproved = ?");
        sb.append(" WHERE FID IN ( ");
        sb.append(" Select FRecordExtendsID from t_hr_traincourserecord where FTrainActivityID IN ( ");
        sb.append(" SELECT FTrainActivityID FROM t_hr_traincourserecord WHERE FID IN (");
        for (i = 0; i < idList.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(idList[i]);
            sb.append("'");
        }
        sb.append(")");
        sb.append(")");
        sb.append("AND FEmployeeID IN (");
        sb.append(" select FEmployeeID FROM t_hr_traincourserecord where FID in (");
        for (i = 0; i < idList.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(idList[i]);
            sb.append("'");
        }
        sb.append(")");
        sb.append(")");
        sb.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setBoolean(1, Boolean.TRUE);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateAuditState(Context ctx, String[] idList) throws BOSException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < idList.length; ++i) {
            if (i > 0) {
                ids.append(" , ");
            }
            ids.append("'");
            ids.append(idList[i]);
            ids.append("'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(TABLEEXTENDS_NAME);
        sb.append(" SET FActIsApproved = ?\n");
        sb.append(" WHERE FID IN (\n");
        sb.append(" select FRecordExtendsID from t_hr_traincourserecord \n");
        sb.append(" where femployeeid in ( \n");
        sb.append(" select r.femployeeid from t_hr_traincourserecord r \n");
        sb.append(" inner join  T_HR_TrainCourseRecordExtends e on e.fid = r.frecordextendsid \n");
        sb.append(" where e.fisapproved = ? \n");
        sb.append(" \tand r.FTrainActivityID in ( \n");
        sb.append(" \t\tSelect FTrainActivityID from t_hr_traincourserecord where FID IN (" + ids.toString() + ")\n");
        sb.append("\t\t)\n");
        sb.append("\t\tand r.femployeeid in (\n");
        sb.append(" \t\tSelect femployeeid from t_hr_traincourserecord where FID IN (" + ids.toString() + ")\n");
        sb.append("\t\t)\n");
        sb.append(" )\n");
        sb.append(" and FTrainActivityId in ( \n");
        sb.append(" select r.FTrainActivityId from t_hr_traincourserecord r \n");
        sb.append(" inner join  T_HR_TrainCourseRecordExtends e on e.fid = r.frecordextendsid \n");
        sb.append(" where e.fisapproved = ? \n");
        sb.append(" \tand r.FTrainActivityID in ( \n");
        sb.append(" \t\tSelect FTrainActivityID from t_hr_traincourserecord where FID IN (" + ids.toString() + ")\n");
        sb.append("\t\t)\n");
        sb.append("\t\tand r.femployeeid in (\n");
        sb.append(" \t\tSelect femployeeid from t_hr_traincourserecord where FID IN (" + ids.toString() + ")\n");
        sb.append("\t\t)\n");
        sb.append(" )\n");
        sb.append(")\n");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setBoolean(1, Boolean.FALSE);
            pstmt.setBoolean(2, Boolean.FALSE);
            pstmt.setBoolean(3, Boolean.FALSE);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void setUnAudit(Context ctx, IObjectValue objectValue) throws SQLDataException, SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)objectValue;
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(TABLEEXTENDS_NAME);
        sb.append(" SET FActIsApproved = ?");
        sb.append(" WHERE FID IN ( ");
        sb.append(" select FRecordExtendsID from t_hr_traincourserecord where ");
        if (recordInfo.getTrainActivity() != null) {
            sb.append("FTrainActivityID = ");
            sb.append("'");
            sb.append(recordInfo.getTrainActivity().getId().toString());
            sb.append("'");
            sb.append(" AND");
            sb.append(" FEmployeeID = ");
            sb.append("'");
            sb.append(recordInfo.getEmployee().getId().toString());
            sb.append("'");
        } else {
            sb.append("FID = ");
            sb.append("'");
            sb.append(recordInfo.getId().toString());
            sb.append("'");
        }
        sb.append(")");
        conn = this.getConnection(ctx);
        pstmt = conn.prepareStatement(sb.toString());
        pstmt.setBoolean(1, Boolean.FALSE);
        pstmt.execute();
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void setAuditStateByDelete(Context ctx, TrainCourseRecordInfo info) throws SQLException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)info.getEmployee().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)info.getTrainActivity().getId().toString()));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        TrainCourseRecordCollection col = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(evi);
        if (col == null || col.size() == 0) {
            return;
        }
        for (int i = 0; i < col.size(); ++i) {
            TrainCourseRecordInfo recordInfo = col.get(i);
            if (recordInfo.getRecordExtends().isIsApproved()) continue;
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(TABLEEXTENDS_NAME);
        sb.append(" SET FActIsApproved = ?");
        sb.append(" WHERE FID IN ( ");
        sb.append(" select FRecordExtendsID from t_hr_traincourserecord where FTrainActivityID = ?");
        sb.append(" AND FEmployeeID = ?");
        sb.append(")");
        conn = this.getConnection(ctx);
        pstmt = conn.prepareStatement(sb.toString());
        pstmt.setBoolean(1, Boolean.TRUE);
        pstmt.setString(2, info.getTrainActivity().getId().toString());
        pstmt.setString(3, info.getEmployee().getId().toString());
        pstmt.execute();
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private IObjectPK[] batchUpdateCourseCost(Context ctx, HashMap recordMap) throws BOSException {
        IObjectPK[] objs = new IObjectPK[recordMap.size()];
        StringBuffer sb = new StringBuffer();
        sb.append("update t_hr_trainCourseRecord set FCourseCost = ?");
        sb.append(" where FID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            TrainCourseRecordInfo courseRecordInfo = null;
            Iterator it = recordMap.values().iterator();
            int index = 0;
            while (it.hasNext()) {
                courseRecordInfo = (TrainCourseRecordInfo)it.next();
                if (courseRecordInfo.getId() == null) continue;
                int i = 1;
                pstmt.setBigDecimal(i++, courseRecordInfo.getCourseCost());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)i++, (String)courseRecordInfo.getId().toString());
                pstmt.addBatch();
                objs[index++] = new ObjectUuidPK(courseRecordInfo.getId().toString());
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return objs;
    }

    private void dealLogInfo(Context ctx, String[] idList, String logItem) throws BOSException, EASBizException {
        StringBuffer name = new StringBuffer();
        int len = idList.length;
        for (int i = 0; i < len; ++i) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("employee.name"));
            sic.add(new SelectorItemInfo("trainActivity.name"));
            sic.add(new SelectorItemInfo("trainCourse.name"));
            TrainCourseRecordInfo recordInfo = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(idList[i]), sic);
            StringBuffer retValue = new StringBuffer();
            if (recordInfo.getEmployee() != null) {
                retValue.append(recordInfo.getEmployee().getName());
            }
            if (recordInfo.getTrainActivity() != null) {
                if (retValue.length() > 0) {
                    retValue.append(" ");
                }
                retValue.append(recordInfo.getTrainActivity().getName());
            }
            if (recordInfo.getTrainCourse() != null) {
                if (retValue.length() > 0) {
                    retValue.append(" ");
                }
                retValue.append(recordInfo.getTrainCourse().getName());
            }
            if (i != len - 1) {
                retValue.append(" \uff0c ");
            }
            name.append(retValue);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TrainCourseRecordFactory.getLocalInstance(ctx).getType(), null, (String)name.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void dealCertificateBatchLogInfo(Context ctx, PersonCertificationInfo cInfo, String logItem) throws BOSException, EASBizException {
        StringBuffer name = new StringBuffer();
        String certificateNumber = cInfo.getCertificateNumber();
        name.append(certificateNumber);
        name.append("   ");
        String certificateName = cInfo.getCertificateName();
        name.append(certificateName);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)PersonCertificationFactory.getLocalInstance((Context)ctx).getType(), null, (String)name.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void dealActLogInfo(Context ctx, String[] idList, String logItem) throws BOSException, EASBizException {
        StringBuffer name = new StringBuffer();
        int len = idList.length;
        for (int i = 0; i < len; ++i) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)idList[i]));
            evi.setFilter(fi);
            evi.getSelector().add(new SelectorItemInfo("employee.name"));
            evi.getSelector().add(new SelectorItemInfo("trainActivity.name"));
            evi.getSelector().add(new SelectorItemInfo("trainCourse.name"));
            StringBuffer retValue = new StringBuffer();
            TrainCourseRecordCollection recordCol = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(evi);
            if (recordCol == null || recordCol.size() <= 0) continue;
            if (recordCol.get(0) != null && recordCol.get(0).getEmployee() != null) {
                retValue.append(recordCol.get(0).getEmployee().getName());
            }
            if (recordCol.get(0) != null && recordCol.get(0).getTrainActivity() != null) {
                if (retValue.length() > 0) {
                    retValue.append(" ");
                }
                retValue.append(recordCol.get(0).getTrainActivity().getName());
            }
            if (i != len - 1) {
                retValue.append(" \uff0c ");
            }
            name.append(retValue);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TrainCourseRecordFactory.getLocalInstance(ctx).getType(), null, (String)name.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

