/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.CourseAuditEnum;
import com.kingdee.eas.hr.train.PreLectureFactory;
import com.kingdee.eas.hr.train.TrainCourseResearchCollection;
import com.kingdee.eas.hr.train.TrainCourseResearchInfo;
import com.kingdee.eas.hr.train.TrainCourseResearchScheduleCollection;
import com.kingdee.eas.hr.train.TrainCourseResearchScheduleInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainCourseResearchControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainCourseResearchControllerBean
extends AbstractTrainCourseResearchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainCourseResearchControllerBean");

    protected void _audit(Context ctx, Set ids) throws BOSException, EASBizException {
        this.setAuditStatus(ctx, ids, CourseAuditEnum.AUDITED);
    }

    protected void _unAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        this.setAuditStatus(ctx, ids, CourseAuditEnum.UN_AUDIT);
    }

    private void setAuditStatus(Context ctx, Set ids, CourseAuditEnum un_audit) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            sb.append("'");
            sb.append(it.next().toString());
            sb.append("'");
            sb.append(",");
        }
        if (sb.length() == 0) {
            return;
        }
        String sql = "UPDATE T_HR_TrainCourseResearch SET FStatus = ? WHERE FID in (" + sb.substring(0, sb.length() - 1).toString() + ")";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, un_audit.getValue());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Map _getIntendDateByCurrentSchedule(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (ids.size() == 0) {
            return map;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("currentSchedule.id"));
        evi.getSelector().add(new SelectorItemInfo("Schedules.schedule.id"));
        evi.getSelector().add(new SelectorItemInfo("Schedules.intendDate"));
        TrainCourseResearchCollection trainCourseResearchColl = this.getTrainCourseResearchCollection(ctx, evi);
        TrainCourseResearchInfo trainCourseResearchInfo = null;
        TrainCourseResearchScheduleInfo scheduleInfo = null;
        String id = null;
        int size = trainCourseResearchColl.size();
        for (int i = 0; i < size; ++i) {
            trainCourseResearchInfo = trainCourseResearchColl.get(i);
            id = trainCourseResearchInfo.getId().toString();
            String currentScheduleId = trainCourseResearchInfo.getCurrentSchedule().getId().toString();
            TrainCourseResearchScheduleCollection scheduleColl = trainCourseResearchInfo.getSchedules();
            for (int j = 0; j < scheduleColl.size(); ++j) {
                scheduleInfo = scheduleColl.get(j);
                if (currentScheduleId == null || !currentScheduleId.equals(scheduleInfo.getSchedule().getId().toString())) continue;
                map.put(id, scheduleInfo.getIntendDate());
            }
        }
        return map;
    }

    protected void _delete(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("courseResearch.id", (Object)idSet, CompareType.INCLUDE));
        PreLectureFactory.getLocalInstance(ctx).delete(fi);
        fi.getFilterItems().clear();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        this.delete(ctx, fi);
    }
}

