/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorCollection;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorFactory;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorInfo;
import com.kingdee.eas.hr.train.TrainAuditStatusEnum;
import com.kingdee.eas.hr.train.TrainCostSummaryFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryCollection;
import com.kingdee.eas.hr.train.TrainCourseSummaryException;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryInfo;
import com.kingdee.eas.hr.train.TrainCourseSummaryParticipatorCollection;
import com.kingdee.eas.hr.train.TrainCourseSummaryParticipatorInfo;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainSummaryException;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainCourseSummaryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainCourseSummaryControllerBean
extends AbstractTrainCourseSummaryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainCourseSummaryControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._deleteTrainCourseSummary(ctx, pk, (IObjectValue)this.getValue(ctx, pk));
    }

    protected void _deleteTrainCourseSummary(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TrainCourseSummaryInfo info = (TrainCourseSummaryInfo)model;
        if (info.isIsAvgCost()) {
            this.updateCorresponValue(ctx, model, null);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourseSumm.id", (Object)info.getId().toString(), CompareType.EQUALS));
        TrainCostSummaryFactory.getLocalInstance(ctx).delete(filterInfo);
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (((TrainCourseSummaryInfo)model).isIsAvgCost()) {
            this.addnewUpdateCorresponseAvg(ctx, model);
        }
        if ("true".equals(model.get("clearCostFlag"))) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainCourseSummaryInfo)model).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("IsAvgCost", (Object)1));
            if (TrainCourseSummaryFactory.getLocalInstance(ctx).exists(filterInfo)) {
                this.updateCorresponValue(ctx, model, null);
            }
        }
        super._update(ctx, pk, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewUpdateCorresponseAvg(ctx, model);
        super._addnew(ctx, pk, model);
    }

    private void addnewUpdateCorresponseAvg(Context ctx, IObjectValue model) throws TrainCourseSummaryException, BOSException, EASBizException {
        TrainCourseSummaryInfo info = (TrainCourseSummaryInfo)model;
        if (info.isIsAvgCost() && "true".equals(info.get("avgCostFlag"))) {
            this.checkCanUpdateCorresponseAvg(model);
            this.updateCorresponValue(ctx, model, ((TrainCourseSummaryInfo)model).getCost());
        }
    }

    private void checkCanUpdateCorresponseAvg(IObjectValue model) throws TrainCourseSummaryException {
        if (((TrainCourseSummaryInfo)model).getCost() == null) {
            throw new TrainCourseSummaryException(TrainCourseSummaryException.AVG_COST_NOT_NULL);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewUpdateCorresponseAvg(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void updateCorresponValue(Context ctx, IObjectValue model, BigDecimal value) throws BOSException, EASBizException {
        int i;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActCourse.id", (Object)((TrainCourseSummaryInfo)model).getTrainActCourse().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("trainSummary.id", (Object)((TrainCourseSummaryInfo)model).getTrainSummary().getId().toString()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordForTrainCourseSummaryQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        if (rowSet == null || rowSet.size() == 0) {
            return;
        }
        BigDecimal avgValue = new BigDecimal("0.00000000");
        BigDecimal sizeValue = new BigDecimal("" + rowSet.size());
        sizeValue = sizeValue.setScale(6);
        if (value != null) {
            avgValue = value.divide(sizeValue, 4);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_HR_TrainCourseRecord SET FCourseCost = ? WHERE FID = ? ");
        int n = rowSet.size();
        for (i = 1; i < n; ++i) {
            sb.append(" OR FID = ? ");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setBigDecimal(1, avgValue);
            i = 0;
            while (rowSet.next()) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)(2 + i), (String)rowSet.getString("id"));
                ++i;
            }
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    protected IObjectValue _createNewData(Context ctx, String trainSummaryId, String trainActCourseId) throws BOSException, EASBizException {
        SelectorItemCollection sic;
        TrainCourseSummaryInfo objectValue = new TrainCourseSummaryInfo();
        TrainSummaryInfo summaryInfo = null;
        if (trainSummaryId != null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("TrainActivity.id"));
            summaryInfo = TrainSummaryFactory.getLocalInstance(ctx).getTrainSummaryInfo((IObjectPK)new ObjectUuidPK(trainSummaryId), sic);
            objectValue.setTrainSummary(summaryInfo);
        }
        if (trainActCourseId != null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("TrainCourse.id"));
            TrainActCourseInfo trainActCourseInfo = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(trainActCourseId), sic);
            objectValue.setTrainActCourse(trainActCourseInfo);
            objectValue.setCourseHour(trainActCourseInfo.getCourseHour());
            if (trainActCourseInfo.getCourseHourUnit() != null) {
                objectValue.setCourseHourUnit(trainActCourseInfo.getCourseHourUnit());
            }
            objectValue.setStartDate(trainActCourseInfo.getStartDate());
            objectValue.setEndDate(trainActCourseInfo.getEndDate());
            BigDecimal evalRate = TrainCourseRecordFactory.getLocalInstance(ctx).getInstructorEvalRate(summaryInfo.getTrainActivity().getId().toString(), trainActCourseInfo.getTrainCourse().getId().toString());
            objectValue.setInstructorEvalRate(evalRate);
            this.setPerticipator(ctx, objectValue, trainActCourseId);
        }
        return objectValue;
    }

    private void setPerticipator(Context ctx, TrainCourseSummaryInfo objectValue, String trainActCourseId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("role.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isTeacher"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.trainChannel.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.Instructor.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.Instructor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.Instructor.isOuter"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.Instructor.Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.Instructor.Employee.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("channelCourse.Instructor.Employee.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("participator.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("participator.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("participator.number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)trainActCourseId));
        viewInfo.setFilter(filterInfo);
        TrainActCourseParticipatorCollection participatorCollection = TrainActCourseParticipatorFactory.getLocalInstance(ctx).getTrainActCourseParticipatorCollection(viewInfo);
        for (int i = 0; i < participatorCollection.size(); ++i) {
            TrainCourseSummaryParticipatorInfo summaryParticipatorInfo = new TrainCourseSummaryParticipatorInfo();
            summaryParticipatorInfo.setActParticipator(participatorCollection.get(i));
            objectValue.getEntrys().add(summaryParticipatorInfo);
        }
    }

    protected Map _getSummaryDatas(Context ctx, String trainActivityId, String trainActCourseId, String trainCourseId) throws BOSException, EASBizException {
        HashMap<String, Number> datas = new HashMap<String, Number>();
        int actualPersonCount = this.getActualPersonCount(ctx, trainActivityId, trainCourseId);
        datas.put("actualPersonCount", actualPersonCount);
        if (actualPersonCount > 0) {
            datas.put("attendPercent", this.getAttendPercent(ctx, trainActCourseId, actualPersonCount));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("AssessScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPassed"));
        TrainCourseRecordCollection recordCollection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        datas.put("studentAverageScore", this.getStudentAverageScore(ctx, recordCollection));
        datas.put("studentPassPercent", this.getStudentPassPercent(ctx, recordCollection));
        return datas;
    }

    private int getActualPersonCount(Context ctx, String trainActivityId, String trainCourseId) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseId));
        filterInfo.getFilterItems().add(new FilterItemInfo("attendAll", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        TrainCourseRecordCollection collection = TrainCourseRecordFactory.getLocalInstance(ctx).getTrainCourseRecordCollection(viewInfo);
        if (collection != null) {
            return collection.size();
        }
        return 0;
    }

    private BigDecimal getAttendPercent(Context ctx, String trainActCourseId, int actualPersonCount) throws BOSException {
        BigDecimal attendPercent = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseId));
        filterInfo.getFilterItems().add(new FilterItemInfo("Type", (Object)10));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        TrainStudentCourseCollection trainStudentCourseCollection = TrainStudentCourseFactory.getLocalInstance(ctx).getTrainStudentCourseCollection(viewInfo);
        int formalCount = 0;
        if (trainStudentCourseCollection != null) {
            formalCount = trainStudentCourseCollection.size();
        }
        if (formalCount > 0) {
            BigDecimal actualValue = new BigDecimal("" + actualPersonCount);
            actualValue = actualValue.setScale(6);
            BigDecimal formalValue = new BigDecimal("" + formalCount);
            formalValue = formalValue.setScale(6);
            attendPercent = actualValue.divide(formalValue, 4);
        }
        return attendPercent;
    }

    private BigDecimal getStudentAverageScore(Context ctx, TrainCourseRecordCollection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        BigDecimal value = new BigDecimal("0.0000000");
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (collection.get(i).getAssessScore() == null) continue;
            value = value.add(collection.get(i).getAssessScore());
        }
        BigDecimal recordCollectionValue = new BigDecimal("" + collection.size());
        recordCollectionValue = recordCollectionValue.setScale(6);
        return value.divide(recordCollectionValue, 4);
    }

    private BigDecimal getStudentPassPercent(Context ctx, TrainCourseRecordCollection collection) {
        if (collection == null || collection.size() == 0) {
            return new BigDecimal("0.00");
        }
        int count = 0;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            if (!TrainRecordIsPassedEnum.PASSED.equals((Object)collection.get(i).getIsPassed())) continue;
            ++count;
        }
        BigDecimal countValue = new BigDecimal("" + count);
        countValue = countValue.setScale(6);
        BigDecimal recordCountValue = new BigDecimal("" + collection.size());
        recordCountValue = recordCountValue.setScale(6);
        return countValue.divide(recordCountValue, 4);
    }

    protected void _syncParticipator(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        TrainActCourseInfo trainActCourseInfo = (TrainActCourseInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseInfo.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("TrainSummary.AuditState"));
        viewInfo.getSelector().add(new SelectorItemInfo("entrys.actParticipator.id"));
        TrainCourseSummaryCollection courseSummarys = TrainCourseSummaryFactory.getLocalInstance(ctx).getTrainCourseSummaryCollection(viewInfo);
        if (courseSummarys != null && courseSummarys.size() > 0) {
            TrainCourseSummaryInfo trainCourseSummaryInfo = courseSummarys.get(0);
            if (TrainAuditStatusEnum.AUDITED.equals((Object)trainCourseSummaryInfo.getTrainSummary().getAuditState())) {
                throw new TrainSummaryException(TrainSummaryException.SUMMARY_AUDITED);
            }
            boolean changed = false;
            if (trainActCourseInfo != null && trainActCourseInfo.getParticipators().size() > 0) {
                TrainActCourseParticipatorCollection actParticipators = trainActCourseInfo.getParticipators();
                HashSet<String> actOrganigerIds = new HashSet<String>();
                int size = actParticipators.size();
                for (int i = 0; i < size; ++i) {
                    actOrganigerIds.add(actParticipators.get(i).getId().toString());
                }
                TrainCourseSummaryParticipatorInfo summaryParticipatorInfo = null;
                TrainCourseSummaryParticipatorCollection summaryParticipatorCollection = trainCourseSummaryInfo.getEntrys();
                for (int i = summaryParticipatorCollection.size() - 1; i >= 0; --i) {
                    summaryParticipatorInfo = summaryParticipatorCollection.get(i);
                    if (actOrganigerIds.contains(summaryParticipatorInfo.getActParticipator().getId().toString())) continue;
                    summaryParticipatorCollection.remove(summaryParticipatorInfo);
                    changed = true;
                }
                HashSet<String> summaryParticipatorIds = new HashSet<String>();
                int size2 = summaryParticipatorCollection.size();
                for (int i = 0; i < size2; ++i) {
                    summaryParticipatorIds.add(summaryParticipatorCollection.get(i).getActParticipator().getId().toString());
                }
                TrainActCourseParticipatorInfo actCourseParticipatorInfo = null;
                int size3 = trainActCourseInfo.getParticipators().size();
                for (int i = 0; i < size3; ++i) {
                    actCourseParticipatorInfo = trainActCourseInfo.getParticipators().get(i);
                    if (summaryParticipatorIds.contains(actCourseParticipatorInfo.getId().toString())) continue;
                    summaryParticipatorInfo = new TrainCourseSummaryParticipatorInfo();
                    summaryParticipatorInfo.setParent(trainCourseSummaryInfo);
                    summaryParticipatorInfo.setActParticipator(actCourseParticipatorInfo);
                    summaryParticipatorInfo.setSeq(summaryParticipatorCollection.size() + 1);
                    summaryParticipatorCollection.add(summaryParticipatorInfo);
                    changed = true;
                }
            } else if (trainCourseSummaryInfo.getEntrys().size() > 0) {
                trainCourseSummaryInfo.getEntrys().clear();
                changed = true;
            }
            if (changed) {
                super._update(ctx, (IObjectPK)new ObjectUuidPK(trainCourseSummaryInfo.getId().toString()), (IObjectValue)trainCourseSummaryInfo);
            }
        }
    }
}

