/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.TrainEquipmentException;
import com.kingdee.eas.hr.train.TrainEquipmentFactory;
import com.kingdee.eas.hr.train.TrainEquipmentInfo;
import com.kingdee.eas.hr.train.TrainResourceException;
import com.kingdee.eas.hr.train.app.AbstractTrainEquipmentControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class TrainEquipmentControllerBean
extends AbstractTrainEquipmentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainEquipmentControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.checkIsReference(ctx, pk)) {
            throw new TrainResourceException(TrainResourceException.CAN_NOT_DEL_TRAINEQUIPMENT);
        }
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainEquipmentFactory.getLocalInstance(ctx), TrainEquipmentInfo.class.getName());
        super._delete(ctx, pk);
    }

    private boolean checkIsReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainEquipmentInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainEquipmentInfo)model));
        return super._addnew(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainEquipmentInfo info = (TrainEquipmentInfo)model;
        String name = info.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new TrainEquipmentException(TrainEquipmentException.EQUIPMENT_NAME_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("treeid.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainEquipmentFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainEquipmentException(TrainEquipmentException.EQUIPMENT_NAME_NOT_DUP);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainEquipmentInfo info = (TrainEquipmentInfo)model;
        String number = info.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new TrainEquipmentException(TrainEquipmentException.EQUIPMENT_NUMBER_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainEquipmentFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainEquipmentException(TrainEquipmentException.EQUIPMENT_NUMBER_NOT_DUP);
        }
    }
}

