/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.hr.train.TrainEquipmentException;
import com.kingdee.eas.hr.train.TrainEquipmentFacadeFactory;
import com.kingdee.eas.hr.train.TrainEquipmentTreeFactory;
import com.kingdee.eas.hr.train.TrainEquipmentTreeInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainEquipmentTreeControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class TrainEquipmentTreeControllerBean
extends AbstractTrainEquipmentTreeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainEquipmentTreeControllerBean");

    protected void _isReferenced(Context ctx) throws BOSException {
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (TrainEquipmentFacadeFactory.getLocalInstance(ctx).isReferenced(pk.toString())) {
            throw new TrainEquipmentException(TrainEquipmentException.EQUIPMENT_ALREADY_REFERENCED);
        }
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainEquipmentTreeFactory.getLocalInstance(ctx), TrainEquipmentTreeInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainEquipmentTreeInfo)model));
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this.checkParentIsReferenced(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainEquipmentTreeInfo)model));
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this.checkParentIsReferenced(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkParentIsReferenced(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String parentID = this.getParentID(ctx, model);
        if (parentID != null && TrainEquipmentFacadeFactory.getLocalInstance(ctx).isReferenced(parentID)) {
            throw new TrainEquipmentException(TrainEquipmentException.PARENT_ISREFERENCED);
        }
    }

    private String getParentID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo parent = treeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        return parent.getId().toString();
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainEquipmentTreeInfo info = (TrainEquipmentTreeInfo)model;
        String name = info.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new TrainEquipmentException(TrainEquipmentException.NAME_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        if (info.getParent() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getParent().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", null));
        }
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        filterInfo.mergeFilter(PfServerUtils.getCUFilterForQuery((Context)ctx), "and");
        if (TrainEquipmentTreeFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainEquipmentException(TrainEquipmentException.NAME_DUP);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainEquipmentTreeInfo info = (TrainEquipmentTreeInfo)model;
        String number = info.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new TrainEquipmentException(TrainEquipmentException.NUMBER_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainEquipmentTreeFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainEquipmentException(TrainEquipmentException.NUMBER_DUP);
        }
    }
}

